/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.PredecessorReferenceDocField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PredecessorReferenceDocSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Predecessor Reference Document Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PredecessorReferenceDocType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PredecessorReferenceDoc extends VdmEntity<PredecessorReferenceDoc>
{

    /**
     * Selector for all available fields of PredecessorReferenceDoc.
     *
     */
    public final static PredecessorReferenceDocSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType_ID</b>
     * </p>
     *
     * @return Predecessor Reference Document Type
     */
    @Key
    @SerializedName( "PredecessorReferenceDocType_ID" )
    @JsonProperty( "PredecessorReferenceDocType_ID" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocType_ID" )
    private String predecessorReferenceDocType_ID;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocType_ID</b> field to query operations.
     *
     */
    public final static PredecessorReferenceDocField<String> PREDECESSOR_REFERENCE_DOC_TYPE_ID =
        new PredecessorReferenceDocField<String>("PredecessorReferenceDocType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocTypeText</b>
     * </p>
     *
     * @return Predecessor Reference Document Type (Description)
     */
    @SerializedName( "PredecessorReferenceDocTypeText" )
    @JsonProperty( "PredecessorReferenceDocTypeText" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocTypeText" )
    private String predecessorReferenceDocTypeText;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocTypeText</b> field to query operations.
     *
     */
    public final static PredecessorReferenceDocField<String> PREDECESSOR_REFERENCE_DOC_TYPE_TEXT =
        new PredecessorReferenceDocField<String>("PredecessorReferenceDocTypeText");

    @Nonnull
    @Override
    public Class<PredecessorReferenceDoc> getType()
    {
        return PredecessorReferenceDoc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType_ID</b>
     * </p>
     *
     * @param predecessorReferenceDocType_ID
     *            Predecessor Reference Document Type
     */
    public void setPredecessorReferenceDocType_ID( @Nullable final String predecessorReferenceDocType_ID )
    {
        rememberChangedField("PredecessorReferenceDocType_ID", this.predecessorReferenceDocType_ID);
        this.predecessorReferenceDocType_ID = predecessorReferenceDocType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocTypeText</b>
     * </p>
     *
     * @param predecessorReferenceDocTypeText
     *            Predecessor Reference Document Type (Description)
     */
    public void setPredecessorReferenceDocTypeText( @Nullable final String predecessorReferenceDocTypeText )
    {
        rememberChangedField("PredecessorReferenceDocTypeText", this.predecessorReferenceDocTypeText);
        this.predecessorReferenceDocTypeText = predecessorReferenceDocTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PredecessorReferenceDocType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PredecessorReferenceDocType_ID", getPredecessorReferenceDocType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PredecessorReferenceDocType_ID", getPredecessorReferenceDocType_ID());
        values.put("PredecessorReferenceDocTypeText", getPredecessorReferenceDocTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PredecessorReferenceDocType_ID") ) {
                final Object value = values.remove("PredecessorReferenceDocType_ID");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocType_ID())) ) {
                    setPredecessorReferenceDocType_ID(((String) value));
                }
            }
            if( values.containsKey("PredecessorReferenceDocTypeText") ) {
                final Object value = values.remove("PredecessorReferenceDocTypeText");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocTypeText())) ) {
                    setPredecessorReferenceDocTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PredecessorReferenceDocField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PredecessorReferenceDocField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PredecessorReferenceDocField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PredecessorReferenceDocField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
