/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ProductGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ProductGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Group (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductGroup</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductGroup extends VdmEntity<ProductGroup>
{

    /**
     * Selector for all available fields of ProductGroup.
     *
     */
    public final static ProductGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup_ID</b>
     * </p>
     *
     * @return Product Group
     */
    @Key
    @SerializedName( "ProductGroup_ID" )
    @JsonProperty( "ProductGroup_ID" )
    @Nullable
    @ODataField( odataName = "ProductGroup_ID" )
    private String productGroup_ID;
    /**
     * Use with available fluent helpers to apply the <b>ProductGroup_ID</b> field to query operations.
     *
     */
    public final static ProductGroupField<String> PRODUCT_GROUP_ID = new ProductGroupField<String>("ProductGroup_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupText</b>
     * </p>
     *
     * @return Product Group (Description)
     */
    @SerializedName( "ProductGroupText" )
    @JsonProperty( "ProductGroupText" )
    @Nullable
    @ODataField( odataName = "ProductGroupText" )
    private String productGroupText;
    /**
     * Use with available fluent helpers to apply the <b>ProductGroupText</b> field to query operations.
     *
     */
    public final static ProductGroupField<String> PRODUCT_GROUP_TEXT =
        new ProductGroupField<String>("ProductGroupText");

    @Nonnull
    @Override
    public Class<ProductGroup> getType()
    {
        return ProductGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup_ID</b>
     * </p>
     *
     * @param productGroup_ID
     *            Product Group
     */
    public void setProductGroup_ID( @Nullable final String productGroup_ID )
    {
        rememberChangedField("ProductGroup_ID", this.productGroup_ID);
        this.productGroup_ID = productGroup_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupText</b>
     * </p>
     *
     * @param productGroupText
     *            Product Group (Description)
     */
    public void setProductGroupText( @Nullable final String productGroupText )
    {
        rememberChangedField("ProductGroupText", this.productGroupText);
        this.productGroupText = productGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProductGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProductGroup_ID", getProductGroup_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProductGroup_ID", getProductGroup_ID());
        values.put("ProductGroupText", getProductGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductGroup_ID") ) {
                final Object value = values.remove("ProductGroup_ID");
                if( (value == null) || (!value.equals(getProductGroup_ID())) ) {
                    setProductGroup_ID(((String) value));
                }
            }
            if( values.containsKey("ProductGroupText") ) {
                final Object value = values.remove("ProductGroupText");
                if( (value == null) || (!value.equals(getProductGroupText())) ) {
                    setProductGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProductGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
