/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ProductGroupSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroup
 * ProductGroup} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class ProductGroupByKeyFluentHelper
    extends
    FluentHelperByKey<ProductGroupByKeyFluentHelper, ProductGroup, ProductGroupSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroup ProductGroup} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProductGroup}
     * @param productGroup_ID
     *            Product Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 9
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProductGroup}
     */
    public ProductGroupByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String productGroup_ID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProductGroup_ID", productGroup_ID);
    }

    @Override
    @Nonnull
    protected Class<ProductGroup> getEntityClass()
    {
        return ProductGroup.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
