/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ProjectExternalIDField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ProjectExternalIDSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Project External ID (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectExternalID</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectExternalID extends VdmEntity<ProjectExternalID>
{

    /**
     * Selector for all available fields of ProjectExternalID.
     *
     */
    public final static ProjectExternalIDSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID_ID</b>
     * </p>
     *
     * @return Project External ID
     */
    @Key
    @SerializedName( "ProjectExternalID_ID" )
    @JsonProperty( "ProjectExternalID_ID" )
    @Nullable
    @ODataField( odataName = "ProjectExternalID_ID" )
    private String projectExternalID_ID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectExternalID_ID</b> field to query operations.
     *
     */
    public final static ProjectExternalIDField<String> PROJECT_EXTERNAL_IDID =
        new ProjectExternalIDField<String>("ProjectExternalID_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalIDText</b>
     * </p>
     *
     * @return Project External ID (Description)
     */
    @SerializedName( "ProjectExternalIDText" )
    @JsonProperty( "ProjectExternalIDText" )
    @Nullable
    @ODataField( odataName = "ProjectExternalIDText" )
    private String projectExternalIDText;
    /**
     * Use with available fluent helpers to apply the <b>ProjectExternalIDText</b> field to query operations.
     *
     */
    public final static ProjectExternalIDField<String> PROJECT_EXTERNAL_ID_TEXT =
        new ProjectExternalIDField<String>("ProjectExternalIDText");

    @Nonnull
    @Override
    public Class<ProjectExternalID> getType()
    {
        return ProjectExternalID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID_ID</b>
     * </p>
     *
     * @param projectExternalID_ID
     *            Project External ID
     */
    public void setProjectExternalID_ID( @Nullable final String projectExternalID_ID )
    {
        rememberChangedField("ProjectExternalID_ID", this.projectExternalID_ID);
        this.projectExternalID_ID = projectExternalID_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalIDText</b>
     * </p>
     *
     * @param projectExternalIDText
     *            Project External ID (Description)
     */
    public void setProjectExternalIDText( @Nullable final String projectExternalIDText )
    {
        rememberChangedField("ProjectExternalIDText", this.projectExternalIDText);
        this.projectExternalIDText = projectExternalIDText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProjectExternalID";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectExternalID_ID", getProjectExternalID_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectExternalID_ID", getProjectExternalID_ID());
        values.put("ProjectExternalIDText", getProjectExternalIDText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectExternalID_ID") ) {
                final Object value = values.remove("ProjectExternalID_ID");
                if( (value == null) || (!value.equals(getProjectExternalID_ID())) ) {
                    setProjectExternalID_ID(((String) value));
                }
            }
            if( values.containsKey("ProjectExternalIDText") ) {
                final Object value = values.remove("ProjectExternalIDText");
                if( (value == null) || (!value.equals(getProjectExternalIDText())) ) {
                    setProjectExternalIDText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProjectExternalIDField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectExternalIDField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectExternalIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectExternalIDField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
