/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ProjectNetworkField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ProjectNetworkSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Network
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectNetwork</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectNetwork extends VdmEntity<ProjectNetwork>
{

    /**
     * Selector for all available fields of ProjectNetwork.
     *
     */
    public final static ProjectNetworkSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network
     */
    @Key
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static ProjectNetworkField<String> PROJECT_NETWORK = new ProjectNetworkField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkText</b>
     * </p>
     *
     * @return Network (Description)
     */
    @SerializedName( "ProjectNetworkText" )
    @JsonProperty( "ProjectNetworkText" )
    @Nullable
    @ODataField( odataName = "ProjectNetworkText" )
    private String projectNetworkText;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetworkText</b> field to query operations.
     *
     */
    public final static ProjectNetworkField<String> PROJECT_NETWORK_TEXT =
        new ProjectNetworkField<String>("ProjectNetworkText");

    @Nonnull
    @Override
    public Class<ProjectNetwork> getType()
    {
        return ProjectNetwork.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkText</b>
     * </p>
     *
     * @param projectNetworkText
     *            Network (Description)
     */
    public void setProjectNetworkText( @Nullable final String projectNetworkText )
    {
        rememberChangedField("ProjectNetworkText", this.projectNetworkText);
        this.projectNetworkText = projectNetworkText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProjectNetwork";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectNetwork", getProjectNetwork());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("ProjectNetworkText", getProjectNetworkText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("ProjectNetworkText") ) {
                final Object value = values.remove("ProjectNetworkText");
                if( (value == null) || (!value.equals(getProjectNetworkText())) ) {
                    setProjectNetworkText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectNetworkField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectNetworkField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectNetworkField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectNetworkField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
