/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ProjectNetworkSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetwork ProjectNetwork} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class ProjectNetworkByKeyFluentHelper
    extends
    FluentHelperByKey<ProjectNetworkByKeyFluentHelper, ProjectNetwork, ProjectNetworkSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetwork ProjectNetwork} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProjectNetwork}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProjectNetwork}
     * @param projectNetwork
     *            Network
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public ProjectNetworkByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String projectNetwork )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjectNetwork", projectNetwork);
    }

    @Override
    @Nonnull
    protected Class<ProjectNetwork> getEntityClass()
    {
        return ProjectNetwork.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
