/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.QuantityIsIncompleteField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.QuantityIsIncompleteSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Qty Is Incomplete (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>QuantityIsIncomplete</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class QuantityIsIncomplete extends VdmEntity<QuantityIsIncomplete>
{

    /**
     * Selector for all available fields of QuantityIsIncomplete.
     *
     */
    public final static QuantityIsIncompleteSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete_ID</b>
     * </p>
     *
     * @return Qty Is Incomplete
     */
    @Key
    @SerializedName( "QuantityIsIncomplete_ID" )
    @JsonProperty( "QuantityIsIncomplete_ID" )
    @Nullable
    @ODataField( odataName = "QuantityIsIncomplete_ID" )
    private String quantityIsIncomplete_ID;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsIncomplete_ID</b> field to query operations.
     *
     */
    public final static QuantityIsIncompleteField<String> QUANTITY_IS_INCOMPLETE_ID =
        new QuantityIsIncompleteField<String>("QuantityIsIncomplete_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncompleteText</b>
     * </p>
     *
     * @return Qty Is Incomplete (Description)
     */
    @SerializedName( "QuantityIsIncompleteText" )
    @JsonProperty( "QuantityIsIncompleteText" )
    @Nullable
    @ODataField( odataName = "QuantityIsIncompleteText" )
    private String quantityIsIncompleteText;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsIncompleteText</b> field to query operations.
     *
     */
    public final static QuantityIsIncompleteField<String> QUANTITY_IS_INCOMPLETE_TEXT =
        new QuantityIsIncompleteField<String>("QuantityIsIncompleteText");

    @Nonnull
    @Override
    public Class<QuantityIsIncomplete> getType()
    {
        return QuantityIsIncomplete.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete_ID</b>
     * </p>
     *
     * @param quantityIsIncomplete_ID
     *            Qty Is Incomplete
     */
    public void setQuantityIsIncomplete_ID( @Nullable final String quantityIsIncomplete_ID )
    {
        rememberChangedField("QuantityIsIncomplete_ID", this.quantityIsIncomplete_ID);
        this.quantityIsIncomplete_ID = quantityIsIncomplete_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncompleteText</b>
     * </p>
     *
     * @param quantityIsIncompleteText
     *            Qty Is Incomplete (Description)
     */
    public void setQuantityIsIncompleteText( @Nullable final String quantityIsIncompleteText )
    {
        rememberChangedField("QuantityIsIncompleteText", this.quantityIsIncompleteText);
        this.quantityIsIncompleteText = quantityIsIncompleteText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "QuantityIsIncomplete";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("QuantityIsIncomplete_ID", getQuantityIsIncomplete_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("QuantityIsIncomplete_ID", getQuantityIsIncomplete_ID());
        values.put("QuantityIsIncompleteText", getQuantityIsIncompleteText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("QuantityIsIncomplete_ID") ) {
                final Object value = values.remove("QuantityIsIncomplete_ID");
                if( (value == null) || (!value.equals(getQuantityIsIncomplete_ID())) ) {
                    setQuantityIsIncomplete_ID(((String) value));
                }
            }
            if( values.containsKey("QuantityIsIncompleteText") ) {
                final Object value = values.remove("QuantityIsIncompleteText");
                if( (value == null) || (!value.equals(getQuantityIsIncompleteText())) ) {
                    setQuantityIsIncompleteText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> QuantityIsIncompleteField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new QuantityIsIncompleteField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> QuantityIsIncompleteField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new QuantityIsIncompleteField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
