/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ReferenceDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.ReferenceDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Reference Document Type (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ReferenceDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReferenceDocument extends VdmEntity<ReferenceDocument>
{

    /**
     * Selector for all available fields of ReferenceDocument.
     *
     */
    public final static ReferenceDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType_ID</b>
     * </p>
     *
     * @return Reference Document Type
     */
    @Key
    @SerializedName( "ReferenceDocumentType_ID" )
    @JsonProperty( "ReferenceDocumentType_ID" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType_ID" )
    private String referenceDocumentType_ID;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType_ID</b> field to query operations.
     *
     */
    public final static ReferenceDocumentField<String> REFERENCE_DOCUMENT_TYPE_ID =
        new ReferenceDocumentField<String>("ReferenceDocumentType_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentTypeText</b>
     * </p>
     *
     * @return Reference Document Type (Description)
     */
    @SerializedName( "ReferenceDocumentTypeText" )
    @JsonProperty( "ReferenceDocumentTypeText" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentTypeText" )
    private String referenceDocumentTypeText;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentTypeText</b> field to query operations.
     *
     */
    public final static ReferenceDocumentField<String> REFERENCE_DOCUMENT_TYPE_TEXT =
        new ReferenceDocumentField<String>("ReferenceDocumentTypeText");

    @Nonnull
    @Override
    public Class<ReferenceDocument> getType()
    {
        return ReferenceDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType_ID</b>
     * </p>
     *
     * @param referenceDocumentType_ID
     *            Reference Document Type
     */
    public void setReferenceDocumentType_ID( @Nullable final String referenceDocumentType_ID )
    {
        rememberChangedField("ReferenceDocumentType_ID", this.referenceDocumentType_ID);
        this.referenceDocumentType_ID = referenceDocumentType_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentTypeText</b>
     * </p>
     *
     * @param referenceDocumentTypeText
     *            Reference Document Type (Description)
     */
    public void setReferenceDocumentTypeText( @Nullable final String referenceDocumentTypeText )
    {
        rememberChangedField("ReferenceDocumentTypeText", this.referenceDocumentTypeText);
        this.referenceDocumentTypeText = referenceDocumentTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ReferenceDocumentType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ReferenceDocumentType_ID", getReferenceDocumentType_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ReferenceDocumentType_ID", getReferenceDocumentType_ID());
        values.put("ReferenceDocumentTypeText", getReferenceDocumentTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ReferenceDocumentType_ID") ) {
                final Object value = values.remove("ReferenceDocumentType_ID");
                if( (value == null) || (!value.equals(getReferenceDocumentType_ID())) ) {
                    setReferenceDocumentType_ID(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentTypeText") ) {
                final Object value = values.remove("ReferenceDocumentTypeText");
                if( (value == null) || (!value.equals(getReferenceDocumentTypeText())) ) {
                    setReferenceDocumentTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReferenceDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReferenceDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReferenceDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReferenceDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
