/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SAP__CurrencySelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency
 * SAP__Currency} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SAP__CurrencyByKeyFluentHelper
    extends
    FluentHelperByKey<SAP__CurrencyByKeyFluentHelper, SAP__Currency, SAP__CurrencySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SAP__Currency}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SAP__Currency}
     * @param currencyCode
     *            Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public SAP__CurrencyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String currencyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("CurrencyCode", currencyCode);
    }

    @Override
    @Nonnull
    protected Class<SAP__Currency> getEntityClass()
    {
        return SAP__Currency.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
