/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>SAP__FitToPage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__FitToPage extends VdmComplex<SAP__FitToPage>
{

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>ErrorRecoveryBehavior</b>
     * </p>
     *
     * @param errorRecoveryBehavior
     *
     * @return Error behavior
     */
    @SerializedName( "ErrorRecoveryBehavior" )
    @JsonProperty( "ErrorRecoveryBehavior" )
    @Nullable
    @ODataField( odataName = "ErrorRecoveryBehavior" )
    private String errorRecoveryBehavior;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>IsEnabled</b>
     * </p>
     *
     * @param isEnabled
     *
     */
    @SerializedName( "IsEnabled" )
    @JsonProperty( "IsEnabled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsEnabled" )
    private Boolean isEnabled;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>MinimumFontSize</b>
     * </p>
     *
     * @param minimumFontSize
     *
     */
    @SerializedName( "MinimumFontSize" )
    @JsonProperty( "MinimumFontSize" )
    @Nullable
    @ODataField( odataName = "MinimumFontSize" )
    private Integer minimumFontSize;

    @Nonnull
    @Override
    public Class<SAP__FitToPage> getType()
    {
        return SAP__FitToPage.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ErrorRecoveryBehavior", getErrorRecoveryBehavior());
        values.put("IsEnabled", getIsEnabled());
        values.put("MinimumFontSize", getMinimumFontSize());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ErrorRecoveryBehavior") ) {
                final Object value = values.remove("ErrorRecoveryBehavior");
                if( (value == null) || (!value.equals(getErrorRecoveryBehavior())) ) {
                    setErrorRecoveryBehavior(((String) value));
                }
            }
            if( values.containsKey("IsEnabled") ) {
                final Object value = values.remove("IsEnabled");
                if( (value == null) || (!value.equals(getIsEnabled())) ) {
                    setIsEnabled(((Boolean) value));
                }
            }
            if( values.containsKey("MinimumFontSize") ) {
                final Object value = values.remove("MinimumFontSize");
                if( (value == null) || (!value.equals(getMinimumFontSize())) ) {
                    setMinimumFontSize(((Integer) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>ErrorRecoveryBehavior</b>
     * </p>
     *
     * @param errorRecoveryBehavior
     *            Error behavior
     */
    public void setErrorRecoveryBehavior( @Nullable final String errorRecoveryBehavior )
    {
        rememberChangedField("ErrorRecoveryBehavior", this.errorRecoveryBehavior);
        this.errorRecoveryBehavior = errorRecoveryBehavior;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>IsEnabled</b>
     * </p>
     *
     * @param isEnabled
     *            The isEnabled to set.
     */
    public void setIsEnabled( @Nullable final Boolean isEnabled )
    {
        rememberChangedField("IsEnabled", this.isEnabled);
        this.isEnabled = isEnabled;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>MinimumFontSize</b>
     * </p>
     *
     * @param minimumFontSize
     *            The minimumFontSize to set.
     */
    public void setMinimumFontSize( @Nullable final Integer minimumFontSize )
    {
        rememberChangedField("MinimumFontSize", this.minimumFontSize);
        this.minimumFontSize = minimumFontSize;
    }

}
