/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SAP__TableColumnsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SAP__TableColumnsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__TableColumns</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__TableColumns extends VdmEntity<SAP__TableColumns>
{

    /**
     * Selector for all available fields of SAP__TableColumns.
     *
     */
    public final static SAP__TableColumnsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @return UUID
     */
    @Key
    @SerializedName( "Id" )
    @JsonProperty( "Id" )
    @Nullable
    @ODataField( odataName = "Id" )
    private UUID id;
    /**
     * Use with available fluent helpers to apply the <b>Id</b> field to query operations.
     *
     */
    public final static SAP__TableColumnsField<UUID> ID = new SAP__TableColumnsField<UUID>("Id");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Name</b>
     * </p>
     *
     * @return The name contained in this entity.
     */
    @Key
    @SerializedName( "Name" )
    @JsonProperty( "Name" )
    @Nullable
    @ODataField( odataName = "Name" )
    private String name;
    /**
     * Use with available fluent helpers to apply the <b>Name</b> field to query operations.
     *
     */
    public final static SAP__TableColumnsField<String> NAME = new SAP__TableColumnsField<String>("Name");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Header</b>
     * </p>
     *
     * @return The header contained in this entity.
     */
    @Key
    @SerializedName( "Header" )
    @JsonProperty( "Header" )
    @Nullable
    @ODataField( odataName = "Header" )
    private String header;
    /**
     * Use with available fluent helpers to apply the <b>Header</b> field to query operations.
     *
     */
    public final static SAP__TableColumnsField<String> HEADER = new SAP__TableColumnsField<String>("Header");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HorizontalAlignment</b>
     * </p>
     *
     * @return The horizontalAlignment contained in this entity.
     */
    @SerializedName( "HorizontalAlignment" )
    @JsonProperty( "HorizontalAlignment" )
    @Nullable
    @ODataField( odataName = "HorizontalAlignment" )
    private String horizontalAlignment;
    /**
     * Use with available fluent helpers to apply the <b>HorizontalAlignment</b> field to query operations.
     *
     */
    public final static SAP__TableColumnsField<String> HORIZONTAL_ALIGNMENT =
        new SAP__TableColumnsField<String>("HorizontalAlignment");

    @Nonnull
    @Override
    public Class<SAP__TableColumns> getType()
    {
        return SAP__TableColumns.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @param id
     *            UUID
     */
    public void setId( @Nullable final UUID id )
    {
        rememberChangedField("Id", this.id);
        this.id = id;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Name</b>
     * </p>
     *
     * @param name
     *            The name to set.
     */
    public void setName( @Nullable final String name )
    {
        rememberChangedField("Name", this.name);
        this.name = name;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>Header</b>
     * </p>
     *
     * @param header
     *            The header to set.
     */
    public void setHeader( @Nullable final String header )
    {
        rememberChangedField("Header", this.header);
        this.header = header;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HorizontalAlignment</b>
     * </p>
     *
     * @param horizontalAlignment
     *            The horizontalAlignment to set.
     */
    public void setHorizontalAlignment( @Nullable final String horizontalAlignment )
    {
        rememberChangedField("HorizontalAlignment", this.horizontalAlignment);
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__TableColumnsSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Id", getId());
        result.put("Name", getName());
        result.put("Header", getHeader());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Id", getId());
        values.put("Name", getName());
        values.put("Header", getHeader());
        values.put("HorizontalAlignment", getHorizontalAlignment());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Id") ) {
                final Object value = values.remove("Id");
                if( (value == null) || (!value.equals(getId())) ) {
                    setId(((UUID) value));
                }
            }
            if( values.containsKey("Name") ) {
                final Object value = values.remove("Name");
                if( (value == null) || (!value.equals(getName())) ) {
                    setName(((String) value));
                }
            }
            if( values.containsKey("Header") ) {
                final Object value = values.remove("Header");
                if( (value == null) || (!value.equals(getHeader())) ) {
                    setHeader(((String) value));
                }
            }
            if( values.containsKey("HorizontalAlignment") ) {
                final Object value = values.remove("HorizontalAlignment");
                if( (value == null) || (!value.equals(getHorizontalAlignment())) ) {
                    setHorizontalAlignment(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SAP__TableColumnsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__TableColumnsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__TableColumnsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__TableColumnsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
