/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SAP__ValueHelpField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SAP__ValueHelpSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SAP__ValueHelp</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SAP__ValueHelp extends VdmEntity<SAP__ValueHelp>
{

    /**
     * Selector for all available fields of SAP__ValueHelp.
     *
     */
    public final static SAP__ValueHelpSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>VALUEHELP</b>
     * </p>
     *
     * @return The vALUEHELP contained in this entity.
     */
    @Key
    @SerializedName( "VALUEHELP" )
    @JsonProperty( "VALUEHELP" )
    @Nullable
    @ODataField( odataName = "VALUEHELP" )
    private String vALUEHELP;
    /**
     * Use with available fluent helpers to apply the <b>VALUEHELP</b> field to query operations.
     *
     */
    public final static SAP__ValueHelpField<String> VALUEHELP = new SAP__ValueHelpField<String>("VALUEHELP");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FIELD_VALUE</b>
     * </p>
     *
     * @return The fIELD_VALUE contained in this entity.
     */
    @SerializedName( "FIELD_VALUE" )
    @JsonProperty( "FIELD_VALUE" )
    @Nullable
    @ODataField( odataName = "FIELD_VALUE" )
    private String fIELD_VALUE;
    /**
     * Use with available fluent helpers to apply the <b>FIELD_VALUE</b> field to query operations.
     *
     */
    public final static SAP__ValueHelpField<String> FIELDVALUE = new SAP__ValueHelpField<String>("FIELD_VALUE");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DESCRIPTION</b>
     * </p>
     *
     * @return The dESCRIPTION contained in this entity.
     */
    @SerializedName( "DESCRIPTION" )
    @JsonProperty( "DESCRIPTION" )
    @Nullable
    @ODataField( odataName = "DESCRIPTION" )
    private String dESCRIPTION;
    /**
     * Use with available fluent helpers to apply the <b>DESCRIPTION</b> field to query operations.
     *
     */
    public final static SAP__ValueHelpField<String> DESCRIPTION = new SAP__ValueHelpField<String>("DESCRIPTION");

    @Nonnull
    @Override
    public Class<SAP__ValueHelp> getType()
    {
        return SAP__ValueHelp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>VALUEHELP</b>
     * </p>
     *
     * @param vALUEHELP
     *            The vALUEHELP to set.
     */
    public void setVALUEHELP( @Nullable final String vALUEHELP )
    {
        rememberChangedField("VALUEHELP", this.vALUEHELP);
        this.vALUEHELP = vALUEHELP;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FIELD_VALUE</b>
     * </p>
     *
     * @param fIELD_VALUE
     *            The fIELD_VALUE to set.
     */
    public void setFIELD_VALUE( @Nullable final String fIELD_VALUE )
    {
        rememberChangedField("FIELD_VALUE", this.fIELD_VALUE);
        this.fIELD_VALUE = fIELD_VALUE;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DESCRIPTION</b>
     * </p>
     *
     * @param dESCRIPTION
     *            The dESCRIPTION to set.
     */
    public void setDESCRIPTION( @Nullable final String dESCRIPTION )
    {
        rememberChangedField("DESCRIPTION", this.dESCRIPTION);
        this.dESCRIPTION = dESCRIPTION;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SAP__ValueHelpSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("VALUEHELP", getVALUEHELP());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("VALUEHELP", getVALUEHELP());
        values.put("FIELD_VALUE", getFIELD_VALUE());
        values.put("DESCRIPTION", getDESCRIPTION());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("VALUEHELP") ) {
                final Object value = values.remove("VALUEHELP");
                if( (value == null) || (!value.equals(getVALUEHELP())) ) {
                    setVALUEHELP(((String) value));
                }
            }
            if( values.containsKey("FIELD_VALUE") ) {
                final Object value = values.remove("FIELD_VALUE");
                if( (value == null) || (!value.equals(getFIELD_VALUE())) ) {
                    setFIELD_VALUE(((String) value));
                }
            }
            if( values.containsKey("DESCRIPTION") ) {
                final Object value = values.remove("DESCRIPTION");
                if( (value == null) || (!value.equals(getDESCRIPTION())) ) {
                    setDESCRIPTION(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SAP__ValueHelpField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SAP__ValueHelpField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SAP__ValueHelpField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SAP__ValueHelpField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
