/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SalesDocumentItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SalesDocumentItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sales Document Item (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesDocumentItem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesDocumentItem extends VdmEntity<SalesDocumentItem>
{

    /**
     * Selector for all available fields of SalesDocumentItem.
     *
     */
    public final static SalesDocumentItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem_ID</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @Key
    @SerializedName( "SalesDocumentItem_ID" )
    @JsonProperty( "SalesDocumentItem_ID" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem_ID" )
    private String salesDocumentItem_ID;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem_ID</b> field to query operations.
     *
     */
    public final static SalesDocumentItemField<String> SALES_DOCUMENT_ITEM_ID =
        new SalesDocumentItemField<String>("SalesDocumentItem_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemText</b>
     * </p>
     *
     * @return Sales Document Item (Description)
     */
    @SerializedName( "SalesDocumentItemText" )
    @JsonProperty( "SalesDocumentItemText" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItemText" )
    private String salesDocumentItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItemText</b> field to query operations.
     *
     */
    public final static SalesDocumentItemField<String> SALES_DOCUMENT_ITEM_TEXT =
        new SalesDocumentItemField<String>("SalesDocumentItemText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document Item (Sales Document)
     */
    @Key
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static SalesDocumentItemField<String> SALES_DOCUMENT =
        new SalesDocumentItemField<String>("SalesDocument");

    @Nonnull
    @Override
    public Class<SalesDocumentItem> getType()
    {
        return SalesDocumentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem_ID</b>
     * </p>
     *
     * @param salesDocumentItem_ID
     *            Sales Document Item
     */
    public void setSalesDocumentItem_ID( @Nullable final String salesDocumentItem_ID )
    {
        rememberChangedField("SalesDocumentItem_ID", this.salesDocumentItem_ID);
        this.salesDocumentItem_ID = salesDocumentItem_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItemText</b>
     * </p>
     *
     * @param salesDocumentItemText
     *            Sales Document Item (Description)
     */
    public void setSalesDocumentItemText( @Nullable final String salesDocumentItemText )
    {
        rememberChangedField("SalesDocumentItemText", this.salesDocumentItemText);
        this.salesDocumentItemText = salesDocumentItemText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document Item (Sales Document)
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SalesDocumentItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesDocumentItem_ID", getSalesDocumentItem_ID());
        result.put("SalesDocument", getSalesDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesDocumentItem_ID", getSalesDocumentItem_ID());
        values.put("SalesDocumentItemText", getSalesDocumentItemText());
        values.put("SalesDocument", getSalesDocument());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesDocumentItem_ID") ) {
                final Object value = values.remove("SalesDocumentItem_ID");
                if( (value == null) || (!value.equals(getSalesDocumentItem_ID())) ) {
                    setSalesDocumentItem_ID(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItemText") ) {
                final Object value = values.remove("SalesDocumentItemText");
                if( (value == null) || (!value.equals(getSalesDocumentItemText())) ) {
                    setSalesDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesDocumentItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesDocumentItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesDocumentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesDocumentItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
