/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SalesOrderItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SalesOrderItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesOrderItem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderItem extends VdmEntity<SalesOrderItem>
{

    /**
     * Selector for all available fields of SalesOrderItem.
     *
     */
    public final static SalesOrderItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem_ID</b>
     * </p>
     *
     * @return Item
     */
    @Key
    @SerializedName( "SalesOrderItem_ID" )
    @JsonProperty( "SalesOrderItem_ID" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem_ID" )
    private String salesOrderItem_ID;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem_ID</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_ORDER_ITEM_ID =
        new SalesOrderItemField<String>("SalesOrderItem_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @return Item (Description)
     */
    @SerializedName( "SalesOrderItemText" )
    @JsonProperty( "SalesOrderItemText" )
    @Nullable
    @ODataField( odataName = "SalesOrderItemText" )
    private String salesOrderItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItemText</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_ORDER_ITEM_TEXT =
        new SalesOrderItemField<String>("SalesOrderItemText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Item (Sales Order)
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_ORDER = new SalesOrderItemField<String>("SalesOrder");

    @Nonnull
    @Override
    public Class<SalesOrderItem> getType()
    {
        return SalesOrderItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem_ID</b>
     * </p>
     *
     * @param salesOrderItem_ID
     *            Item
     */
    public void setSalesOrderItem_ID( @Nullable final String salesOrderItem_ID )
    {
        rememberChangedField("SalesOrderItem_ID", this.salesOrderItem_ID);
        this.salesOrderItem_ID = salesOrderItem_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @param salesOrderItemText
     *            Item (Description)
     */
    public void setSalesOrderItemText( @Nullable final String salesOrderItemText )
    {
        rememberChangedField("SalesOrderItemText", this.salesOrderItemText);
        this.salesOrderItemText = salesOrderItemText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Item (Sales Order)
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SalesOrderItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrderItem_ID", getSalesOrderItem_ID());
        result.put("SalesOrder", getSalesOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrderItem_ID", getSalesOrderItem_ID());
        values.put("SalesOrderItemText", getSalesOrderItemText());
        values.put("SalesOrder", getSalesOrder());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrderItem_ID") ) {
                final Object value = values.remove("SalesOrderItem_ID");
                if( (value == null) || (!value.equals(getSalesOrderItem_ID())) ) {
                    setSalesOrderItem_ID(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItemText") ) {
                final Object value = values.remove("SalesOrderItemText");
                if( (value == null) || (!value.equals(getSalesOrderItemText())) ) {
                    setSalesOrderItemText(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesOrderItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
