/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SegmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SegmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Segment (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Segment</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Segment extends VdmEntity<Segment>
{

    /**
     * Selector for all available fields of Segment.
     *
     */
    public final static SegmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment_ID</b>
     * </p>
     *
     * @return Segment
     */
    @Key
    @SerializedName( "Segment_ID" )
    @JsonProperty( "Segment_ID" )
    @Nullable
    @ODataField( odataName = "Segment_ID" )
    private String segment_ID;
    /**
     * Use with available fluent helpers to apply the <b>Segment_ID</b> field to query operations.
     *
     */
    public final static SegmentField<String> SEGMENT_ID = new SegmentField<String>("Segment_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SegmentText</b>
     * </p>
     *
     * @return Segment (Description)
     */
    @SerializedName( "SegmentText" )
    @JsonProperty( "SegmentText" )
    @Nullable
    @ODataField( odataName = "SegmentText" )
    private String segmentText;
    /**
     * Use with available fluent helpers to apply the <b>SegmentText</b> field to query operations.
     *
     */
    public final static SegmentField<String> SEGMENT_TEXT = new SegmentField<String>("SegmentText");

    @Nonnull
    @Override
    public Class<Segment> getType()
    {
        return Segment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment_ID</b>
     * </p>
     *
     * @param segment_ID
     *            Segment
     */
    public void setSegment_ID( @Nullable final String segment_ID )
    {
        rememberChangedField("Segment_ID", this.segment_ID);
        this.segment_ID = segment_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SegmentText</b>
     * </p>
     *
     * @param segmentText
     *            Segment (Description)
     */
    public void setSegmentText( @Nullable final String segmentText )
    {
        rememberChangedField("SegmentText", this.segmentText);
        this.segmentText = segmentText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Segment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Segment_ID", getSegment_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Segment_ID", getSegment_ID());
        values.put("SegmentText", getSegmentText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Segment_ID") ) {
                final Object value = values.remove("Segment_ID");
                if( (value == null) || (!value.equals(getSegment_ID())) ) {
                    setSegment_ID(((String) value));
                }
            }
            if( values.containsKey("SegmentText") ) {
                final Object value = values.remove("SegmentText");
                if( (value == null) || (!value.equals(getSegmentText())) ) {
                    setSegmentText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SegmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SegmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SegmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SegmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
