/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SoldProductField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SoldProductSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Sold
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SoldProduct</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SoldProduct extends VdmEntity<SoldProduct>
{

    /**
     * Selector for all available fields of SoldProduct.
     *
     */
    public final static SoldProductSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @return Product Sold
     */
    @Key
    @SerializedName( "SoldProduct" )
    @JsonProperty( "SoldProduct" )
    @Nullable
    @ODataField( odataName = "SoldProduct" )
    private String soldProduct;
    /**
     * Use with available fluent helpers to apply the <b>SoldProduct</b> field to query operations.
     *
     */
    public final static SoldProductField<String> SOLD_PRODUCT = new SoldProductField<String>("SoldProduct");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductText</b>
     * </p>
     *
     * @return Product Sold (Description)
     */
    @SerializedName( "SoldProductText" )
    @JsonProperty( "SoldProductText" )
    @Nullable
    @ODataField( odataName = "SoldProductText" )
    private String soldProductText;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductText</b> field to query operations.
     *
     */
    public final static SoldProductField<String> SOLD_PRODUCT_TEXT = new SoldProductField<String>("SoldProductText");

    @Nonnull
    @Override
    public Class<SoldProduct> getType()
    {
        return SoldProduct.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @param soldProduct
     *            Product Sold
     */
    public void setSoldProduct( @Nullable final String soldProduct )
    {
        rememberChangedField("SoldProduct", this.soldProduct);
        this.soldProduct = soldProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductText</b>
     * </p>
     *
     * @param soldProductText
     *            Product Sold (Description)
     */
    public void setSoldProductText( @Nullable final String soldProductText )
    {
        rememberChangedField("SoldProductText", this.soldProductText);
        this.soldProductText = soldProductText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SoldProduct";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SoldProduct", getSoldProduct());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SoldProduct", getSoldProduct());
        values.put("SoldProductText", getSoldProductText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SoldProduct") ) {
                final Object value = values.remove("SoldProduct");
                if( (value == null) || (!value.equals(getSoldProduct())) ) {
                    setSoldProduct(((String) value));
                }
            }
            if( values.containsKey("SoldProductText") ) {
                final Object value = values.remove("SoldProductText");
                if( (value == null) || (!value.equals(getSoldProductText())) ) {
                    setSoldProductText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SoldProductField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SoldProductField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SoldProductField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SoldProductField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
