/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SoldProductGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SoldProductGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Sold Group (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SoldProductGroup</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SoldProductGroup extends VdmEntity<SoldProductGroup>
{

    /**
     * Selector for all available fields of SoldProductGroup.
     *
     */
    public final static SoldProductGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup_ID</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @Key
    @SerializedName( "SoldProductGroup_ID" )
    @JsonProperty( "SoldProductGroup_ID" )
    @Nullable
    @ODataField( odataName = "SoldProductGroup_ID" )
    private String soldProductGroup_ID;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroup_ID</b> field to query operations.
     *
     */
    public final static SoldProductGroupField<String> SOLD_PRODUCT_GROUP_ID =
        new SoldProductGroupField<String>("SoldProductGroup_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroupText</b>
     * </p>
     *
     * @return Product Sold Group (Description)
     */
    @SerializedName( "SoldProductGroupText" )
    @JsonProperty( "SoldProductGroupText" )
    @Nullable
    @ODataField( odataName = "SoldProductGroupText" )
    private String soldProductGroupText;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroupText</b> field to query operations.
     *
     */
    public final static SoldProductGroupField<String> SOLD_PRODUCT_GROUP_TEXT =
        new SoldProductGroupField<String>("SoldProductGroupText");

    @Nonnull
    @Override
    public Class<SoldProductGroup> getType()
    {
        return SoldProductGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup_ID</b>
     * </p>
     *
     * @param soldProductGroup_ID
     *            Product Sold Group
     */
    public void setSoldProductGroup_ID( @Nullable final String soldProductGroup_ID )
    {
        rememberChangedField("SoldProductGroup_ID", this.soldProductGroup_ID);
        this.soldProductGroup_ID = soldProductGroup_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroupText</b>
     * </p>
     *
     * @param soldProductGroupText
     *            Product Sold Group (Description)
     */
    public void setSoldProductGroupText( @Nullable final String soldProductGroupText )
    {
        rememberChangedField("SoldProductGroupText", this.soldProductGroupText);
        this.soldProductGroupText = soldProductGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SoldProductGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SoldProductGroup_ID", getSoldProductGroup_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SoldProductGroup_ID", getSoldProductGroup_ID());
        values.put("SoldProductGroupText", getSoldProductGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SoldProductGroup_ID") ) {
                final Object value = values.remove("SoldProductGroup_ID");
                if( (value == null) || (!value.equals(getSoldProductGroup_ID())) ) {
                    setSoldProductGroup_ID(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroupText") ) {
                final Object value = values.remove("SoldProductGroupText");
                if( (value == null) || (!value.equals(getSoldProductGroupText())) ) {
                    setSoldProductGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SoldProductGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SoldProductGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SoldProductGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SoldProductGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
