/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SpecialGLCodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SpecialGLCodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Special G/L (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SpecialGLCode</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecialGLCode extends VdmEntity<SpecialGLCode>
{

    /**
     * Selector for all available fields of SpecialGLCode.
     *
     */
    public final static SpecialGLCodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode_ID</b>
     * </p>
     *
     * @return Special G/L
     */
    @Key
    @SerializedName( "SpecialGLCode_ID" )
    @JsonProperty( "SpecialGLCode_ID" )
    @Nullable
    @ODataField( odataName = "SpecialGLCode_ID" )
    private String specialGLCode_ID;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCode_ID</b> field to query operations.
     *
     */
    public final static SpecialGLCodeField<String> SPECIAL_GL_CODE_ID =
        new SpecialGLCodeField<String>("SpecialGLCode_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCodeText</b>
     * </p>
     *
     * @return Special G/L (Description)
     */
    @SerializedName( "SpecialGLCodeText" )
    @JsonProperty( "SpecialGLCodeText" )
    @Nullable
    @ODataField( odataName = "SpecialGLCodeText" )
    private String specialGLCodeText;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCodeText</b> field to query operations.
     *
     */
    public final static SpecialGLCodeField<String> SPECIAL_GL_CODE_TEXT =
        new SpecialGLCodeField<String>("SpecialGLCodeText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @return Special G/L (Account Type)
     */
    @Key
    @SerializedName( "FinancialAccountType" )
    @JsonProperty( "FinancialAccountType" )
    @Nullable
    @ODataField( odataName = "FinancialAccountType" )
    private String financialAccountType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountType</b> field to query operations.
     *
     */
    public final static SpecialGLCodeField<String> FINANCIAL_ACCOUNT_TYPE =
        new SpecialGLCodeField<String>("FinancialAccountType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeName</b>
     * </p>
     *
     * @return Account Type (Description) (Parent Description)
     */
    @SerializedName( "FinancialAccountTypeName" )
    @JsonProperty( "FinancialAccountTypeName" )
    @Nullable
    @ODataField( odataName = "FinancialAccountTypeName" )
    private String financialAccountTypeName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountTypeName</b> field to query operations.
     *
     */
    public final static SpecialGLCodeField<String> FINANCIAL_ACCOUNT_TYPE_NAME =
        new SpecialGLCodeField<String>("FinancialAccountTypeName");

    @Nonnull
    @Override
    public Class<SpecialGLCode> getType()
    {
        return SpecialGLCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode_ID</b>
     * </p>
     *
     * @param specialGLCode_ID
     *            Special G/L
     */
    public void setSpecialGLCode_ID( @Nullable final String specialGLCode_ID )
    {
        rememberChangedField("SpecialGLCode_ID", this.specialGLCode_ID);
        this.specialGLCode_ID = specialGLCode_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCodeText</b>
     * </p>
     *
     * @param specialGLCodeText
     *            Special G/L (Description)
     */
    public void setSpecialGLCodeText( @Nullable final String specialGLCodeText )
    {
        rememberChangedField("SpecialGLCodeText", this.specialGLCodeText);
        this.specialGLCodeText = specialGLCodeText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @param financialAccountType
     *            Special G/L (Account Type)
     */
    public void setFinancialAccountType( @Nullable final String financialAccountType )
    {
        rememberChangedField("FinancialAccountType", this.financialAccountType);
        this.financialAccountType = financialAccountType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeName</b>
     * </p>
     *
     * @param financialAccountTypeName
     *            Account Type (Description) (Parent Description)
     */
    public void setFinancialAccountTypeName( @Nullable final String financialAccountTypeName )
    {
        rememberChangedField("FinancialAccountTypeName", this.financialAccountTypeName);
        this.financialAccountTypeName = financialAccountTypeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SpecialGLCode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecialGLCode_ID", getSpecialGLCode_ID());
        result.put("FinancialAccountType", getFinancialAccountType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecialGLCode_ID", getSpecialGLCode_ID());
        values.put("SpecialGLCodeText", getSpecialGLCodeText());
        values.put("FinancialAccountType", getFinancialAccountType());
        values.put("FinancialAccountTypeName", getFinancialAccountTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecialGLCode_ID") ) {
                final Object value = values.remove("SpecialGLCode_ID");
                if( (value == null) || (!value.equals(getSpecialGLCode_ID())) ) {
                    setSpecialGLCode_ID(((String) value));
                }
            }
            if( values.containsKey("SpecialGLCodeText") ) {
                final Object value = values.remove("SpecialGLCodeText");
                if( (value == null) || (!value.equals(getSpecialGLCodeText())) ) {
                    setSpecialGLCodeText(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountType") ) {
                final Object value = values.remove("FinancialAccountType");
                if( (value == null) || (!value.equals(getFinancialAccountType())) ) {
                    setFinancialAccountType(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountTypeName") ) {
                final Object value = values.remove("FinancialAccountTypeName");
                if( (value == null) || (!value.equals(getFinancialAccountTypeName())) ) {
                    setFinancialAccountTypeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SpecialGLCodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SpecialGLCodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecialGLCodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecialGLCodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
