/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SpecialGLCodeSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode
 * SpecialGLCode} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SpecialGLCodeByKeyFluentHelper
    extends
    FluentHelperByKey<SpecialGLCodeByKeyFluentHelper, SpecialGLCode, SpecialGLCodeSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode SpecialGLCode} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SpecialGLCode}
     * @param financialAccountType
     *            Special G/L (Account Type)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SpecialGLCode}
     * @param specialGLCode_ID
     *            Special G/L
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public SpecialGLCodeByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String specialGLCode_ID,
        final String financialAccountType )
    {
        super(servicePath, entityCollection);
        this.key.put("SpecialGLCode_ID", specialGLCode_ID);
        this.key.put("FinancialAccountType", financialAccountType);
    }

    @Override
    @Nonnull
    protected Class<SpecialGLCode> getEntityClass()
    {
        return SpecialGLCode.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
