/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.SupplierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SupplierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Supplier (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Supplier</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Supplier extends VdmEntity<Supplier>
{

    /**
     * Selector for all available fields of Supplier.
     *
     */
    public final static SupplierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier_ID</b>
     * </p>
     *
     * @return Supplier
     */
    @Key
    @SerializedName( "Supplier_ID" )
    @JsonProperty( "Supplier_ID" )
    @Nullable
    @ODataField( odataName = "Supplier_ID" )
    private String supplier_ID;
    /**
     * Use with available fluent helpers to apply the <b>Supplier_ID</b> field to query operations.
     *
     */
    public final static SupplierField<String> SUPPLIER_ID = new SupplierField<String>("Supplier_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierText</b>
     * </p>
     *
     * @return Supplier (Description)
     */
    @SerializedName( "SupplierText" )
    @JsonProperty( "SupplierText" )
    @Nullable
    @ODataField( odataName = "SupplierText" )
    private String supplierText;
    /**
     * Use with available fluent helpers to apply the <b>SupplierText</b> field to query operations.
     *
     */
    public final static SupplierField<String> SUPPLIER_TEXT = new SupplierField<String>("SupplierText");

    @Nonnull
    @Override
    public Class<Supplier> getType()
    {
        return Supplier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier_ID</b>
     * </p>
     *
     * @param supplier_ID
     *            Supplier
     */
    public void setSupplier_ID( @Nullable final String supplier_ID )
    {
        rememberChangedField("Supplier_ID", this.supplier_ID);
        this.supplier_ID = supplier_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierText</b>
     * </p>
     *
     * @param supplierText
     *            Supplier (Description)
     */
    public void setSupplierText( @Nullable final String supplierText )
    {
        rememberChangedField("SupplierText", this.supplierText);
        this.supplierText = supplierText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Supplier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Supplier_ID", getSupplier_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Supplier_ID", getSupplier_ID());
        values.put("SupplierText", getSupplierText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Supplier_ID") ) {
                final Object value = values.remove("Supplier_ID");
                if( (value == null) || (!value.equals(getSupplier_ID())) ) {
                    setSupplier_ID(((String) value));
                }
            }
            if( values.containsKey("SupplierText") ) {
                final Object value = values.remove("SupplierText");
                if( (value == null) || (!value.equals(getSupplierText())) ) {
                    setSupplierText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SupplierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
