/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.TRIALBALANCEParametersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.TRIALBALANCEParametersLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.TRIALBALANCEParametersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>C_TRIALBALANCEParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TRIALBALANCEParameters extends VdmEntity<TRIALBALANCEParameters>
{

    /**
     * Selector for all available fields of TRIALBALANCEParameters.
     *
     */
    public final static TRIALBALANCEParametersSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_FromPostingDate</b>
     * </p>
     *
     * @return Posting Date From
     */
    @Key
    @SerializedName( "P_FromPostingDate" )
    @JsonProperty( "P_FromPostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_FromPostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_FromPostingDate;
    /**
     * Use with available fluent helpers to apply the <b>P_FromPostingDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEParametersField<LocalDateTime> P_FROM_POSTING_DATE =
        new TRIALBALANCEParametersField<LocalDateTime>("P_FromPostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>P_FromPostingDateText</b>
     * </p>
     *
     * @return Posting Date From (Description)
     */
    @SerializedName( "P_FromPostingDateText" )
    @JsonProperty( "P_FromPostingDateText" )
    @Nullable
    @ODataField( odataName = "P_FromPostingDateText" )
    private String p_FromPostingDateText;
    /**
     * Use with available fluent helpers to apply the <b>P_FromPostingDateText</b> field to query operations.
     *
     */
    public final static TRIALBALANCEParametersField<String> P_FROM_POSTING_DATE_TEXT =
        new TRIALBALANCEParametersField<String>("P_FromPostingDateText");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_ToPostingDate</b>
     * </p>
     *
     * @return Posting Date To
     */
    @Key
    @SerializedName( "P_ToPostingDate" )
    @JsonProperty( "P_ToPostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_ToPostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_ToPostingDate;
    /**
     * Use with available fluent helpers to apply the <b>P_ToPostingDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEParametersField<LocalDateTime> P_TO_POSTING_DATE =
        new TRIALBALANCEParametersField<LocalDateTime>("P_ToPostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>P_ToPostingDateText</b>
     * </p>
     *
     * @return Posting Date To (Description)
     */
    @SerializedName( "P_ToPostingDateText" )
    @JsonProperty( "P_ToPostingDateText" )
    @Nullable
    @ODataField( odataName = "P_ToPostingDateText" )
    private String p_ToPostingDateText;
    /**
     * Use with available fluent helpers to apply the <b>P_ToPostingDateText</b> field to query operations.
     *
     */
    public final static TRIALBALANCEParametersField<String> P_TO_POSTING_DATE_TEXT =
        new TRIALBALANCEParametersField<String>("P_ToPostingDateText");
    /**
     * Navigation property <b>Results</b> for <b>TRIALBALANCEParameters</b> to multiple <b>TRIALBALANCEResult</b>.
     *
     */
    @SerializedName( "Results" )
    @JsonProperty( "Results" )
    @ODataField( odataName = "Results" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TRIALBALANCEResult> toResults;
    /**
     * Use with available fluent helpers to apply the <b>Results</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEParametersLink<TRIALBALANCEResult> TO_RESULTS =
        new TRIALBALANCEParametersLink<TRIALBALANCEResult>("Results");

    @Nonnull
    @Override
    public Class<TRIALBALANCEParameters> getType()
    {
        return TRIALBALANCEParameters.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_FromPostingDate</b>
     * </p>
     *
     * @param p_FromPostingDate
     *            Posting Date From
     */
    public void setP_FromPostingDate( @Nullable final LocalDateTime p_FromPostingDate )
    {
        rememberChangedField("P_FromPostingDate", this.p_FromPostingDate);
        this.p_FromPostingDate = p_FromPostingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>P_FromPostingDateText</b>
     * </p>
     *
     * @param p_FromPostingDateText
     *            Posting Date From (Description)
     */
    public void setP_FromPostingDateText( @Nullable final String p_FromPostingDateText )
    {
        rememberChangedField("P_FromPostingDateText", this.p_FromPostingDateText);
        this.p_FromPostingDateText = p_FromPostingDateText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_ToPostingDate</b>
     * </p>
     *
     * @param p_ToPostingDate
     *            Posting Date To
     */
    public void setP_ToPostingDate( @Nullable final LocalDateTime p_ToPostingDate )
    {
        rememberChangedField("P_ToPostingDate", this.p_ToPostingDate);
        this.p_ToPostingDate = p_ToPostingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>P_ToPostingDateText</b>
     * </p>
     *
     * @param p_ToPostingDateText
     *            Posting Date To (Description)
     */
    public void setP_ToPostingDateText( @Nullable final String p_ToPostingDateText )
    {
        rememberChangedField("P_ToPostingDateText", this.p_ToPostingDateText);
        this.p_ToPostingDateText = p_ToPostingDateText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "C_TRIALBALANCE";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_FromPostingDate", getP_FromPostingDate());
        result.put("P_ToPostingDate", getP_ToPostingDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_FromPostingDate", getP_FromPostingDate());
        values.put("P_FromPostingDateText", getP_FromPostingDateText());
        values.put("P_ToPostingDate", getP_ToPostingDate());
        values.put("P_ToPostingDateText", getP_ToPostingDateText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_FromPostingDate") ) {
                final Object value = values.remove("P_FromPostingDate");
                if( (value == null) || (!value.equals(getP_FromPostingDate())) ) {
                    setP_FromPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_FromPostingDateText") ) {
                final Object value = values.remove("P_FromPostingDateText");
                if( (value == null) || (!value.equals(getP_FromPostingDateText())) ) {
                    setP_FromPostingDateText(((String) value));
                }
            }
            if( values.containsKey("P_ToPostingDate") ) {
                final Object value = values.remove("P_ToPostingDate");
                if( (value == null) || (!value.equals(getP_ToPostingDate())) ) {
                    setP_ToPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_ToPostingDateText") ) {
                final Object value = values.remove("P_ToPostingDateText");
                if( (value == null) || (!value.equals(getP_ToPostingDateText())) ) {
                    setP_ToPostingDateText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Results") ) {
                final Object value = (values).remove("Results");
                if( value instanceof Iterable ) {
                    if( toResults == null ) {
                        toResults = Lists.newArrayList();
                    } else {
                        toResults = Lists.newArrayList(toResults);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TRIALBALANCEResult entity;
                        if( toResults.size() > i ) {
                            entity = toResults.get(i);
                        } else {
                            entity = new TRIALBALANCEResult();
                            toResults.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> TRIALBALANCEParametersField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TRIALBALANCEParametersField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TRIALBALANCEParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TRIALBALANCEParametersField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResults != null ) {
            (values).put("Results", toResults);
        }
        return values;
    }

    /**
     * Fetches the <b>TRIALBALANCEResult</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>Results</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>TRIALBALANCEResult</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<TRIALBALANCEResult> fetchResults()
    {
        return fetchFieldAsList("Results", TRIALBALANCEResult.class);
    }

    /**
     * Retrieval of associated <b>TRIALBALANCEResult</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>TRIALBALANCEParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>TRIALBALANCEResult</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<TRIALBALANCEResult> getResultsOrFetch()
    {
        if( toResults == null ) {
            toResults = fetchResults();
        }
        return toResults;
    }

    /**
     * Retrieval of associated <b>TRIALBALANCEResult</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEParameters</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Results</b> is already loaded, the result will contain the
     *         <b>TRIALBALANCEResult</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<TRIALBALANCEResult>> getResultsIfPresent()
    {
        return Option.of(toResults);
    }

    /**
     * Overwrites the list of associated <b>TRIALBALANCEResult</b> entities for the loaded navigation property
     * <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>TRIALBALANCEParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>TRIALBALANCEResult</b> entities.
     */
    public void setResults( @Nonnull final List<TRIALBALANCEResult> value )
    {
        if( toResults == null ) {
            toResults = Lists.newArrayList();
        }
        toResults.clear();
        toResults.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TRIALBALANCEResult</b> entities. This corresponds to the OData
     * navigation property <b>Results</b>.
     * <p>
     * If the navigation property <b>Results</b> of a queried <b>TRIALBALANCEParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>TRIALBALANCEResult</b> entities.
     */
    public void addResults( TRIALBALANCEResult... entity )
    {
        if( toResults == null ) {
            toResults = Lists.newArrayList();
        }
        toResults.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of TRIALBALANCEParameters instances.
     *
     */
    public final static class TRIALBALANCEParametersBuilder
    {

        private List<TRIALBALANCEResult> toResults = Lists.newArrayList();

        private TRIALBALANCEParameters.TRIALBALANCEParametersBuilder toResults( final List<TRIALBALANCEResult> value )
        {
            toResults.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>Results</b> for <b>TRIALBALANCEParameters</b> to multiple <b>TRIALBALANCEResult</b>.
         *
         * @param value
         *            The TRIALBALANCEResults to build this TRIALBALANCEParameters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEParameters.TRIALBALANCEParametersBuilder results( TRIALBALANCEResult... value )
        {
            return toResults(Lists.newArrayList(value));
        }

    }

}
