/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.TRIALBALANCEParametersSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters
 * TRIALBALANCEParameters} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class TRIALBALANCEParametersByKeyFluentHelper
    extends
    FluentHelperByKey<TRIALBALANCEParametersByKeyFluentHelper, TRIALBALANCEParameters, TRIALBALANCEParametersSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters
     * TRIALBALANCEParameters} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param p_ToPostingDate
     *            Posting Date To
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code TRIALBALANCEParameters}
     * @param servicePath
     *            Service path to be used to fetch a single {@code TRIALBALANCEParameters}
     * @param p_FromPostingDate
     *            Posting Date From
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     */
    public TRIALBALANCEParametersByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final LocalDateTime p_FromPostingDate,
        final LocalDateTime p_ToPostingDate )
    {
        super(servicePath, entityCollection);
        this.key.put("P_FromPostingDate", p_FromPostingDate);
        this.key.put("P_ToPostingDate", p_ToPostingDate);
    }

    @Override
    @Nonnull
    protected Class<TRIALBALANCEParameters> getEntityClass()
    {
        return TRIALBALANCEParameters.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
