/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.TRIALBALANCEResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.TRIALBALANCEResultOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.TRIALBALANCEResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * Trial Balance
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>C_TRIALBALANCEResult</b>
 * </p>
 *
 */
@Data
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TRIALBALANCEResult extends VdmEntity<TRIALBALANCEResult>
{

    /**
     * Selector for all available fields of TRIALBALANCEResult.
     *
     */
    public final static TRIALBALANCEResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @return The iD contained in this entity.
     */
    @Key
    @SerializedName( "ID" )
    @JsonProperty( "ID" )
    @Nullable
    @ODataField( odataName = "ID" )
    private String iD;
    /**
     * Use with available fluent helpers to apply the <b>ID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ID = new TRIALBALANCEResultField<String>("ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TotaledProperties</b>
     * </p>
     *
     * @return The totaledProperties contained in this entity.
     */
    @SerializedName( "TotaledProperties" )
    @JsonProperty( "TotaledProperties" )
    @Nullable
    @ODataField( odataName = "TotaledProperties" )
    private String totaledProperties;
    /**
     * Use with available fluent helpers to apply the <b>TotaledProperties</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> TOTALED_PROPERTIES =
        new TRIALBALANCEResultField<String>("TotaledProperties");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COMPANY_CODE =
        new TRIALBALANCEResultField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COMPANY_CODE_NAME =
        new TRIALBALANCEResultField<String>("CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GL_ACCOUNT = new TRIALBALANCEResultField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchyName</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccountHierarchyName" )
    @JsonProperty( "GLAccountHierarchyName" )
    @Nullable
    @ODataField( odataName = "GLAccountHierarchyName" )
    private String gLAccountHierarchyName;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountHierarchyName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GL_ACCOUNT_HIERARCHY_NAME =
        new TRIALBALANCEResultField<String>("GLAccountHierarchyName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> BUSINESS_PROCESS =
        new TRIALBALANCEResultField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @return Freely Defined Currency 8
     */
    @SerializedName( "FreeDefinedCurrency8" )
    @JsonProperty( "FreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency8" )
    private String freeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY8 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostObject</b>
     * </p>
     *
     * @return Partner Cost Object
     */
    @SerializedName( "PartnerCostObject" )
    @JsonProperty( "PartnerCostObject" )
    @Nullable
    @ODataField( odataName = "PartnerCostObject" )
    private String partnerCostObject;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostObject</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_COST_OBJECT =
        new TRIALBALANCEResultField<String>("PartnerCostObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @return Asset Value Date
     */
    @SerializedName( "AssetValueDate" )
    @JsonProperty( "AssetValueDate" )
    @Nullable
    @ODataField( odataName = "AssetValueDate" )
    private String assetValueDate;
    /**
     * Use with available fluent helpers to apply the <b>AssetValueDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ASSET_VALUE_DATE =
        new TRIALBALANCEResultField<String>("AssetValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate_T</b>
     * </p>
     *
     * @return Asset Value Date
     */
    @SerializedName( "AssetValueDate_T" )
    @JsonProperty( "AssetValueDate_T" )
    @Nullable
    @ODataField( odataName = "AssetValueDate_T" )
    private String assetValueDate_T;
    /**
     * Use with available fluent helpers to apply the <b>AssetValueDate_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ASSET_VALUE_DATE_T =
        new TRIALBALANCEResultField<String>("AssetValueDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @return Fiscal Year Period
     */
    @SerializedName( "FiscalYearPeriod" )
    @JsonProperty( "FiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearPeriod" )
    private String fiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearPeriod</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_YEAR_PERIOD =
        new TRIALBALANCEResultField<String>("FiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete</b>
     * </p>
     *
     * @return Indicator: Quantity Is Incomplete
     */
    @SerializedName( "QuantityIsIncomplete" )
    @JsonProperty( "QuantityIsIncomplete" )
    @Nullable
    @ODataField( odataName = "QuantityIsIncomplete" )
    private String quantityIsIncomplete;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsIncomplete</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> QUANTITY_IS_INCOMPLETE =
        new TRIALBALANCEResultField<String>("QuantityIsIncomplete");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @return Managed on an Open Item Basis
     */
    @SerializedName( "IsOpenItemManaged" )
    @JsonProperty( "IsOpenItemManaged" )
    @Nullable
    @ODataField( odataName = "IsOpenItemManaged" )
    private String isOpenItemManaged;
    /**
     * Use with available fluent helpers to apply the <b>IsOpenItemManaged</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> IS_OPEN_ITEM_MANAGED =
        new TRIALBALANCEResultField<String>("IsOpenItemManaged");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @return Group Account Number
     */
    @SerializedName( "CorporateGroupAccount" )
    @JsonProperty( "CorporateGroupAccount" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccount" )
    private String corporateGroupAccount;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccount</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CORPORATE_GROUP_ACCOUNT =
        new TRIALBALANCEResultField<String>("CorporateGroupAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount_T</b>
     * </p>
     *
     * @return Group Account Number
     */
    @SerializedName( "CorporateGroupAccount_T" )
    @JsonProperty( "CorporateGroupAccount_T" )
    @Nullable
    @ODataField( odataName = "CorporateGroupAccount_T" )
    private String corporateGroupAccount_T;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupAccount_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CORPORATE_GROUP_ACCOUNT_T =
        new TRIALBALANCEResultField<String>("CorporateGroupAccount_T");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @return Billing Type
     */
    @SerializedName( "BillingDocumentType" )
    @JsonProperty( "BillingDocumentType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType" )
    private String billingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> BILLING_DOCUMENT_TYPE =
        new TRIALBALANCEResultField<String>("BillingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FiscalQuarter</b>
     * </p>
     *
     * @return Fiscal Quarter
     */
    @SerializedName( "FiscalQuarter" )
    @JsonProperty( "FiscalQuarter" )
    @Nullable
    @ODataField( odataName = "FiscalQuarter" )
    private String fiscalQuarter;
    /**
     * Use with available fluent helpers to apply the <b>FiscalQuarter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_QUARTER =
        new TRIALBALANCEResultField<String>("FiscalQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @return Group Chart of Accts
     */
    @SerializedName( "CorporateGroupChartOfAccounts" )
    @JsonProperty( "CorporateGroupChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CorporateGroupChartOfAccounts" )
    private String corporateGroupChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CorporateGroupChartOfAccounts</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CORPORATE_GROUP_CHART_OF_ACCOUNTS =
        new TRIALBALANCEResultField<String>("CorporateGroupChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Clearing Journal Entry (Deprecated)
     */
    @SerializedName( "ClearingDocFiscalYear" )
    @JsonProperty( "ClearingDocFiscalYear" )
    @Nullable
    @ODataField( odataName = "ClearingDocFiscalYear" )
    private String clearingDocFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDocFiscalYear</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CLEARING_DOC_FISCAL_YEAR =
        new TRIALBALANCEResultField<String>("ClearingDocFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @return Partner WBS Element
     */
    @SerializedName( "PartnerWBSElement" )
    @JsonProperty( "PartnerWBSElement" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElement" )
    private String partnerWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElement</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_WBS_ELEMENT =
        new TRIALBALANCEResultField<String>("PartnerWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @return Freely Defined Currency 2
     */
    @SerializedName( "FreeDefinedCurrency2" )
    @JsonProperty( "FreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency2" )
    private String freeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY2 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @SerializedName( "PartnerProfitCenter" )
    @JsonProperty( "PartnerProfitCenter" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter" )
    private String partnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_PROFIT_CENTER =
        new TRIALBALANCEResultField<String>("PartnerProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterName</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @SerializedName( "PartnerProfitCenterName" )
    @JsonProperty( "PartnerProfitCenterName" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenterName" )
    private String partnerProfitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenterName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_PROFIT_CENTER_NAME =
        new TRIALBALANCEResultField<String>("PartnerProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass</b>
     * </p>
     *
     * @return Partner Controlling Object Class
     */
    @SerializedName( "PartnerControllingObjectClass" )
    @JsonProperty( "PartnerControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "PartnerControllingObjectClass" )
    private String partnerControllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>PartnerControllingObjectClass</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_CONTROLLING_OBJECT_CLASS =
        new TRIALBALANCEResultField<String>("PartnerControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @return Type of a General Ledger Account
     */
    @SerializedName( "GLAccountType" )
    @JsonProperty( "GLAccountType" )
    @Nullable
    @ODataField( odataName = "GLAccountType" )
    private String gLAccountType;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GL_ACCOUNT_TYPE =
        new TRIALBALANCEResultField<String>("GLAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @return Journal Entry Category
     */
    @SerializedName( "AccountingDocumentCategory" )
    @JsonProperty( "AccountingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentCategory" )
    private String accountingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCategory</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ACCOUNTING_DOCUMENT_CATEGORY =
        new TRIALBALANCEResultField<String>("AccountingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "BusinessTransactionType" )
    @JsonProperty( "BusinessTransactionType" )
    @Nullable
    @ODataField( odataName = "BusinessTransactionType" )
    private String businessTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessTransactionType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> BUSINESS_TRANSACTION_TYPE =
        new TRIALBALANCEResultField<String>("BusinessTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @return Calendar Month
     */
    @SerializedName( "CalendarMonth" )
    @JsonProperty( "CalendarMonth" )
    @Nullable
    @ODataField( odataName = "CalendarMonth" )
    private String calendarMonth;
    /**
     * Use with available fluent helpers to apply the <b>CalendarMonth</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CALENDAR_MONTH =
        new TRIALBALANCEResultField<String>("CalendarMonth");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalendarQuarter</b>
     * </p>
     *
     * @return Calendar Quarter
     */
    @SerializedName( "CalendarQuarter" )
    @JsonProperty( "CalendarQuarter" )
    @Nullable
    @ODataField( odataName = "CalendarQuarter" )
    private String calendarQuarter;
    /**
     * Use with available fluent helpers to apply the <b>CalendarQuarter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CALENDAR_QUARTER =
        new TRIALBALANCEResultField<String>("CalendarQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @return Clearing Journal Entry (Deprecated)
     */
    @SerializedName( "ClearingAccountingDocument" )
    @JsonProperty( "ClearingAccountingDocument" )
    @Nullable
    @ODataField( odataName = "ClearingAccountingDocument" )
    private String clearingAccountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>ClearingAccountingDocument</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CLEARING_ACCOUNTING_DOCUMENT =
        new TRIALBALANCEResultField<String>("ClearingAccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @return Journal Entry Type
     */
    @SerializedName( "AccountingDocumentType" )
    @JsonProperty( "AccountingDocumentType" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentType" )
    private String accountingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ACCOUNTING_DOCUMENT_TYPE =
        new TRIALBALANCEResultField<String>("AccountingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @return Journal Entry Type
     */
    @SerializedName( "AccountingDocumentTypeName" )
    @JsonProperty( "AccountingDocumentTypeName" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentTypeName" )
    private String accountingDocumentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentTypeName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ACCOUNTING_DOCUMENT_TYPE_NAME =
        new TRIALBALANCEResultField<String>("AccountingDocumentTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "FinancialAccountType" )
    @JsonProperty( "FinancialAccountType" )
    @Nullable
    @ODataField( odataName = "FinancialAccountType" )
    private String financialAccountType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FINANCIAL_ACCOUNT_TYPE =
        new TRIALBALANCEResultField<String>("FinancialAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeName</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "FinancialAccountTypeName" )
    @JsonProperty( "FinancialAccountTypeName" )
    @Nullable
    @ODataField( odataName = "FinancialAccountTypeName" )
    private String financialAccountTypeName;
    /**
     * Use with available fluent helpers to apply the <b>FinancialAccountTypeName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FINANCIAL_ACCOUNT_TYPE_NAME =
        new TRIALBALANCEResultField<String>("FinancialAccountTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> BUSINESS_AREA =
        new TRIALBALANCEResultField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessAreaName" )
    @JsonProperty( "BusinessAreaName" )
    @Nullable
    @ODataField( odataName = "BusinessAreaName" )
    private String businessAreaName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessAreaName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> BUSINESS_AREA_NAME =
        new TRIALBALANCEResultField<String>("BusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType</b>
     * </p>
     *
     * @return Origin Cost Center Activity Type
     */
    @SerializedName( "OriginCostCtrActivityType" )
    @JsonProperty( "OriginCostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "OriginCostCtrActivityType" )
    private String originCostCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCtrActivityType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ORIGIN_COST_CTR_ACTIVITY_TYPE =
        new TRIALBALANCEResultField<String>("OriginCostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CHART_OF_ACCOUNTS =
        new TRIALBALANCEResultField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CONTROLLING_AREA =
        new TRIALBALANCEResultField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingAreaName" )
    @JsonProperty( "ControllingAreaName" )
    @Nullable
    @ODataField( odataName = "ControllingAreaName" )
    private String controllingAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ControllingAreaName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CONTROLLING_AREA_NAME =
        new TRIALBALANCEResultField<String>("ControllingAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @return Controlling Object Class
     */
    @SerializedName( "ControllingObjectClass" )
    @JsonProperty( "ControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "ControllingObjectClass" )
    private String controllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectClass</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CONTROLLING_OBJECT_CLASS =
        new TRIALBALANCEResultField<String>("ControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @SerializedName( "PartnerCostCenter" )
    @JsonProperty( "PartnerCostCenter" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter" )
    private String partnerCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_COST_CENTER =
        new TRIALBALANCEResultField<String>("PartnerCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderCostCenterName</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @SerializedName( "SenderCostCenterName" )
    @JsonProperty( "SenderCostCenterName" )
    @Nullable
    @ODataField( odataName = "SenderCostCenterName" )
    private String senderCostCenterName;
    /**
     * Use with available fluent helpers to apply the <b>SenderCostCenterName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SENDER_COST_CENTER_NAME =
        new TRIALBALANCEResultField<String>("SenderCostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_CREDIT_CODE =
        new TRIALBALANCEResultField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCodeName</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCodeName" )
    @JsonProperty( "DebitCreditCodeName" )
    @Nullable
    @ODataField( odataName = "DebitCreditCodeName" )
    private String debitCreditCodeName;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCodeName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_CREDIT_CODE_NAME =
        new TRIALBALANCEResultField<String>("DebitCreditCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @ODataField( odataName = "PostingDate" )
    private String postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> POSTING_DATE =
        new TRIALBALANCEResultField<String>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate_T</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate_T" )
    @JsonProperty( "PostingDate_T" )
    @Nullable
    @ODataField( odataName = "PostingDate_T" )
    private String postingDate_T;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> POSTING_DATE_T =
        new TRIALBALANCEResultField<String>("PostingDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_YEAR_VARIANT =
        new TRIALBALANCEResultField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FUNCTIONAL_AREA =
        new TRIALBALANCEResultField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalAreaName" )
    @JsonProperty( "FunctionalAreaName" )
    @Nullable
    @ODataField( odataName = "FunctionalAreaName" )
    private String functionalAreaName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FUNCTIONAL_AREA_NAME =
        new TRIALBALANCEResultField<String>("FunctionalAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_YEAR = new TRIALBALANCEResultField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> BUDGET_PERIOD =
        new TRIALBALANCEResultField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarWeek</b>
     * </p>
     *
     * @return Calendar Week
     */
    @SerializedName( "CalendarWeek" )
    @JsonProperty( "CalendarWeek" )
    @Nullable
    @ODataField( odataName = "CalendarWeek" )
    private String calendarWeek;
    /**
     * Use with available fluent helpers to apply the <b>CalendarWeek</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CALENDAR_WEEK =
        new TRIALBALANCEResultField<String>("CalendarWeek");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @return Calendar Year
     */
    @SerializedName( "CalendarYear" )
    @JsonProperty( "CalendarYear" )
    @Nullable
    @ODataField( odataName = "CalendarYear" )
    private String calendarYear;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYear</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CALENDAR_YEAR =
        new TRIALBALANCEResultField<String>("CalendarYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @return Clearing Date
     */
    @SerializedName( "ClearingDate" )
    @JsonProperty( "ClearingDate" )
    @Nullable
    @ODataField( odataName = "ClearingDate" )
    private String clearingDate;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CLEARING_DATE =
        new TRIALBALANCEResultField<String>("ClearingDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate_T</b>
     * </p>
     *
     * @return Clearing Date
     */
    @SerializedName( "ClearingDate_T" )
    @JsonProperty( "ClearingDate_T" )
    @Nullable
    @ODataField( odataName = "ClearingDate_T" )
    private String clearingDate_T;
    /**
     * Use with available fluent helpers to apply the <b>ClearingDate_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CLEARING_DATE_T =
        new TRIALBALANCEResultField<String>("ClearingDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COST_CENTER = new TRIALBALANCEResultField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenterName" )
    @JsonProperty( "CostCenterName" )
    @Nullable
    @ODataField( odataName = "CostCenterName" )
    private String costCenterName;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COST_CENTER_NAME =
        new TRIALBALANCEResultField<String>("CostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COST_OBJECT = new TRIALBALANCEResultField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_PERIOD =
        new TRIALBALANCEResultField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalWeek</b>
     * </p>
     *
     * @return Fiscal Week
     */
    @SerializedName( "FiscalWeek" )
    @JsonProperty( "FiscalWeek" )
    @Nullable
    @ODataField( odataName = "FiscalWeek" )
    private String fiscalWeek;
    /**
     * Use with available fluent helpers to apply the <b>FiscalWeek</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_WEEK = new TRIALBALANCEResultField<String>("FiscalWeek");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FUND = new TRIALBALANCEResultField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GRANT_ID = new TRIALBALANCEResultField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @return Indicator: Item is Reversing Another Item
     */
    @SerializedName( "IsReversal" )
    @JsonProperty( "IsReversal" )
    @Nullable
    @ODataField( odataName = "IsReversal" )
    private String isReversal;
    /**
     * Use with available fluent helpers to apply the <b>IsReversal</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> IS_REVERSAL = new TRIALBALANCEResultField<String>("IsReversal");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @return Indicator: Item is Reversed
     */
    @SerializedName( "IsReversed" )
    @JsonProperty( "IsReversed" )
    @Nullable
    @ODataField( odataName = "IsReversed" )
    private String isReversed;
    /**
     * Use with available fluent helpers to apply the <b>IsReversed</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> IS_REVERSED = new TRIALBALANCEResultField<String>("IsReversed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled</b>
     * </p>
     *
     * @return Indicator: Line Item is Settled or Transferred
     */
    @SerializedName( "IsSettled" )
    @JsonProperty( "IsSettled" )
    @Nullable
    @ODataField( odataName = "IsSettled" )
    private String isSettled;
    /**
     * Use with available fluent helpers to apply the <b>IsSettled</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> IS_SETTLED = new TRIALBALANCEResultField<String>("IsSettled");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement</b>
     * </p>
     *
     * @return Indicator: Item is Settling or Transferring Another Item
     */
    @SerializedName( "IsSettlement" )
    @JsonProperty( "IsSettlement" )
    @Nullable
    @ODataField( odataName = "IsSettlement" )
    private String isSettlement;
    /**
     * Use with available fluent helpers to apply the <b>IsSettlement</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> IS_SETTLEMENT =
        new TRIALBALANCEResultField<String>("IsSettlement");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @return Joint Venture
     */
    @SerializedName( "JointVenture" )
    @JsonProperty( "JointVenture" )
    @Nullable
    @ODataField( odataName = "JointVenture" )
    private String jointVenture;
    /**
     * Use with available fluent helpers to apply the <b>JointVenture</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> JOINT_VENTURE =
        new TRIALBALANCEResultField<String>("JointVenture");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ORDER_ID = new TRIALBALANCEResultField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @return Partner Fund
     */
    @SerializedName( "PartnerFund" )
    @JsonProperty( "PartnerFund" )
    @Nullable
    @ODataField( odataName = "PartnerFund" )
    private String partnerFund;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFund</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_FUND =
        new TRIALBALANCEResultField<String>("PartnerFund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @return Partner Grant
     */
    @SerializedName( "PartnerGrant" )
    @JsonProperty( "PartnerGrant" )
    @Nullable
    @ODataField( odataName = "PartnerGrant" )
    private String partnerGrant;
    /**
     * Use with available fluent helpers to apply the <b>PartnerGrant</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_GRANT =
        new TRIALBALANCEResultField<String>("PartnerGrant");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @return Partner Order
     */
    @SerializedName( "PartnerOrder" )
    @JsonProperty( "PartnerOrder" )
    @Nullable
    @ODataField( odataName = "PartnerOrder" )
    private String partnerOrder;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrder</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_ORDER =
        new TRIALBALANCEResultField<String>("PartnerOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SALES_ORDER = new TRIALBALANCEResultField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldMaterial</b>
     * </p>
     *
     * @return Product Sold (Deprecated)
     */
    @SerializedName( "SoldMaterial" )
    @JsonProperty( "SoldMaterial" )
    @Nullable
    @ODataField( odataName = "SoldMaterial" )
    private String soldMaterial;
    /**
     * Use with available fluent helpers to apply the <b>SoldMaterial</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SOLD_MATERIAL =
        new TRIALBALANCEResultField<String>("SoldMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @return Product Sold
     */
    @SerializedName( "SoldProduct" )
    @JsonProperty( "SoldProduct" )
    @Nullable
    @ODataField( odataName = "SoldProduct" )
    private String soldProduct;
    /**
     * Use with available fluent helpers to apply the <b>SoldProduct</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SOLD_PRODUCT =
        new TRIALBALANCEResultField<String>("SoldProduct");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> TAX_CODE = new TRIALBALANCEResultField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> WBS_ELEMENT = new TRIALBALANCEResultField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @return House Bank Key
     */
    @SerializedName( "HouseBank" )
    @JsonProperty( "HouseBank" )
    @Nullable
    @ODataField( odataName = "HouseBank" )
    private String houseBank;
    /**
     * Use with available fluent helpers to apply the <b>HouseBank</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> HOUSE_BANK = new TRIALBALANCEResultField<String>("HouseBank");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @return Inventory Special Stock Valuation Type (Deprecated)
     */
    @SerializedName( "InventorySpecialStockValnType" )
    @JsonProperty( "InventorySpecialStockValnType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockValnType" )
    private String inventorySpecialStockValnType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockValnType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVENTORY_SPECIAL_STOCK_VALN_TYPE =
        new TRIALBALANCEResultField<String>("InventorySpecialStockValnType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> LEDGER = new TRIALBALANCEResultField<String>("Ledger");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Fixed Asset
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> MASTER_FIXED_ASSET =
        new TRIALBALANCEResultField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @return Posting Key
     */
    @SerializedName( "PostingKey" )
    @JsonProperty( "PostingKey" )
    @Nullable
    @ODataField( odataName = "PostingKey" )
    private String postingKey;
    /**
     * Use with available fluent helpers to apply the <b>PostingKey</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> POSTING_KEY = new TRIALBALANCEResultField<String>("PostingKey");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyName</b>
     * </p>
     *
     * @return Posting Key
     */
    @SerializedName( "PostingKeyName" )
    @JsonProperty( "PostingKeyName" )
    @Nullable
    @ODataField( odataName = "PostingKeyName" )
    private String postingKeyName;
    /**
     * Use with available fluent helpers to apply the <b>PostingKeyName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> POSTING_KEY_NAME =
        new TRIALBALANCEResultField<String>("PostingKeyName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PROFIT_CENTER =
        new TRIALBALANCEResultField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenterName" )
    @JsonProperty( "ProfitCenterName" )
    @Nullable
    @ODataField( odataName = "ProfitCenterName" )
    private String profitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PROFIT_CENTER_NAME =
        new TRIALBALANCEResultField<String>("ProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SEGMENT = new TRIALBALANCEResultField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "SegmentName" )
    @JsonProperty( "SegmentName" )
    @Nullable
    @ODataField( odataName = "SegmentName" )
    private String segmentName;
    /**
     * Use with available fluent helpers to apply the <b>SegmentName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SEGMENT_NAME =
        new TRIALBALANCEResultField<String>("SegmentName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @return Special G/L Indicator
     */
    @SerializedName( "SpecialGLCode" )
    @JsonProperty( "SpecialGLCode" )
    @Nullable
    @ODataField( odataName = "SpecialGLCode" )
    private String specialGLCode;
    /**
     * Use with available fluent helpers to apply the <b>SpecialGLCode</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SPECIAL_GL_CODE =
        new TRIALBALANCEResultField<String>("SpecialGLCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Financial Transaction Type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FINANCIAL_TRANSACTION_TYPE =
        new TRIALBALANCEResultField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FIXED_ASSET = new TRIALBALANCEResultField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @return Joint Venture Equity Type
     */
    @SerializedName( "JointVentureEquityType" )
    @JsonProperty( "JointVentureEquityType" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityType" )
    private String jointVentureEquityType;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> JOINT_VENTURE_EQUITY_TYPE =
        new TRIALBALANCEResultField<String>("JointVentureEquityType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @return House Bank Account
     */
    @SerializedName( "HouseBankAccount" )
    @JsonProperty( "HouseBankAccount" )
    @Nullable
    @ODataField( odataName = "HouseBankAccount" )
    private String houseBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>HouseBankAccount</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> HOUSE_BANK_ACCOUNT =
        new TRIALBALANCEResultField<String>("HouseBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Inventory Special Stock Type
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new TRIALBALANCEResultField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @return Alternative G/L Account Number In Company Code
     */
    @SerializedName( "AlternativeGLAccount" )
    @JsonProperty( "AlternativeGLAccount" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccount" )
    private String alternativeGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccount</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ALTERNATIVE_GL_ACCOUNT =
        new TRIALBALANCEResultField<String>("AlternativeGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount_T</b>
     * </p>
     *
     * @return Alternative G/L Account Number In Company Code
     */
    @SerializedName( "AlternativeGLAccount_T" )
    @JsonProperty( "AlternativeGLAccount_T" )
    @Nullable
    @ODataField( odataName = "AlternativeGLAccount_T" )
    private String alternativeGLAccount_T;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeGLAccount_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ALTERNATIVE_GL_ACCOUNT_T =
        new TRIALBALANCEResultField<String>("AlternativeGLAccount_T");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Product (Deprecated)
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> MATERIAL = new TRIALBALANCEResultField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Sold Group (Deprecated)
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> MATERIAL_GROUP =
        new TRIALBALANCEResultField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PLANT = new TRIALBALANCEResultField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PLANT_NAME = new TRIALBALANCEResultField<String>("PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @return Order Category
     */
    @SerializedName( "OrderCategory" )
    @JsonProperty( "OrderCategory" )
    @Nullable
    @ODataField( odataName = "OrderCategory" )
    private String orderCategory;
    /**
     * Use with available fluent helpers to apply the <b>OrderCategory</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ORDER_CATEGORY =
        new TRIALBALANCEResultField<String>("OrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PRODUCT = new TRIALBALANCEResultField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> MATERIAL_NAME =
        new TRIALBALANCEResultField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @SerializedName( "ProductGroup" )
    @JsonProperty( "ProductGroup" )
    @Nullable
    @ODataField( odataName = "ProductGroup" )
    private String productGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProductGroup</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PRODUCT_GROUP =
        new TRIALBALANCEResultField<String>("ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PROJECT = new TRIALBALANCEResultField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @return Valuation Area
     */
    @SerializedName( "ValuationArea" )
    @JsonProperty( "ValuationArea" )
    @Nullable
    @ODataField( odataName = "ValuationArea" )
    private String valuationArea;
    /**
     * Use with available fluent helpers to apply the <b>ValuationArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> VALUATION_AREA =
        new TRIALBALANCEResultField<String>("ValuationArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CUSTOMER_GROUP =
        new TRIALBALANCEResultField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupName</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroupName" )
    @JsonProperty( "CustomerGroupName" )
    @Nullable
    @ODataField( odataName = "CustomerGroupName" )
    private String customerGroupName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroupName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CUSTOMER_GROUP_NAME =
        new TRIALBALANCEResultField<String>("CustomerGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @return Inventory Special Stock Sales Document
     */
    @SerializedName( "InventorySpclStkSalesDocument" )
    @JsonProperty( "InventorySpclStkSalesDocument" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocument" )
    private String inventorySpclStkSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocument</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVENTORY_SPCL_STK_SALES_DOCUMENT =
        new TRIALBALANCEResultField<String>("InventorySpclStkSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @return Inventory Special Stock Sales Document Item
     */
    @SerializedName( "InventorySpclStkSalesDocItm" )
    @JsonProperty( "InventorySpclStkSalesDocItm" )
    @Nullable
    @ODataField( odataName = "InventorySpclStkSalesDocItm" )
    private String inventorySpclStkSalesDocItm;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStkSalesDocItm</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVENTORY_SPCL_STK_SALES_DOC_ITM =
        new TRIALBALANCEResultField<String>("InventorySpclStkSalesDocItm");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntIntID</b>
     * </p>
     *
     * @return Inventory Special Stock WBS Element Internal ID
     */
    @SerializedName( "InvtrySpclStockWBSElmntIntID" )
    @JsonProperty( "InvtrySpclStockWBSElmntIntID" )
    @Nullable
    @ODataField( odataName = "InvtrySpclStockWBSElmntIntID" )
    private String invtrySpclStockWBSElmntIntID;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpclStockWBSElmntIntID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVTRY_SPCL_STOCK_WBS_ELMNT_INT_ID =
        new TRIALBALANCEResultField<String>("InvtrySpclStockWBSElmntIntID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElement</b>
     * </p>
     *
     * @return WBS Element (external) of Valuated Special Inventory
     */
    @SerializedName( "InventorySpclStockWBSElement" )
    @JsonProperty( "InventorySpclStockWBSElement" )
    @Nullable
    @ODataField( odataName = "InventorySpclStockWBSElement" )
    private String inventorySpclStockWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpclStockWBSElement</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVENTORY_SPCL_STOCK_WBS_ELEMENT =
        new TRIALBALANCEResultField<String>("InventorySpclStockWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearMonth</b>
     * </p>
     *
     * @return Year Month
     */
    @SerializedName( "CalendarYearMonth" )
    @JsonProperty( "CalendarYearMonth" )
    @Nullable
    @ODataField( odataName = "CalendarYearMonth" )
    private String calendarYearMonth;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYearMonth</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CALENDAR_YEAR_MONTH =
        new TRIALBALANCEResultField<String>("CalendarYearMonth");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CUSTOMER = new TRIALBALANCEResultField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "CustomerName" )
    @JsonProperty( "CustomerName" )
    @Nullable
    @ODataField( odataName = "CustomerName" )
    private String customerName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CUSTOMER_NAME =
        new TRIALBALANCEResultField<String>("CustomerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SUPPLIER = new TRIALBALANCEResultField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "SupplierName" )
    @JsonProperty( "SupplierName" )
    @Nullable
    @ODataField( odataName = "SupplierName" )
    private String supplierName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SUPPLIER_NAME =
        new TRIALBALANCEResultField<String>("SupplierName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @return Balance Transaction Currency
     */
    @SerializedName( "BalanceTransactionCurrency" )
    @JsonProperty( "BalanceTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "BalanceTransactionCurrency" )
    private String balanceTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>BalanceTransactionCurrency</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> BALANCE_TRANSACTION_CURRENCY =
        new TRIALBALANCEResultField<String>("BalanceTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Reference
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ASSIGNMENT_REFERENCE =
        new TRIALBALANCEResultField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return WBS Element External ID
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> WBS_ELEMENT_EXTERNAL_ID =
        new TRIALBALANCEResultField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ORGANIZATION_DIVISION =
        new TRIALBALANCEResultField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetworkActivity</b>
     * </p>
     *
     * @return Partner Project Network Activity
     */
    @SerializedName( "PartnerProjectNetworkActivity" )
    @JsonProperty( "PartnerProjectNetworkActivity" )
    @Nullable
    @ODataField( odataName = "PartnerProjectNetworkActivity" )
    private String partnerProjectNetworkActivity;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectNetworkActivity</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_PROJECT_NETWORK_ACTIVITY =
        new TRIALBALANCEResultField<String>("PartnerProjectNetworkActivity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearQuarter</b>
     * </p>
     *
     * @return Year Quarter
     */
    @SerializedName( "CalendarYearQuarter" )
    @JsonProperty( "CalendarYearQuarter" )
    @Nullable
    @ODataField( odataName = "CalendarYearQuarter" )
    private String calendarYearQuarter;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYearQuarter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CALENDAR_YEAR_QUARTER =
        new TRIALBALANCEResultField<String>("CalendarYearQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @return Indicator: Account is a balance sheet account?
     */
    @SerializedName( "IsBalanceSheetAccount" )
    @JsonProperty( "IsBalanceSheetAccount" )
    @Nullable
    @ODataField( odataName = "IsBalanceSheetAccount" )
    private String isBalanceSheetAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsBalanceSheetAccount</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> IS_BALANCE_SHEET_ACCOUNT =
        new TRIALBALANCEResultField<String>("IsBalanceSheetAccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @return Partner Account Assignment Type
     */
    @SerializedName( "PartnerAccountAssignmentType" )
    @JsonProperty( "PartnerAccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "PartnerAccountAssignmentType" )
    private String partnerAccountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountAssignmentType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_ACCOUNT_ASSIGNMENT_TYPE =
        new TRIALBALANCEResultField<String>("PartnerAccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearWeek</b>
     * </p>
     *
     * @return Fiscal Year + Fiscal Week
     */
    @SerializedName( "FiscalYearWeek" )
    @JsonProperty( "FiscalYearWeek" )
    @Nullable
    @ODataField( odataName = "FiscalYearWeek" )
    private String fiscalYearWeek;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearWeek</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_YEAR_WEEK =
        new TRIALBALANCEResultField<String>("FiscalYearWeek");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     *
     * @return Joint Venture Equity Group
     */
    @SerializedName( "JointVentureEquityGroup" )
    @JsonProperty( "JointVentureEquityGroup" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityGroup" )
    private String jointVentureEquityGroup;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityGroup</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> JOINT_VENTURE_EQUITY_GROUP =
        new TRIALBALANCEResultField<String>("JointVentureEquityGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FINANCIAL_MANAGEMENT_AREA =
        new TRIALBALANCEResultField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COST_CTR_ACTIVITY_TYPE =
        new TRIALBALANCEResultField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignment</b>
     * </p>
     *
     * @return Sender Account Assignment
     */
    @SerializedName( "SenderAccountAssignment" )
    @JsonProperty( "SenderAccountAssignment" )
    @Nullable
    @ODataField( odataName = "SenderAccountAssignment" )
    private String senderAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>SenderAccountAssignment</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SENDER_ACCOUNT_ASSIGNMENT =
        new TRIALBALANCEResultField<String>("SenderAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearQuarter</b>
     * </p>
     *
     * @return Fiscal Year + Fiscal Quarter
     */
    @SerializedName( "FiscalYearQuarter" )
    @JsonProperty( "FiscalYearQuarter" )
    @Nullable
    @ODataField( odataName = "FiscalYearQuarter" )
    private String fiscalYearQuarter;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearQuarter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_YEAR_QUARTER =
        new TRIALBALANCEResultField<String>("FiscalYearQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Document Type
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> REFERENCE_DOCUMENT_TYPE =
        new TRIALBALANCEResultField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset</b>
     * </p>
     *
     * @return Group Asset Subnumber
     */
    @SerializedName( "GroupFixedAsset" )
    @JsonProperty( "GroupFixedAsset" )
    @Nullable
    @ODataField( odataName = "GroupFixedAsset" )
    private String groupFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>GroupFixedAsset</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GROUP_FIXED_ASSET =
        new TRIALBALANCEResultField<String>("GroupFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItemGroup</b>
     * </p>
     *
     * @return Reference Document Item Group
     */
    @SerializedName( "ReferenceDocumentItemGroup" )
    @JsonProperty( "ReferenceDocumentItemGroup" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItemGroup" )
    private String referenceDocumentItemGroup;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItemGroup</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> REFERENCE_DOCUMENT_ITEM_GROUP =
        new TRIALBALANCEResultField<String>("ReferenceDocumentItemGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetDepreciationArea</b>
     * </p>
     *
     * @return Asset Depreciation Area (Real or Derived)
     */
    @SerializedName( "AssetDepreciationArea" )
    @JsonProperty( "AssetDepreciationArea" )
    @Nullable
    @ODataField( odataName = "AssetDepreciationArea" )
    private String assetDepreciationArea;
    /**
     * Use with available fluent helpers to apply the <b>AssetDepreciationArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ASSET_DEPRECIATION_AREA =
        new TRIALBALANCEResultField<String>("AssetDepreciationArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @return Partner Segment for Segmental Reporting
     */
    @SerializedName( "PartnerSegment" )
    @JsonProperty( "PartnerSegment" )
    @Nullable
    @ODataField( odataName = "PartnerSegment" )
    private String partnerSegment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_SEGMENT =
        new TRIALBALANCEResultField<String>("PartnerSegment");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentName</b>
     * </p>
     *
     * @return Partner Segment for Segmental Reporting
     */
    @SerializedName( "PartnerSegmentName" )
    @JsonProperty( "PartnerSegmentName" )
    @Nullable
    @ODataField( odataName = "PartnerSegmentName" )
    private String partnerSegmentName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegmentName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_SEGMENT_NAME =
        new TRIALBALANCEResultField<String>("PartnerSegmentName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntry</b>
     * </p>
     *
     * @return Clearing Journal Entry
     */
    @SerializedName( "ClearingJournalEntry" )
    @JsonProperty( "ClearingJournalEntry" )
    @Nullable
    @ODataField( odataName = "ClearingJournalEntry" )
    private String clearingJournalEntry;
    /**
     * Use with available fluent helpers to apply the <b>ClearingJournalEntry</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CLEARING_JOURNAL_ENTRY =
        new TRIALBALANCEResultField<String>("ClearingJournalEntry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @return Operating Concern
     */
    @SerializedName( "OperatingConcern" )
    @JsonProperty( "OperatingConcern" )
    @Nullable
    @ODataField( odataName = "OperatingConcern" )
    private String operatingConcern;
    /**
     * Use with available fluent helpers to apply the <b>OperatingConcern</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> OPERATING_CONCERN =
        new TRIALBALANCEResultField<String>("OperatingConcern");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtID</b>
     * </p>
     *
     * @return Inventory Special Stock WBS Element External ID
     */
    @SerializedName( "InvtrySpclStockWBSElmntExtID" )
    @JsonProperty( "InvtrySpclStockWBSElmntExtID" )
    @Nullable
    @ODataField( odataName = "InvtrySpclStockWBSElmntExtID" )
    private String invtrySpclStockWBSElmntExtID;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpclStockWBSElmntExtID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVTRY_SPCL_STOCK_WBS_ELMNT_EXT_ID =
        new TRIALBALANCEResultField<String>("InvtrySpclStockWBSElmntExtID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate</b>
     * </p>
     *
     * @return End Date of Fiscal Period
     */
    @SerializedName( "FiscalPeriodEndDate" )
    @JsonProperty( "FiscalPeriodEndDate" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodEndDate" )
    private String fiscalPeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodEndDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_PERIOD_END_DATE =
        new TRIALBALANCEResultField<String>("FiscalPeriodEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate_T</b>
     * </p>
     *
     * @return End Date of Fiscal Period
     */
    @SerializedName( "FiscalPeriodEndDate_T" )
    @JsonProperty( "FiscalPeriodEndDate_T" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodEndDate_T" )
    private String fiscalPeriodEndDate_T;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodEndDate_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_PERIOD_END_DATE_T =
        new TRIALBALANCEResultField<String>("FiscalPeriodEndDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @return Alternative Chart of Accounts for Country/Region
     */
    @SerializedName( "CountryChartOfAccounts" )
    @JsonProperty( "CountryChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CountryChartOfAccounts" )
    private String countryChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CountryChartOfAccounts</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COUNTRY_CHART_OF_ACCOUNTS =
        new TRIALBALANCEResultField<String>("CountryChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate</b>
     * </p>
     *
     * @return Start Date of Fiscal Period
     */
    @SerializedName( "FiscalPeriodStartDate" )
    @JsonProperty( "FiscalPeriodStartDate" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodStartDate" )
    private String fiscalPeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodStartDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_PERIOD_START_DATE =
        new TRIALBALANCEResultField<String>("FiscalPeriodStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate_T</b>
     * </p>
     *
     * @return Start Date of Fiscal Period
     */
    @SerializedName( "FiscalPeriodStartDate_T" )
    @JsonProperty( "FiscalPeriodStartDate_T" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodStartDate_T" )
    private String fiscalPeriodStartDate_T;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodStartDate_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_PERIOD_START_DATE_T =
        new TRIALBALANCEResultField<String>("FiscalPeriodStartDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @return Freely Defined Currency 6
     */
    @SerializedName( "FreeDefinedCurrency6" )
    @JsonProperty( "FreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency6" )
    private String freeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY6 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> TRANSACTION_CURRENCY =
        new TRIALBALANCEResultField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @return Account Assignment
     */
    @SerializedName( "AccountAssignment" )
    @JsonProperty( "AccountAssignment" )
    @Nullable
    @ODataField( odataName = "AccountAssignment" )
    private String accountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignment</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ACCOUNT_ASSIGNMENT =
        new TRIALBALANCEResultField<String>("AccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @return Partner Cost Center Activity Type
     */
    @SerializedName( "PartnerCostCtrActivityType" )
    @JsonProperty( "PartnerCostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "PartnerCostCtrActivityType" )
    private String partnerCostCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCtrActivityType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_COST_CTR_ACTIVITY_TYPE =
        new TRIALBALANCEResultField<String>("PartnerCostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessProcess</b>
     * </p>
     *
     * @return Partner Business Process
     */
    @SerializedName( "PartnerBusinessProcess" )
    @JsonProperty( "PartnerBusinessProcess" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessProcess" )
    private String partnerBusinessProcess;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessProcess</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_BUSINESS_PROCESS =
        new TRIALBALANCEResultField<String>("PartnerBusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RelatedNetworkActivity</b>
     * </p>
     *
     * @return Related Network Activity
     */
    @SerializedName( "RelatedNetworkActivity" )
    @JsonProperty( "RelatedNetworkActivity" )
    @Nullable
    @ODataField( odataName = "RelatedNetworkActivity" )
    private String relatedNetworkActivity;
    /**
     * Use with available fluent helpers to apply the <b>RelatedNetworkActivity</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> RELATED_NETWORK_ACTIVITY =
        new TRIALBALANCEResultField<String>("RelatedNetworkActivity");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SALES_DOCUMENT =
        new TRIALBALANCEResultField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @return Freely Defined Currency 1
     */
    @SerializedName( "FreeDefinedCurrency1" )
    @JsonProperty( "FreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency1" )
    private String freeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY1 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodDate</b>
     * </p>
     *
     * @return Fiscal Period Date
     */
    @SerializedName( "FiscalPeriodDate" )
    @JsonProperty( "FiscalPeriodDate" )
    @Nullable
    @ODataField( odataName = "FiscalPeriodDate" )
    private String fiscalPeriodDate;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriodDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FISCAL_PERIOD_DATE =
        new TRIALBALANCEResultField<String>("FiscalPeriodDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @return Freely Defined Currency 3
     */
    @SerializedName( "FreeDefinedCurrency3" )
    @JsonProperty( "FreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency3" )
    private String freeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY3 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @return Asset Transaction Type
     */
    @SerializedName( "AssetTransactionType" )
    @JsonProperty( "AssetTransactionType" )
    @Nullable
    @ODataField( odataName = "AssetTransactionType" )
    private String assetTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>AssetTransactionType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ASSET_TRANSACTION_TYPE =
        new TRIALBALANCEResultField<String>("AssetTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PURCHASING_DOCUMENT =
        new TRIALBALANCEResultField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2</b>
     * </p>
     *
     * @return Inventory Special Stock Valuation Type
     */
    @SerializedName( "InvtrySpecialStockValnType_2" )
    @JsonProperty( "InvtrySpecialStockValnType_2" )
    @Nullable
    @ODataField( odataName = "InvtrySpecialStockValnType_2" )
    private String invtrySpecialStockValnType_2;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpecialStockValnType_2</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVTRY_SPECIAL_STOCK_VALN_TYPE_2 =
        new TRIALBALANCEResultField<String>("InvtrySpecialStockValnType_2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter</b>
     * </p>
     *
     * @return Elimination Profit Center
     */
    @SerializedName( "EliminationProfitCenter" )
    @JsonProperty( "EliminationProfitCenter" )
    @Nullable
    @ODataField( odataName = "EliminationProfitCenter" )
    private String eliminationProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>EliminationProfitCenter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ELIMINATION_PROFIT_CENTER =
        new TRIALBALANCEResultField<String>("EliminationProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenterName</b>
     * </p>
     *
     * @return Elimination Profit Center
     */
    @SerializedName( "EliminationProfitCenterName" )
    @JsonProperty( "EliminationProfitCenterName" )
    @Nullable
    @ODataField( odataName = "EliminationProfitCenterName" )
    private String eliminationProfitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>EliminationProfitCenterName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ELIMINATION_PROFIT_CENTER_NAME =
        new TRIALBALANCEResultField<String>("EliminationProfitCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @return Global Currency
     */
    @SerializedName( "GlobalCurrency" )
    @JsonProperty( "GlobalCurrency" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency" )
    private String globalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GLOBAL_CURRENCY =
        new TRIALBALANCEResultField<String>("GlobalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType</b>
     * </p>
     *
     * @return Predecessor Reference Document Type
     */
    @SerializedName( "PredecessorReferenceDocType" )
    @JsonProperty( "PredecessorReferenceDocType" )
    @Nullable
    @ODataField( odataName = "PredecessorReferenceDocType" )
    private String predecessorReferenceDocType;
    /**
     * Use with available fluent helpers to apply the <b>PredecessorReferenceDocType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PREDECESSOR_REFERENCE_DOC_TYPE =
        new TRIALBALANCEResultField<String>("PredecessorReferenceDocType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Ledger
     */
    @SerializedName( "LedgerFiscalYear" )
    @JsonProperty( "LedgerFiscalYear" )
    @Nullable
    @ODataField( odataName = "LedgerFiscalYear" )
    private String ledgerFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>LedgerFiscalYear</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> LEDGER_FISCAL_YEAR =
        new TRIALBALANCEResultField<String>("LedgerFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @return Partner Sales Document
     */
    @SerializedName( "PartnerSalesDocument" )
    @JsonProperty( "PartnerSalesDocument" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocument" )
    private String partnerSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocument</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_SALES_DOCUMENT =
        new TRIALBALANCEResultField<String>("PartnerSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignment</b>
     * </p>
     *
     * @return Partner Account Assignment
     */
    @SerializedName( "PartnerAccountAssignment" )
    @JsonProperty( "PartnerAccountAssignment" )
    @Nullable
    @ODataField( odataName = "PartnerAccountAssignment" )
    private String partnerAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountAssignment</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_ACCOUNT_ASSIGNMENT =
        new TRIALBALANCEResultField<String>("PartnerAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @return Offsetting Account
     */
    @SerializedName( "OffsettingAccount" )
    @JsonProperty( "OffsettingAccount" )
    @Nullable
    @ODataField( odataName = "OffsettingAccount" )
    private String offsettingAccount;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccount</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> OFFSETTING_ACCOUNT =
        new TRIALBALANCEResultField<String>("OffsettingAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @return FM: Partner Budget Period
     */
    @SerializedName( "PartnerBudgetPeriod" )
    @JsonProperty( "PartnerBudgetPeriod" )
    @Nullable
    @ODataField( odataName = "PartnerBudgetPeriod" )
    private String partnerBudgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBudgetPeriod</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_BUDGET_PERIOD =
        new TRIALBALANCEResultField<String>("PartnerBudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @return User that created the journal entry
     */
    @SerializedName( "AccountingDocCreatedByUser" )
    @JsonProperty( "AccountingDocCreatedByUser" )
    @Nullable
    @ODataField( odataName = "AccountingDocCreatedByUser" )
    private String accountingDocCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocCreatedByUser</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ACCOUNTING_DOC_CREATED_BY_USER =
        new TRIALBALANCEResultField<String>("AccountingDocCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @return Freely Defined Currency 4
     */
    @SerializedName( "FreeDefinedCurrency4" )
    @JsonProperty( "FreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency4" )
    private String freeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY4 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PROJECT_NETWORK =
        new TRIALBALANCEResultField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted</b>
     * </p>
     *
     * @return Indicator: Line Item is Completed
     */
    @SerializedName( "LineItemIsCompleted" )
    @JsonProperty( "LineItemIsCompleted" )
    @Nullable
    @ODataField( odataName = "LineItemIsCompleted" )
    private String lineItemIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>LineItemIsCompleted</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> LINE_ITEM_IS_COMPLETED =
        new TRIALBALANCEResultField<String>("LineItemIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID</b>
     * </p>
     *
     * @return Partner Project Internal ID
     */
    @SerializedName( "PartnerProjectInternalID" )
    @JsonProperty( "PartnerProjectInternalID" )
    @Nullable
    @ODataField( odataName = "PartnerProjectInternalID" )
    private String partnerProjectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectInternalID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_PROJECT_INTERNAL_ID =
        new TRIALBALANCEResultField<String>("PartnerProjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectExternalID</b>
     * </p>
     *
     * @return Partner Project External ID
     */
    @SerializedName( "PartnerProjectExternalID" )
    @JsonProperty( "PartnerProjectExternalID" )
    @Nullable
    @ODataField( odataName = "PartnerProjectExternalID" )
    private String partnerProjectExternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectExternalID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_PROJECT_EXTERNAL_ID =
        new TRIALBALANCEResultField<String>("PartnerProjectExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @return Joint Venture Cost Recovery Code
     */
    @SerializedName( "JointVentureCostRecoveryCode" )
    @JsonProperty( "JointVentureCostRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureCostRecoveryCode" )
    private String jointVentureCostRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureCostRecoveryCode</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> JOINT_VENTURE_COST_RECOVERY_CODE =
        new TRIALBALANCEResultField<String>("JointVentureCostRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier</b>
     * </p>
     *
     * @return Supplier of Inventory Special Stock
     */
    @SerializedName( "InventorySpecialStockSupplier" )
    @JsonProperty( "InventorySpecialStockSupplier" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockSupplier" )
    private String inventorySpecialStockSupplier;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockSupplier</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVENTORY_SPECIAL_STOCK_SUPPLIER =
        new TRIALBALANCEResultField<String>("InventorySpecialStockSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockSupplierName</b>
     * </p>
     *
     * @return Supplier of Inventory Special Stock
     */
    @SerializedName( "InvtrySpecialStockSupplierName" )
    @JsonProperty( "InvtrySpecialStockSupplierName" )
    @Nullable
    @ODataField( odataName = "InvtrySpecialStockSupplierName" )
    private String invtrySpecialStockSupplierName;
    /**
     * Use with available fluent helpers to apply the <b>InvtrySpecialStockSupplierName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVTRY_SPECIAL_STOCK_SUPPLIER_NAME =
        new TRIALBALANCEResultField<String>("InvtrySpecialStockSupplierName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @return Account Assignment Type
     */
    @SerializedName( "AccountAssignmentType" )
    @JsonProperty( "AccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentType" )
    private String accountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ACCOUNT_ASSIGNMENT_TYPE =
        new TRIALBALANCEResultField<String>("AccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @SerializedName( "SoldProductGroup" )
    @JsonProperty( "SoldProductGroup" )
    @Nullable
    @ODataField( odataName = "SoldProductGroup" )
    private String soldProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroup</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SOLD_PRODUCT_GROUP =
        new TRIALBALANCEResultField<String>("SoldProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @SerializedName( "MaterialGroupName" )
    @JsonProperty( "MaterialGroupName" )
    @Nullable
    @ODataField( odataName = "MaterialGroupName" )
    private String materialGroupName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> MATERIAL_GROUP_NAME =
        new TRIALBALANCEResultField<String>("MaterialGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @return Partner Project
     */
    @SerializedName( "PartnerProject" )
    @JsonProperty( "PartnerProject" )
    @Nullable
    @ODataField( odataName = "PartnerProject" )
    private String partnerProject;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProject</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_PROJECT =
        new TRIALBALANCEResultField<String>("PartnerProject");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntryFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Clearing Journal Entry
     */
    @SerializedName( "ClearingJournalEntryFiscalYear" )
    @JsonProperty( "ClearingJournalEntryFiscalYear" )
    @Nullable
    @ODataField( odataName = "ClearingJournalEntryFiscalYear" )
    private String clearingJournalEntryFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>ClearingJournalEntryFiscalYear</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CLEARING_JOURNAL_ENTRY_FISCAL_YEAR =
        new TRIALBALANCEResultField<String>("ClearingJournalEntryFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_COMPANY =
        new TRIALBALANCEResultField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> LOGICAL_SYSTEM =
        new TRIALBALANCEResultField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PERSONNEL_NUMBER =
        new TRIALBALANCEResultField<String>("PersonnelNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @return Group Asset
     */
    @SerializedName( "GroupMasterFixedAsset" )
    @JsonProperty( "GroupMasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "GroupMasterFixedAsset" )
    private String groupMasterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>GroupMasterFixedAsset</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GROUP_MASTER_FIXED_ASSET =
        new TRIALBALANCEResultField<String>("GroupMasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SALES_DOCUMENT_ITEM =
        new TRIALBALANCEResultField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory</b>
     * </p>
     *
     * @return Partner Order Category
     */
    @SerializedName( "PartnerOrderCategory" )
    @JsonProperty( "PartnerOrderCategory" )
    @Nullable
    @ODataField( odataName = "PartnerOrderCategory" )
    private String partnerOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrderCategory</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_ORDER_CATEGORY =
        new TRIALBALANCEResultField<String>("PartnerOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Partner Business Area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_BUSINESS_AREA =
        new TRIALBALANCEResultField<String>("PartnerBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaName</b>
     * </p>
     *
     * @return Partner Business Area
     */
    @SerializedName( "PartnerBusinessAreaName" )
    @JsonProperty( "PartnerBusinessAreaName" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessAreaName" )
    private String partnerBusinessAreaName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessAreaName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_BUSINESS_AREA_NAME =
        new TRIALBALANCEResultField<String>("PartnerBusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @return Partner Functional Area
     */
    @SerializedName( "PartnerFunctionalArea" )
    @JsonProperty( "PartnerFunctionalArea" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea" )
    private String partnerFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_FUNCTIONAL_AREA =
        new TRIALBALANCEResultField<String>("PartnerFunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaName</b>
     * </p>
     *
     * @return Partner Functional Area
     */
    @SerializedName( "PartnerFunctionalAreaName" )
    @JsonProperty( "PartnerFunctionalAreaName" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalAreaName" )
    private String partnerFunctionalAreaName;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalAreaName</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_FUNCTIONAL_AREA_NAME =
        new TRIALBALANCEResultField<String>("PartnerFunctionalAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID</b>
     * </p>
     *
     * @return Project External ID
     */
    @SerializedName( "ProjectExternalID" )
    @JsonProperty( "ProjectExternalID" )
    @Nullable
    @ODataField( odataName = "ProjectExternalID" )
    private String projectExternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectExternalID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PROJECT_EXTERNAL_ID =
        new TRIALBALANCEResultField<String>("ProjectExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @return Origin Cost Center
     */
    @SerializedName( "OriginCostCenter" )
    @JsonProperty( "OriginCostCenter" )
    @Nullable
    @ODataField( odataName = "OriginCostCenter" )
    private String originCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCenter</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ORIGIN_COST_CENTER =
        new TRIALBALANCEResultField<String>("OriginCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @return Freely Defined Currency 5
     */
    @SerializedName( "FreeDefinedCurrency5" )
    @JsonProperty( "FreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency5" )
    private String freeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY5 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> COMPANY_CODE_CURRENCY =
        new TRIALBALANCEResultField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @return Type of Origin Object
     */
    @SerializedName( "OriginObjectType" )
    @JsonProperty( "OriginObjectType" )
    @Nullable
    @ODataField( odataName = "OriginObjectType" )
    private String originObjectType;
    /**
     * Use with available fluent helpers to apply the <b>OriginObjectType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ORIGIN_OBJECT_TYPE =
        new TRIALBALANCEResultField<String>("OriginObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType</b>
     * </p>
     *
     * @return Controlling Object Debit Type
     */
    @SerializedName( "ControllingObjectDebitType" )
    @JsonProperty( "ControllingObjectDebitType" )
    @Nullable
    @ODataField( odataName = "ControllingObjectDebitType" )
    private String controllingObjectDebitType;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectDebitType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CONTROLLING_OBJECT_DEBIT_TYPE =
        new TRIALBALANCEResultField<String>("ControllingObjectDebitType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @return Partner WBS Element Internal ID
     */
    @SerializedName( "PartnerWBSElementInternalID" )
    @JsonProperty( "PartnerWBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementInternalID" )
    private String partnerWBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementInternalID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_WBS_ELEMENT_INTERNAL_ID =
        new TRIALBALANCEResultField<String>("PartnerWBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementExternalID</b>
     * </p>
     *
     * @return Partner WBS Element External ID
     */
    @SerializedName( "PartnerWBSElementExternalID" )
    @JsonProperty( "PartnerWBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementExternalID" )
    private String partnerWBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementExternalID</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_WBS_ELEMENT_EXTERNAL_ID =
        new TRIALBALANCEResultField<String>("PartnerWBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccountHierarchy" )
    @JsonProperty( "GLAccountHierarchy" )
    @Nullable
    @ODataField( odataName = "GLAccountHierarchy" )
    private String gLAccountHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>GLAccountHierarchy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> GL_ACCOUNT_HIERARCHY =
        new TRIALBALANCEResultField<String>("GLAccountHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CustomerServiceNotification</b>
     * </p>
     *
     * @return Customer Service Notification
     */
    @SerializedName( "CustomerServiceNotification" )
    @JsonProperty( "CustomerServiceNotification" )
    @Nullable
    @ODataField( odataName = "CustomerServiceNotification" )
    private String customerServiceNotification;
    /**
     * Use with available fluent helpers to apply the <b>CustomerServiceNotification</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CUSTOMER_SERVICE_NOTIFICATION =
        new TRIALBALANCEResultField<String>("CustomerServiceNotification");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @return Freely Defined Currency 7
     */
    @SerializedName( "FreeDefinedCurrency7" )
    @JsonProperty( "FreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency7" )
    private String freeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> FREE_DEFINED_CURRENCY7 =
        new TRIALBALANCEResultField<String>("FreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @return Account Assignment Number
     */
    @SerializedName( "AccountAssignmentNumber" )
    @JsonProperty( "AccountAssignmentNumber" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentNumber" )
    private String accountAssignmentNumber;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentNumber</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ACCOUNT_ASSIGNMENT_NUMBER =
        new TRIALBALANCEResultField<String>("AccountAssignmentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SALES_ORGANIZATION =
        new TRIALBALANCEResultField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @return Transaction Key
     */
    @SerializedName( "TransactionTypeDetermination" )
    @JsonProperty( "TransactionTypeDetermination" )
    @Nullable
    @ODataField( odataName = "TransactionTypeDetermination" )
    private String transactionTypeDetermination;
    /**
     * Use with available fluent helpers to apply the <b>TransactionTypeDetermination</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> TRANSACTION_TYPE_DETERMINATION =
        new TRIALBALANCEResultField<String>("TransactionTypeDetermination");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetwork</b>
     * </p>
     *
     * @return Partner Project Network
     */
    @SerializedName( "PartnerProjectNetwork" )
    @JsonProperty( "PartnerProjectNetwork" )
    @Nullable
    @ODataField( odataName = "PartnerProjectNetwork" )
    private String partnerProjectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectNetwork</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_PROJECT_NETWORK =
        new TRIALBALANCEResultField<String>("PartnerProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @return Partner Company Code
     */
    @SerializedName( "PartnerCompanyCode" )
    @JsonProperty( "PartnerCompanyCode" )
    @Nullable
    @ODataField( odataName = "PartnerCompanyCode" )
    private String partnerCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyCode</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_COMPANY_CODE =
        new TRIALBALANCEResultField<String>("PartnerCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SALES_ORDER_ITEM =
        new TRIALBALANCEResultField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @return Offsetting Account Type
     */
    @SerializedName( "OffsettingAccountType" )
    @JsonProperty( "OffsettingAccountType" )
    @Nullable
    @ODataField( odataName = "OffsettingAccountType" )
    private String offsettingAccountType;
    /**
     * Use with available fluent helpers to apply the <b>OffsettingAccountType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> OFFSETTING_ACCOUNT_TYPE =
        new TRIALBALANCEResultField<String>("OffsettingAccountType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearWeek</b>
     * </p>
     *
     * @return Year Week
     */
    @SerializedName( "CalendarYearWeek" )
    @JsonProperty( "CalendarYearWeek" )
    @Nullable
    @ODataField( odataName = "CalendarYearWeek" )
    private String calendarYearWeek;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYearWeek</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CALENDAR_YEAR_WEEK =
        new TRIALBALANCEResultField<String>("CalendarYearWeek");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignmentType</b>
     * </p>
     *
     * @return Account Assignment Type in Sender System
     */
    @SerializedName( "SenderAccountAssignmentType" )
    @JsonProperty( "SenderAccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "SenderAccountAssignmentType" )
    private String senderAccountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>SenderAccountAssignmentType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SENDER_ACCOUNT_ASSIGNMENT_TYPE =
        new TRIALBALANCEResultField<String>("SenderAccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PURCHASING_DOCUMENT_ITEM =
        new TRIALBALANCEResultField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderGLAccount</b>
     * </p>
     *
     * @return Sender G/L Account
     */
    @SerializedName( "SenderGLAccount" )
    @JsonProperty( "SenderGLAccount" )
    @Nullable
    @ODataField( odataName = "SenderGLAccount" )
    private String senderGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>SenderGLAccount</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SENDER_GL_ACCOUNT =
        new TRIALBALANCEResultField<String>("SenderGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @return Partner Sales Document Item
     */
    @SerializedName( "PartnerSalesDocumentItem" )
    @JsonProperty( "PartnerSalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocumentItem" )
    private String partnerSalesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentItem</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> PARTNER_SALES_DOCUMENT_ITEM =
        new TRIALBALANCEResultField<String>("PartnerSalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @return Inventory Valuation Type
     */
    @SerializedName( "InventoryValuationType" )
    @JsonProperty( "InventoryValuationType" )
    @Nullable
    @ODataField( odataName = "InventoryValuationType" )
    private String inventoryValuationType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryValuationType</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> INVENTORY_VALUATION_TYPE =
        new TRIALBALANCEResultField<String>("InventoryValuationType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @return Settlement Reference Date
     */
    @SerializedName( "SettlementReferenceDate" )
    @JsonProperty( "SettlementReferenceDate" )
    @Nullable
    @ODataField( odataName = "SettlementReferenceDate" )
    private String settlementReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SETTLEMENT_REFERENCE_DATE =
        new TRIALBALANCEResultField<String>("SettlementReferenceDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate_T</b>
     * </p>
     *
     * @return Settlement Reference Date
     */
    @SerializedName( "SettlementReferenceDate_T" )
    @JsonProperty( "SettlementReferenceDate_T" )
    @Nullable
    @ODataField( odataName = "SettlementReferenceDate_T" )
    private String settlementReferenceDate_T;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate_T</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> SETTLEMENT_REFERENCE_DATE_T =
        new TRIALBALANCEResultField<String>("SettlementReferenceDate_T");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DISTRIBUTION_CHANNEL =
        new TRIALBALANCEResultField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Starting Balance Amount In Company Code Currency
     */
    @SerializedName( "StartingBalanceAmtInCoCodeCrcy" )
    @JsonProperty( "StartingBalanceAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInCoCodeCrcy" )
    private BigDecimal startingBalanceAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STARTING_BALANCE_AMT_IN_CO_CODE_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("StartingBalanceAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInCoCodeCrcy_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Company Code Currency
     */
    @SerializedName( "StartingBalanceAmtInCoCodeCrcy_F" )
    @JsonProperty( "StartingBalanceAmtInCoCodeCrcy_F" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInCoCodeCrcy_F" )
    private String startingBalanceAmtInCoCodeCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInCoCodeCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BALANCE_AMT_IN_CO_CODE_CRCY_F =
        new TRIALBALANCEResultField<String>("StartingBalanceAmtInCoCodeCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInCoCodeCrcy_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Company Code Currency
     */
    @SerializedName( "StartingBalanceAmtInCoCodeCrcy_E" )
    @JsonProperty( "StartingBalanceAmtInCoCodeCrcy_E" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInCoCodeCrcy_E" )
    private String startingBalanceAmtInCoCodeCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInCoCodeCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BALANCE_AMT_IN_CO_CODE_CRCY_E =
        new TRIALBALANCEResultField<String>("StartingBalanceAmtInCoCodeCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Debit Balance in Company Code Currency
     */
    @SerializedName( "DebitAmountInCoCodeCrcy" )
    @JsonProperty( "DebitAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "DebitAmountInCoCodeCrcy" )
    private BigDecimal debitAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_CO_CODE_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInCoCodeCrcy_F</b>
     * </p>
     *
     * @return Debit Balance in Company Code Currency
     */
    @SerializedName( "DebitAmountInCoCodeCrcy_F" )
    @JsonProperty( "DebitAmountInCoCodeCrcy_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInCoCodeCrcy_F" )
    private String debitAmountInCoCodeCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInCoCodeCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_CO_CODE_CRCY_F =
        new TRIALBALANCEResultField<String>("DebitAmountInCoCodeCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInCoCodeCrcy_E</b>
     * </p>
     *
     * @return Debit Balance in Company Code Currency
     */
    @SerializedName( "DebitAmountInCoCodeCrcy_E" )
    @JsonProperty( "DebitAmountInCoCodeCrcy_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInCoCodeCrcy_E" )
    private String debitAmountInCoCodeCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInCoCodeCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_CO_CODE_CRCY_E =
        new TRIALBALANCEResultField<String>("DebitAmountInCoCodeCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Credit Balance in Company Code Currency
     */
    @SerializedName( "CreditAmountInCoCodeCrcy" )
    @JsonProperty( "CreditAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "CreditAmountInCoCodeCrcy" )
    private BigDecimal creditAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_CO_CODE_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInCoCodeCrcy_F</b>
     * </p>
     *
     * @return Credit Balance in Company Code Currency
     */
    @SerializedName( "CreditAmountInCoCodeCrcy_F" )
    @JsonProperty( "CreditAmountInCoCodeCrcy_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInCoCodeCrcy_F" )
    private String creditAmountInCoCodeCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInCoCodeCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_CO_CODE_CRCY_F =
        new TRIALBALANCEResultField<String>("CreditAmountInCoCodeCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInCoCodeCrcy_E</b>
     * </p>
     *
     * @return Credit Balance in Company Code Currency
     */
    @SerializedName( "CreditAmountInCoCodeCrcy_E" )
    @JsonProperty( "CreditAmountInCoCodeCrcy_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInCoCodeCrcy_E" )
    private String creditAmountInCoCodeCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInCoCodeCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_CO_CODE_CRCY_E =
        new TRIALBALANCEResultField<String>("CreditAmountInCoCodeCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Ending Balance in Company Code Currency
     */
    @SerializedName( "EndingBalanceAmtInCoCodeCrcy" )
    @JsonProperty( "EndingBalanceAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInCoCodeCrcy" )
    private BigDecimal endingBalanceAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BALANCE_AMT_IN_CO_CODE_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalanceAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInCoCodeCrcy_F</b>
     * </p>
     *
     * @return Ending Balance in Company Code Currency
     */
    @SerializedName( "EndingBalanceAmtInCoCodeCrcy_F" )
    @JsonProperty( "EndingBalanceAmtInCoCodeCrcy_F" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInCoCodeCrcy_F" )
    private String endingBalanceAmtInCoCodeCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInCoCodeCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_CO_CODE_CRCY_F =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInCoCodeCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInCoCodeCrcy_E</b>
     * </p>
     *
     * @return Ending Balance in Company Code Currency
     */
    @SerializedName( "EndingBalanceAmtInCoCodeCrcy_E" )
    @JsonProperty( "EndingBalanceAmtInCoCodeCrcy_E" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInCoCodeCrcy_E" )
    private String endingBalanceAmtInCoCodeCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInCoCodeCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_CO_CODE_CRCY_E =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInCoCodeCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInGlobalCrcy</b>
     * </p>
     *
     * @return Starting Balance Amount In Global Currency
     */
    @SerializedName( "StartingBalanceAmtInGlobalCrcy" )
    @JsonProperty( "StartingBalanceAmtInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInGlobalCrcy" )
    private BigDecimal startingBalanceAmtInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInGlobalCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STARTING_BALANCE_AMT_IN_GLOBAL_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("StartingBalanceAmtInGlobalCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInGlobalCrcy_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Global Currency
     */
    @SerializedName( "StartingBalanceAmtInGlobalCrcy_F" )
    @JsonProperty( "StartingBalanceAmtInGlobalCrcy_F" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInGlobalCrcy_F" )
    private String startingBalanceAmtInGlobalCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInGlobalCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BALANCE_AMT_IN_GLOBAL_CRCY_F =
        new TRIALBALANCEResultField<String>("StartingBalanceAmtInGlobalCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInGlobalCrcy_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Global Currency
     */
    @SerializedName( "StartingBalanceAmtInGlobalCrcy_E" )
    @JsonProperty( "StartingBalanceAmtInGlobalCrcy_E" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInGlobalCrcy_E" )
    private String startingBalanceAmtInGlobalCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInGlobalCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BALANCE_AMT_IN_GLOBAL_CRCY_E =
        new TRIALBALANCEResultField<String>("StartingBalanceAmtInGlobalCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInGlobalCrcy</b>
     * </p>
     *
     * @return Debit Balance in Global Currency
     */
    @SerializedName( "DebitAmountInGlobalCrcy" )
    @JsonProperty( "DebitAmountInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "DebitAmountInGlobalCrcy" )
    private BigDecimal debitAmountInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInGlobalCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_GLOBAL_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInGlobalCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInGlobalCrcy_F</b>
     * </p>
     *
     * @return Debit Balance in Global Currency
     */
    @SerializedName( "DebitAmountInGlobalCrcy_F" )
    @JsonProperty( "DebitAmountInGlobalCrcy_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInGlobalCrcy_F" )
    private String debitAmountInGlobalCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInGlobalCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_GLOBAL_CRCY_F =
        new TRIALBALANCEResultField<String>("DebitAmountInGlobalCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInGlobalCrcy_E</b>
     * </p>
     *
     * @return Debit Balance in Global Currency
     */
    @SerializedName( "DebitAmountInGlobalCrcy_E" )
    @JsonProperty( "DebitAmountInGlobalCrcy_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInGlobalCrcy_E" )
    private String debitAmountInGlobalCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInGlobalCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_GLOBAL_CRCY_E =
        new TRIALBALANCEResultField<String>("DebitAmountInGlobalCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInGlobalCrcy</b>
     * </p>
     *
     * @return Credit Balance in Global Currency
     */
    @SerializedName( "CreditAmountInGlobalCrcy" )
    @JsonProperty( "CreditAmountInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "CreditAmountInGlobalCrcy" )
    private BigDecimal creditAmountInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInGlobalCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_GLOBAL_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInGlobalCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInGlobalCrcy_F</b>
     * </p>
     *
     * @return Credit Balance in Global Currency
     */
    @SerializedName( "CreditAmountInGlobalCrcy_F" )
    @JsonProperty( "CreditAmountInGlobalCrcy_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInGlobalCrcy_F" )
    private String creditAmountInGlobalCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInGlobalCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_GLOBAL_CRCY_F =
        new TRIALBALANCEResultField<String>("CreditAmountInGlobalCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInGlobalCrcy_E</b>
     * </p>
     *
     * @return Credit Balance in Global Currency
     */
    @SerializedName( "CreditAmountInGlobalCrcy_E" )
    @JsonProperty( "CreditAmountInGlobalCrcy_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInGlobalCrcy_E" )
    private String creditAmountInGlobalCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInGlobalCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_GLOBAL_CRCY_E =
        new TRIALBALANCEResultField<String>("CreditAmountInGlobalCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInGlobalCrcy</b>
     * </p>
     *
     * @return Ending Balance in Global Currency
     */
    @SerializedName( "EndingBalanceAmtInGlobalCrcy" )
    @JsonProperty( "EndingBalanceAmtInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInGlobalCrcy" )
    private BigDecimal endingBalanceAmtInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInGlobalCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BALANCE_AMT_IN_GLOBAL_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalanceAmtInGlobalCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInGlobalCrcy_F</b>
     * </p>
     *
     * @return Ending Balance in Global Currency
     */
    @SerializedName( "EndingBalanceAmtInGlobalCrcy_F" )
    @JsonProperty( "EndingBalanceAmtInGlobalCrcy_F" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInGlobalCrcy_F" )
    private String endingBalanceAmtInGlobalCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInGlobalCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_GLOBAL_CRCY_F =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInGlobalCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInGlobalCrcy_E</b>
     * </p>
     *
     * @return Ending Balance in Global Currency
     */
    @SerializedName( "EndingBalanceAmtInGlobalCrcy_E" )
    @JsonProperty( "EndingBalanceAmtInGlobalCrcy_E" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInGlobalCrcy_E" )
    private String endingBalanceAmtInGlobalCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInGlobalCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_GLOBAL_CRCY_E =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInGlobalCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy1</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 1
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy1" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy1" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy1" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy1;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy1</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY1 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy1");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 1
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy1_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy1_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy1_F" )
    private String strtgBalAmtInFreeDfndCrcy1_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy1_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY1_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy1_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 1
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy1_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy1_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy1_E" )
    private String strtgBalAmtInFreeDfndCrcy1_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy1_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY1_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy1_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy1</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 1
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy1" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy1" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy1" )
    private BigDecimal debitAmountInFreeDfndCrcy1;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy1</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY1 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy1");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 1
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy1_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy1_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy1_F" )
    private String debitAmountInFreeDfndCrcy1_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy1_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY1_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy1_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 1
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy1_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy1_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy1_E" )
    private String debitAmountInFreeDfndCrcy1_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy1_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY1_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy1_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy1</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 1
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy1" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy1" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy1" )
    private BigDecimal creditAmountInFreeDfndCrcy1;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy1</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY1 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy1");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 1
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy1_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy1_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy1_F" )
    private String creditAmountInFreeDfndCrcy1_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy1_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY1_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy1_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 1
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy1_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy1_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy1_E" )
    private String creditAmountInFreeDfndCrcy1_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy1_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY1_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy1_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy1</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 1
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy1" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy1" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy1" )
    private BigDecimal endingBalAmtInFreeDfndCrcy1;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy1</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY1 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy1");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 1
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy1_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy1_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy1_F" )
    private String endingBalAmtInFreeDfndCrcy1_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy1_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY1_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy1_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 1
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy1_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy1_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy1_E" )
    private String endingBalAmtInFreeDfndCrcy1_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy1_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY1_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy1_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy2</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 2
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy2" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy2" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy2" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy2;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy2</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY2 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy2");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 2
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy2_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy2_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy2_F" )
    private String strtgBalAmtInFreeDfndCrcy2_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy2_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY2_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy2_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 2
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy2_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy2_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy2_E" )
    private String strtgBalAmtInFreeDfndCrcy2_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy2_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY2_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy2_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy2</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 2
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy2" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy2" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy2" )
    private BigDecimal debitAmountInFreeDfndCrcy2;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy2</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY2 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy2");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 2
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy2_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy2_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy2_F" )
    private String debitAmountInFreeDfndCrcy2_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy2_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY2_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy2_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 2
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy2_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy2_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy2_E" )
    private String debitAmountInFreeDfndCrcy2_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy2_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY2_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy2_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy2</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 2
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy2" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy2" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy2" )
    private BigDecimal creditAmountInFreeDfndCrcy2;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy2</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY2 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy2");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 2
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy2_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy2_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy2_F" )
    private String creditAmountInFreeDfndCrcy2_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy2_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY2_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy2_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 2
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy2_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy2_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy2_E" )
    private String creditAmountInFreeDfndCrcy2_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy2_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY2_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy2_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy2</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 2
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy2" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy2" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy2" )
    private BigDecimal endingBalAmtInFreeDfndCrcy2;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy2</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY2 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy2");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 2
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy2_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy2_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy2_F" )
    private String endingBalAmtInFreeDfndCrcy2_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy2_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY2_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy2_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 2
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy2_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy2_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy2_E" )
    private String endingBalAmtInFreeDfndCrcy2_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy2_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY2_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy2_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy3</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 3
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy3" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy3" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy3" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy3;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy3</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY3 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy3");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 3
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy3_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy3_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy3_F" )
    private String strtgBalAmtInFreeDfndCrcy3_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy3_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY3_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy3_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 3
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy3_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy3_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy3_E" )
    private String strtgBalAmtInFreeDfndCrcy3_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy3_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY3_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy3_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy3</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 3
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy3" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy3" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy3" )
    private BigDecimal debitAmountInFreeDfndCrcy3;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy3</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY3 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy3");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 3
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy3_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy3_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy3_F" )
    private String debitAmountInFreeDfndCrcy3_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy3_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY3_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy3_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 3
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy3_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy3_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy3_E" )
    private String debitAmountInFreeDfndCrcy3_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy3_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY3_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy3_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy3</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 3
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy3" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy3" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy3" )
    private BigDecimal creditAmountInFreeDfndCrcy3;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy3</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY3 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy3");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 3
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy3_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy3_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy3_F" )
    private String creditAmountInFreeDfndCrcy3_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy3_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY3_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy3_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 3
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy3_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy3_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy3_E" )
    private String creditAmountInFreeDfndCrcy3_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy3_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY3_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy3_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy3</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 3
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy3" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy3" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy3" )
    private BigDecimal endingBalAmtInFreeDfndCrcy3;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy3</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY3 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy3");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 3
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy3_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy3_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy3_F" )
    private String endingBalAmtInFreeDfndCrcy3_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy3_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY3_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy3_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 3
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy3_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy3_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy3_E" )
    private String endingBalAmtInFreeDfndCrcy3_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy3_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY3_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy3_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy4</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 4
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy4" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy4" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy4" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy4;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy4</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY4 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy4");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 4
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy4_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy4_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy4_F" )
    private String strtgBalAmtInFreeDfndCrcy4_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy4_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY4_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy4_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 4
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy4_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy4_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy4_E" )
    private String strtgBalAmtInFreeDfndCrcy4_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy4_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY4_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy4_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy4</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 4
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy4" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy4" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy4" )
    private BigDecimal debitAmountInFreeDfndCrcy4;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy4</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY4 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy4");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 4
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy4_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy4_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy4_F" )
    private String debitAmountInFreeDfndCrcy4_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy4_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY4_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy4_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 4
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy4_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy4_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy4_E" )
    private String debitAmountInFreeDfndCrcy4_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy4_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY4_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy4_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy4</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 4
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy4" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy4" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy4" )
    private BigDecimal creditAmountInFreeDfndCrcy4;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy4</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY4 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy4");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 4
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy4_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy4_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy4_F" )
    private String creditAmountInFreeDfndCrcy4_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy4_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY4_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy4_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 4
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy4_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy4_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy4_E" )
    private String creditAmountInFreeDfndCrcy4_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy4_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY4_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy4_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy4</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 4
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy4" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy4" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy4" )
    private BigDecimal endingBalAmtInFreeDfndCrcy4;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy4</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY4 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy4");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 4
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy4_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy4_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy4_F" )
    private String endingBalAmtInFreeDfndCrcy4_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy4_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY4_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy4_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 4
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy4_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy4_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy4_E" )
    private String endingBalAmtInFreeDfndCrcy4_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy4_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY4_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy4_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy5</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 5
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy5" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy5" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy5" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy5;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy5</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY5 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy5");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 5
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy5_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy5_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy5_F" )
    private String strtgBalAmtInFreeDfndCrcy5_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy5_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY5_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy5_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 5
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy5_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy5_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy5_E" )
    private String strtgBalAmtInFreeDfndCrcy5_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy5_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY5_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy5_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy5</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 5
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy5" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy5" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy5" )
    private BigDecimal debitAmountInFreeDfndCrcy5;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy5</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY5 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy5");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 5
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy5_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy5_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy5_F" )
    private String debitAmountInFreeDfndCrcy5_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy5_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY5_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy5_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 5
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy5_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy5_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy5_E" )
    private String debitAmountInFreeDfndCrcy5_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy5_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY5_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy5_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy5</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 5
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy5" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy5" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy5" )
    private BigDecimal creditAmountInFreeDfndCrcy5;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy5</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY5 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy5");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 5
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy5_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy5_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy5_F" )
    private String creditAmountInFreeDfndCrcy5_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy5_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY5_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy5_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 5
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy5_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy5_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy5_E" )
    private String creditAmountInFreeDfndCrcy5_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy5_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY5_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy5_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy5</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 5
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy5" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy5" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy5" )
    private BigDecimal endingBalAmtInFreeDfndCrcy5;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy5</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY5 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy5");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 5
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy5_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy5_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy5_F" )
    private String endingBalAmtInFreeDfndCrcy5_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy5_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY5_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy5_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 5
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy5_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy5_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy5_E" )
    private String endingBalAmtInFreeDfndCrcy5_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy5_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY5_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy5_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy6</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 6
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy6" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy6" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy6" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy6;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy6</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY6 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy6");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 6
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy6_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy6_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy6_F" )
    private String strtgBalAmtInFreeDfndCrcy6_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy6_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY6_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy6_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 6
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy6_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy6_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy6_E" )
    private String strtgBalAmtInFreeDfndCrcy6_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy6_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY6_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy6_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy6</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 6
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy6" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy6" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy6" )
    private BigDecimal debitAmountInFreeDfndCrcy6;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy6</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY6 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy6");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 6
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy6_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy6_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy6_F" )
    private String debitAmountInFreeDfndCrcy6_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy6_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY6_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy6_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 6
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy6_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy6_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy6_E" )
    private String debitAmountInFreeDfndCrcy6_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy6_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY6_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy6_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy6</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 6
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy6" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy6" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy6" )
    private BigDecimal creditAmountInFreeDfndCrcy6;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy6</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY6 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy6");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 6
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy6_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy6_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy6_F" )
    private String creditAmountInFreeDfndCrcy6_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy6_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY6_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy6_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 6
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy6_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy6_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy6_E" )
    private String creditAmountInFreeDfndCrcy6_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy6_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY6_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy6_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy6</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 6
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy6" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy6" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy6" )
    private BigDecimal endingBalAmtInFreeDfndCrcy6;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy6</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY6 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy6");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 6
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy6_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy6_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy6_F" )
    private String endingBalAmtInFreeDfndCrcy6_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy6_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY6_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy6_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 6
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy6_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy6_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy6_E" )
    private String endingBalAmtInFreeDfndCrcy6_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy6_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY6_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy6_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy7</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 7
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy7" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy7" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy7" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy7;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy7</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY7 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy7");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 7
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy7_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy7_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy7_F" )
    private String strtgBalAmtInFreeDfndCrcy7_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy7_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY7_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy7_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 7
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy7_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy7_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy7_E" )
    private String strtgBalAmtInFreeDfndCrcy7_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy7_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY7_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy7_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy7</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 7
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy7" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy7" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy7" )
    private BigDecimal debitAmountInFreeDfndCrcy7;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy7</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY7 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy7");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 7
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy7_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy7_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy7_F" )
    private String debitAmountInFreeDfndCrcy7_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy7_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY7_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy7_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 7
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy7_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy7_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy7_E" )
    private String debitAmountInFreeDfndCrcy7_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy7_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY7_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy7_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy7</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 7
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy7" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy7" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy7" )
    private BigDecimal creditAmountInFreeDfndCrcy7;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy7</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY7 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy7");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 7
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy7_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy7_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy7_F" )
    private String creditAmountInFreeDfndCrcy7_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy7_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY7_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy7_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 7
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy7_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy7_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy7_E" )
    private String creditAmountInFreeDfndCrcy7_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy7_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY7_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy7_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy7</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 7
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy7" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy7" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy7" )
    private BigDecimal endingBalAmtInFreeDfndCrcy7;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy7</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY7 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy7");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 7
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy7_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy7_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy7_F" )
    private String endingBalAmtInFreeDfndCrcy7_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy7_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY7_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy7_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 7
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy7_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy7_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy7_E" )
    private String endingBalAmtInFreeDfndCrcy7_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy7_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY7_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy7_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy8</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 8
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy8" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy8" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy8" )
    private BigDecimal strtgBalAmtInFreeDfndCrcy8;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy8</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STRTG_BAL_AMT_IN_FREE_DFND_CRCY8 =
        new TRIALBALANCEResultField<BigDecimal>("StrtgBalAmtInFreeDfndCrcy8");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 8
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy8_F" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy8_F" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy8_F" )
    private String strtgBalAmtInFreeDfndCrcy8_F;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy8_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY8_F =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy8_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Freely Defined Currency 8
     */
    @SerializedName( "StrtgBalAmtInFreeDfndCrcy8_E" )
    @JsonProperty( "StrtgBalAmtInFreeDfndCrcy8_E" )
    @Nullable
    @ODataField( odataName = "StrtgBalAmtInFreeDfndCrcy8_E" )
    private String strtgBalAmtInFreeDfndCrcy8_E;
    /**
     * Use with available fluent helpers to apply the <b>StrtgBalAmtInFreeDfndCrcy8_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STRTG_BAL_AMT_IN_FREE_DFND_CRCY8_E =
        new TRIALBALANCEResultField<String>("StrtgBalAmtInFreeDfndCrcy8_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy8</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 8
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy8" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy8" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy8" )
    private BigDecimal debitAmountInFreeDfndCrcy8;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy8</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_FREE_DFND_CRCY8 =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInFreeDfndCrcy8");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 8
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy8_F" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy8_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy8_F" )
    private String debitAmountInFreeDfndCrcy8_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy8_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY8_F =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy8_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @return Debit Balance in Freely Defined Currency 8
     */
    @SerializedName( "DebitAmountInFreeDfndCrcy8_E" )
    @JsonProperty( "DebitAmountInFreeDfndCrcy8_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInFreeDfndCrcy8_E" )
    private String debitAmountInFreeDfndCrcy8_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInFreeDfndCrcy8_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_FREE_DFND_CRCY8_E =
        new TRIALBALANCEResultField<String>("DebitAmountInFreeDfndCrcy8_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy8</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 8
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy8" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy8" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy8" )
    private BigDecimal creditAmountInFreeDfndCrcy8;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy8</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_FREE_DFND_CRCY8 =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInFreeDfndCrcy8");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 8
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy8_F" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy8_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy8_F" )
    private String creditAmountInFreeDfndCrcy8_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy8_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY8_F =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy8_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @return Credit Balance in Freely Defined Currency 8
     */
    @SerializedName( "CreditAmountInFreeDfndCrcy8_E" )
    @JsonProperty( "CreditAmountInFreeDfndCrcy8_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInFreeDfndCrcy8_E" )
    private String creditAmountInFreeDfndCrcy8_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInFreeDfndCrcy8_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_FREE_DFND_CRCY8_E =
        new TRIALBALANCEResultField<String>("CreditAmountInFreeDfndCrcy8_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy8</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 8
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy8" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy8" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy8" )
    private BigDecimal endingBalAmtInFreeDfndCrcy8;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy8</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BAL_AMT_IN_FREE_DFND_CRCY8 =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalAmtInFreeDfndCrcy8");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 8
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy8_F" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy8_F" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy8_F" )
    private String endingBalAmtInFreeDfndCrcy8_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy8_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY8_F =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy8_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @return Ending Balance in Freely Defined Currency 8
     */
    @SerializedName( "EndingBalAmtInFreeDfndCrcy8_E" )
    @JsonProperty( "EndingBalAmtInFreeDfndCrcy8_E" )
    @Nullable
    @ODataField( odataName = "EndingBalAmtInFreeDfndCrcy8_E" )
    private String endingBalAmtInFreeDfndCrcy8_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalAmtInFreeDfndCrcy8_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BAL_AMT_IN_FREE_DFND_CRCY8_E =
        new TRIALBALANCEResultField<String>("EndingBalAmtInFreeDfndCrcy8_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalAmtInBalTransCrcy</b>
     * </p>
     *
     * @return Starting Balance Amount In Balance Transaction Currency
     */
    @SerializedName( "StartingBalAmtInBalTransCrcy" )
    @JsonProperty( "StartingBalAmtInBalTransCrcy" )
    @Nullable
    @ODataField( odataName = "StartingBalAmtInBalTransCrcy" )
    private BigDecimal startingBalAmtInBalTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalAmtInBalTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STARTING_BAL_AMT_IN_BAL_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("StartingBalAmtInBalTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalAmtInBalTransCrcy_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Balance Transaction Currency
     */
    @SerializedName( "StartingBalAmtInBalTransCrcy_F" )
    @JsonProperty( "StartingBalAmtInBalTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "StartingBalAmtInBalTransCrcy_F" )
    private String startingBalAmtInBalTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalAmtInBalTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BAL_AMT_IN_BAL_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("StartingBalAmtInBalTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalAmtInBalTransCrcy_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Balance Transaction Currency
     */
    @SerializedName( "StartingBalAmtInBalTransCrcy_E" )
    @JsonProperty( "StartingBalAmtInBalTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "StartingBalAmtInBalTransCrcy_E" )
    private String startingBalAmtInBalTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalAmtInBalTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BAL_AMT_IN_BAL_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("StartingBalAmtInBalTransCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInBalanceTransCrcy</b>
     * </p>
     *
     * @return Debit Balance in Balance Transaction Currency
     */
    @SerializedName( "DebitAmountInBalanceTransCrcy" )
    @JsonProperty( "DebitAmountInBalanceTransCrcy" )
    @Nullable
    @ODataField( odataName = "DebitAmountInBalanceTransCrcy" )
    private BigDecimal debitAmountInBalanceTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInBalanceTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInBalanceTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInBalanceTransCrcy_F</b>
     * </p>
     *
     * @return Debit Balance in Balance Transaction Currency
     */
    @SerializedName( "DebitAmountInBalanceTransCrcy_F" )
    @JsonProperty( "DebitAmountInBalanceTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInBalanceTransCrcy_F" )
    private String debitAmountInBalanceTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInBalanceTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("DebitAmountInBalanceTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInBalanceTransCrcy_E</b>
     * </p>
     *
     * @return Debit Balance in Balance Transaction Currency
     */
    @SerializedName( "DebitAmountInBalanceTransCrcy_E" )
    @JsonProperty( "DebitAmountInBalanceTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInBalanceTransCrcy_E" )
    private String debitAmountInBalanceTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInBalanceTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_BALANCE_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("DebitAmountInBalanceTransCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInBalanceTransCrcy</b>
     * </p>
     *
     * @return Credit Balance in Balance Transaction Currency
     */
    @SerializedName( "CreditAmountInBalanceTransCrcy" )
    @JsonProperty( "CreditAmountInBalanceTransCrcy" )
    @Nullable
    @ODataField( odataName = "CreditAmountInBalanceTransCrcy" )
    private BigDecimal creditAmountInBalanceTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInBalanceTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInBalanceTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInBalanceTransCrcy_F</b>
     * </p>
     *
     * @return Credit Balance in Balance Transaction Currency
     */
    @SerializedName( "CreditAmountInBalanceTransCrcy_F" )
    @JsonProperty( "CreditAmountInBalanceTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInBalanceTransCrcy_F" )
    private String creditAmountInBalanceTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInBalanceTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("CreditAmountInBalanceTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInBalanceTransCrcy_E</b>
     * </p>
     *
     * @return Credit Balance in Balance Transaction Currency
     */
    @SerializedName( "CreditAmountInBalanceTransCrcy_E" )
    @JsonProperty( "CreditAmountInBalanceTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInBalanceTransCrcy_E" )
    private String creditAmountInBalanceTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInBalanceTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_BALANCE_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("CreditAmountInBalanceTransCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInBalTransCrcy</b>
     * </p>
     *
     * @return Ending Balance in Balance Transaction Currency
     */
    @SerializedName( "EndingBalanceAmtInBalTransCrcy" )
    @JsonProperty( "EndingBalanceAmtInBalTransCrcy" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInBalTransCrcy" )
    private BigDecimal endingBalanceAmtInBalTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInBalTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalanceAmtInBalTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInBalTransCrcy_F</b>
     * </p>
     *
     * @return Ending Balance in Balance Transaction Currency
     */
    @SerializedName( "EndingBalanceAmtInBalTransCrcy_F" )
    @JsonProperty( "EndingBalanceAmtInBalTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInBalTransCrcy_F" )
    private String endingBalanceAmtInBalTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInBalTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInBalTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInBalTransCrcy_E</b>
     * </p>
     *
     * @return Ending Balance in Balance Transaction Currency
     */
    @SerializedName( "EndingBalanceAmtInBalTransCrcy_E" )
    @JsonProperty( "EndingBalanceAmtInBalTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInBalTransCrcy_E" )
    private String endingBalanceAmtInBalTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInBalTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_BAL_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInBalTransCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInTransCrcy</b>
     * </p>
     *
     * @return Starting Balance Amount In Transaction Currency
     */
    @SerializedName( "StartingBalanceAmtInTransCrcy" )
    @JsonProperty( "StartingBalanceAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInTransCrcy" )
    private BigDecimal startingBalanceAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> STARTING_BALANCE_AMT_IN_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("StartingBalanceAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInTransCrcy_F</b>
     * </p>
     *
     * @return Starting Balance Amount In Transaction Currency
     */
    @SerializedName( "StartingBalanceAmtInTransCrcy_F" )
    @JsonProperty( "StartingBalanceAmtInTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInTransCrcy_F" )
    private String startingBalanceAmtInTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BALANCE_AMT_IN_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("StartingBalanceAmtInTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInTransCrcy_E</b>
     * </p>
     *
     * @return Starting Balance Amount In Transaction Currency
     */
    @SerializedName( "StartingBalanceAmtInTransCrcy_E" )
    @JsonProperty( "StartingBalanceAmtInTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "StartingBalanceAmtInTransCrcy_E" )
    private String startingBalanceAmtInTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>StartingBalanceAmtInTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> STARTING_BALANCE_AMT_IN_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("StartingBalanceAmtInTransCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy</b>
     * </p>
     *
     * @return Debit Balance in Transaction Currency
     */
    @SerializedName( "DebitAmountInTransCrcy" )
    @JsonProperty( "DebitAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "DebitAmountInTransCrcy" )
    private BigDecimal debitAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> DEBIT_AMOUNT_IN_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("DebitAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy_F</b>
     * </p>
     *
     * @return Debit Balance in Transaction Currency
     */
    @SerializedName( "DebitAmountInTransCrcy_F" )
    @JsonProperty( "DebitAmountInTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "DebitAmountInTransCrcy_F" )
    private String debitAmountInTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("DebitAmountInTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy_E</b>
     * </p>
     *
     * @return Debit Balance in Transaction Currency
     */
    @SerializedName( "DebitAmountInTransCrcy_E" )
    @JsonProperty( "DebitAmountInTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "DebitAmountInTransCrcy_E" )
    private String debitAmountInTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>DebitAmountInTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> DEBIT_AMOUNT_IN_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("DebitAmountInTransCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy</b>
     * </p>
     *
     * @return Credit Balance in Transaction Currency
     */
    @SerializedName( "CreditAmountInTransCrcy" )
    @JsonProperty( "CreditAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "CreditAmountInTransCrcy" )
    private BigDecimal creditAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> CREDIT_AMOUNT_IN_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("CreditAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy_F</b>
     * </p>
     *
     * @return Credit Balance in Transaction Currency
     */
    @SerializedName( "CreditAmountInTransCrcy_F" )
    @JsonProperty( "CreditAmountInTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "CreditAmountInTransCrcy_F" )
    private String creditAmountInTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("CreditAmountInTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy_E</b>
     * </p>
     *
     * @return Credit Balance in Transaction Currency
     */
    @SerializedName( "CreditAmountInTransCrcy_E" )
    @JsonProperty( "CreditAmountInTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "CreditAmountInTransCrcy_E" )
    private String creditAmountInTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>CreditAmountInTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> CREDIT_AMOUNT_IN_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("CreditAmountInTransCrcy_E");
    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInTransCrcy</b>
     * </p>
     *
     * @return Ending Balance in Transaction Currency
     */
    @SerializedName( "EndingBalanceAmtInTransCrcy" )
    @JsonProperty( "EndingBalanceAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInTransCrcy" )
    private BigDecimal endingBalanceAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<BigDecimal> ENDING_BALANCE_AMT_IN_TRANS_CRCY =
        new TRIALBALANCEResultField<BigDecimal>("EndingBalanceAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInTransCrcy_F</b>
     * </p>
     *
     * @return Ending Balance in Transaction Currency
     */
    @SerializedName( "EndingBalanceAmtInTransCrcy_F" )
    @JsonProperty( "EndingBalanceAmtInTransCrcy_F" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInTransCrcy_F" )
    private String endingBalanceAmtInTransCrcy_F;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInTransCrcy_F</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_TRANS_CRCY_F =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInTransCrcy_F");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInTransCrcy_E</b>
     * </p>
     *
     * @return Ending Balance in Transaction Currency
     */
    @SerializedName( "EndingBalanceAmtInTransCrcy_E" )
    @JsonProperty( "EndingBalanceAmtInTransCrcy_E" )
    @Nullable
    @ODataField( odataName = "EndingBalanceAmtInTransCrcy_E" )
    private String endingBalanceAmtInTransCrcy_E;
    /**
     * Use with available fluent helpers to apply the <b>EndingBalanceAmtInTransCrcy_E</b> field to query operations.
     *
     */
    public final static TRIALBALANCEResultField<String> ENDING_BALANCE_AMT_IN_TRANS_CRCY_E =
        new TRIALBALANCEResultField<String>("EndingBalanceAmtInTransCrcy_E");
    /**
     * Navigation property <b>Parameters</b> for <b>TRIALBALANCEResult</b> to single <b>TRIALBALANCEParameters</b>.
     *
     */
    @SerializedName( "Parameters" )
    @JsonProperty( "Parameters" )
    @ODataField( odataName = "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TRIALBALANCEParameters toParameters;
    /**
     * Navigation property <b>LedgerDetails</b> for <b>TRIALBALANCEResult</b> to single <b>Ledger</b>.
     *
     */
    @SerializedName( "LedgerDetails" )
    @JsonProperty( "LedgerDetails" )
    @ODataField( odataName = "LedgerDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Ledger toLedgerDetails;
    /**
     * Navigation property <b>CompanyCodeDetails</b> for <b>TRIALBALANCEResult</b> to single <b>CompanyCode</b>.
     *
     */
    @SerializedName( "CompanyCodeDetails" )
    @JsonProperty( "CompanyCodeDetails" )
    @ODataField( odataName = "CompanyCodeDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CompanyCode toCompanyCodeDetails;
    /**
     * Navigation property <b>GLAccountDetails</b> for <b>TRIALBALANCEResult</b> to single <b>GLAccount</b>.
     *
     */
    @SerializedName( "GLAccountDetails" )
    @JsonProperty( "GLAccountDetails" )
    @ODataField( odataName = "GLAccountDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GLAccount toGLAccountDetails;
    /**
     * Navigation property <b>OrderIDDetails</b> for <b>TRIALBALANCEResult</b> to single <b>OrderID</b>.
     *
     */
    @SerializedName( "OrderIDDetails" )
    @JsonProperty( "OrderIDDetails" )
    @ODataField( odataName = "OrderIDDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private OrderID toOrderIDDetails;
    /**
     * Navigation property <b>ProjectNetworkDetails</b> for <b>TRIALBALANCEResult</b> to single <b>ProjectNetwork</b>.
     *
     */
    @SerializedName( "ProjectNetworkDetails" )
    @JsonProperty( "ProjectNetworkDetails" )
    @ODataField( odataName = "ProjectNetworkDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectNetwork toProjectNetworkDetails;
    /**
     * Navigation property <b>ProjectDetails</b> for <b>TRIALBALANCEResult</b> to single <b>Project</b>.
     *
     */
    @SerializedName( "ProjectDetails" )
    @JsonProperty( "ProjectDetails" )
    @ODataField( odataName = "ProjectDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Project toProjectDetails;
    /**
     * Navigation property <b>BusinessProcessDetails</b> for <b>TRIALBALANCEResult</b> to single <b>BusinessProcess</b>.
     *
     */
    @SerializedName( "BusinessProcessDetails" )
    @JsonProperty( "BusinessProcessDetails" )
    @ODataField( odataName = "BusinessProcessDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessProcess toBusinessProcessDetails;
    /**
     * Navigation property <b>BillingDocumentTypeDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>BillingDocument</b>.
     *
     */
    @SerializedName( "BillingDocumentTypeDetails" )
    @JsonProperty( "BillingDocumentTypeDetails" )
    @ODataField( odataName = "BillingDocumentTypeDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillingDocument toBillingDocumentTypeDetails;
    /**
     * Navigation property <b>SalesOrganizationDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>SalesOrganization</b>.
     *
     */
    @SerializedName( "SalesOrganizationDetails" )
    @JsonProperty( "SalesOrganizationDetails" )
    @ODataField( odataName = "SalesOrganizationDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrganization toSalesOrganizationDetails;
    /**
     * Navigation property <b>DistributionChannelDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>DistributionChannel</b>.
     *
     */
    @SerializedName( "DistributionChannelDetails" )
    @JsonProperty( "DistributionChannelDetails" )
    @ODataField( odataName = "DistributionChannelDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DistributionChannel toDistributionChannelDetails;
    /**
     * Navigation property <b>SoldProductDetails</b> for <b>TRIALBALANCEResult</b> to single <b>SoldProduct</b>.
     *
     */
    @SerializedName( "SoldProductDetails" )
    @JsonProperty( "SoldProductDetails" )
    @ODataField( odataName = "SoldProductDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SoldProduct toSoldProductDetails;
    /**
     * Navigation property <b>PartnerCompanyDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerCompany</b>.
     *
     */
    @SerializedName( "PartnerCompanyDetails" )
    @JsonProperty( "PartnerCompanyDetails" )
    @ODataField( odataName = "PartnerCompanyDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerCompany toPartnerCompanyDetails;
    /**
     * Navigation property <b>PartnerOrderDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerOrder</b>.
     *
     */
    @SerializedName( "PartnerOrderDetails" )
    @JsonProperty( "PartnerOrderDetails" )
    @ODataField( odataName = "PartnerOrderDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerOrder toPartnerOrderDetails;
    /**
     * Navigation property <b>PartnerWBSElementDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>PartnerWBSElement</b>.
     *
     */
    @SerializedName( "PartnerWBSElementDetails" )
    @JsonProperty( "PartnerWBSElementDetails" )
    @ODataField( odataName = "PartnerWBSElementDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerWBSElement toPartnerWBSElementDetails;
    /**
     * Navigation property <b>PartnerProjectDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerProject</b>.
     *
     */
    @SerializedName( "PartnerProjectDetails" )
    @JsonProperty( "PartnerProjectDetails" )
    @ODataField( odataName = "PartnerProjectDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerProject toPartnerProjectDetails;
    /**
     * Navigation property <b>PartnerSalesDocumentDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>PartnerSalesDocument</b>.
     *
     */
    @SerializedName( "PartnerSalesDocumentDetails" )
    @JsonProperty( "PartnerSalesDocumentDetails" )
    @ODataField( odataName = "PartnerSalesDocumentDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerSalesDocument toPartnerSalesDocumentDetails;
    /**
     * Navigation property <b>PartnerBusinessProcessDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>PartnerBusinessProcess</b>.
     *
     */
    @SerializedName( "PartnerBusinessProcessDetails" )
    @JsonProperty( "PartnerBusinessProcessDetails" )
    @ODataField( odataName = "PartnerBusinessProcessDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerBusinessProcess toPartnerBusinessProcessDetails;
    /**
     * Navigation property <b>FinancialManagementAreaDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>FinancialManagementArea</b>.
     *
     */
    @SerializedName( "FinancialManagementAreaDetails" )
    @JsonProperty( "FinancialManagementAreaDetails" )
    @ODataField( odataName = "FinancialManagementAreaDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FinancialManagementArea toFinancialManagementAreaDetails;
    /**
     * Navigation property <b>FundDetails</b> for <b>TRIALBALANCEResult</b> to single <b>Fund</b>.
     *
     */
    @SerializedName( "FundDetails" )
    @JsonProperty( "FundDetails" )
    @ODataField( odataName = "FundDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Fund toFundDetails;
    /**
     * Navigation property <b>GrantIDDetails</b> for <b>TRIALBALANCEResult</b> to single <b>GrantID</b>.
     *
     */
    @SerializedName( "GrantIDDetails" )
    @JsonProperty( "GrantIDDetails" )
    @ODataField( odataName = "GrantIDDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private GrantID toGrantIDDetails;
    /**
     * Navigation property <b>BudgetPeriodDetails</b> for <b>TRIALBALANCEResult</b> to single <b>BudgetPeriod</b>.
     *
     */
    @SerializedName( "BudgetPeriodDetails" )
    @JsonProperty( "BudgetPeriodDetails" )
    @ODataField( odataName = "BudgetPeriodDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BudgetPeriod toBudgetPeriodDetails;
    /**
     * Navigation property <b>PartnerFundDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerFund</b>.
     *
     */
    @SerializedName( "PartnerFundDetails" )
    @JsonProperty( "PartnerFundDetails" )
    @ODataField( odataName = "PartnerFundDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerFund toPartnerFundDetails;
    /**
     * Navigation property <b>PartnerGrantDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerGrant</b>.
     *
     */
    @SerializedName( "PartnerGrantDetails" )
    @JsonProperty( "PartnerGrantDetails" )
    @ODataField( odataName = "PartnerGrantDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerGrant toPartnerGrantDetails;
    /**
     * Navigation property <b>PartnerBudgetPeriodDetails</b> for <b>TRIALBALANCEResult</b> to single
     * <b>PartnerBudgetPeriod</b>.
     *
     */
    @SerializedName( "PartnerBudgetPeriodDetails" )
    @JsonProperty( "PartnerBudgetPeriodDetails" )
    @ODataField( odataName = "PartnerBudgetPeriodDetails" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerBudgetPeriod toPartnerBudgetPeriodDetails;
    /**
     * Use with available fluent helpers to apply the <b>Parameters</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<TRIALBALANCEParameters> TO_PARAMETERS =
        new TRIALBALANCEResultOneToOneLink<TRIALBALANCEParameters>("Parameters");
    /**
     * Use with available fluent helpers to apply the <b>LedgerDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<Ledger> TO_LEDGER_DETAILS =
        new TRIALBALANCEResultOneToOneLink<Ledger>("LedgerDetails");
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<CompanyCode> TO_COMPANY_CODE_DETAILS =
        new TRIALBALANCEResultOneToOneLink<CompanyCode>("CompanyCodeDetails");
    /**
     * Use with available fluent helpers to apply the <b>GLAccountDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<GLAccount> TO_GL_ACCOUNT_DETAILS =
        new TRIALBALANCEResultOneToOneLink<GLAccount>("GLAccountDetails");
    /**
     * Use with available fluent helpers to apply the <b>OrderIDDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<OrderID> TO_ORDER_ID_DETAILS =
        new TRIALBALANCEResultOneToOneLink<OrderID>("OrderIDDetails");
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetworkDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<ProjectNetwork> TO_PROJECT_NETWORK_DETAILS =
        new TRIALBALANCEResultOneToOneLink<ProjectNetwork>("ProjectNetworkDetails");
    /**
     * Use with available fluent helpers to apply the <b>ProjectDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<Project> TO_PROJECT_DETAILS =
        new TRIALBALANCEResultOneToOneLink<Project>("ProjectDetails");
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcessDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<BusinessProcess> TO_BUSINESS_PROCESS_DETAILS =
        new TRIALBALANCEResultOneToOneLink<BusinessProcess>("BusinessProcessDetails");
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentTypeDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<BillingDocument> TO_BILLING_DOCUMENT_TYPE_DETAILS =
        new TRIALBALANCEResultOneToOneLink<BillingDocument>("BillingDocumentTypeDetails");
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganizationDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<SalesOrganization> TO_SALES_ORGANIZATION_DETAILS =
        new TRIALBALANCEResultOneToOneLink<SalesOrganization>("SalesOrganizationDetails");
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannelDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<DistributionChannel> TO_DISTRIBUTION_CHANNEL_DETAILS =
        new TRIALBALANCEResultOneToOneLink<DistributionChannel>("DistributionChannelDetails");
    /**
     * Use with available fluent helpers to apply the <b>SoldProductDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<SoldProduct> TO_SOLD_PRODUCT_DETAILS =
        new TRIALBALANCEResultOneToOneLink<SoldProduct>("SoldProductDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerCompany> TO_PARTNER_COMPANY_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerCompany>("PartnerCompanyDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrderDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerOrder> TO_PARTNER_ORDER_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerOrder>("PartnerOrderDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerWBSElement> TO_PARTNER_WBS_ELEMENT_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerWBSElement>("PartnerWBSElementDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerProjectDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerProject> TO_PARTNER_PROJECT_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerProject>("PartnerProjectDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerSalesDocument> TO_PARTNER_SALES_DOCUMENT_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerSalesDocument>("PartnerSalesDocumentDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessProcessDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerBusinessProcess> TO_PARTNER_BUSINESS_PROCESS_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerBusinessProcess>("PartnerBusinessProcessDetails");
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementAreaDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<FinancialManagementArea> TO_FINANCIAL_MANAGEMENT_AREA_DETAILS =
        new TRIALBALANCEResultOneToOneLink<FinancialManagementArea>("FinancialManagementAreaDetails");
    /**
     * Use with available fluent helpers to apply the <b>FundDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<Fund> TO_FUND_DETAILS =
        new TRIALBALANCEResultOneToOneLink<Fund>("FundDetails");
    /**
     * Use with available fluent helpers to apply the <b>GrantIDDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<GrantID> TO_GRANT_ID_DETAILS =
        new TRIALBALANCEResultOneToOneLink<GrantID>("GrantIDDetails");
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriodDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<BudgetPeriod> TO_BUDGET_PERIOD_DETAILS =
        new TRIALBALANCEResultOneToOneLink<BudgetPeriod>("BudgetPeriodDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerFundDetails</b> navigation property to query operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerFund> TO_PARTNER_FUND_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerFund>("PartnerFundDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerGrantDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerGrant> TO_PARTNER_GRANT_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerGrant>("PartnerGrantDetails");
    /**
     * Use with available fluent helpers to apply the <b>PartnerBudgetPeriodDetails</b> navigation property to query
     * operations.
     *
     */
    public final static TRIALBALANCEResultOneToOneLink<PartnerBudgetPeriod> TO_PARTNER_BUDGET_PERIOD_DETAILS =
        new TRIALBALANCEResultOneToOneLink<PartnerBudgetPeriod>("PartnerBudgetPeriodDetails");

    @Nonnull
    @Override
    public Class<TRIALBALANCEResult> getType()
    {
        return TRIALBALANCEResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @param iD
     *            The iD to set.
     */
    public void setID( @Nullable final String iD )
    {
        rememberChangedField("ID", this.iD);
        this.iD = iD;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TotaledProperties</b>
     * </p>
     *
     * @param totaledProperties
     *            The totaledProperties to set.
     */
    public void setTotaledProperties( @Nullable final String totaledProperties )
    {
        rememberChangedField("TotaledProperties", this.totaledProperties);
        this.totaledProperties = totaledProperties;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Company Code
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchyName</b>
     * </p>
     *
     * @param gLAccountHierarchyName
     *            G/L Account
     */
    public void setGLAccountHierarchyName( @Nullable final String gLAccountHierarchyName )
    {
        rememberChangedField("GLAccountHierarchyName", this.gLAccountHierarchyName);
        this.gLAccountHierarchyName = gLAccountHierarchyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @param freeDefinedCurrency8
     *            Freely Defined Currency 8
     */
    public void setFreeDefinedCurrency8( @Nullable final String freeDefinedCurrency8 )
    {
        rememberChangedField("FreeDefinedCurrency8", this.freeDefinedCurrency8);
        this.freeDefinedCurrency8 = freeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostObject</b>
     * </p>
     *
     * @param partnerCostObject
     *            Partner Cost Object
     */
    public void setPartnerCostObject( @Nullable final String partnerCostObject )
    {
        rememberChangedField("PartnerCostObject", this.partnerCostObject);
        this.partnerCostObject = partnerCostObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate</b>
     * </p>
     *
     * @param assetValueDate
     *            Asset Value Date
     */
    public void setAssetValueDate( @Nullable final String assetValueDate )
    {
        rememberChangedField("AssetValueDate", this.assetValueDate);
        this.assetValueDate = assetValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetValueDate_T</b>
     * </p>
     *
     * @param assetValueDate_T
     *            Asset Value Date
     */
    public void setAssetValueDate_T( @Nullable final String assetValueDate_T )
    {
        rememberChangedField("AssetValueDate_T", this.assetValueDate_T);
        this.assetValueDate_T = assetValueDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @param fiscalYearPeriod
     *            Fiscal Year Period
     */
    public void setFiscalYearPeriod( @Nullable final String fiscalYearPeriod )
    {
        rememberChangedField("FiscalYearPeriod", this.fiscalYearPeriod);
        this.fiscalYearPeriod = fiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsIncomplete</b>
     * </p>
     *
     * @param quantityIsIncomplete
     *            Indicator: Quantity Is Incomplete
     */
    public void setQuantityIsIncomplete( @Nullable final String quantityIsIncomplete )
    {
        rememberChangedField("QuantityIsIncomplete", this.quantityIsIncomplete);
        this.quantityIsIncomplete = quantityIsIncomplete;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsOpenItemManaged</b>
     * </p>
     *
     * @param isOpenItemManaged
     *            Managed on an Open Item Basis
     */
    public void setIsOpenItemManaged( @Nullable final String isOpenItemManaged )
    {
        rememberChangedField("IsOpenItemManaged", this.isOpenItemManaged);
        this.isOpenItemManaged = isOpenItemManaged;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount</b>
     * </p>
     *
     * @param corporateGroupAccount
     *            Group Account Number
     */
    public void setCorporateGroupAccount( @Nullable final String corporateGroupAccount )
    {
        rememberChangedField("CorporateGroupAccount", this.corporateGroupAccount);
        this.corporateGroupAccount = corporateGroupAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupAccount_T</b>
     * </p>
     *
     * @param corporateGroupAccount_T
     *            Group Account Number
     */
    public void setCorporateGroupAccount_T( @Nullable final String corporateGroupAccount_T )
    {
        rememberChangedField("CorporateGroupAccount_T", this.corporateGroupAccount_T);
        this.corporateGroupAccount_T = corporateGroupAccount_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @param billingDocumentType
     *            Billing Type
     */
    public void setBillingDocumentType( @Nullable final String billingDocumentType )
    {
        rememberChangedField("BillingDocumentType", this.billingDocumentType);
        this.billingDocumentType = billingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FiscalQuarter</b>
     * </p>
     *
     * @param fiscalQuarter
     *            Fiscal Quarter
     */
    public void setFiscalQuarter( @Nullable final String fiscalQuarter )
    {
        rememberChangedField("FiscalQuarter", this.fiscalQuarter);
        this.fiscalQuarter = fiscalQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CorporateGroupChartOfAccounts</b>
     * </p>
     *
     * @param corporateGroupChartOfAccounts
     *            Group Chart of Accts
     */
    public void setCorporateGroupChartOfAccounts( @Nullable final String corporateGroupChartOfAccounts )
    {
        rememberChangedField("CorporateGroupChartOfAccounts", this.corporateGroupChartOfAccounts);
        this.corporateGroupChartOfAccounts = corporateGroupChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDocFiscalYear</b>
     * </p>
     *
     * @param clearingDocFiscalYear
     *            Fiscal Year of Clearing Journal Entry (Deprecated)
     */
    public void setClearingDocFiscalYear( @Nullable final String clearingDocFiscalYear )
    {
        rememberChangedField("ClearingDocFiscalYear", this.clearingDocFiscalYear);
        this.clearingDocFiscalYear = clearingDocFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @param partnerWBSElement
     *            Partner WBS Element
     */
    public void setPartnerWBSElement( @Nullable final String partnerWBSElement )
    {
        rememberChangedField("PartnerWBSElement", this.partnerWBSElement);
        this.partnerWBSElement = partnerWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @param freeDefinedCurrency2
     *            Freely Defined Currency 2
     */
    public void setFreeDefinedCurrency2( @Nullable final String freeDefinedCurrency2 )
    {
        rememberChangedField("FreeDefinedCurrency2", this.freeDefinedCurrency2);
        this.freeDefinedCurrency2 = freeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @param partnerProfitCenter
     *            Partner Profit Center
     */
    public void setPartnerProfitCenter( @Nullable final String partnerProfitCenter )
    {
        rememberChangedField("PartnerProfitCenter", this.partnerProfitCenter);
        this.partnerProfitCenter = partnerProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenterName</b>
     * </p>
     *
     * @param partnerProfitCenterName
     *            Partner Profit Center
     */
    public void setPartnerProfitCenterName( @Nullable final String partnerProfitCenterName )
    {
        rememberChangedField("PartnerProfitCenterName", this.partnerProfitCenterName);
        this.partnerProfitCenterName = partnerProfitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerControllingObjectClass</b>
     * </p>
     *
     * @param partnerControllingObjectClass
     *            Partner Controlling Object Class
     */
    public void setPartnerControllingObjectClass( @Nullable final String partnerControllingObjectClass )
    {
        rememberChangedField("PartnerControllingObjectClass", this.partnerControllingObjectClass);
        this.partnerControllingObjectClass = partnerControllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountType</b>
     * </p>
     *
     * @param gLAccountType
     *            Type of a General Ledger Account
     */
    public void setGLAccountType( @Nullable final String gLAccountType )
    {
        rememberChangedField("GLAccountType", this.gLAccountType);
        this.gLAccountType = gLAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCategory</b>
     * </p>
     *
     * @param accountingDocumentCategory
     *            Journal Entry Category
     */
    public void setAccountingDocumentCategory( @Nullable final String accountingDocumentCategory )
    {
        rememberChangedField("AccountingDocumentCategory", this.accountingDocumentCategory);
        this.accountingDocumentCategory = accountingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessTransactionType</b>
     * </p>
     *
     * @param businessTransactionType
     *            Business Transaction Type
     */
    public void setBusinessTransactionType( @Nullable final String businessTransactionType )
    {
        rememberChangedField("BusinessTransactionType", this.businessTransactionType);
        this.businessTransactionType = businessTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @param calendarMonth
     *            Calendar Month
     */
    public void setCalendarMonth( @Nullable final String calendarMonth )
    {
        rememberChangedField("CalendarMonth", this.calendarMonth);
        this.calendarMonth = calendarMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CalendarQuarter</b>
     * </p>
     *
     * @param calendarQuarter
     *            Calendar Quarter
     */
    public void setCalendarQuarter( @Nullable final String calendarQuarter )
    {
        rememberChangedField("CalendarQuarter", this.calendarQuarter);
        this.calendarQuarter = calendarQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingAccountingDocument</b>
     * </p>
     *
     * @param clearingAccountingDocument
     *            Clearing Journal Entry (Deprecated)
     */
    public void setClearingAccountingDocument( @Nullable final String clearingAccountingDocument )
    {
        rememberChangedField("ClearingAccountingDocument", this.clearingAccountingDocument);
        this.clearingAccountingDocument = clearingAccountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentType</b>
     * </p>
     *
     * @param accountingDocumentType
     *            Journal Entry Type
     */
    public void setAccountingDocumentType( @Nullable final String accountingDocumentType )
    {
        rememberChangedField("AccountingDocumentType", this.accountingDocumentType);
        this.accountingDocumentType = accountingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentTypeName</b>
     * </p>
     *
     * @param accountingDocumentTypeName
     *            Journal Entry Type
     */
    public void setAccountingDocumentTypeName( @Nullable final String accountingDocumentTypeName )
    {
        rememberChangedField("AccountingDocumentTypeName", this.accountingDocumentTypeName);
        this.accountingDocumentTypeName = accountingDocumentTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountType</b>
     * </p>
     *
     * @param financialAccountType
     *            Account Type
     */
    public void setFinancialAccountType( @Nullable final String financialAccountType )
    {
        rememberChangedField("FinancialAccountType", this.financialAccountType);
        this.financialAccountType = financialAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>FinancialAccountTypeName</b>
     * </p>
     *
     * @param financialAccountTypeName
     *            Account Type
     */
    public void setFinancialAccountTypeName( @Nullable final String financialAccountTypeName )
    {
        rememberChangedField("FinancialAccountTypeName", this.financialAccountTypeName);
        this.financialAccountTypeName = financialAccountTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     *
     * @param businessAreaName
     *            Business Area
     */
    public void setBusinessAreaName( @Nullable final String businessAreaName )
    {
        rememberChangedField("BusinessAreaName", this.businessAreaName);
        this.businessAreaName = businessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCtrActivityType</b>
     * </p>
     *
     * @param originCostCtrActivityType
     *            Origin Cost Center Activity Type
     */
    public void setOriginCostCtrActivityType( @Nullable final String originCostCtrActivityType )
    {
        rememberChangedField("OriginCostCtrActivityType", this.originCostCtrActivityType);
        this.originCostCtrActivityType = originCostCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>ControllingAreaName</b>
     * </p>
     *
     * @param controllingAreaName
     *            Controlling Area
     */
    public void setControllingAreaName( @Nullable final String controllingAreaName )
    {
        rememberChangedField("ControllingAreaName", this.controllingAreaName);
        this.controllingAreaName = controllingAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @param controllingObjectClass
     *            Controlling Object Class
     */
    public void setControllingObjectClass( @Nullable final String controllingObjectClass )
    {
        rememberChangedField("ControllingObjectClass", this.controllingObjectClass);
        this.controllingObjectClass = controllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @param partnerCostCenter
     *            Partner Cost Center
     */
    public void setPartnerCostCenter( @Nullable final String partnerCostCenter )
    {
        rememberChangedField("PartnerCostCenter", this.partnerCostCenter);
        this.partnerCostCenter = partnerCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SenderCostCenterName</b>
     * </p>
     *
     * @param senderCostCenterName
     *            Partner Cost Center
     */
    public void setSenderCostCenterName( @Nullable final String senderCostCenterName )
    {
        rememberChangedField("SenderCostCenterName", this.senderCostCenterName);
        this.senderCostCenterName = senderCostCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Code
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCodeName</b>
     * </p>
     *
     * @param debitCreditCodeName
     *            Debit/Credit Code
     */
    public void setDebitCreditCodeName( @Nullable final String debitCreditCodeName )
    {
        rememberChangedField("DebitCreditCodeName", this.debitCreditCodeName);
        this.debitCreditCodeName = debitCreditCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final String postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate_T</b>
     * </p>
     *
     * @param postingDate_T
     *            Posting Date
     */
    public void setPostingDate_T( @Nullable final String postingDate_T )
    {
        rememberChangedField("PostingDate_T", this.postingDate_T);
        this.postingDate_T = postingDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @param functionalAreaName
     *            Functional Area
     */
    public void setFunctionalAreaName( @Nullable final String functionalAreaName )
    {
        rememberChangedField("FunctionalAreaName", this.functionalAreaName);
        this.functionalAreaName = functionalAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CalendarWeek</b>
     * </p>
     *
     * @param calendarWeek
     *            Calendar Week
     */
    public void setCalendarWeek( @Nullable final String calendarWeek )
    {
        rememberChangedField("CalendarWeek", this.calendarWeek);
        this.calendarWeek = calendarWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @param calendarYear
     *            Calendar Year
     */
    public void setCalendarYear( @Nullable final String calendarYear )
    {
        rememberChangedField("CalendarYear", this.calendarYear);
        this.calendarYear = calendarYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate</b>
     * </p>
     *
     * @param clearingDate
     *            Clearing Date
     */
    public void setClearingDate( @Nullable final String clearingDate )
    {
        rememberChangedField("ClearingDate", this.clearingDate);
        this.clearingDate = clearingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingDate_T</b>
     * </p>
     *
     * @param clearingDate_T
     *            Clearing Date
     */
    public void setClearingDate_T( @Nullable final String clearingDate_T )
    {
        rememberChangedField("ClearingDate_T", this.clearingDate_T);
        this.clearingDate_T = clearingDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @param costCenterName
     *            Cost Center
     */
    public void setCostCenterName( @Nullable final String costCenterName )
    {
        rememberChangedField("CostCenterName", this.costCenterName);
        this.costCenterName = costCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalWeek</b>
     * </p>
     *
     * @param fiscalWeek
     *            Fiscal Week
     */
    public void setFiscalWeek( @Nullable final String fiscalWeek )
    {
        rememberChangedField("FiscalWeek", this.fiscalWeek);
        this.fiscalWeek = fiscalWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *            Indicator: Item is Reversing Another Item
     */
    public void setIsReversal( @Nullable final String isReversal )
    {
        rememberChangedField("IsReversal", this.isReversal);
        this.isReversal = isReversal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *            Indicator: Item is Reversed
     */
    public void setIsReversed( @Nullable final String isReversed )
    {
        rememberChangedField("IsReversed", this.isReversed);
        this.isReversed = isReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettled</b>
     * </p>
     *
     * @param isSettled
     *            Indicator: Line Item is Settled or Transferred
     */
    public void setIsSettled( @Nullable final String isSettled )
    {
        rememberChangedField("IsSettled", this.isSettled);
        this.isSettled = isSettled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsSettlement</b>
     * </p>
     *
     * @param isSettlement
     *            Indicator: Item is Settling or Transferring Another Item
     */
    public void setIsSettlement( @Nullable final String isSettlement )
    {
        rememberChangedField("IsSettlement", this.isSettlement);
        this.isSettlement = isSettlement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @param partnerFund
     *            Partner Fund
     */
    public void setPartnerFund( @Nullable final String partnerFund )
    {
        rememberChangedField("PartnerFund", this.partnerFund);
        this.partnerFund = partnerFund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @param partnerGrant
     *            Partner Grant
     */
    public void setPartnerGrant( @Nullable final String partnerGrant )
    {
        rememberChangedField("PartnerGrant", this.partnerGrant);
        this.partnerGrant = partnerGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @param partnerOrder
     *            Partner Order
     */
    public void setPartnerOrder( @Nullable final String partnerOrder )
    {
        rememberChangedField("PartnerOrder", this.partnerOrder);
        this.partnerOrder = partnerOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldMaterial</b>
     * </p>
     *
     * @param soldMaterial
     *            Product Sold (Deprecated)
     */
    public void setSoldMaterial( @Nullable final String soldMaterial )
    {
        rememberChangedField("SoldMaterial", this.soldMaterial);
        this.soldMaterial = soldMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @param soldProduct
     *            Product Sold
     */
    public void setSoldProduct( @Nullable final String soldProduct )
    {
        rememberChangedField("SoldProduct", this.soldProduct);
        this.soldProduct = soldProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     *
     * @param houseBank
     *            House Bank Key
     */
    public void setHouseBank( @Nullable final String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @param inventorySpecialStockValnType
     *            Inventory Special Stock Valuation Type (Deprecated)
     */
    public void setInventorySpecialStockValnType( @Nullable final String inventorySpecialStockValnType )
    {
        rememberChangedField("InventorySpecialStockValnType", this.inventorySpecialStockValnType);
        this.inventorySpecialStockValnType = inventorySpecialStockValnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Fixed Asset
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingKey</b>
     * </p>
     *
     * @param postingKey
     *            Posting Key
     */
    public void setPostingKey( @Nullable final String postingKey )
    {
        rememberChangedField("PostingKey", this.postingKey);
        this.postingKey = postingKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PostingKeyName</b>
     * </p>
     *
     * @param postingKeyName
     *            Posting Key
     */
    public void setPostingKeyName( @Nullable final String postingKeyName )
    {
        rememberChangedField("PostingKeyName", this.postingKeyName);
        this.postingKeyName = postingKeyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @param profitCenterName
     *            Profit Center
     */
    public void setProfitCenterName( @Nullable final String profitCenterName )
    {
        rememberChangedField("ProfitCenterName", this.profitCenterName);
        this.profitCenterName = profitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     *
     * @param segmentName
     *            Segment for Segmental Reporting
     */
    public void setSegmentName( @Nullable final String segmentName )
    {
        rememberChangedField("SegmentName", this.segmentName);
        this.segmentName = segmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SpecialGLCode</b>
     * </p>
     *
     * @param specialGLCode
     *            Special G/L Indicator
     */
    public void setSpecialGLCode( @Nullable final String specialGLCode )
    {
        rememberChangedField("SpecialGLCode", this.specialGLCode);
        this.specialGLCode = specialGLCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Financial Transaction Type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @param jointVentureEquityType
     *            Joint Venture Equity Type
     */
    public void setJointVentureEquityType( @Nullable final String jointVentureEquityType )
    {
        rememberChangedField("JointVentureEquityType", this.jointVentureEquityType);
        this.jointVentureEquityType = jointVentureEquityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     *
     * @param houseBankAccount
     *            House Bank Account
     */
    public void setHouseBankAccount( @Nullable final String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Inventory Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount</b>
     * </p>
     *
     * @param alternativeGLAccount
     *            Alternative G/L Account Number In Company Code
     */
    public void setAlternativeGLAccount( @Nullable final String alternativeGLAccount )
    {
        rememberChangedField("AlternativeGLAccount", this.alternativeGLAccount);
        this.alternativeGLAccount = alternativeGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeGLAccount_T</b>
     * </p>
     *
     * @param alternativeGLAccount_T
     *            Alternative G/L Account Number In Company Code
     */
    public void setAlternativeGLAccount_T( @Nullable final String alternativeGLAccount_T )
    {
        rememberChangedField("AlternativeGLAccount_T", this.alternativeGLAccount_T);
        this.alternativeGLAccount_T = alternativeGLAccount_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Product (Deprecated)
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Sold Group (Deprecated)
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @param orderCategory
     *            Order Category
     */
    public void setOrderCategory( @Nullable final String orderCategory )
    {
        rememberChangedField("OrderCategory", this.orderCategory);
        this.orderCategory = orderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Product Number
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     *
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ValuationArea</b>
     * </p>
     *
     * @param valuationArea
     *            Valuation Area
     */
    public void setValuationArea( @Nullable final String valuationArea )
    {
        rememberChangedField("ValuationArea", this.valuationArea);
        this.valuationArea = valuationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroupName</b>
     * </p>
     *
     * @param customerGroupName
     *            Customer Group
     */
    public void setCustomerGroupName( @Nullable final String customerGroupName )
    {
        rememberChangedField("CustomerGroupName", this.customerGroupName);
        this.customerGroupName = customerGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocument</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocument
     *            Inventory Special Stock Sales Document
     */
    public void setInventorySpclStkSalesDocument( @Nullable final String inventorySpclStkSalesDocument )
    {
        rememberChangedField("InventorySpclStkSalesDocument", this.inventorySpclStkSalesDocument);
        this.inventorySpclStkSalesDocument = inventorySpclStkSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStkSalesDocItm</b>
     * </p>
     *
     * @param inventorySpclStkSalesDocItm
     *            Inventory Special Stock Sales Document Item
     */
    public void setInventorySpclStkSalesDocItm( @Nullable final String inventorySpclStkSalesDocItm )
    {
        rememberChangedField("InventorySpclStkSalesDocItm", this.inventorySpclStkSalesDocItm);
        this.inventorySpclStkSalesDocItm = inventorySpclStkSalesDocItm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntIntID</b>
     * </p>
     *
     * @param invtrySpclStockWBSElmntIntID
     *            Inventory Special Stock WBS Element Internal ID
     */
    public void setInvtrySpclStockWBSElmntIntID( @Nullable final String invtrySpclStockWBSElmntIntID )
    {
        rememberChangedField("InvtrySpclStockWBSElmntIntID", this.invtrySpclStockWBSElmntIntID);
        this.invtrySpclStockWBSElmntIntID = invtrySpclStockWBSElmntIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpclStockWBSElement</b>
     * </p>
     *
     * @param inventorySpclStockWBSElement
     *            WBS Element (external) of Valuated Special Inventory
     */
    public void setInventorySpclStockWBSElement( @Nullable final String inventorySpclStockWBSElement )
    {
        rememberChangedField("InventorySpclStockWBSElement", this.inventorySpclStockWBSElement);
        this.inventorySpclStockWBSElement = inventorySpclStockWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearMonth</b>
     * </p>
     *
     * @param calendarYearMonth
     *            Year Month
     */
    public void setCalendarYearMonth( @Nullable final String calendarYearMonth )
    {
        rememberChangedField("CalendarYearMonth", this.calendarYearMonth);
        this.calendarYearMonth = calendarYearMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @param customerName
     *            Customer Number
     */
    public void setCustomerName( @Nullable final String customerName )
    {
        rememberChangedField("CustomerName", this.customerName);
        this.customerName = customerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @param supplierName
     *            Supplier
     */
    public void setSupplierName( @Nullable final String supplierName )
    {
        rememberChangedField("SupplierName", this.supplierName);
        this.supplierName = supplierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BalanceTransactionCurrency</b>
     * </p>
     *
     * @param balanceTransactionCurrency
     *            Balance Transaction Currency
     */
    public void setBalanceTransactionCurrency( @Nullable final String balanceTransactionCurrency )
    {
        rememberChangedField("BalanceTransactionCurrency", this.balanceTransactionCurrency);
        this.balanceTransactionCurrency = balanceTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Reference
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            WBS Element External ID
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetworkActivity</b>
     * </p>
     *
     * @param partnerProjectNetworkActivity
     *            Partner Project Network Activity
     */
    public void setPartnerProjectNetworkActivity( @Nullable final String partnerProjectNetworkActivity )
    {
        rememberChangedField("PartnerProjectNetworkActivity", this.partnerProjectNetworkActivity);
        this.partnerProjectNetworkActivity = partnerProjectNetworkActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearQuarter</b>
     * </p>
     *
     * @param calendarYearQuarter
     *            Year Quarter
     */
    public void setCalendarYearQuarter( @Nullable final String calendarYearQuarter )
    {
        rememberChangedField("CalendarYearQuarter", this.calendarYearQuarter);
        this.calendarYearQuarter = calendarYearQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBalanceSheetAccount</b>
     * </p>
     *
     * @param isBalanceSheetAccount
     *            Indicator: Account is a balance sheet account?
     */
    public void setIsBalanceSheetAccount( @Nullable final String isBalanceSheetAccount )
    {
        rememberChangedField("IsBalanceSheetAccount", this.isBalanceSheetAccount);
        this.isBalanceSheetAccount = isBalanceSheetAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @param partnerAccountAssignmentType
     *            Partner Account Assignment Type
     */
    public void setPartnerAccountAssignmentType( @Nullable final String partnerAccountAssignmentType )
    {
        rememberChangedField("PartnerAccountAssignmentType", this.partnerAccountAssignmentType);
        this.partnerAccountAssignmentType = partnerAccountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearWeek</b>
     * </p>
     *
     * @param fiscalYearWeek
     *            Fiscal Year + Fiscal Week
     */
    public void setFiscalYearWeek( @Nullable final String fiscalYearWeek )
    {
        rememberChangedField("FiscalYearWeek", this.fiscalYearWeek);
        this.fiscalYearWeek = fiscalYearWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     *
     * @param jointVentureEquityGroup
     *            Joint Venture Equity Group
     */
    public void setJointVentureEquityGroup( @Nullable final String jointVentureEquityGroup )
    {
        rememberChangedField("JointVentureEquityGroup", this.jointVentureEquityGroup);
        this.jointVentureEquityGroup = jointVentureEquityGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignment</b>
     * </p>
     *
     * @param senderAccountAssignment
     *            Sender Account Assignment
     */
    public void setSenderAccountAssignment( @Nullable final String senderAccountAssignment )
    {
        rememberChangedField("SenderAccountAssignment", this.senderAccountAssignment);
        this.senderAccountAssignment = senderAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearQuarter</b>
     * </p>
     *
     * @param fiscalYearQuarter
     *            Fiscal Year + Fiscal Quarter
     */
    public void setFiscalYearQuarter( @Nullable final String fiscalYearQuarter )
    {
        rememberChangedField("FiscalYearQuarter", this.fiscalYearQuarter);
        this.fiscalYearQuarter = fiscalYearQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>GroupFixedAsset</b>
     * </p>
     *
     * @param groupFixedAsset
     *            Group Asset Subnumber
     */
    public void setGroupFixedAsset( @Nullable final String groupFixedAsset )
    {
        rememberChangedField("GroupFixedAsset", this.groupFixedAsset);
        this.groupFixedAsset = groupFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItemGroup</b>
     * </p>
     *
     * @param referenceDocumentItemGroup
     *            Reference Document Item Group
     */
    public void setReferenceDocumentItemGroup( @Nullable final String referenceDocumentItemGroup )
    {
        rememberChangedField("ReferenceDocumentItemGroup", this.referenceDocumentItemGroup);
        this.referenceDocumentItemGroup = referenceDocumentItemGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssetDepreciationArea</b>
     * </p>
     *
     * @param assetDepreciationArea
     *            Asset Depreciation Area (Real or Derived)
     */
    public void setAssetDepreciationArea( @Nullable final String assetDepreciationArea )
    {
        rememberChangedField("AssetDepreciationArea", this.assetDepreciationArea);
        this.assetDepreciationArea = assetDepreciationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @param partnerSegment
     *            Partner Segment for Segmental Reporting
     */
    public void setPartnerSegment( @Nullable final String partnerSegment )
    {
        rememberChangedField("PartnerSegment", this.partnerSegment);
        this.partnerSegment = partnerSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentName</b>
     * </p>
     *
     * @param partnerSegmentName
     *            Partner Segment for Segmental Reporting
     */
    public void setPartnerSegmentName( @Nullable final String partnerSegmentName )
    {
        rememberChangedField("PartnerSegmentName", this.partnerSegmentName);
        this.partnerSegmentName = partnerSegmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntry</b>
     * </p>
     *
     * @param clearingJournalEntry
     *            Clearing Journal Entry
     */
    public void setClearingJournalEntry( @Nullable final String clearingJournalEntry )
    {
        rememberChangedField("ClearingJournalEntry", this.clearingJournalEntry);
        this.clearingJournalEntry = clearingJournalEntry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @param operatingConcern
     *            Operating Concern
     */
    public void setOperatingConcern( @Nullable final String operatingConcern )
    {
        rememberChangedField("OperatingConcern", this.operatingConcern);
        this.operatingConcern = operatingConcern;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpclStockWBSElmntExtID</b>
     * </p>
     *
     * @param invtrySpclStockWBSElmntExtID
     *            Inventory Special Stock WBS Element External ID
     */
    public void setInvtrySpclStockWBSElmntExtID( @Nullable final String invtrySpclStockWBSElmntExtID )
    {
        rememberChangedField("InvtrySpclStockWBSElmntExtID", this.invtrySpclStockWBSElmntExtID);
        this.invtrySpclStockWBSElmntExtID = invtrySpclStockWBSElmntExtID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate</b>
     * </p>
     *
     * @param fiscalPeriodEndDate
     *            End Date of Fiscal Period
     */
    public void setFiscalPeriodEndDate( @Nullable final String fiscalPeriodEndDate )
    {
        rememberChangedField("FiscalPeriodEndDate", this.fiscalPeriodEndDate);
        this.fiscalPeriodEndDate = fiscalPeriodEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodEndDate_T</b>
     * </p>
     *
     * @param fiscalPeriodEndDate_T
     *            End Date of Fiscal Period
     */
    public void setFiscalPeriodEndDate_T( @Nullable final String fiscalPeriodEndDate_T )
    {
        rememberChangedField("FiscalPeriodEndDate_T", this.fiscalPeriodEndDate_T);
        this.fiscalPeriodEndDate_T = fiscalPeriodEndDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @param countryChartOfAccounts
     *            Alternative Chart of Accounts for Country/Region
     */
    public void setCountryChartOfAccounts( @Nullable final String countryChartOfAccounts )
    {
        rememberChangedField("CountryChartOfAccounts", this.countryChartOfAccounts);
        this.countryChartOfAccounts = countryChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate</b>
     * </p>
     *
     * @param fiscalPeriodStartDate
     *            Start Date of Fiscal Period
     */
    public void setFiscalPeriodStartDate( @Nullable final String fiscalPeriodStartDate )
    {
        rememberChangedField("FiscalPeriodStartDate", this.fiscalPeriodStartDate);
        this.fiscalPeriodStartDate = fiscalPeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodStartDate_T</b>
     * </p>
     *
     * @param fiscalPeriodStartDate_T
     *            Start Date of Fiscal Period
     */
    public void setFiscalPeriodStartDate_T( @Nullable final String fiscalPeriodStartDate_T )
    {
        rememberChangedField("FiscalPeriodStartDate_T", this.fiscalPeriodStartDate_T);
        this.fiscalPeriodStartDate_T = fiscalPeriodStartDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @param freeDefinedCurrency6
     *            Freely Defined Currency 6
     */
    public void setFreeDefinedCurrency6( @Nullable final String freeDefinedCurrency6 )
    {
        rememberChangedField("FreeDefinedCurrency6", this.freeDefinedCurrency6);
        this.freeDefinedCurrency6 = freeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @param accountAssignment
     *            Account Assignment
     */
    public void setAccountAssignment( @Nullable final String accountAssignment )
    {
        rememberChangedField("AccountAssignment", this.accountAssignment);
        this.accountAssignment = accountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @param partnerCostCtrActivityType
     *            Partner Cost Center Activity Type
     */
    public void setPartnerCostCtrActivityType( @Nullable final String partnerCostCtrActivityType )
    {
        rememberChangedField("PartnerCostCtrActivityType", this.partnerCostCtrActivityType);
        this.partnerCostCtrActivityType = partnerCostCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessProcess</b>
     * </p>
     *
     * @param partnerBusinessProcess
     *            Partner Business Process
     */
    public void setPartnerBusinessProcess( @Nullable final String partnerBusinessProcess )
    {
        rememberChangedField("PartnerBusinessProcess", this.partnerBusinessProcess);
        this.partnerBusinessProcess = partnerBusinessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RelatedNetworkActivity</b>
     * </p>
     *
     * @param relatedNetworkActivity
     *            Related Network Activity
     */
    public void setRelatedNetworkActivity( @Nullable final String relatedNetworkActivity )
    {
        rememberChangedField("RelatedNetworkActivity", this.relatedNetworkActivity);
        this.relatedNetworkActivity = relatedNetworkActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @param freeDefinedCurrency1
     *            Freely Defined Currency 1
     */
    public void setFreeDefinedCurrency1( @Nullable final String freeDefinedCurrency1 )
    {
        rememberChangedField("FreeDefinedCurrency1", this.freeDefinedCurrency1);
        this.freeDefinedCurrency1 = freeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriodDate</b>
     * </p>
     *
     * @param fiscalPeriodDate
     *            Fiscal Period Date
     */
    public void setFiscalPeriodDate( @Nullable final String fiscalPeriodDate )
    {
        rememberChangedField("FiscalPeriodDate", this.fiscalPeriodDate);
        this.fiscalPeriodDate = fiscalPeriodDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @param freeDefinedCurrency3
     *            Freely Defined Currency 3
     */
    public void setFreeDefinedCurrency3( @Nullable final String freeDefinedCurrency3 )
    {
        rememberChangedField("FreeDefinedCurrency3", this.freeDefinedCurrency3);
        this.freeDefinedCurrency3 = freeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AssetTransactionType</b>
     * </p>
     *
     * @param assetTransactionType
     *            Asset Transaction Type
     */
    public void setAssetTransactionType( @Nullable final String assetTransactionType )
    {
        rememberChangedField("AssetTransactionType", this.assetTransactionType);
        this.assetTransactionType = assetTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockValnType_2</b>
     * </p>
     *
     * @param invtrySpecialStockValnType_2
     *            Inventory Special Stock Valuation Type
     */
    public void setInvtrySpecialStockValnType_2( @Nullable final String invtrySpecialStockValnType_2 )
    {
        rememberChangedField("InvtrySpecialStockValnType_2", this.invtrySpecialStockValnType_2);
        this.invtrySpecialStockValnType_2 = invtrySpecialStockValnType_2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenter</b>
     * </p>
     *
     * @param eliminationProfitCenter
     *            Elimination Profit Center
     */
    public void setEliminationProfitCenter( @Nullable final String eliminationProfitCenter )
    {
        rememberChangedField("EliminationProfitCenter", this.eliminationProfitCenter);
        this.eliminationProfitCenter = eliminationProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EliminationProfitCenterName</b>
     * </p>
     *
     * @param eliminationProfitCenterName
     *            Elimination Profit Center
     */
    public void setEliminationProfitCenterName( @Nullable final String eliminationProfitCenterName )
    {
        rememberChangedField("EliminationProfitCenterName", this.eliminationProfitCenterName);
        this.eliminationProfitCenterName = eliminationProfitCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @param globalCurrency
     *            Global Currency
     */
    public void setGlobalCurrency( @Nullable final String globalCurrency )
    {
        rememberChangedField("GlobalCurrency", this.globalCurrency);
        this.globalCurrency = globalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PredecessorReferenceDocType</b>
     * </p>
     *
     * @param predecessorReferenceDocType
     *            Predecessor Reference Document Type
     */
    public void setPredecessorReferenceDocType( @Nullable final String predecessorReferenceDocType )
    {
        rememberChangedField("PredecessorReferenceDocType", this.predecessorReferenceDocType);
        this.predecessorReferenceDocType = predecessorReferenceDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @param ledgerFiscalYear
     *            Fiscal Year of Ledger
     */
    public void setLedgerFiscalYear( @Nullable final String ledgerFiscalYear )
    {
        rememberChangedField("LedgerFiscalYear", this.ledgerFiscalYear);
        this.ledgerFiscalYear = ledgerFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @param partnerSalesDocument
     *            Partner Sales Document
     */
    public void setPartnerSalesDocument( @Nullable final String partnerSalesDocument )
    {
        rememberChangedField("PartnerSalesDocument", this.partnerSalesDocument);
        this.partnerSalesDocument = partnerSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignment</b>
     * </p>
     *
     * @param partnerAccountAssignment
     *            Partner Account Assignment
     */
    public void setPartnerAccountAssignment( @Nullable final String partnerAccountAssignment )
    {
        rememberChangedField("PartnerAccountAssignment", this.partnerAccountAssignment);
        this.partnerAccountAssignment = partnerAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccount</b>
     * </p>
     *
     * @param offsettingAccount
     *            Offsetting Account
     */
    public void setOffsettingAccount( @Nullable final String offsettingAccount )
    {
        rememberChangedField("OffsettingAccount", this.offsettingAccount);
        this.offsettingAccount = offsettingAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @param partnerBudgetPeriod
     *            FM: Partner Budget Period
     */
    public void setPartnerBudgetPeriod( @Nullable final String partnerBudgetPeriod )
    {
        rememberChangedField("PartnerBudgetPeriod", this.partnerBudgetPeriod);
        this.partnerBudgetPeriod = partnerBudgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @param accountingDocCreatedByUser
     *            User that created the journal entry
     */
    public void setAccountingDocCreatedByUser( @Nullable final String accountingDocCreatedByUser )
    {
        rememberChangedField("AccountingDocCreatedByUser", this.accountingDocCreatedByUser);
        this.accountingDocCreatedByUser = accountingDocCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @param freeDefinedCurrency4
     *            Freely Defined Currency 4
     */
    public void setFreeDefinedCurrency4( @Nullable final String freeDefinedCurrency4 )
    {
        rememberChangedField("FreeDefinedCurrency4", this.freeDefinedCurrency4);
        this.freeDefinedCurrency4 = freeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LineItemIsCompleted</b>
     * </p>
     *
     * @param lineItemIsCompleted
     *            Indicator: Line Item is Completed
     */
    public void setLineItemIsCompleted( @Nullable final String lineItemIsCompleted )
    {
        rememberChangedField("LineItemIsCompleted", this.lineItemIsCompleted);
        this.lineItemIsCompleted = lineItemIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectInternalID</b>
     * </p>
     *
     * @param partnerProjectInternalID
     *            Partner Project Internal ID
     */
    public void setPartnerProjectInternalID( @Nullable final String partnerProjectInternalID )
    {
        rememberChangedField("PartnerProjectInternalID", this.partnerProjectInternalID);
        this.partnerProjectInternalID = partnerProjectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectExternalID</b>
     * </p>
     *
     * @param partnerProjectExternalID
     *            Partner Project External ID
     */
    public void setPartnerProjectExternalID( @Nullable final String partnerProjectExternalID )
    {
        rememberChangedField("PartnerProjectExternalID", this.partnerProjectExternalID);
        this.partnerProjectExternalID = partnerProjectExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @param jointVentureCostRecoveryCode
     *            Joint Venture Cost Recovery Code
     */
    public void setJointVentureCostRecoveryCode( @Nullable final String jointVentureCostRecoveryCode )
    {
        rememberChangedField("JointVentureCostRecoveryCode", this.jointVentureCostRecoveryCode);
        this.jointVentureCostRecoveryCode = jointVentureCostRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockSupplier</b>
     * </p>
     *
     * @param inventorySpecialStockSupplier
     *            Supplier of Inventory Special Stock
     */
    public void setInventorySpecialStockSupplier( @Nullable final String inventorySpecialStockSupplier )
    {
        rememberChangedField("InventorySpecialStockSupplier", this.inventorySpecialStockSupplier);
        this.inventorySpecialStockSupplier = inventorySpecialStockSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>InvtrySpecialStockSupplierName</b>
     * </p>
     *
     * @param invtrySpecialStockSupplierName
     *            Supplier of Inventory Special Stock
     */
    public void setInvtrySpecialStockSupplierName( @Nullable final String invtrySpecialStockSupplierName )
    {
        rememberChangedField("InvtrySpecialStockSupplierName", this.invtrySpecialStockSupplierName);
        this.invtrySpecialStockSupplierName = invtrySpecialStockSupplierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @param accountAssignmentType
     *            Account Assignment Type
     */
    public void setAccountAssignmentType( @Nullable final String accountAssignmentType )
    {
        rememberChangedField("AccountAssignmentType", this.accountAssignmentType);
        this.accountAssignmentType = accountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @param soldProductGroup
     *            Product Sold Group
     */
    public void setSoldProductGroup( @Nullable final String soldProductGroup )
    {
        rememberChangedField("SoldProductGroup", this.soldProductGroup);
        this.soldProductGroup = soldProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupName</b>
     * </p>
     *
     * @param materialGroupName
     *            Product Sold Group
     */
    public void setMaterialGroupName( @Nullable final String materialGroupName )
    {
        rememberChangedField("MaterialGroupName", this.materialGroupName);
        this.materialGroupName = materialGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @param partnerProject
     *            Partner Project
     */
    public void setPartnerProject( @Nullable final String partnerProject )
    {
        rememberChangedField("PartnerProject", this.partnerProject);
        this.partnerProject = partnerProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ClearingJournalEntryFiscalYear</b>
     * </p>
     *
     * @param clearingJournalEntryFiscalYear
     *            Fiscal Year of Clearing Journal Entry
     */
    public void setClearingJournalEntryFiscalYear( @Nullable final String clearingJournalEntryFiscalYear )
    {
        rememberChangedField("ClearingJournalEntryFiscalYear", this.clearingJournalEntryFiscalYear);
        this.clearingJournalEntryFiscalYear = clearingJournalEntryFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GroupMasterFixedAsset</b>
     * </p>
     *
     * @param groupMasterFixedAsset
     *            Group Asset
     */
    public void setGroupMasterFixedAsset( @Nullable final String groupMasterFixedAsset )
    {
        rememberChangedField("GroupMasterFixedAsset", this.groupMasterFixedAsset);
        this.groupMasterFixedAsset = groupMasterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrderCategory</b>
     * </p>
     *
     * @param partnerOrderCategory
     *            Partner Order Category
     */
    public void setPartnerOrderCategory( @Nullable final String partnerOrderCategory )
    {
        rememberChangedField("PartnerOrderCategory", this.partnerOrderCategory);
        this.partnerOrderCategory = partnerOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Partner Business Area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessAreaName</b>
     * </p>
     *
     * @param partnerBusinessAreaName
     *            Partner Business Area
     */
    public void setPartnerBusinessAreaName( @Nullable final String partnerBusinessAreaName )
    {
        rememberChangedField("PartnerBusinessAreaName", this.partnerBusinessAreaName);
        this.partnerBusinessAreaName = partnerBusinessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @param partnerFunctionalArea
     *            Partner Functional Area
     */
    public void setPartnerFunctionalArea( @Nullable final String partnerFunctionalArea )
    {
        rememberChangedField("PartnerFunctionalArea", this.partnerFunctionalArea);
        this.partnerFunctionalArea = partnerFunctionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalAreaName</b>
     * </p>
     *
     * @param partnerFunctionalAreaName
     *            Partner Functional Area
     */
    public void setPartnerFunctionalAreaName( @Nullable final String partnerFunctionalAreaName )
    {
        rememberChangedField("PartnerFunctionalAreaName", this.partnerFunctionalAreaName);
        this.partnerFunctionalAreaName = partnerFunctionalAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectExternalID</b>
     * </p>
     *
     * @param projectExternalID
     *            Project External ID
     */
    public void setProjectExternalID( @Nullable final String projectExternalID )
    {
        rememberChangedField("ProjectExternalID", this.projectExternalID);
        this.projectExternalID = projectExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @param originCostCenter
     *            Origin Cost Center
     */
    public void setOriginCostCenter( @Nullable final String originCostCenter )
    {
        rememberChangedField("OriginCostCenter", this.originCostCenter);
        this.originCostCenter = originCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @param freeDefinedCurrency5
     *            Freely Defined Currency 5
     */
    public void setFreeDefinedCurrency5( @Nullable final String freeDefinedCurrency5 )
    {
        rememberChangedField("FreeDefinedCurrency5", this.freeDefinedCurrency5);
        this.freeDefinedCurrency5 = freeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @param originObjectType
     *            Type of Origin Object
     */
    public void setOriginObjectType( @Nullable final String originObjectType )
    {
        rememberChangedField("OriginObjectType", this.originObjectType);
        this.originObjectType = originObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectDebitType</b>
     * </p>
     *
     * @param controllingObjectDebitType
     *            Controlling Object Debit Type
     */
    public void setControllingObjectDebitType( @Nullable final String controllingObjectDebitType )
    {
        rememberChangedField("ControllingObjectDebitType", this.controllingObjectDebitType);
        this.controllingObjectDebitType = controllingObjectDebitType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @param partnerWBSElementInternalID
     *            Partner WBS Element Internal ID
     */
    public void setPartnerWBSElementInternalID( @Nullable final String partnerWBSElementInternalID )
    {
        rememberChangedField("PartnerWBSElementInternalID", this.partnerWBSElementInternalID);
        this.partnerWBSElementInternalID = partnerWBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementExternalID</b>
     * </p>
     *
     * @param partnerWBSElementExternalID
     *            Partner WBS Element External ID
     */
    public void setPartnerWBSElementExternalID( @Nullable final String partnerWBSElementExternalID )
    {
        rememberChangedField("PartnerWBSElementExternalID", this.partnerWBSElementExternalID);
        this.partnerWBSElementExternalID = partnerWBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccountHierarchy</b>
     * </p>
     *
     * @param gLAccountHierarchy
     *            G/L Account
     */
    public void setGLAccountHierarchy( @Nullable final String gLAccountHierarchy )
    {
        rememberChangedField("GLAccountHierarchy", this.gLAccountHierarchy);
        this.gLAccountHierarchy = gLAccountHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CustomerServiceNotification</b>
     * </p>
     *
     * @param customerServiceNotification
     *            Customer Service Notification
     */
    public void setCustomerServiceNotification( @Nullable final String customerServiceNotification )
    {
        rememberChangedField("CustomerServiceNotification", this.customerServiceNotification);
        this.customerServiceNotification = customerServiceNotification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @param freeDefinedCurrency7
     *            Freely Defined Currency 7
     */
    public void setFreeDefinedCurrency7( @Nullable final String freeDefinedCurrency7 )
    {
        rememberChangedField("FreeDefinedCurrency7", this.freeDefinedCurrency7);
        this.freeDefinedCurrency7 = freeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentNumber</b>
     * </p>
     *
     * @param accountAssignmentNumber
     *            Account Assignment Number
     */
    public void setAccountAssignmentNumber( @Nullable final String accountAssignmentNumber )
    {
        rememberChangedField("AccountAssignmentNumber", this.accountAssignmentNumber);
        this.accountAssignmentNumber = accountAssignmentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TransactionTypeDetermination</b>
     * </p>
     *
     * @param transactionTypeDetermination
     *            Transaction Key
     */
    public void setTransactionTypeDetermination( @Nullable final String transactionTypeDetermination )
    {
        rememberChangedField("TransactionTypeDetermination", this.transactionTypeDetermination);
        this.transactionTypeDetermination = transactionTypeDetermination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProjectNetwork</b>
     * </p>
     *
     * @param partnerProjectNetwork
     *            Partner Project Network
     */
    public void setPartnerProjectNetwork( @Nullable final String partnerProjectNetwork )
    {
        rememberChangedField("PartnerProjectNetwork", this.partnerProjectNetwork);
        this.partnerProjectNetwork = partnerProjectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @param partnerCompanyCode
     *            Partner Company Code
     */
    public void setPartnerCompanyCode( @Nullable final String partnerCompanyCode )
    {
        rememberChangedField("PartnerCompanyCode", this.partnerCompanyCode);
        this.partnerCompanyCode = partnerCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OffsettingAccountType</b>
     * </p>
     *
     * @param offsettingAccountType
     *            Offsetting Account Type
     */
    public void setOffsettingAccountType( @Nullable final String offsettingAccountType )
    {
        rememberChangedField("OffsettingAccountType", this.offsettingAccountType);
        this.offsettingAccountType = offsettingAccountType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYearWeek</b>
     * </p>
     *
     * @param calendarYearWeek
     *            Year Week
     */
    public void setCalendarYearWeek( @Nullable final String calendarYearWeek )
    {
        rememberChangedField("CalendarYearWeek", this.calendarYearWeek);
        this.calendarYearWeek = calendarYearWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderAccountAssignmentType</b>
     * </p>
     *
     * @param senderAccountAssignmentType
     *            Account Assignment Type in Sender System
     */
    public void setSenderAccountAssignmentType( @Nullable final String senderAccountAssignmentType )
    {
        rememberChangedField("SenderAccountAssignmentType", this.senderAccountAssignmentType);
        this.senderAccountAssignmentType = senderAccountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchasing Document Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SenderGLAccount</b>
     * </p>
     *
     * @param senderGLAccount
     *            Sender G/L Account
     */
    public void setSenderGLAccount( @Nullable final String senderGLAccount )
    {
        rememberChangedField("SenderGLAccount", this.senderGLAccount);
        this.senderGLAccount = senderGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @param partnerSalesDocumentItem
     *            Partner Sales Document Item
     */
    public void setPartnerSalesDocumentItem( @Nullable final String partnerSalesDocumentItem )
    {
        rememberChangedField("PartnerSalesDocumentItem", this.partnerSalesDocumentItem);
        this.partnerSalesDocumentItem = partnerSalesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InventoryValuationType</b>
     * </p>
     *
     * @param inventoryValuationType
     *            Inventory Valuation Type
     */
    public void setInventoryValuationType( @Nullable final String inventoryValuationType )
    {
        rememberChangedField("InventoryValuationType", this.inventoryValuationType);
        this.inventoryValuationType = inventoryValuationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @param settlementReferenceDate
     *            Settlement Reference Date
     */
    public void setSettlementReferenceDate( @Nullable final String settlementReferenceDate )
    {
        rememberChangedField("SettlementReferenceDate", this.settlementReferenceDate);
        this.settlementReferenceDate = settlementReferenceDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate_T</b>
     * </p>
     *
     * @param settlementReferenceDate_T
     *            Settlement Reference Date
     */
    public void setSettlementReferenceDate_T( @Nullable final String settlementReferenceDate_T )
    {
        rememberChangedField("SettlementReferenceDate_T", this.settlementReferenceDate_T);
        this.settlementReferenceDate_T = settlementReferenceDate_T;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param startingBalanceAmtInCoCodeCrcy
     *            Starting Balance Amount In Company Code Currency
     */
    public void setStartingBalanceAmtInCoCodeCrcy( @Nullable final BigDecimal startingBalanceAmtInCoCodeCrcy )
    {
        rememberChangedField("StartingBalanceAmtInCoCodeCrcy", this.startingBalanceAmtInCoCodeCrcy);
        this.startingBalanceAmtInCoCodeCrcy = startingBalanceAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInCoCodeCrcy_F</b>
     * </p>
     *
     * @param startingBalanceAmtInCoCodeCrcy_F
     *            Starting Balance Amount In Company Code Currency
     */
    public void setStartingBalanceAmtInCoCodeCrcy_F( @Nullable final String startingBalanceAmtInCoCodeCrcy_F )
    {
        rememberChangedField("StartingBalanceAmtInCoCodeCrcy_F", this.startingBalanceAmtInCoCodeCrcy_F);
        this.startingBalanceAmtInCoCodeCrcy_F = startingBalanceAmtInCoCodeCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInCoCodeCrcy_E</b>
     * </p>
     *
     * @param startingBalanceAmtInCoCodeCrcy_E
     *            Starting Balance Amount In Company Code Currency
     */
    public void setStartingBalanceAmtInCoCodeCrcy_E( @Nullable final String startingBalanceAmtInCoCodeCrcy_E )
    {
        rememberChangedField("StartingBalanceAmtInCoCodeCrcy_E", this.startingBalanceAmtInCoCodeCrcy_E);
        this.startingBalanceAmtInCoCodeCrcy_E = startingBalanceAmtInCoCodeCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param debitAmountInCoCodeCrcy
     *            Debit Balance in Company Code Currency
     */
    public void setDebitAmountInCoCodeCrcy( @Nullable final BigDecimal debitAmountInCoCodeCrcy )
    {
        rememberChangedField("DebitAmountInCoCodeCrcy", this.debitAmountInCoCodeCrcy);
        this.debitAmountInCoCodeCrcy = debitAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInCoCodeCrcy_F</b>
     * </p>
     *
     * @param debitAmountInCoCodeCrcy_F
     *            Debit Balance in Company Code Currency
     */
    public void setDebitAmountInCoCodeCrcy_F( @Nullable final String debitAmountInCoCodeCrcy_F )
    {
        rememberChangedField("DebitAmountInCoCodeCrcy_F", this.debitAmountInCoCodeCrcy_F);
        this.debitAmountInCoCodeCrcy_F = debitAmountInCoCodeCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInCoCodeCrcy_E</b>
     * </p>
     *
     * @param debitAmountInCoCodeCrcy_E
     *            Debit Balance in Company Code Currency
     */
    public void setDebitAmountInCoCodeCrcy_E( @Nullable final String debitAmountInCoCodeCrcy_E )
    {
        rememberChangedField("DebitAmountInCoCodeCrcy_E", this.debitAmountInCoCodeCrcy_E);
        this.debitAmountInCoCodeCrcy_E = debitAmountInCoCodeCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param creditAmountInCoCodeCrcy
     *            Credit Balance in Company Code Currency
     */
    public void setCreditAmountInCoCodeCrcy( @Nullable final BigDecimal creditAmountInCoCodeCrcy )
    {
        rememberChangedField("CreditAmountInCoCodeCrcy", this.creditAmountInCoCodeCrcy);
        this.creditAmountInCoCodeCrcy = creditAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInCoCodeCrcy_F</b>
     * </p>
     *
     * @param creditAmountInCoCodeCrcy_F
     *            Credit Balance in Company Code Currency
     */
    public void setCreditAmountInCoCodeCrcy_F( @Nullable final String creditAmountInCoCodeCrcy_F )
    {
        rememberChangedField("CreditAmountInCoCodeCrcy_F", this.creditAmountInCoCodeCrcy_F);
        this.creditAmountInCoCodeCrcy_F = creditAmountInCoCodeCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInCoCodeCrcy_E</b>
     * </p>
     *
     * @param creditAmountInCoCodeCrcy_E
     *            Credit Balance in Company Code Currency
     */
    public void setCreditAmountInCoCodeCrcy_E( @Nullable final String creditAmountInCoCodeCrcy_E )
    {
        rememberChangedField("CreditAmountInCoCodeCrcy_E", this.creditAmountInCoCodeCrcy_E);
        this.creditAmountInCoCodeCrcy_E = creditAmountInCoCodeCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param endingBalanceAmtInCoCodeCrcy
     *            Ending Balance in Company Code Currency
     */
    public void setEndingBalanceAmtInCoCodeCrcy( @Nullable final BigDecimal endingBalanceAmtInCoCodeCrcy )
    {
        rememberChangedField("EndingBalanceAmtInCoCodeCrcy", this.endingBalanceAmtInCoCodeCrcy);
        this.endingBalanceAmtInCoCodeCrcy = endingBalanceAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInCoCodeCrcy_F</b>
     * </p>
     *
     * @param endingBalanceAmtInCoCodeCrcy_F
     *            Ending Balance in Company Code Currency
     */
    public void setEndingBalanceAmtInCoCodeCrcy_F( @Nullable final String endingBalanceAmtInCoCodeCrcy_F )
    {
        rememberChangedField("EndingBalanceAmtInCoCodeCrcy_F", this.endingBalanceAmtInCoCodeCrcy_F);
        this.endingBalanceAmtInCoCodeCrcy_F = endingBalanceAmtInCoCodeCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInCoCodeCrcy_E</b>
     * </p>
     *
     * @param endingBalanceAmtInCoCodeCrcy_E
     *            Ending Balance in Company Code Currency
     */
    public void setEndingBalanceAmtInCoCodeCrcy_E( @Nullable final String endingBalanceAmtInCoCodeCrcy_E )
    {
        rememberChangedField("EndingBalanceAmtInCoCodeCrcy_E", this.endingBalanceAmtInCoCodeCrcy_E);
        this.endingBalanceAmtInCoCodeCrcy_E = endingBalanceAmtInCoCodeCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInGlobalCrcy</b>
     * </p>
     *
     * @param startingBalanceAmtInGlobalCrcy
     *            Starting Balance Amount In Global Currency
     */
    public void setStartingBalanceAmtInGlobalCrcy( @Nullable final BigDecimal startingBalanceAmtInGlobalCrcy )
    {
        rememberChangedField("StartingBalanceAmtInGlobalCrcy", this.startingBalanceAmtInGlobalCrcy);
        this.startingBalanceAmtInGlobalCrcy = startingBalanceAmtInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInGlobalCrcy_F</b>
     * </p>
     *
     * @param startingBalanceAmtInGlobalCrcy_F
     *            Starting Balance Amount In Global Currency
     */
    public void setStartingBalanceAmtInGlobalCrcy_F( @Nullable final String startingBalanceAmtInGlobalCrcy_F )
    {
        rememberChangedField("StartingBalanceAmtInGlobalCrcy_F", this.startingBalanceAmtInGlobalCrcy_F);
        this.startingBalanceAmtInGlobalCrcy_F = startingBalanceAmtInGlobalCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInGlobalCrcy_E</b>
     * </p>
     *
     * @param startingBalanceAmtInGlobalCrcy_E
     *            Starting Balance Amount In Global Currency
     */
    public void setStartingBalanceAmtInGlobalCrcy_E( @Nullable final String startingBalanceAmtInGlobalCrcy_E )
    {
        rememberChangedField("StartingBalanceAmtInGlobalCrcy_E", this.startingBalanceAmtInGlobalCrcy_E);
        this.startingBalanceAmtInGlobalCrcy_E = startingBalanceAmtInGlobalCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInGlobalCrcy</b>
     * </p>
     *
     * @param debitAmountInGlobalCrcy
     *            Debit Balance in Global Currency
     */
    public void setDebitAmountInGlobalCrcy( @Nullable final BigDecimal debitAmountInGlobalCrcy )
    {
        rememberChangedField("DebitAmountInGlobalCrcy", this.debitAmountInGlobalCrcy);
        this.debitAmountInGlobalCrcy = debitAmountInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInGlobalCrcy_F</b>
     * </p>
     *
     * @param debitAmountInGlobalCrcy_F
     *            Debit Balance in Global Currency
     */
    public void setDebitAmountInGlobalCrcy_F( @Nullable final String debitAmountInGlobalCrcy_F )
    {
        rememberChangedField("DebitAmountInGlobalCrcy_F", this.debitAmountInGlobalCrcy_F);
        this.debitAmountInGlobalCrcy_F = debitAmountInGlobalCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInGlobalCrcy_E</b>
     * </p>
     *
     * @param debitAmountInGlobalCrcy_E
     *            Debit Balance in Global Currency
     */
    public void setDebitAmountInGlobalCrcy_E( @Nullable final String debitAmountInGlobalCrcy_E )
    {
        rememberChangedField("DebitAmountInGlobalCrcy_E", this.debitAmountInGlobalCrcy_E);
        this.debitAmountInGlobalCrcy_E = debitAmountInGlobalCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInGlobalCrcy</b>
     * </p>
     *
     * @param creditAmountInGlobalCrcy
     *            Credit Balance in Global Currency
     */
    public void setCreditAmountInGlobalCrcy( @Nullable final BigDecimal creditAmountInGlobalCrcy )
    {
        rememberChangedField("CreditAmountInGlobalCrcy", this.creditAmountInGlobalCrcy);
        this.creditAmountInGlobalCrcy = creditAmountInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInGlobalCrcy_F</b>
     * </p>
     *
     * @param creditAmountInGlobalCrcy_F
     *            Credit Balance in Global Currency
     */
    public void setCreditAmountInGlobalCrcy_F( @Nullable final String creditAmountInGlobalCrcy_F )
    {
        rememberChangedField("CreditAmountInGlobalCrcy_F", this.creditAmountInGlobalCrcy_F);
        this.creditAmountInGlobalCrcy_F = creditAmountInGlobalCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInGlobalCrcy_E</b>
     * </p>
     *
     * @param creditAmountInGlobalCrcy_E
     *            Credit Balance in Global Currency
     */
    public void setCreditAmountInGlobalCrcy_E( @Nullable final String creditAmountInGlobalCrcy_E )
    {
        rememberChangedField("CreditAmountInGlobalCrcy_E", this.creditAmountInGlobalCrcy_E);
        this.creditAmountInGlobalCrcy_E = creditAmountInGlobalCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInGlobalCrcy</b>
     * </p>
     *
     * @param endingBalanceAmtInGlobalCrcy
     *            Ending Balance in Global Currency
     */
    public void setEndingBalanceAmtInGlobalCrcy( @Nullable final BigDecimal endingBalanceAmtInGlobalCrcy )
    {
        rememberChangedField("EndingBalanceAmtInGlobalCrcy", this.endingBalanceAmtInGlobalCrcy);
        this.endingBalanceAmtInGlobalCrcy = endingBalanceAmtInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInGlobalCrcy_F</b>
     * </p>
     *
     * @param endingBalanceAmtInGlobalCrcy_F
     *            Ending Balance in Global Currency
     */
    public void setEndingBalanceAmtInGlobalCrcy_F( @Nullable final String endingBalanceAmtInGlobalCrcy_F )
    {
        rememberChangedField("EndingBalanceAmtInGlobalCrcy_F", this.endingBalanceAmtInGlobalCrcy_F);
        this.endingBalanceAmtInGlobalCrcy_F = endingBalanceAmtInGlobalCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInGlobalCrcy_E</b>
     * </p>
     *
     * @param endingBalanceAmtInGlobalCrcy_E
     *            Ending Balance in Global Currency
     */
    public void setEndingBalanceAmtInGlobalCrcy_E( @Nullable final String endingBalanceAmtInGlobalCrcy_E )
    {
        rememberChangedField("EndingBalanceAmtInGlobalCrcy_E", this.endingBalanceAmtInGlobalCrcy_E);
        this.endingBalanceAmtInGlobalCrcy_E = endingBalanceAmtInGlobalCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy1</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy1
     *            Starting Balance Amount In Freely Defined Currency 1
     */
    public void setStrtgBalAmtInFreeDfndCrcy1( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy1 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy1", this.strtgBalAmtInFreeDfndCrcy1);
        this.strtgBalAmtInFreeDfndCrcy1 = strtgBalAmtInFreeDfndCrcy1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy1_F
     *            Starting Balance Amount In Freely Defined Currency 1
     */
    public void setStrtgBalAmtInFreeDfndCrcy1_F( @Nullable final String strtgBalAmtInFreeDfndCrcy1_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy1_F", this.strtgBalAmtInFreeDfndCrcy1_F);
        this.strtgBalAmtInFreeDfndCrcy1_F = strtgBalAmtInFreeDfndCrcy1_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy1_E
     *            Starting Balance Amount In Freely Defined Currency 1
     */
    public void setStrtgBalAmtInFreeDfndCrcy1_E( @Nullable final String strtgBalAmtInFreeDfndCrcy1_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy1_E", this.strtgBalAmtInFreeDfndCrcy1_E);
        this.strtgBalAmtInFreeDfndCrcy1_E = strtgBalAmtInFreeDfndCrcy1_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy1</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy1
     *            Debit Balance in Freely Defined Currency 1
     */
    public void setDebitAmountInFreeDfndCrcy1( @Nullable final BigDecimal debitAmountInFreeDfndCrcy1 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy1", this.debitAmountInFreeDfndCrcy1);
        this.debitAmountInFreeDfndCrcy1 = debitAmountInFreeDfndCrcy1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy1_F
     *            Debit Balance in Freely Defined Currency 1
     */
    public void setDebitAmountInFreeDfndCrcy1_F( @Nullable final String debitAmountInFreeDfndCrcy1_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy1_F", this.debitAmountInFreeDfndCrcy1_F);
        this.debitAmountInFreeDfndCrcy1_F = debitAmountInFreeDfndCrcy1_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy1_E
     *            Debit Balance in Freely Defined Currency 1
     */
    public void setDebitAmountInFreeDfndCrcy1_E( @Nullable final String debitAmountInFreeDfndCrcy1_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy1_E", this.debitAmountInFreeDfndCrcy1_E);
        this.debitAmountInFreeDfndCrcy1_E = debitAmountInFreeDfndCrcy1_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy1</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy1
     *            Credit Balance in Freely Defined Currency 1
     */
    public void setCreditAmountInFreeDfndCrcy1( @Nullable final BigDecimal creditAmountInFreeDfndCrcy1 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy1", this.creditAmountInFreeDfndCrcy1);
        this.creditAmountInFreeDfndCrcy1 = creditAmountInFreeDfndCrcy1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy1_F
     *            Credit Balance in Freely Defined Currency 1
     */
    public void setCreditAmountInFreeDfndCrcy1_F( @Nullable final String creditAmountInFreeDfndCrcy1_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy1_F", this.creditAmountInFreeDfndCrcy1_F);
        this.creditAmountInFreeDfndCrcy1_F = creditAmountInFreeDfndCrcy1_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy1_E
     *            Credit Balance in Freely Defined Currency 1
     */
    public void setCreditAmountInFreeDfndCrcy1_E( @Nullable final String creditAmountInFreeDfndCrcy1_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy1_E", this.creditAmountInFreeDfndCrcy1_E);
        this.creditAmountInFreeDfndCrcy1_E = creditAmountInFreeDfndCrcy1_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy1</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy1
     *            Ending Balance in Freely Defined Currency 1
     */
    public void setEndingBalAmtInFreeDfndCrcy1( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy1 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy1", this.endingBalAmtInFreeDfndCrcy1);
        this.endingBalAmtInFreeDfndCrcy1 = endingBalAmtInFreeDfndCrcy1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy1_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy1_F
     *            Ending Balance in Freely Defined Currency 1
     */
    public void setEndingBalAmtInFreeDfndCrcy1_F( @Nullable final String endingBalAmtInFreeDfndCrcy1_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy1_F", this.endingBalAmtInFreeDfndCrcy1_F);
        this.endingBalAmtInFreeDfndCrcy1_F = endingBalAmtInFreeDfndCrcy1_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy1_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy1_E
     *            Ending Balance in Freely Defined Currency 1
     */
    public void setEndingBalAmtInFreeDfndCrcy1_E( @Nullable final String endingBalAmtInFreeDfndCrcy1_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy1_E", this.endingBalAmtInFreeDfndCrcy1_E);
        this.endingBalAmtInFreeDfndCrcy1_E = endingBalAmtInFreeDfndCrcy1_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy2</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy2
     *            Starting Balance Amount In Freely Defined Currency 2
     */
    public void setStrtgBalAmtInFreeDfndCrcy2( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy2 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy2", this.strtgBalAmtInFreeDfndCrcy2);
        this.strtgBalAmtInFreeDfndCrcy2 = strtgBalAmtInFreeDfndCrcy2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy2_F
     *            Starting Balance Amount In Freely Defined Currency 2
     */
    public void setStrtgBalAmtInFreeDfndCrcy2_F( @Nullable final String strtgBalAmtInFreeDfndCrcy2_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy2_F", this.strtgBalAmtInFreeDfndCrcy2_F);
        this.strtgBalAmtInFreeDfndCrcy2_F = strtgBalAmtInFreeDfndCrcy2_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy2_E
     *            Starting Balance Amount In Freely Defined Currency 2
     */
    public void setStrtgBalAmtInFreeDfndCrcy2_E( @Nullable final String strtgBalAmtInFreeDfndCrcy2_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy2_E", this.strtgBalAmtInFreeDfndCrcy2_E);
        this.strtgBalAmtInFreeDfndCrcy2_E = strtgBalAmtInFreeDfndCrcy2_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy2</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy2
     *            Debit Balance in Freely Defined Currency 2
     */
    public void setDebitAmountInFreeDfndCrcy2( @Nullable final BigDecimal debitAmountInFreeDfndCrcy2 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy2", this.debitAmountInFreeDfndCrcy2);
        this.debitAmountInFreeDfndCrcy2 = debitAmountInFreeDfndCrcy2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy2_F
     *            Debit Balance in Freely Defined Currency 2
     */
    public void setDebitAmountInFreeDfndCrcy2_F( @Nullable final String debitAmountInFreeDfndCrcy2_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy2_F", this.debitAmountInFreeDfndCrcy2_F);
        this.debitAmountInFreeDfndCrcy2_F = debitAmountInFreeDfndCrcy2_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy2_E
     *            Debit Balance in Freely Defined Currency 2
     */
    public void setDebitAmountInFreeDfndCrcy2_E( @Nullable final String debitAmountInFreeDfndCrcy2_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy2_E", this.debitAmountInFreeDfndCrcy2_E);
        this.debitAmountInFreeDfndCrcy2_E = debitAmountInFreeDfndCrcy2_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy2</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy2
     *            Credit Balance in Freely Defined Currency 2
     */
    public void setCreditAmountInFreeDfndCrcy2( @Nullable final BigDecimal creditAmountInFreeDfndCrcy2 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy2", this.creditAmountInFreeDfndCrcy2);
        this.creditAmountInFreeDfndCrcy2 = creditAmountInFreeDfndCrcy2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy2_F
     *            Credit Balance in Freely Defined Currency 2
     */
    public void setCreditAmountInFreeDfndCrcy2_F( @Nullable final String creditAmountInFreeDfndCrcy2_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy2_F", this.creditAmountInFreeDfndCrcy2_F);
        this.creditAmountInFreeDfndCrcy2_F = creditAmountInFreeDfndCrcy2_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy2_E
     *            Credit Balance in Freely Defined Currency 2
     */
    public void setCreditAmountInFreeDfndCrcy2_E( @Nullable final String creditAmountInFreeDfndCrcy2_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy2_E", this.creditAmountInFreeDfndCrcy2_E);
        this.creditAmountInFreeDfndCrcy2_E = creditAmountInFreeDfndCrcy2_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy2</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy2
     *            Ending Balance in Freely Defined Currency 2
     */
    public void setEndingBalAmtInFreeDfndCrcy2( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy2 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy2", this.endingBalAmtInFreeDfndCrcy2);
        this.endingBalAmtInFreeDfndCrcy2 = endingBalAmtInFreeDfndCrcy2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy2_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy2_F
     *            Ending Balance in Freely Defined Currency 2
     */
    public void setEndingBalAmtInFreeDfndCrcy2_F( @Nullable final String endingBalAmtInFreeDfndCrcy2_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy2_F", this.endingBalAmtInFreeDfndCrcy2_F);
        this.endingBalAmtInFreeDfndCrcy2_F = endingBalAmtInFreeDfndCrcy2_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy2_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy2_E
     *            Ending Balance in Freely Defined Currency 2
     */
    public void setEndingBalAmtInFreeDfndCrcy2_E( @Nullable final String endingBalAmtInFreeDfndCrcy2_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy2_E", this.endingBalAmtInFreeDfndCrcy2_E);
        this.endingBalAmtInFreeDfndCrcy2_E = endingBalAmtInFreeDfndCrcy2_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy3</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy3
     *            Starting Balance Amount In Freely Defined Currency 3
     */
    public void setStrtgBalAmtInFreeDfndCrcy3( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy3 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy3", this.strtgBalAmtInFreeDfndCrcy3);
        this.strtgBalAmtInFreeDfndCrcy3 = strtgBalAmtInFreeDfndCrcy3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy3_F
     *            Starting Balance Amount In Freely Defined Currency 3
     */
    public void setStrtgBalAmtInFreeDfndCrcy3_F( @Nullable final String strtgBalAmtInFreeDfndCrcy3_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy3_F", this.strtgBalAmtInFreeDfndCrcy3_F);
        this.strtgBalAmtInFreeDfndCrcy3_F = strtgBalAmtInFreeDfndCrcy3_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy3_E
     *            Starting Balance Amount In Freely Defined Currency 3
     */
    public void setStrtgBalAmtInFreeDfndCrcy3_E( @Nullable final String strtgBalAmtInFreeDfndCrcy3_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy3_E", this.strtgBalAmtInFreeDfndCrcy3_E);
        this.strtgBalAmtInFreeDfndCrcy3_E = strtgBalAmtInFreeDfndCrcy3_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy3</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy3
     *            Debit Balance in Freely Defined Currency 3
     */
    public void setDebitAmountInFreeDfndCrcy3( @Nullable final BigDecimal debitAmountInFreeDfndCrcy3 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy3", this.debitAmountInFreeDfndCrcy3);
        this.debitAmountInFreeDfndCrcy3 = debitAmountInFreeDfndCrcy3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy3_F
     *            Debit Balance in Freely Defined Currency 3
     */
    public void setDebitAmountInFreeDfndCrcy3_F( @Nullable final String debitAmountInFreeDfndCrcy3_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy3_F", this.debitAmountInFreeDfndCrcy3_F);
        this.debitAmountInFreeDfndCrcy3_F = debitAmountInFreeDfndCrcy3_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy3_E
     *            Debit Balance in Freely Defined Currency 3
     */
    public void setDebitAmountInFreeDfndCrcy3_E( @Nullable final String debitAmountInFreeDfndCrcy3_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy3_E", this.debitAmountInFreeDfndCrcy3_E);
        this.debitAmountInFreeDfndCrcy3_E = debitAmountInFreeDfndCrcy3_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy3</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy3
     *            Credit Balance in Freely Defined Currency 3
     */
    public void setCreditAmountInFreeDfndCrcy3( @Nullable final BigDecimal creditAmountInFreeDfndCrcy3 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy3", this.creditAmountInFreeDfndCrcy3);
        this.creditAmountInFreeDfndCrcy3 = creditAmountInFreeDfndCrcy3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy3_F
     *            Credit Balance in Freely Defined Currency 3
     */
    public void setCreditAmountInFreeDfndCrcy3_F( @Nullable final String creditAmountInFreeDfndCrcy3_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy3_F", this.creditAmountInFreeDfndCrcy3_F);
        this.creditAmountInFreeDfndCrcy3_F = creditAmountInFreeDfndCrcy3_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy3_E
     *            Credit Balance in Freely Defined Currency 3
     */
    public void setCreditAmountInFreeDfndCrcy3_E( @Nullable final String creditAmountInFreeDfndCrcy3_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy3_E", this.creditAmountInFreeDfndCrcy3_E);
        this.creditAmountInFreeDfndCrcy3_E = creditAmountInFreeDfndCrcy3_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy3</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy3
     *            Ending Balance in Freely Defined Currency 3
     */
    public void setEndingBalAmtInFreeDfndCrcy3( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy3 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy3", this.endingBalAmtInFreeDfndCrcy3);
        this.endingBalAmtInFreeDfndCrcy3 = endingBalAmtInFreeDfndCrcy3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy3_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy3_F
     *            Ending Balance in Freely Defined Currency 3
     */
    public void setEndingBalAmtInFreeDfndCrcy3_F( @Nullable final String endingBalAmtInFreeDfndCrcy3_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy3_F", this.endingBalAmtInFreeDfndCrcy3_F);
        this.endingBalAmtInFreeDfndCrcy3_F = endingBalAmtInFreeDfndCrcy3_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy3_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy3_E
     *            Ending Balance in Freely Defined Currency 3
     */
    public void setEndingBalAmtInFreeDfndCrcy3_E( @Nullable final String endingBalAmtInFreeDfndCrcy3_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy3_E", this.endingBalAmtInFreeDfndCrcy3_E);
        this.endingBalAmtInFreeDfndCrcy3_E = endingBalAmtInFreeDfndCrcy3_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy4</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy4
     *            Starting Balance Amount In Freely Defined Currency 4
     */
    public void setStrtgBalAmtInFreeDfndCrcy4( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy4 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy4", this.strtgBalAmtInFreeDfndCrcy4);
        this.strtgBalAmtInFreeDfndCrcy4 = strtgBalAmtInFreeDfndCrcy4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy4_F
     *            Starting Balance Amount In Freely Defined Currency 4
     */
    public void setStrtgBalAmtInFreeDfndCrcy4_F( @Nullable final String strtgBalAmtInFreeDfndCrcy4_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy4_F", this.strtgBalAmtInFreeDfndCrcy4_F);
        this.strtgBalAmtInFreeDfndCrcy4_F = strtgBalAmtInFreeDfndCrcy4_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy4_E
     *            Starting Balance Amount In Freely Defined Currency 4
     */
    public void setStrtgBalAmtInFreeDfndCrcy4_E( @Nullable final String strtgBalAmtInFreeDfndCrcy4_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy4_E", this.strtgBalAmtInFreeDfndCrcy4_E);
        this.strtgBalAmtInFreeDfndCrcy4_E = strtgBalAmtInFreeDfndCrcy4_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy4</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy4
     *            Debit Balance in Freely Defined Currency 4
     */
    public void setDebitAmountInFreeDfndCrcy4( @Nullable final BigDecimal debitAmountInFreeDfndCrcy4 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy4", this.debitAmountInFreeDfndCrcy4);
        this.debitAmountInFreeDfndCrcy4 = debitAmountInFreeDfndCrcy4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy4_F
     *            Debit Balance in Freely Defined Currency 4
     */
    public void setDebitAmountInFreeDfndCrcy4_F( @Nullable final String debitAmountInFreeDfndCrcy4_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy4_F", this.debitAmountInFreeDfndCrcy4_F);
        this.debitAmountInFreeDfndCrcy4_F = debitAmountInFreeDfndCrcy4_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy4_E
     *            Debit Balance in Freely Defined Currency 4
     */
    public void setDebitAmountInFreeDfndCrcy4_E( @Nullable final String debitAmountInFreeDfndCrcy4_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy4_E", this.debitAmountInFreeDfndCrcy4_E);
        this.debitAmountInFreeDfndCrcy4_E = debitAmountInFreeDfndCrcy4_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy4</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy4
     *            Credit Balance in Freely Defined Currency 4
     */
    public void setCreditAmountInFreeDfndCrcy4( @Nullable final BigDecimal creditAmountInFreeDfndCrcy4 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy4", this.creditAmountInFreeDfndCrcy4);
        this.creditAmountInFreeDfndCrcy4 = creditAmountInFreeDfndCrcy4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy4_F
     *            Credit Balance in Freely Defined Currency 4
     */
    public void setCreditAmountInFreeDfndCrcy4_F( @Nullable final String creditAmountInFreeDfndCrcy4_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy4_F", this.creditAmountInFreeDfndCrcy4_F);
        this.creditAmountInFreeDfndCrcy4_F = creditAmountInFreeDfndCrcy4_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy4_E
     *            Credit Balance in Freely Defined Currency 4
     */
    public void setCreditAmountInFreeDfndCrcy4_E( @Nullable final String creditAmountInFreeDfndCrcy4_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy4_E", this.creditAmountInFreeDfndCrcy4_E);
        this.creditAmountInFreeDfndCrcy4_E = creditAmountInFreeDfndCrcy4_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy4</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy4
     *            Ending Balance in Freely Defined Currency 4
     */
    public void setEndingBalAmtInFreeDfndCrcy4( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy4 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy4", this.endingBalAmtInFreeDfndCrcy4);
        this.endingBalAmtInFreeDfndCrcy4 = endingBalAmtInFreeDfndCrcy4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy4_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy4_F
     *            Ending Balance in Freely Defined Currency 4
     */
    public void setEndingBalAmtInFreeDfndCrcy4_F( @Nullable final String endingBalAmtInFreeDfndCrcy4_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy4_F", this.endingBalAmtInFreeDfndCrcy4_F);
        this.endingBalAmtInFreeDfndCrcy4_F = endingBalAmtInFreeDfndCrcy4_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy4_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy4_E
     *            Ending Balance in Freely Defined Currency 4
     */
    public void setEndingBalAmtInFreeDfndCrcy4_E( @Nullable final String endingBalAmtInFreeDfndCrcy4_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy4_E", this.endingBalAmtInFreeDfndCrcy4_E);
        this.endingBalAmtInFreeDfndCrcy4_E = endingBalAmtInFreeDfndCrcy4_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy5</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy5
     *            Starting Balance Amount In Freely Defined Currency 5
     */
    public void setStrtgBalAmtInFreeDfndCrcy5( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy5 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy5", this.strtgBalAmtInFreeDfndCrcy5);
        this.strtgBalAmtInFreeDfndCrcy5 = strtgBalAmtInFreeDfndCrcy5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy5_F
     *            Starting Balance Amount In Freely Defined Currency 5
     */
    public void setStrtgBalAmtInFreeDfndCrcy5_F( @Nullable final String strtgBalAmtInFreeDfndCrcy5_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy5_F", this.strtgBalAmtInFreeDfndCrcy5_F);
        this.strtgBalAmtInFreeDfndCrcy5_F = strtgBalAmtInFreeDfndCrcy5_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy5_E
     *            Starting Balance Amount In Freely Defined Currency 5
     */
    public void setStrtgBalAmtInFreeDfndCrcy5_E( @Nullable final String strtgBalAmtInFreeDfndCrcy5_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy5_E", this.strtgBalAmtInFreeDfndCrcy5_E);
        this.strtgBalAmtInFreeDfndCrcy5_E = strtgBalAmtInFreeDfndCrcy5_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy5</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy5
     *            Debit Balance in Freely Defined Currency 5
     */
    public void setDebitAmountInFreeDfndCrcy5( @Nullable final BigDecimal debitAmountInFreeDfndCrcy5 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy5", this.debitAmountInFreeDfndCrcy5);
        this.debitAmountInFreeDfndCrcy5 = debitAmountInFreeDfndCrcy5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy5_F
     *            Debit Balance in Freely Defined Currency 5
     */
    public void setDebitAmountInFreeDfndCrcy5_F( @Nullable final String debitAmountInFreeDfndCrcy5_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy5_F", this.debitAmountInFreeDfndCrcy5_F);
        this.debitAmountInFreeDfndCrcy5_F = debitAmountInFreeDfndCrcy5_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy5_E
     *            Debit Balance in Freely Defined Currency 5
     */
    public void setDebitAmountInFreeDfndCrcy5_E( @Nullable final String debitAmountInFreeDfndCrcy5_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy5_E", this.debitAmountInFreeDfndCrcy5_E);
        this.debitAmountInFreeDfndCrcy5_E = debitAmountInFreeDfndCrcy5_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy5</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy5
     *            Credit Balance in Freely Defined Currency 5
     */
    public void setCreditAmountInFreeDfndCrcy5( @Nullable final BigDecimal creditAmountInFreeDfndCrcy5 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy5", this.creditAmountInFreeDfndCrcy5);
        this.creditAmountInFreeDfndCrcy5 = creditAmountInFreeDfndCrcy5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy5_F
     *            Credit Balance in Freely Defined Currency 5
     */
    public void setCreditAmountInFreeDfndCrcy5_F( @Nullable final String creditAmountInFreeDfndCrcy5_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy5_F", this.creditAmountInFreeDfndCrcy5_F);
        this.creditAmountInFreeDfndCrcy5_F = creditAmountInFreeDfndCrcy5_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy5_E
     *            Credit Balance in Freely Defined Currency 5
     */
    public void setCreditAmountInFreeDfndCrcy5_E( @Nullable final String creditAmountInFreeDfndCrcy5_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy5_E", this.creditAmountInFreeDfndCrcy5_E);
        this.creditAmountInFreeDfndCrcy5_E = creditAmountInFreeDfndCrcy5_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy5</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy5
     *            Ending Balance in Freely Defined Currency 5
     */
    public void setEndingBalAmtInFreeDfndCrcy5( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy5 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy5", this.endingBalAmtInFreeDfndCrcy5);
        this.endingBalAmtInFreeDfndCrcy5 = endingBalAmtInFreeDfndCrcy5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy5_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy5_F
     *            Ending Balance in Freely Defined Currency 5
     */
    public void setEndingBalAmtInFreeDfndCrcy5_F( @Nullable final String endingBalAmtInFreeDfndCrcy5_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy5_F", this.endingBalAmtInFreeDfndCrcy5_F);
        this.endingBalAmtInFreeDfndCrcy5_F = endingBalAmtInFreeDfndCrcy5_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy5_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy5_E
     *            Ending Balance in Freely Defined Currency 5
     */
    public void setEndingBalAmtInFreeDfndCrcy5_E( @Nullable final String endingBalAmtInFreeDfndCrcy5_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy5_E", this.endingBalAmtInFreeDfndCrcy5_E);
        this.endingBalAmtInFreeDfndCrcy5_E = endingBalAmtInFreeDfndCrcy5_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy6</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy6
     *            Starting Balance Amount In Freely Defined Currency 6
     */
    public void setStrtgBalAmtInFreeDfndCrcy6( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy6 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy6", this.strtgBalAmtInFreeDfndCrcy6);
        this.strtgBalAmtInFreeDfndCrcy6 = strtgBalAmtInFreeDfndCrcy6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy6_F
     *            Starting Balance Amount In Freely Defined Currency 6
     */
    public void setStrtgBalAmtInFreeDfndCrcy6_F( @Nullable final String strtgBalAmtInFreeDfndCrcy6_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy6_F", this.strtgBalAmtInFreeDfndCrcy6_F);
        this.strtgBalAmtInFreeDfndCrcy6_F = strtgBalAmtInFreeDfndCrcy6_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy6_E
     *            Starting Balance Amount In Freely Defined Currency 6
     */
    public void setStrtgBalAmtInFreeDfndCrcy6_E( @Nullable final String strtgBalAmtInFreeDfndCrcy6_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy6_E", this.strtgBalAmtInFreeDfndCrcy6_E);
        this.strtgBalAmtInFreeDfndCrcy6_E = strtgBalAmtInFreeDfndCrcy6_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy6</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy6
     *            Debit Balance in Freely Defined Currency 6
     */
    public void setDebitAmountInFreeDfndCrcy6( @Nullable final BigDecimal debitAmountInFreeDfndCrcy6 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy6", this.debitAmountInFreeDfndCrcy6);
        this.debitAmountInFreeDfndCrcy6 = debitAmountInFreeDfndCrcy6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy6_F
     *            Debit Balance in Freely Defined Currency 6
     */
    public void setDebitAmountInFreeDfndCrcy6_F( @Nullable final String debitAmountInFreeDfndCrcy6_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy6_F", this.debitAmountInFreeDfndCrcy6_F);
        this.debitAmountInFreeDfndCrcy6_F = debitAmountInFreeDfndCrcy6_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy6_E
     *            Debit Balance in Freely Defined Currency 6
     */
    public void setDebitAmountInFreeDfndCrcy6_E( @Nullable final String debitAmountInFreeDfndCrcy6_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy6_E", this.debitAmountInFreeDfndCrcy6_E);
        this.debitAmountInFreeDfndCrcy6_E = debitAmountInFreeDfndCrcy6_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy6</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy6
     *            Credit Balance in Freely Defined Currency 6
     */
    public void setCreditAmountInFreeDfndCrcy6( @Nullable final BigDecimal creditAmountInFreeDfndCrcy6 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy6", this.creditAmountInFreeDfndCrcy6);
        this.creditAmountInFreeDfndCrcy6 = creditAmountInFreeDfndCrcy6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy6_F
     *            Credit Balance in Freely Defined Currency 6
     */
    public void setCreditAmountInFreeDfndCrcy6_F( @Nullable final String creditAmountInFreeDfndCrcy6_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy6_F", this.creditAmountInFreeDfndCrcy6_F);
        this.creditAmountInFreeDfndCrcy6_F = creditAmountInFreeDfndCrcy6_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy6_E
     *            Credit Balance in Freely Defined Currency 6
     */
    public void setCreditAmountInFreeDfndCrcy6_E( @Nullable final String creditAmountInFreeDfndCrcy6_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy6_E", this.creditAmountInFreeDfndCrcy6_E);
        this.creditAmountInFreeDfndCrcy6_E = creditAmountInFreeDfndCrcy6_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy6</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy6
     *            Ending Balance in Freely Defined Currency 6
     */
    public void setEndingBalAmtInFreeDfndCrcy6( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy6 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy6", this.endingBalAmtInFreeDfndCrcy6);
        this.endingBalAmtInFreeDfndCrcy6 = endingBalAmtInFreeDfndCrcy6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy6_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy6_F
     *            Ending Balance in Freely Defined Currency 6
     */
    public void setEndingBalAmtInFreeDfndCrcy6_F( @Nullable final String endingBalAmtInFreeDfndCrcy6_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy6_F", this.endingBalAmtInFreeDfndCrcy6_F);
        this.endingBalAmtInFreeDfndCrcy6_F = endingBalAmtInFreeDfndCrcy6_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy6_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy6_E
     *            Ending Balance in Freely Defined Currency 6
     */
    public void setEndingBalAmtInFreeDfndCrcy6_E( @Nullable final String endingBalAmtInFreeDfndCrcy6_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy6_E", this.endingBalAmtInFreeDfndCrcy6_E);
        this.endingBalAmtInFreeDfndCrcy6_E = endingBalAmtInFreeDfndCrcy6_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy7</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy7
     *            Starting Balance Amount In Freely Defined Currency 7
     */
    public void setStrtgBalAmtInFreeDfndCrcy7( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy7 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy7", this.strtgBalAmtInFreeDfndCrcy7);
        this.strtgBalAmtInFreeDfndCrcy7 = strtgBalAmtInFreeDfndCrcy7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy7_F
     *            Starting Balance Amount In Freely Defined Currency 7
     */
    public void setStrtgBalAmtInFreeDfndCrcy7_F( @Nullable final String strtgBalAmtInFreeDfndCrcy7_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy7_F", this.strtgBalAmtInFreeDfndCrcy7_F);
        this.strtgBalAmtInFreeDfndCrcy7_F = strtgBalAmtInFreeDfndCrcy7_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy7_E
     *            Starting Balance Amount In Freely Defined Currency 7
     */
    public void setStrtgBalAmtInFreeDfndCrcy7_E( @Nullable final String strtgBalAmtInFreeDfndCrcy7_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy7_E", this.strtgBalAmtInFreeDfndCrcy7_E);
        this.strtgBalAmtInFreeDfndCrcy7_E = strtgBalAmtInFreeDfndCrcy7_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy7</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy7
     *            Debit Balance in Freely Defined Currency 7
     */
    public void setDebitAmountInFreeDfndCrcy7( @Nullable final BigDecimal debitAmountInFreeDfndCrcy7 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy7", this.debitAmountInFreeDfndCrcy7);
        this.debitAmountInFreeDfndCrcy7 = debitAmountInFreeDfndCrcy7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy7_F
     *            Debit Balance in Freely Defined Currency 7
     */
    public void setDebitAmountInFreeDfndCrcy7_F( @Nullable final String debitAmountInFreeDfndCrcy7_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy7_F", this.debitAmountInFreeDfndCrcy7_F);
        this.debitAmountInFreeDfndCrcy7_F = debitAmountInFreeDfndCrcy7_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy7_E
     *            Debit Balance in Freely Defined Currency 7
     */
    public void setDebitAmountInFreeDfndCrcy7_E( @Nullable final String debitAmountInFreeDfndCrcy7_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy7_E", this.debitAmountInFreeDfndCrcy7_E);
        this.debitAmountInFreeDfndCrcy7_E = debitAmountInFreeDfndCrcy7_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy7</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy7
     *            Credit Balance in Freely Defined Currency 7
     */
    public void setCreditAmountInFreeDfndCrcy7( @Nullable final BigDecimal creditAmountInFreeDfndCrcy7 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy7", this.creditAmountInFreeDfndCrcy7);
        this.creditAmountInFreeDfndCrcy7 = creditAmountInFreeDfndCrcy7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy7_F
     *            Credit Balance in Freely Defined Currency 7
     */
    public void setCreditAmountInFreeDfndCrcy7_F( @Nullable final String creditAmountInFreeDfndCrcy7_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy7_F", this.creditAmountInFreeDfndCrcy7_F);
        this.creditAmountInFreeDfndCrcy7_F = creditAmountInFreeDfndCrcy7_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy7_E
     *            Credit Balance in Freely Defined Currency 7
     */
    public void setCreditAmountInFreeDfndCrcy7_E( @Nullable final String creditAmountInFreeDfndCrcy7_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy7_E", this.creditAmountInFreeDfndCrcy7_E);
        this.creditAmountInFreeDfndCrcy7_E = creditAmountInFreeDfndCrcy7_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy7</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy7
     *            Ending Balance in Freely Defined Currency 7
     */
    public void setEndingBalAmtInFreeDfndCrcy7( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy7 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy7", this.endingBalAmtInFreeDfndCrcy7);
        this.endingBalAmtInFreeDfndCrcy7 = endingBalAmtInFreeDfndCrcy7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy7_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy7_F
     *            Ending Balance in Freely Defined Currency 7
     */
    public void setEndingBalAmtInFreeDfndCrcy7_F( @Nullable final String endingBalAmtInFreeDfndCrcy7_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy7_F", this.endingBalAmtInFreeDfndCrcy7_F);
        this.endingBalAmtInFreeDfndCrcy7_F = endingBalAmtInFreeDfndCrcy7_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy7_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy7_E
     *            Ending Balance in Freely Defined Currency 7
     */
    public void setEndingBalAmtInFreeDfndCrcy7_E( @Nullable final String endingBalAmtInFreeDfndCrcy7_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy7_E", this.endingBalAmtInFreeDfndCrcy7_E);
        this.endingBalAmtInFreeDfndCrcy7_E = endingBalAmtInFreeDfndCrcy7_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy8</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy8
     *            Starting Balance Amount In Freely Defined Currency 8
     */
    public void setStrtgBalAmtInFreeDfndCrcy8( @Nullable final BigDecimal strtgBalAmtInFreeDfndCrcy8 )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy8", this.strtgBalAmtInFreeDfndCrcy8);
        this.strtgBalAmtInFreeDfndCrcy8 = strtgBalAmtInFreeDfndCrcy8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy8_F
     *            Starting Balance Amount In Freely Defined Currency 8
     */
    public void setStrtgBalAmtInFreeDfndCrcy8_F( @Nullable final String strtgBalAmtInFreeDfndCrcy8_F )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy8_F", this.strtgBalAmtInFreeDfndCrcy8_F);
        this.strtgBalAmtInFreeDfndCrcy8_F = strtgBalAmtInFreeDfndCrcy8_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StrtgBalAmtInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @param strtgBalAmtInFreeDfndCrcy8_E
     *            Starting Balance Amount In Freely Defined Currency 8
     */
    public void setStrtgBalAmtInFreeDfndCrcy8_E( @Nullable final String strtgBalAmtInFreeDfndCrcy8_E )
    {
        rememberChangedField("StrtgBalAmtInFreeDfndCrcy8_E", this.strtgBalAmtInFreeDfndCrcy8_E);
        this.strtgBalAmtInFreeDfndCrcy8_E = strtgBalAmtInFreeDfndCrcy8_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy8</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy8
     *            Debit Balance in Freely Defined Currency 8
     */
    public void setDebitAmountInFreeDfndCrcy8( @Nullable final BigDecimal debitAmountInFreeDfndCrcy8 )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy8", this.debitAmountInFreeDfndCrcy8);
        this.debitAmountInFreeDfndCrcy8 = debitAmountInFreeDfndCrcy8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy8_F
     *            Debit Balance in Freely Defined Currency 8
     */
    public void setDebitAmountInFreeDfndCrcy8_F( @Nullable final String debitAmountInFreeDfndCrcy8_F )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy8_F", this.debitAmountInFreeDfndCrcy8_F);
        this.debitAmountInFreeDfndCrcy8_F = debitAmountInFreeDfndCrcy8_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @param debitAmountInFreeDfndCrcy8_E
     *            Debit Balance in Freely Defined Currency 8
     */
    public void setDebitAmountInFreeDfndCrcy8_E( @Nullable final String debitAmountInFreeDfndCrcy8_E )
    {
        rememberChangedField("DebitAmountInFreeDfndCrcy8_E", this.debitAmountInFreeDfndCrcy8_E);
        this.debitAmountInFreeDfndCrcy8_E = debitAmountInFreeDfndCrcy8_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy8</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy8
     *            Credit Balance in Freely Defined Currency 8
     */
    public void setCreditAmountInFreeDfndCrcy8( @Nullable final BigDecimal creditAmountInFreeDfndCrcy8 )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy8", this.creditAmountInFreeDfndCrcy8);
        this.creditAmountInFreeDfndCrcy8 = creditAmountInFreeDfndCrcy8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy8_F
     *            Credit Balance in Freely Defined Currency 8
     */
    public void setCreditAmountInFreeDfndCrcy8_F( @Nullable final String creditAmountInFreeDfndCrcy8_F )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy8_F", this.creditAmountInFreeDfndCrcy8_F);
        this.creditAmountInFreeDfndCrcy8_F = creditAmountInFreeDfndCrcy8_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @param creditAmountInFreeDfndCrcy8_E
     *            Credit Balance in Freely Defined Currency 8
     */
    public void setCreditAmountInFreeDfndCrcy8_E( @Nullable final String creditAmountInFreeDfndCrcy8_E )
    {
        rememberChangedField("CreditAmountInFreeDfndCrcy8_E", this.creditAmountInFreeDfndCrcy8_E);
        this.creditAmountInFreeDfndCrcy8_E = creditAmountInFreeDfndCrcy8_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy8</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy8
     *            Ending Balance in Freely Defined Currency 8
     */
    public void setEndingBalAmtInFreeDfndCrcy8( @Nullable final BigDecimal endingBalAmtInFreeDfndCrcy8 )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy8", this.endingBalAmtInFreeDfndCrcy8);
        this.endingBalAmtInFreeDfndCrcy8 = endingBalAmtInFreeDfndCrcy8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy8_F</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy8_F
     *            Ending Balance in Freely Defined Currency 8
     */
    public void setEndingBalAmtInFreeDfndCrcy8_F( @Nullable final String endingBalAmtInFreeDfndCrcy8_F )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy8_F", this.endingBalAmtInFreeDfndCrcy8_F);
        this.endingBalAmtInFreeDfndCrcy8_F = endingBalAmtInFreeDfndCrcy8_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalAmtInFreeDfndCrcy8_E</b>
     * </p>
     *
     * @param endingBalAmtInFreeDfndCrcy8_E
     *            Ending Balance in Freely Defined Currency 8
     */
    public void setEndingBalAmtInFreeDfndCrcy8_E( @Nullable final String endingBalAmtInFreeDfndCrcy8_E )
    {
        rememberChangedField("EndingBalAmtInFreeDfndCrcy8_E", this.endingBalAmtInFreeDfndCrcy8_E);
        this.endingBalAmtInFreeDfndCrcy8_E = endingBalAmtInFreeDfndCrcy8_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalAmtInBalTransCrcy</b>
     * </p>
     *
     * @param startingBalAmtInBalTransCrcy
     *            Starting Balance Amount In Balance Transaction Currency
     */
    public void setStartingBalAmtInBalTransCrcy( @Nullable final BigDecimal startingBalAmtInBalTransCrcy )
    {
        rememberChangedField("StartingBalAmtInBalTransCrcy", this.startingBalAmtInBalTransCrcy);
        this.startingBalAmtInBalTransCrcy = startingBalAmtInBalTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalAmtInBalTransCrcy_F</b>
     * </p>
     *
     * @param startingBalAmtInBalTransCrcy_F
     *            Starting Balance Amount In Balance Transaction Currency
     */
    public void setStartingBalAmtInBalTransCrcy_F( @Nullable final String startingBalAmtInBalTransCrcy_F )
    {
        rememberChangedField("StartingBalAmtInBalTransCrcy_F", this.startingBalAmtInBalTransCrcy_F);
        this.startingBalAmtInBalTransCrcy_F = startingBalAmtInBalTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalAmtInBalTransCrcy_E</b>
     * </p>
     *
     * @param startingBalAmtInBalTransCrcy_E
     *            Starting Balance Amount In Balance Transaction Currency
     */
    public void setStartingBalAmtInBalTransCrcy_E( @Nullable final String startingBalAmtInBalTransCrcy_E )
    {
        rememberChangedField("StartingBalAmtInBalTransCrcy_E", this.startingBalAmtInBalTransCrcy_E);
        this.startingBalAmtInBalTransCrcy_E = startingBalAmtInBalTransCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInBalanceTransCrcy</b>
     * </p>
     *
     * @param debitAmountInBalanceTransCrcy
     *            Debit Balance in Balance Transaction Currency
     */
    public void setDebitAmountInBalanceTransCrcy( @Nullable final BigDecimal debitAmountInBalanceTransCrcy )
    {
        rememberChangedField("DebitAmountInBalanceTransCrcy", this.debitAmountInBalanceTransCrcy);
        this.debitAmountInBalanceTransCrcy = debitAmountInBalanceTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInBalanceTransCrcy_F</b>
     * </p>
     *
     * @param debitAmountInBalanceTransCrcy_F
     *            Debit Balance in Balance Transaction Currency
     */
    public void setDebitAmountInBalanceTransCrcy_F( @Nullable final String debitAmountInBalanceTransCrcy_F )
    {
        rememberChangedField("DebitAmountInBalanceTransCrcy_F", this.debitAmountInBalanceTransCrcy_F);
        this.debitAmountInBalanceTransCrcy_F = debitAmountInBalanceTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInBalanceTransCrcy_E</b>
     * </p>
     *
     * @param debitAmountInBalanceTransCrcy_E
     *            Debit Balance in Balance Transaction Currency
     */
    public void setDebitAmountInBalanceTransCrcy_E( @Nullable final String debitAmountInBalanceTransCrcy_E )
    {
        rememberChangedField("DebitAmountInBalanceTransCrcy_E", this.debitAmountInBalanceTransCrcy_E);
        this.debitAmountInBalanceTransCrcy_E = debitAmountInBalanceTransCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInBalanceTransCrcy</b>
     * </p>
     *
     * @param creditAmountInBalanceTransCrcy
     *            Credit Balance in Balance Transaction Currency
     */
    public void setCreditAmountInBalanceTransCrcy( @Nullable final BigDecimal creditAmountInBalanceTransCrcy )
    {
        rememberChangedField("CreditAmountInBalanceTransCrcy", this.creditAmountInBalanceTransCrcy);
        this.creditAmountInBalanceTransCrcy = creditAmountInBalanceTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInBalanceTransCrcy_F</b>
     * </p>
     *
     * @param creditAmountInBalanceTransCrcy_F
     *            Credit Balance in Balance Transaction Currency
     */
    public void setCreditAmountInBalanceTransCrcy_F( @Nullable final String creditAmountInBalanceTransCrcy_F )
    {
        rememberChangedField("CreditAmountInBalanceTransCrcy_F", this.creditAmountInBalanceTransCrcy_F);
        this.creditAmountInBalanceTransCrcy_F = creditAmountInBalanceTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInBalanceTransCrcy_E</b>
     * </p>
     *
     * @param creditAmountInBalanceTransCrcy_E
     *            Credit Balance in Balance Transaction Currency
     */
    public void setCreditAmountInBalanceTransCrcy_E( @Nullable final String creditAmountInBalanceTransCrcy_E )
    {
        rememberChangedField("CreditAmountInBalanceTransCrcy_E", this.creditAmountInBalanceTransCrcy_E);
        this.creditAmountInBalanceTransCrcy_E = creditAmountInBalanceTransCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInBalTransCrcy</b>
     * </p>
     *
     * @param endingBalanceAmtInBalTransCrcy
     *            Ending Balance in Balance Transaction Currency
     */
    public void setEndingBalanceAmtInBalTransCrcy( @Nullable final BigDecimal endingBalanceAmtInBalTransCrcy )
    {
        rememberChangedField("EndingBalanceAmtInBalTransCrcy", this.endingBalanceAmtInBalTransCrcy);
        this.endingBalanceAmtInBalTransCrcy = endingBalanceAmtInBalTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInBalTransCrcy_F</b>
     * </p>
     *
     * @param endingBalanceAmtInBalTransCrcy_F
     *            Ending Balance in Balance Transaction Currency
     */
    public void setEndingBalanceAmtInBalTransCrcy_F( @Nullable final String endingBalanceAmtInBalTransCrcy_F )
    {
        rememberChangedField("EndingBalanceAmtInBalTransCrcy_F", this.endingBalanceAmtInBalTransCrcy_F);
        this.endingBalanceAmtInBalTransCrcy_F = endingBalanceAmtInBalTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInBalTransCrcy_E</b>
     * </p>
     *
     * @param endingBalanceAmtInBalTransCrcy_E
     *            Ending Balance in Balance Transaction Currency
     */
    public void setEndingBalanceAmtInBalTransCrcy_E( @Nullable final String endingBalanceAmtInBalTransCrcy_E )
    {
        rememberChangedField("EndingBalanceAmtInBalTransCrcy_E", this.endingBalanceAmtInBalTransCrcy_E);
        this.endingBalanceAmtInBalTransCrcy_E = endingBalanceAmtInBalTransCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInTransCrcy</b>
     * </p>
     *
     * @param startingBalanceAmtInTransCrcy
     *            Starting Balance Amount In Transaction Currency
     */
    public void setStartingBalanceAmtInTransCrcy( @Nullable final BigDecimal startingBalanceAmtInTransCrcy )
    {
        rememberChangedField("StartingBalanceAmtInTransCrcy", this.startingBalanceAmtInTransCrcy);
        this.startingBalanceAmtInTransCrcy = startingBalanceAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInTransCrcy_F</b>
     * </p>
     *
     * @param startingBalanceAmtInTransCrcy_F
     *            Starting Balance Amount In Transaction Currency
     */
    public void setStartingBalanceAmtInTransCrcy_F( @Nullable final String startingBalanceAmtInTransCrcy_F )
    {
        rememberChangedField("StartingBalanceAmtInTransCrcy_F", this.startingBalanceAmtInTransCrcy_F);
        this.startingBalanceAmtInTransCrcy_F = startingBalanceAmtInTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StartingBalanceAmtInTransCrcy_E</b>
     * </p>
     *
     * @param startingBalanceAmtInTransCrcy_E
     *            Starting Balance Amount In Transaction Currency
     */
    public void setStartingBalanceAmtInTransCrcy_E( @Nullable final String startingBalanceAmtInTransCrcy_E )
    {
        rememberChangedField("StartingBalanceAmtInTransCrcy_E", this.startingBalanceAmtInTransCrcy_E);
        this.startingBalanceAmtInTransCrcy_E = startingBalanceAmtInTransCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy</b>
     * </p>
     *
     * @param debitAmountInTransCrcy
     *            Debit Balance in Transaction Currency
     */
    public void setDebitAmountInTransCrcy( @Nullable final BigDecimal debitAmountInTransCrcy )
    {
        rememberChangedField("DebitAmountInTransCrcy", this.debitAmountInTransCrcy);
        this.debitAmountInTransCrcy = debitAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy_F</b>
     * </p>
     *
     * @param debitAmountInTransCrcy_F
     *            Debit Balance in Transaction Currency
     */
    public void setDebitAmountInTransCrcy_F( @Nullable final String debitAmountInTransCrcy_F )
    {
        rememberChangedField("DebitAmountInTransCrcy_F", this.debitAmountInTransCrcy_F);
        this.debitAmountInTransCrcy_F = debitAmountInTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DebitAmountInTransCrcy_E</b>
     * </p>
     *
     * @param debitAmountInTransCrcy_E
     *            Debit Balance in Transaction Currency
     */
    public void setDebitAmountInTransCrcy_E( @Nullable final String debitAmountInTransCrcy_E )
    {
        rememberChangedField("DebitAmountInTransCrcy_E", this.debitAmountInTransCrcy_E);
        this.debitAmountInTransCrcy_E = debitAmountInTransCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy</b>
     * </p>
     *
     * @param creditAmountInTransCrcy
     *            Credit Balance in Transaction Currency
     */
    public void setCreditAmountInTransCrcy( @Nullable final BigDecimal creditAmountInTransCrcy )
    {
        rememberChangedField("CreditAmountInTransCrcy", this.creditAmountInTransCrcy);
        this.creditAmountInTransCrcy = creditAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy_F</b>
     * </p>
     *
     * @param creditAmountInTransCrcy_F
     *            Credit Balance in Transaction Currency
     */
    public void setCreditAmountInTransCrcy_F( @Nullable final String creditAmountInTransCrcy_F )
    {
        rememberChangedField("CreditAmountInTransCrcy_F", this.creditAmountInTransCrcy_F);
        this.creditAmountInTransCrcy_F = creditAmountInTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditAmountInTransCrcy_E</b>
     * </p>
     *
     * @param creditAmountInTransCrcy_E
     *            Credit Balance in Transaction Currency
     */
    public void setCreditAmountInTransCrcy_E( @Nullable final String creditAmountInTransCrcy_E )
    {
        rememberChangedField("CreditAmountInTransCrcy_E", this.creditAmountInTransCrcy_E);
        this.creditAmountInTransCrcy_E = creditAmountInTransCrcy_E;
    }

    /**
     * Constraints: Not nullable, Precision: 42, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInTransCrcy</b>
     * </p>
     *
     * @param endingBalanceAmtInTransCrcy
     *            Ending Balance in Transaction Currency
     */
    public void setEndingBalanceAmtInTransCrcy( @Nullable final BigDecimal endingBalanceAmtInTransCrcy )
    {
        rememberChangedField("EndingBalanceAmtInTransCrcy", this.endingBalanceAmtInTransCrcy);
        this.endingBalanceAmtInTransCrcy = endingBalanceAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInTransCrcy_F</b>
     * </p>
     *
     * @param endingBalanceAmtInTransCrcy_F
     *            Ending Balance in Transaction Currency
     */
    public void setEndingBalanceAmtInTransCrcy_F( @Nullable final String endingBalanceAmtInTransCrcy_F )
    {
        rememberChangedField("EndingBalanceAmtInTransCrcy_F", this.endingBalanceAmtInTransCrcy_F);
        this.endingBalanceAmtInTransCrcy_F = endingBalanceAmtInTransCrcy_F;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EndingBalanceAmtInTransCrcy_E</b>
     * </p>
     *
     * @param endingBalanceAmtInTransCrcy_E
     *            Ending Balance in Transaction Currency
     */
    public void setEndingBalanceAmtInTransCrcy_E( @Nullable final String endingBalanceAmtInTransCrcy_E )
    {
        rememberChangedField("EndingBalanceAmtInTransCrcy_E", this.endingBalanceAmtInTransCrcy_E);
        this.endingBalanceAmtInTransCrcy_E = endingBalanceAmtInTransCrcy_E;
    }

    @Override
    protected String getEntityCollection()
    {
        return "C_TRIALBALANCEResults";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ID", getID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ID", getID());
        values.put("TotaledProperties", getTotaledProperties());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("GLAccount", getGLAccount());
        values.put("GLAccountHierarchyName", getGLAccountHierarchyName());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("FreeDefinedCurrency8", getFreeDefinedCurrency8());
        values.put("PartnerCostObject", getPartnerCostObject());
        values.put("AssetValueDate", getAssetValueDate());
        values.put("AssetValueDate_T", getAssetValueDate_T());
        values.put("FiscalYearPeriod", getFiscalYearPeriod());
        values.put("QuantityIsIncomplete", getQuantityIsIncomplete());
        values.put("IsOpenItemManaged", getIsOpenItemManaged());
        values.put("CorporateGroupAccount", getCorporateGroupAccount());
        values.put("CorporateGroupAccount_T", getCorporateGroupAccount_T());
        values.put("BillingDocumentType", getBillingDocumentType());
        values.put("FiscalQuarter", getFiscalQuarter());
        values.put("CorporateGroupChartOfAccounts", getCorporateGroupChartOfAccounts());
        values.put("ClearingDocFiscalYear", getClearingDocFiscalYear());
        values.put("PartnerWBSElement", getPartnerWBSElement());
        values.put("FreeDefinedCurrency2", getFreeDefinedCurrency2());
        values.put("PartnerProfitCenter", getPartnerProfitCenter());
        values.put("PartnerProfitCenterName", getPartnerProfitCenterName());
        values.put("PartnerControllingObjectClass", getPartnerControllingObjectClass());
        values.put("GLAccountType", getGLAccountType());
        values.put("AccountingDocumentCategory", getAccountingDocumentCategory());
        values.put("BusinessTransactionType", getBusinessTransactionType());
        values.put("CalendarMonth", getCalendarMonth());
        values.put("CalendarQuarter", getCalendarQuarter());
        values.put("ClearingAccountingDocument", getClearingAccountingDocument());
        values.put("AccountingDocumentType", getAccountingDocumentType());
        values.put("AccountingDocumentTypeName", getAccountingDocumentTypeName());
        values.put("FinancialAccountType", getFinancialAccountType());
        values.put("FinancialAccountTypeName", getFinancialAccountTypeName());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessAreaName", getBusinessAreaName());
        values.put("OriginCostCtrActivityType", getOriginCostCtrActivityType());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("ControllingArea", getControllingArea());
        values.put("ControllingAreaName", getControllingAreaName());
        values.put("ControllingObjectClass", getControllingObjectClass());
        values.put("PartnerCostCenter", getPartnerCostCenter());
        values.put("SenderCostCenterName", getSenderCostCenterName());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("DebitCreditCodeName", getDebitCreditCodeName());
        values.put("PostingDate", getPostingDate());
        values.put("PostingDate_T", getPostingDate_T());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("FunctionalAreaName", getFunctionalAreaName());
        values.put("FiscalYear", getFiscalYear());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("CalendarWeek", getCalendarWeek());
        values.put("CalendarYear", getCalendarYear());
        values.put("ClearingDate", getClearingDate());
        values.put("ClearingDate_T", getClearingDate_T());
        values.put("CostCenter", getCostCenter());
        values.put("CostCenterName", getCostCenterName());
        values.put("CostObject", getCostObject());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("FiscalWeek", getFiscalWeek());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("IsReversal", getIsReversal());
        values.put("IsReversed", getIsReversed());
        values.put("IsSettled", getIsSettled());
        values.put("IsSettlement", getIsSettlement());
        values.put("JointVenture", getJointVenture());
        values.put("OrderID", getOrderID());
        values.put("PartnerFund", getPartnerFund());
        values.put("PartnerGrant", getPartnerGrant());
        values.put("PartnerOrder", getPartnerOrder());
        values.put("SalesOrder", getSalesOrder());
        values.put("SoldMaterial", getSoldMaterial());
        values.put("SoldProduct", getSoldProduct());
        values.put("TaxCode", getTaxCode());
        values.put("WBSElement", getWBSElement());
        values.put("HouseBank", getHouseBank());
        values.put("InventorySpecialStockValnType", getInventorySpecialStockValnType());
        values.put("Ledger", getLedger());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("PostingKey", getPostingKey());
        values.put("PostingKeyName", getPostingKeyName());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenterName", getProfitCenterName());
        values.put("Segment", getSegment());
        values.put("SegmentName", getSegmentName());
        values.put("SpecialGLCode", getSpecialGLCode());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("FixedAsset", getFixedAsset());
        values.put("JointVentureEquityType", getJointVentureEquityType());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("AlternativeGLAccount", getAlternativeGLAccount());
        values.put("AlternativeGLAccount_T", getAlternativeGLAccount_T());
        values.put("Material", getMaterial());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Plant", getPlant());
        values.put("PlantName", getPlantName());
        values.put("OrderCategory", getOrderCategory());
        values.put("Product", getProduct());
        values.put("MaterialName", getMaterialName());
        values.put("ProductGroup", getProductGroup());
        values.put("Project", getProject());
        values.put("ValuationArea", getValuationArea());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerGroupName", getCustomerGroupName());
        values.put("InventorySpclStkSalesDocument", getInventorySpclStkSalesDocument());
        values.put("InventorySpclStkSalesDocItm", getInventorySpclStkSalesDocItm());
        values.put("InvtrySpclStockWBSElmntIntID", getInvtrySpclStockWBSElmntIntID());
        values.put("InventorySpclStockWBSElement", getInventorySpclStockWBSElement());
        values.put("CalendarYearMonth", getCalendarYearMonth());
        values.put("Customer", getCustomer());
        values.put("CustomerName", getCustomerName());
        values.put("Supplier", getSupplier());
        values.put("SupplierName", getSupplierName());
        values.put("BalanceTransactionCurrency", getBalanceTransactionCurrency());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("PartnerProjectNetworkActivity", getPartnerProjectNetworkActivity());
        values.put("CalendarYearQuarter", getCalendarYearQuarter());
        values.put("IsBalanceSheetAccount", getIsBalanceSheetAccount());
        values.put("PartnerAccountAssignmentType", getPartnerAccountAssignmentType());
        values.put("FiscalYearWeek", getFiscalYearWeek());
        values.put("JointVentureEquityGroup", getJointVentureEquityGroup());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("SenderAccountAssignment", getSenderAccountAssignment());
        values.put("FiscalYearQuarter", getFiscalYearQuarter());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("GroupFixedAsset", getGroupFixedAsset());
        values.put("ReferenceDocumentItemGroup", getReferenceDocumentItemGroup());
        values.put("AssetDepreciationArea", getAssetDepreciationArea());
        values.put("PartnerSegment", getPartnerSegment());
        values.put("PartnerSegmentName", getPartnerSegmentName());
        values.put("ClearingJournalEntry", getClearingJournalEntry());
        values.put("OperatingConcern", getOperatingConcern());
        values.put("InvtrySpclStockWBSElmntExtID", getInvtrySpclStockWBSElmntExtID());
        values.put("FiscalPeriodEndDate", getFiscalPeriodEndDate());
        values.put("FiscalPeriodEndDate_T", getFiscalPeriodEndDate_T());
        values.put("CountryChartOfAccounts", getCountryChartOfAccounts());
        values.put("FiscalPeriodStartDate", getFiscalPeriodStartDate());
        values.put("FiscalPeriodStartDate_T", getFiscalPeriodStartDate_T());
        values.put("FreeDefinedCurrency6", getFreeDefinedCurrency6());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AccountAssignment", getAccountAssignment());
        values.put("PartnerCostCtrActivityType", getPartnerCostCtrActivityType());
        values.put("PartnerBusinessProcess", getPartnerBusinessProcess());
        values.put("RelatedNetworkActivity", getRelatedNetworkActivity());
        values.put("SalesDocument", getSalesDocument());
        values.put("FreeDefinedCurrency1", getFreeDefinedCurrency1());
        values.put("FiscalPeriodDate", getFiscalPeriodDate());
        values.put("FreeDefinedCurrency3", getFreeDefinedCurrency3());
        values.put("AssetTransactionType", getAssetTransactionType());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("InvtrySpecialStockValnType_2", getInvtrySpecialStockValnType_2());
        values.put("EliminationProfitCenter", getEliminationProfitCenter());
        values.put("EliminationProfitCenterName", getEliminationProfitCenterName());
        values.put("GlobalCurrency", getGlobalCurrency());
        values.put("PredecessorReferenceDocType", getPredecessorReferenceDocType());
        values.put("LedgerFiscalYear", getLedgerFiscalYear());
        values.put("PartnerSalesDocument", getPartnerSalesDocument());
        values.put("PartnerAccountAssignment", getPartnerAccountAssignment());
        values.put("OffsettingAccount", getOffsettingAccount());
        values.put("PartnerBudgetPeriod", getPartnerBudgetPeriod());
        values.put("AccountingDocCreatedByUser", getAccountingDocCreatedByUser());
        values.put("FreeDefinedCurrency4", getFreeDefinedCurrency4());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("LineItemIsCompleted", getLineItemIsCompleted());
        values.put("PartnerProjectInternalID", getPartnerProjectInternalID());
        values.put("PartnerProjectExternalID", getPartnerProjectExternalID());
        values.put("JointVentureCostRecoveryCode", getJointVentureCostRecoveryCode());
        values.put("InventorySpecialStockSupplier", getInventorySpecialStockSupplier());
        values.put("InvtrySpecialStockSupplierName", getInvtrySpecialStockSupplierName());
        values.put("AccountAssignmentType", getAccountAssignmentType());
        values.put("SoldProductGroup", getSoldProductGroup());
        values.put("MaterialGroupName", getMaterialGroupName());
        values.put("PartnerProject", getPartnerProject());
        values.put("ClearingJournalEntryFiscalYear", getClearingJournalEntryFiscalYear());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("GroupMasterFixedAsset", getGroupMasterFixedAsset());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("PartnerOrderCategory", getPartnerOrderCategory());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("PartnerBusinessAreaName", getPartnerBusinessAreaName());
        values.put("PartnerFunctionalArea", getPartnerFunctionalArea());
        values.put("PartnerFunctionalAreaName", getPartnerFunctionalAreaName());
        values.put("ProjectExternalID", getProjectExternalID());
        values.put("OriginCostCenter", getOriginCostCenter());
        values.put("FreeDefinedCurrency5", getFreeDefinedCurrency5());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("OriginObjectType", getOriginObjectType());
        values.put("ControllingObjectDebitType", getControllingObjectDebitType());
        values.put("PartnerWBSElementInternalID", getPartnerWBSElementInternalID());
        values.put("PartnerWBSElementExternalID", getPartnerWBSElementExternalID());
        values.put("GLAccountHierarchy", getGLAccountHierarchy());
        values.put("CustomerServiceNotification", getCustomerServiceNotification());
        values.put("FreeDefinedCurrency7", getFreeDefinedCurrency7());
        values.put("AccountAssignmentNumber", getAccountAssignmentNumber());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("TransactionTypeDetermination", getTransactionTypeDetermination());
        values.put("PartnerProjectNetwork", getPartnerProjectNetwork());
        values.put("PartnerCompanyCode", getPartnerCompanyCode());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("OffsettingAccountType", getOffsettingAccountType());
        values.put("CalendarYearWeek", getCalendarYearWeek());
        values.put("SenderAccountAssignmentType", getSenderAccountAssignmentType());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("SenderGLAccount", getSenderGLAccount());
        values.put("PartnerSalesDocumentItem", getPartnerSalesDocumentItem());
        values.put("InventoryValuationType", getInventoryValuationType());
        values.put("SettlementReferenceDate", getSettlementReferenceDate());
        values.put("SettlementReferenceDate_T", getSettlementReferenceDate_T());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("StartingBalanceAmtInCoCodeCrcy", getStartingBalanceAmtInCoCodeCrcy());
        values.put("StartingBalanceAmtInCoCodeCrcy_F", getStartingBalanceAmtInCoCodeCrcy_F());
        values.put("StartingBalanceAmtInCoCodeCrcy_E", getStartingBalanceAmtInCoCodeCrcy_E());
        values.put("DebitAmountInCoCodeCrcy", getDebitAmountInCoCodeCrcy());
        values.put("DebitAmountInCoCodeCrcy_F", getDebitAmountInCoCodeCrcy_F());
        values.put("DebitAmountInCoCodeCrcy_E", getDebitAmountInCoCodeCrcy_E());
        values.put("CreditAmountInCoCodeCrcy", getCreditAmountInCoCodeCrcy());
        values.put("CreditAmountInCoCodeCrcy_F", getCreditAmountInCoCodeCrcy_F());
        values.put("CreditAmountInCoCodeCrcy_E", getCreditAmountInCoCodeCrcy_E());
        values.put("EndingBalanceAmtInCoCodeCrcy", getEndingBalanceAmtInCoCodeCrcy());
        values.put("EndingBalanceAmtInCoCodeCrcy_F", getEndingBalanceAmtInCoCodeCrcy_F());
        values.put("EndingBalanceAmtInCoCodeCrcy_E", getEndingBalanceAmtInCoCodeCrcy_E());
        values.put("StartingBalanceAmtInGlobalCrcy", getStartingBalanceAmtInGlobalCrcy());
        values.put("StartingBalanceAmtInGlobalCrcy_F", getStartingBalanceAmtInGlobalCrcy_F());
        values.put("StartingBalanceAmtInGlobalCrcy_E", getStartingBalanceAmtInGlobalCrcy_E());
        values.put("DebitAmountInGlobalCrcy", getDebitAmountInGlobalCrcy());
        values.put("DebitAmountInGlobalCrcy_F", getDebitAmountInGlobalCrcy_F());
        values.put("DebitAmountInGlobalCrcy_E", getDebitAmountInGlobalCrcy_E());
        values.put("CreditAmountInGlobalCrcy", getCreditAmountInGlobalCrcy());
        values.put("CreditAmountInGlobalCrcy_F", getCreditAmountInGlobalCrcy_F());
        values.put("CreditAmountInGlobalCrcy_E", getCreditAmountInGlobalCrcy_E());
        values.put("EndingBalanceAmtInGlobalCrcy", getEndingBalanceAmtInGlobalCrcy());
        values.put("EndingBalanceAmtInGlobalCrcy_F", getEndingBalanceAmtInGlobalCrcy_F());
        values.put("EndingBalanceAmtInGlobalCrcy_E", getEndingBalanceAmtInGlobalCrcy_E());
        values.put("StrtgBalAmtInFreeDfndCrcy1", getStrtgBalAmtInFreeDfndCrcy1());
        values.put("StrtgBalAmtInFreeDfndCrcy1_F", getStrtgBalAmtInFreeDfndCrcy1_F());
        values.put("StrtgBalAmtInFreeDfndCrcy1_E", getStrtgBalAmtInFreeDfndCrcy1_E());
        values.put("DebitAmountInFreeDfndCrcy1", getDebitAmountInFreeDfndCrcy1());
        values.put("DebitAmountInFreeDfndCrcy1_F", getDebitAmountInFreeDfndCrcy1_F());
        values.put("DebitAmountInFreeDfndCrcy1_E", getDebitAmountInFreeDfndCrcy1_E());
        values.put("CreditAmountInFreeDfndCrcy1", getCreditAmountInFreeDfndCrcy1());
        values.put("CreditAmountInFreeDfndCrcy1_F", getCreditAmountInFreeDfndCrcy1_F());
        values.put("CreditAmountInFreeDfndCrcy1_E", getCreditAmountInFreeDfndCrcy1_E());
        values.put("EndingBalAmtInFreeDfndCrcy1", getEndingBalAmtInFreeDfndCrcy1());
        values.put("EndingBalAmtInFreeDfndCrcy1_F", getEndingBalAmtInFreeDfndCrcy1_F());
        values.put("EndingBalAmtInFreeDfndCrcy1_E", getEndingBalAmtInFreeDfndCrcy1_E());
        values.put("StrtgBalAmtInFreeDfndCrcy2", getStrtgBalAmtInFreeDfndCrcy2());
        values.put("StrtgBalAmtInFreeDfndCrcy2_F", getStrtgBalAmtInFreeDfndCrcy2_F());
        values.put("StrtgBalAmtInFreeDfndCrcy2_E", getStrtgBalAmtInFreeDfndCrcy2_E());
        values.put("DebitAmountInFreeDfndCrcy2", getDebitAmountInFreeDfndCrcy2());
        values.put("DebitAmountInFreeDfndCrcy2_F", getDebitAmountInFreeDfndCrcy2_F());
        values.put("DebitAmountInFreeDfndCrcy2_E", getDebitAmountInFreeDfndCrcy2_E());
        values.put("CreditAmountInFreeDfndCrcy2", getCreditAmountInFreeDfndCrcy2());
        values.put("CreditAmountInFreeDfndCrcy2_F", getCreditAmountInFreeDfndCrcy2_F());
        values.put("CreditAmountInFreeDfndCrcy2_E", getCreditAmountInFreeDfndCrcy2_E());
        values.put("EndingBalAmtInFreeDfndCrcy2", getEndingBalAmtInFreeDfndCrcy2());
        values.put("EndingBalAmtInFreeDfndCrcy2_F", getEndingBalAmtInFreeDfndCrcy2_F());
        values.put("EndingBalAmtInFreeDfndCrcy2_E", getEndingBalAmtInFreeDfndCrcy2_E());
        values.put("StrtgBalAmtInFreeDfndCrcy3", getStrtgBalAmtInFreeDfndCrcy3());
        values.put("StrtgBalAmtInFreeDfndCrcy3_F", getStrtgBalAmtInFreeDfndCrcy3_F());
        values.put("StrtgBalAmtInFreeDfndCrcy3_E", getStrtgBalAmtInFreeDfndCrcy3_E());
        values.put("DebitAmountInFreeDfndCrcy3", getDebitAmountInFreeDfndCrcy3());
        values.put("DebitAmountInFreeDfndCrcy3_F", getDebitAmountInFreeDfndCrcy3_F());
        values.put("DebitAmountInFreeDfndCrcy3_E", getDebitAmountInFreeDfndCrcy3_E());
        values.put("CreditAmountInFreeDfndCrcy3", getCreditAmountInFreeDfndCrcy3());
        values.put("CreditAmountInFreeDfndCrcy3_F", getCreditAmountInFreeDfndCrcy3_F());
        values.put("CreditAmountInFreeDfndCrcy3_E", getCreditAmountInFreeDfndCrcy3_E());
        values.put("EndingBalAmtInFreeDfndCrcy3", getEndingBalAmtInFreeDfndCrcy3());
        values.put("EndingBalAmtInFreeDfndCrcy3_F", getEndingBalAmtInFreeDfndCrcy3_F());
        values.put("EndingBalAmtInFreeDfndCrcy3_E", getEndingBalAmtInFreeDfndCrcy3_E());
        values.put("StrtgBalAmtInFreeDfndCrcy4", getStrtgBalAmtInFreeDfndCrcy4());
        values.put("StrtgBalAmtInFreeDfndCrcy4_F", getStrtgBalAmtInFreeDfndCrcy4_F());
        values.put("StrtgBalAmtInFreeDfndCrcy4_E", getStrtgBalAmtInFreeDfndCrcy4_E());
        values.put("DebitAmountInFreeDfndCrcy4", getDebitAmountInFreeDfndCrcy4());
        values.put("DebitAmountInFreeDfndCrcy4_F", getDebitAmountInFreeDfndCrcy4_F());
        values.put("DebitAmountInFreeDfndCrcy4_E", getDebitAmountInFreeDfndCrcy4_E());
        values.put("CreditAmountInFreeDfndCrcy4", getCreditAmountInFreeDfndCrcy4());
        values.put("CreditAmountInFreeDfndCrcy4_F", getCreditAmountInFreeDfndCrcy4_F());
        values.put("CreditAmountInFreeDfndCrcy4_E", getCreditAmountInFreeDfndCrcy4_E());
        values.put("EndingBalAmtInFreeDfndCrcy4", getEndingBalAmtInFreeDfndCrcy4());
        values.put("EndingBalAmtInFreeDfndCrcy4_F", getEndingBalAmtInFreeDfndCrcy4_F());
        values.put("EndingBalAmtInFreeDfndCrcy4_E", getEndingBalAmtInFreeDfndCrcy4_E());
        values.put("StrtgBalAmtInFreeDfndCrcy5", getStrtgBalAmtInFreeDfndCrcy5());
        values.put("StrtgBalAmtInFreeDfndCrcy5_F", getStrtgBalAmtInFreeDfndCrcy5_F());
        values.put("StrtgBalAmtInFreeDfndCrcy5_E", getStrtgBalAmtInFreeDfndCrcy5_E());
        values.put("DebitAmountInFreeDfndCrcy5", getDebitAmountInFreeDfndCrcy5());
        values.put("DebitAmountInFreeDfndCrcy5_F", getDebitAmountInFreeDfndCrcy5_F());
        values.put("DebitAmountInFreeDfndCrcy5_E", getDebitAmountInFreeDfndCrcy5_E());
        values.put("CreditAmountInFreeDfndCrcy5", getCreditAmountInFreeDfndCrcy5());
        values.put("CreditAmountInFreeDfndCrcy5_F", getCreditAmountInFreeDfndCrcy5_F());
        values.put("CreditAmountInFreeDfndCrcy5_E", getCreditAmountInFreeDfndCrcy5_E());
        values.put("EndingBalAmtInFreeDfndCrcy5", getEndingBalAmtInFreeDfndCrcy5());
        values.put("EndingBalAmtInFreeDfndCrcy5_F", getEndingBalAmtInFreeDfndCrcy5_F());
        values.put("EndingBalAmtInFreeDfndCrcy5_E", getEndingBalAmtInFreeDfndCrcy5_E());
        values.put("StrtgBalAmtInFreeDfndCrcy6", getStrtgBalAmtInFreeDfndCrcy6());
        values.put("StrtgBalAmtInFreeDfndCrcy6_F", getStrtgBalAmtInFreeDfndCrcy6_F());
        values.put("StrtgBalAmtInFreeDfndCrcy6_E", getStrtgBalAmtInFreeDfndCrcy6_E());
        values.put("DebitAmountInFreeDfndCrcy6", getDebitAmountInFreeDfndCrcy6());
        values.put("DebitAmountInFreeDfndCrcy6_F", getDebitAmountInFreeDfndCrcy6_F());
        values.put("DebitAmountInFreeDfndCrcy6_E", getDebitAmountInFreeDfndCrcy6_E());
        values.put("CreditAmountInFreeDfndCrcy6", getCreditAmountInFreeDfndCrcy6());
        values.put("CreditAmountInFreeDfndCrcy6_F", getCreditAmountInFreeDfndCrcy6_F());
        values.put("CreditAmountInFreeDfndCrcy6_E", getCreditAmountInFreeDfndCrcy6_E());
        values.put("EndingBalAmtInFreeDfndCrcy6", getEndingBalAmtInFreeDfndCrcy6());
        values.put("EndingBalAmtInFreeDfndCrcy6_F", getEndingBalAmtInFreeDfndCrcy6_F());
        values.put("EndingBalAmtInFreeDfndCrcy6_E", getEndingBalAmtInFreeDfndCrcy6_E());
        values.put("StrtgBalAmtInFreeDfndCrcy7", getStrtgBalAmtInFreeDfndCrcy7());
        values.put("StrtgBalAmtInFreeDfndCrcy7_F", getStrtgBalAmtInFreeDfndCrcy7_F());
        values.put("StrtgBalAmtInFreeDfndCrcy7_E", getStrtgBalAmtInFreeDfndCrcy7_E());
        values.put("DebitAmountInFreeDfndCrcy7", getDebitAmountInFreeDfndCrcy7());
        values.put("DebitAmountInFreeDfndCrcy7_F", getDebitAmountInFreeDfndCrcy7_F());
        values.put("DebitAmountInFreeDfndCrcy7_E", getDebitAmountInFreeDfndCrcy7_E());
        values.put("CreditAmountInFreeDfndCrcy7", getCreditAmountInFreeDfndCrcy7());
        values.put("CreditAmountInFreeDfndCrcy7_F", getCreditAmountInFreeDfndCrcy7_F());
        values.put("CreditAmountInFreeDfndCrcy7_E", getCreditAmountInFreeDfndCrcy7_E());
        values.put("EndingBalAmtInFreeDfndCrcy7", getEndingBalAmtInFreeDfndCrcy7());
        values.put("EndingBalAmtInFreeDfndCrcy7_F", getEndingBalAmtInFreeDfndCrcy7_F());
        values.put("EndingBalAmtInFreeDfndCrcy7_E", getEndingBalAmtInFreeDfndCrcy7_E());
        values.put("StrtgBalAmtInFreeDfndCrcy8", getStrtgBalAmtInFreeDfndCrcy8());
        values.put("StrtgBalAmtInFreeDfndCrcy8_F", getStrtgBalAmtInFreeDfndCrcy8_F());
        values.put("StrtgBalAmtInFreeDfndCrcy8_E", getStrtgBalAmtInFreeDfndCrcy8_E());
        values.put("DebitAmountInFreeDfndCrcy8", getDebitAmountInFreeDfndCrcy8());
        values.put("DebitAmountInFreeDfndCrcy8_F", getDebitAmountInFreeDfndCrcy8_F());
        values.put("DebitAmountInFreeDfndCrcy8_E", getDebitAmountInFreeDfndCrcy8_E());
        values.put("CreditAmountInFreeDfndCrcy8", getCreditAmountInFreeDfndCrcy8());
        values.put("CreditAmountInFreeDfndCrcy8_F", getCreditAmountInFreeDfndCrcy8_F());
        values.put("CreditAmountInFreeDfndCrcy8_E", getCreditAmountInFreeDfndCrcy8_E());
        values.put("EndingBalAmtInFreeDfndCrcy8", getEndingBalAmtInFreeDfndCrcy8());
        values.put("EndingBalAmtInFreeDfndCrcy8_F", getEndingBalAmtInFreeDfndCrcy8_F());
        values.put("EndingBalAmtInFreeDfndCrcy8_E", getEndingBalAmtInFreeDfndCrcy8_E());
        values.put("StartingBalAmtInBalTransCrcy", getStartingBalAmtInBalTransCrcy());
        values.put("StartingBalAmtInBalTransCrcy_F", getStartingBalAmtInBalTransCrcy_F());
        values.put("StartingBalAmtInBalTransCrcy_E", getStartingBalAmtInBalTransCrcy_E());
        values.put("DebitAmountInBalanceTransCrcy", getDebitAmountInBalanceTransCrcy());
        values.put("DebitAmountInBalanceTransCrcy_F", getDebitAmountInBalanceTransCrcy_F());
        values.put("DebitAmountInBalanceTransCrcy_E", getDebitAmountInBalanceTransCrcy_E());
        values.put("CreditAmountInBalanceTransCrcy", getCreditAmountInBalanceTransCrcy());
        values.put("CreditAmountInBalanceTransCrcy_F", getCreditAmountInBalanceTransCrcy_F());
        values.put("CreditAmountInBalanceTransCrcy_E", getCreditAmountInBalanceTransCrcy_E());
        values.put("EndingBalanceAmtInBalTransCrcy", getEndingBalanceAmtInBalTransCrcy());
        values.put("EndingBalanceAmtInBalTransCrcy_F", getEndingBalanceAmtInBalTransCrcy_F());
        values.put("EndingBalanceAmtInBalTransCrcy_E", getEndingBalanceAmtInBalTransCrcy_E());
        values.put("StartingBalanceAmtInTransCrcy", getStartingBalanceAmtInTransCrcy());
        values.put("StartingBalanceAmtInTransCrcy_F", getStartingBalanceAmtInTransCrcy_F());
        values.put("StartingBalanceAmtInTransCrcy_E", getStartingBalanceAmtInTransCrcy_E());
        values.put("DebitAmountInTransCrcy", getDebitAmountInTransCrcy());
        values.put("DebitAmountInTransCrcy_F", getDebitAmountInTransCrcy_F());
        values.put("DebitAmountInTransCrcy_E", getDebitAmountInTransCrcy_E());
        values.put("CreditAmountInTransCrcy", getCreditAmountInTransCrcy());
        values.put("CreditAmountInTransCrcy_F", getCreditAmountInTransCrcy_F());
        values.put("CreditAmountInTransCrcy_E", getCreditAmountInTransCrcy_E());
        values.put("EndingBalanceAmtInTransCrcy", getEndingBalanceAmtInTransCrcy());
        values.put("EndingBalanceAmtInTransCrcy_F", getEndingBalanceAmtInTransCrcy_F());
        values.put("EndingBalanceAmtInTransCrcy_E", getEndingBalanceAmtInTransCrcy_E());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ID") ) {
                final Object value = values.remove("ID");
                if( (value == null) || (!value.equals(getID())) ) {
                    setID(((String) value));
                }
            }
            if( values.containsKey("TotaledProperties") ) {
                final Object value = values.remove("TotaledProperties");
                if( (value == null) || (!value.equals(getTotaledProperties())) ) {
                    setTotaledProperties(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("GLAccountHierarchyName") ) {
                final Object value = values.remove("GLAccountHierarchyName");
                if( (value == null) || (!value.equals(getGLAccountHierarchyName())) ) {
                    setGLAccountHierarchyName(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency8") ) {
                final Object value = values.remove("FreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency8())) ) {
                    setFreeDefinedCurrency8(((String) value));
                }
            }
            if( values.containsKey("PartnerCostObject") ) {
                final Object value = values.remove("PartnerCostObject");
                if( (value == null) || (!value.equals(getPartnerCostObject())) ) {
                    setPartnerCostObject(((String) value));
                }
            }
            if( values.containsKey("AssetValueDate") ) {
                final Object value = values.remove("AssetValueDate");
                if( (value == null) || (!value.equals(getAssetValueDate())) ) {
                    setAssetValueDate(((String) value));
                }
            }
            if( values.containsKey("AssetValueDate_T") ) {
                final Object value = values.remove("AssetValueDate_T");
                if( (value == null) || (!value.equals(getAssetValueDate_T())) ) {
                    setAssetValueDate_T(((String) value));
                }
            }
            if( values.containsKey("FiscalYearPeriod") ) {
                final Object value = values.remove("FiscalYearPeriod");
                if( (value == null) || (!value.equals(getFiscalYearPeriod())) ) {
                    setFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("QuantityIsIncomplete") ) {
                final Object value = values.remove("QuantityIsIncomplete");
                if( (value == null) || (!value.equals(getQuantityIsIncomplete())) ) {
                    setQuantityIsIncomplete(((String) value));
                }
            }
            if( values.containsKey("IsOpenItemManaged") ) {
                final Object value = values.remove("IsOpenItemManaged");
                if( (value == null) || (!value.equals(getIsOpenItemManaged())) ) {
                    setIsOpenItemManaged(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupAccount") ) {
                final Object value = values.remove("CorporateGroupAccount");
                if( (value == null) || (!value.equals(getCorporateGroupAccount())) ) {
                    setCorporateGroupAccount(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupAccount_T") ) {
                final Object value = values.remove("CorporateGroupAccount_T");
                if( (value == null) || (!value.equals(getCorporateGroupAccount_T())) ) {
                    setCorporateGroupAccount_T(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType") ) {
                final Object value = values.remove("BillingDocumentType");
                if( (value == null) || (!value.equals(getBillingDocumentType())) ) {
                    setBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("FiscalQuarter") ) {
                final Object value = values.remove("FiscalQuarter");
                if( (value == null) || (!value.equals(getFiscalQuarter())) ) {
                    setFiscalQuarter(((String) value));
                }
            }
            if( values.containsKey("CorporateGroupChartOfAccounts") ) {
                final Object value = values.remove("CorporateGroupChartOfAccounts");
                if( (value == null) || (!value.equals(getCorporateGroupChartOfAccounts())) ) {
                    setCorporateGroupChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ClearingDocFiscalYear") ) {
                final Object value = values.remove("ClearingDocFiscalYear");
                if( (value == null) || (!value.equals(getClearingDocFiscalYear())) ) {
                    setClearingDocFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElement") ) {
                final Object value = values.remove("PartnerWBSElement");
                if( (value == null) || (!value.equals(getPartnerWBSElement())) ) {
                    setPartnerWBSElement(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency2") ) {
                final Object value = values.remove("FreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency2())) ) {
                    setFreeDefinedCurrency2(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenter") ) {
                final Object value = values.remove("PartnerProfitCenter");
                if( (value == null) || (!value.equals(getPartnerProfitCenter())) ) {
                    setPartnerProfitCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenterName") ) {
                final Object value = values.remove("PartnerProfitCenterName");
                if( (value == null) || (!value.equals(getPartnerProfitCenterName())) ) {
                    setPartnerProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("PartnerControllingObjectClass") ) {
                final Object value = values.remove("PartnerControllingObjectClass");
                if( (value == null) || (!value.equals(getPartnerControllingObjectClass())) ) {
                    setPartnerControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("GLAccountType") ) {
                final Object value = values.remove("GLAccountType");
                if( (value == null) || (!value.equals(getGLAccountType())) ) {
                    setGLAccountType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCategory") ) {
                final Object value = values.remove("AccountingDocumentCategory");
                if( (value == null) || (!value.equals(getAccountingDocumentCategory())) ) {
                    setAccountingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("BusinessTransactionType") ) {
                final Object value = values.remove("BusinessTransactionType");
                if( (value == null) || (!value.equals(getBusinessTransactionType())) ) {
                    setBusinessTransactionType(((String) value));
                }
            }
            if( values.containsKey("CalendarMonth") ) {
                final Object value = values.remove("CalendarMonth");
                if( (value == null) || (!value.equals(getCalendarMonth())) ) {
                    setCalendarMonth(((String) value));
                }
            }
            if( values.containsKey("CalendarQuarter") ) {
                final Object value = values.remove("CalendarQuarter");
                if( (value == null) || (!value.equals(getCalendarQuarter())) ) {
                    setCalendarQuarter(((String) value));
                }
            }
            if( values.containsKey("ClearingAccountingDocument") ) {
                final Object value = values.remove("ClearingAccountingDocument");
                if( (value == null) || (!value.equals(getClearingAccountingDocument())) ) {
                    setClearingAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentType") ) {
                final Object value = values.remove("AccountingDocumentType");
                if( (value == null) || (!value.equals(getAccountingDocumentType())) ) {
                    setAccountingDocumentType(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentTypeName") ) {
                final Object value = values.remove("AccountingDocumentTypeName");
                if( (value == null) || (!value.equals(getAccountingDocumentTypeName())) ) {
                    setAccountingDocumentTypeName(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountType") ) {
                final Object value = values.remove("FinancialAccountType");
                if( (value == null) || (!value.equals(getFinancialAccountType())) ) {
                    setFinancialAccountType(((String) value));
                }
            }
            if( values.containsKey("FinancialAccountTypeName") ) {
                final Object value = values.remove("FinancialAccountTypeName");
                if( (value == null) || (!value.equals(getFinancialAccountTypeName())) ) {
                    setFinancialAccountTypeName(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("BusinessAreaName") ) {
                final Object value = values.remove("BusinessAreaName");
                if( (value == null) || (!value.equals(getBusinessAreaName())) ) {
                    setBusinessAreaName(((String) value));
                }
            }
            if( values.containsKey("OriginCostCtrActivityType") ) {
                final Object value = values.remove("OriginCostCtrActivityType");
                if( (value == null) || (!value.equals(getOriginCostCtrActivityType())) ) {
                    setOriginCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ControllingAreaName") ) {
                final Object value = values.remove("ControllingAreaName");
                if( (value == null) || (!value.equals(getControllingAreaName())) ) {
                    setControllingAreaName(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectClass") ) {
                final Object value = values.remove("ControllingObjectClass");
                if( (value == null) || (!value.equals(getControllingObjectClass())) ) {
                    setControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenter") ) {
                final Object value = values.remove("PartnerCostCenter");
                if( (value == null) || (!value.equals(getPartnerCostCenter())) ) {
                    setPartnerCostCenter(((String) value));
                }
            }
            if( values.containsKey("SenderCostCenterName") ) {
                final Object value = values.remove("SenderCostCenterName");
                if( (value == null) || (!value.equals(getSenderCostCenterName())) ) {
                    setSenderCostCenterName(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("DebitCreditCodeName") ) {
                final Object value = values.remove("DebitCreditCodeName");
                if( (value == null) || (!value.equals(getDebitCreditCodeName())) ) {
                    setDebitCreditCodeName(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((String) value));
                }
            }
            if( values.containsKey("PostingDate_T") ) {
                final Object value = values.remove("PostingDate_T");
                if( (value == null) || (!value.equals(getPostingDate_T())) ) {
                    setPostingDate_T(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("FunctionalAreaName") ) {
                final Object value = values.remove("FunctionalAreaName");
                if( (value == null) || (!value.equals(getFunctionalAreaName())) ) {
                    setFunctionalAreaName(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("CalendarWeek") ) {
                final Object value = values.remove("CalendarWeek");
                if( (value == null) || (!value.equals(getCalendarWeek())) ) {
                    setCalendarWeek(((String) value));
                }
            }
            if( values.containsKey("CalendarYear") ) {
                final Object value = values.remove("CalendarYear");
                if( (value == null) || (!value.equals(getCalendarYear())) ) {
                    setCalendarYear(((String) value));
                }
            }
            if( values.containsKey("ClearingDate") ) {
                final Object value = values.remove("ClearingDate");
                if( (value == null) || (!value.equals(getClearingDate())) ) {
                    setClearingDate(((String) value));
                }
            }
            if( values.containsKey("ClearingDate_T") ) {
                final Object value = values.remove("ClearingDate_T");
                if( (value == null) || (!value.equals(getClearingDate_T())) ) {
                    setClearingDate_T(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenterName") ) {
                final Object value = values.remove("CostCenterName");
                if( (value == null) || (!value.equals(getCostCenterName())) ) {
                    setCostCenterName(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalWeek") ) {
                final Object value = values.remove("FiscalWeek");
                if( (value == null) || (!value.equals(getFiscalWeek())) ) {
                    setFiscalWeek(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("IsReversal") ) {
                final Object value = values.remove("IsReversal");
                if( (value == null) || (!value.equals(getIsReversal())) ) {
                    setIsReversal(((String) value));
                }
            }
            if( values.containsKey("IsReversed") ) {
                final Object value = values.remove("IsReversed");
                if( (value == null) || (!value.equals(getIsReversed())) ) {
                    setIsReversed(((String) value));
                }
            }
            if( values.containsKey("IsSettled") ) {
                final Object value = values.remove("IsSettled");
                if( (value == null) || (!value.equals(getIsSettled())) ) {
                    setIsSettled(((String) value));
                }
            }
            if( values.containsKey("IsSettlement") ) {
                final Object value = values.remove("IsSettlement");
                if( (value == null) || (!value.equals(getIsSettlement())) ) {
                    setIsSettlement(((String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("PartnerFund") ) {
                final Object value = values.remove("PartnerFund");
                if( (value == null) || (!value.equals(getPartnerFund())) ) {
                    setPartnerFund(((String) value));
                }
            }
            if( values.containsKey("PartnerGrant") ) {
                final Object value = values.remove("PartnerGrant");
                if( (value == null) || (!value.equals(getPartnerGrant())) ) {
                    setPartnerGrant(((String) value));
                }
            }
            if( values.containsKey("PartnerOrder") ) {
                final Object value = values.remove("PartnerOrder");
                if( (value == null) || (!value.equals(getPartnerOrder())) ) {
                    setPartnerOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SoldMaterial") ) {
                final Object value = values.remove("SoldMaterial");
                if( (value == null) || (!value.equals(getSoldMaterial())) ) {
                    setSoldMaterial(((String) value));
                }
            }
            if( values.containsKey("SoldProduct") ) {
                final Object value = values.remove("SoldProduct");
                if( (value == null) || (!value.equals(getSoldProduct())) ) {
                    setSoldProduct(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockValnType") ) {
                final Object value = values.remove("InventorySpecialStockValnType");
                if( (value == null) || (!value.equals(getInventorySpecialStockValnType())) ) {
                    setInventorySpecialStockValnType(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("PostingKey") ) {
                final Object value = values.remove("PostingKey");
                if( (value == null) || (!value.equals(getPostingKey())) ) {
                    setPostingKey(((String) value));
                }
            }
            if( values.containsKey("PostingKeyName") ) {
                final Object value = values.remove("PostingKeyName");
                if( (value == null) || (!value.equals(getPostingKeyName())) ) {
                    setPostingKeyName(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenterName") ) {
                final Object value = values.remove("ProfitCenterName");
                if( (value == null) || (!value.equals(getProfitCenterName())) ) {
                    setProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("SegmentName") ) {
                final Object value = values.remove("SegmentName");
                if( (value == null) || (!value.equals(getSegmentName())) ) {
                    setSegmentName(((String) value));
                }
            }
            if( values.containsKey("SpecialGLCode") ) {
                final Object value = values.remove("SpecialGLCode");
                if( (value == null) || (!value.equals(getSpecialGLCode())) ) {
                    setSpecialGLCode(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityType") ) {
                final Object value = values.remove("JointVentureEquityType");
                if( (value == null) || (!value.equals(getJointVentureEquityType())) ) {
                    setJointVentureEquityType(((String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("AlternativeGLAccount") ) {
                final Object value = values.remove("AlternativeGLAccount");
                if( (value == null) || (!value.equals(getAlternativeGLAccount())) ) {
                    setAlternativeGLAccount(((String) value));
                }
            }
            if( values.containsKey("AlternativeGLAccount_T") ) {
                final Object value = values.remove("AlternativeGLAccount_T");
                if( (value == null) || (!value.equals(getAlternativeGLAccount_T())) ) {
                    setAlternativeGLAccount_T(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("OrderCategory") ) {
                final Object value = values.remove("OrderCategory");
                if( (value == null) || (!value.equals(getOrderCategory())) ) {
                    setOrderCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("ValuationArea") ) {
                final Object value = values.remove("ValuationArea");
                if( (value == null) || (!value.equals(getValuationArea())) ) {
                    setValuationArea(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerGroupName") ) {
                final Object value = values.remove("CustomerGroupName");
                if( (value == null) || (!value.equals(getCustomerGroupName())) ) {
                    setCustomerGroupName(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocument") ) {
                final Object value = values.remove("InventorySpclStkSalesDocument");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocument())) ) {
                    setInventorySpclStkSalesDocument(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStkSalesDocItm") ) {
                final Object value = values.remove("InventorySpclStkSalesDocItm");
                if( (value == null) || (!value.equals(getInventorySpclStkSalesDocItm())) ) {
                    setInventorySpclStkSalesDocItm(((String) value));
                }
            }
            if( values.containsKey("InvtrySpclStockWBSElmntIntID") ) {
                final Object value = values.remove("InvtrySpclStockWBSElmntIntID");
                if( (value == null) || (!value.equals(getInvtrySpclStockWBSElmntIntID())) ) {
                    setInvtrySpclStockWBSElmntIntID(((String) value));
                }
            }
            if( values.containsKey("InventorySpclStockWBSElement") ) {
                final Object value = values.remove("InventorySpclStockWBSElement");
                if( (value == null) || (!value.equals(getInventorySpclStockWBSElement())) ) {
                    setInventorySpclStockWBSElement(((String) value));
                }
            }
            if( values.containsKey("CalendarYearMonth") ) {
                final Object value = values.remove("CalendarYearMonth");
                if( (value == null) || (!value.equals(getCalendarYearMonth())) ) {
                    setCalendarYearMonth(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerName") ) {
                final Object value = values.remove("CustomerName");
                if( (value == null) || (!value.equals(getCustomerName())) ) {
                    setCustomerName(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierName") ) {
                final Object value = values.remove("SupplierName");
                if( (value == null) || (!value.equals(getSupplierName())) ) {
                    setSupplierName(((String) value));
                }
            }
            if( values.containsKey("BalanceTransactionCurrency") ) {
                final Object value = values.remove("BalanceTransactionCurrency");
                if( (value == null) || (!value.equals(getBalanceTransactionCurrency())) ) {
                    setBalanceTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectNetworkActivity") ) {
                final Object value = values.remove("PartnerProjectNetworkActivity");
                if( (value == null) || (!value.equals(getPartnerProjectNetworkActivity())) ) {
                    setPartnerProjectNetworkActivity(((String) value));
                }
            }
            if( values.containsKey("CalendarYearQuarter") ) {
                final Object value = values.remove("CalendarYearQuarter");
                if( (value == null) || (!value.equals(getCalendarYearQuarter())) ) {
                    setCalendarYearQuarter(((String) value));
                }
            }
            if( values.containsKey("IsBalanceSheetAccount") ) {
                final Object value = values.remove("IsBalanceSheetAccount");
                if( (value == null) || (!value.equals(getIsBalanceSheetAccount())) ) {
                    setIsBalanceSheetAccount(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountAssignmentType") ) {
                final Object value = values.remove("PartnerAccountAssignmentType");
                if( (value == null) || (!value.equals(getPartnerAccountAssignmentType())) ) {
                    setPartnerAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("FiscalYearWeek") ) {
                final Object value = values.remove("FiscalYearWeek");
                if( (value == null) || (!value.equals(getFiscalYearWeek())) ) {
                    setFiscalYearWeek(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityGroup") ) {
                final Object value = values.remove("JointVentureEquityGroup");
                if( (value == null) || (!value.equals(getJointVentureEquityGroup())) ) {
                    setJointVentureEquityGroup(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("SenderAccountAssignment") ) {
                final Object value = values.remove("SenderAccountAssignment");
                if( (value == null) || (!value.equals(getSenderAccountAssignment())) ) {
                    setSenderAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("FiscalYearQuarter") ) {
                final Object value = values.remove("FiscalYearQuarter");
                if( (value == null) || (!value.equals(getFiscalYearQuarter())) ) {
                    setFiscalYearQuarter(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("GroupFixedAsset") ) {
                final Object value = values.remove("GroupFixedAsset");
                if( (value == null) || (!value.equals(getGroupFixedAsset())) ) {
                    setGroupFixedAsset(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItemGroup") ) {
                final Object value = values.remove("ReferenceDocumentItemGroup");
                if( (value == null) || (!value.equals(getReferenceDocumentItemGroup())) ) {
                    setReferenceDocumentItemGroup(((String) value));
                }
            }
            if( values.containsKey("AssetDepreciationArea") ) {
                final Object value = values.remove("AssetDepreciationArea");
                if( (value == null) || (!value.equals(getAssetDepreciationArea())) ) {
                    setAssetDepreciationArea(((String) value));
                }
            }
            if( values.containsKey("PartnerSegment") ) {
                final Object value = values.remove("PartnerSegment");
                if( (value == null) || (!value.equals(getPartnerSegment())) ) {
                    setPartnerSegment(((String) value));
                }
            }
            if( values.containsKey("PartnerSegmentName") ) {
                final Object value = values.remove("PartnerSegmentName");
                if( (value == null) || (!value.equals(getPartnerSegmentName())) ) {
                    setPartnerSegmentName(((String) value));
                }
            }
            if( values.containsKey("ClearingJournalEntry") ) {
                final Object value = values.remove("ClearingJournalEntry");
                if( (value == null) || (!value.equals(getClearingJournalEntry())) ) {
                    setClearingJournalEntry(((String) value));
                }
            }
            if( values.containsKey("OperatingConcern") ) {
                final Object value = values.remove("OperatingConcern");
                if( (value == null) || (!value.equals(getOperatingConcern())) ) {
                    setOperatingConcern(((String) value));
                }
            }
            if( values.containsKey("InvtrySpclStockWBSElmntExtID") ) {
                final Object value = values.remove("InvtrySpclStockWBSElmntExtID");
                if( (value == null) || (!value.equals(getInvtrySpclStockWBSElmntExtID())) ) {
                    setInvtrySpclStockWBSElmntExtID(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodEndDate") ) {
                final Object value = values.remove("FiscalPeriodEndDate");
                if( (value == null) || (!value.equals(getFiscalPeriodEndDate())) ) {
                    setFiscalPeriodEndDate(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodEndDate_T") ) {
                final Object value = values.remove("FiscalPeriodEndDate_T");
                if( (value == null) || (!value.equals(getFiscalPeriodEndDate_T())) ) {
                    setFiscalPeriodEndDate_T(((String) value));
                }
            }
            if( values.containsKey("CountryChartOfAccounts") ) {
                final Object value = values.remove("CountryChartOfAccounts");
                if( (value == null) || (!value.equals(getCountryChartOfAccounts())) ) {
                    setCountryChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodStartDate") ) {
                final Object value = values.remove("FiscalPeriodStartDate");
                if( (value == null) || (!value.equals(getFiscalPeriodStartDate())) ) {
                    setFiscalPeriodStartDate(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodStartDate_T") ) {
                final Object value = values.remove("FiscalPeriodStartDate_T");
                if( (value == null) || (!value.equals(getFiscalPeriodStartDate_T())) ) {
                    setFiscalPeriodStartDate_T(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency6") ) {
                final Object value = values.remove("FreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency6())) ) {
                    setFreeDefinedCurrency6(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AccountAssignment") ) {
                final Object value = values.remove("AccountAssignment");
                if( (value == null) || (!value.equals(getAccountAssignment())) ) {
                    setAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCtrActivityType") ) {
                final Object value = values.remove("PartnerCostCtrActivityType");
                if( (value == null) || (!value.equals(getPartnerCostCtrActivityType())) ) {
                    setPartnerCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessProcess") ) {
                final Object value = values.remove("PartnerBusinessProcess");
                if( (value == null) || (!value.equals(getPartnerBusinessProcess())) ) {
                    setPartnerBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("RelatedNetworkActivity") ) {
                final Object value = values.remove("RelatedNetworkActivity");
                if( (value == null) || (!value.equals(getRelatedNetworkActivity())) ) {
                    setRelatedNetworkActivity(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency1") ) {
                final Object value = values.remove("FreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency1())) ) {
                    setFreeDefinedCurrency1(((String) value));
                }
            }
            if( values.containsKey("FiscalPeriodDate") ) {
                final Object value = values.remove("FiscalPeriodDate");
                if( (value == null) || (!value.equals(getFiscalPeriodDate())) ) {
                    setFiscalPeriodDate(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency3") ) {
                final Object value = values.remove("FreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency3())) ) {
                    setFreeDefinedCurrency3(((String) value));
                }
            }
            if( values.containsKey("AssetTransactionType") ) {
                final Object value = values.remove("AssetTransactionType");
                if( (value == null) || (!value.equals(getAssetTransactionType())) ) {
                    setAssetTransactionType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("InvtrySpecialStockValnType_2") ) {
                final Object value = values.remove("InvtrySpecialStockValnType_2");
                if( (value == null) || (!value.equals(getInvtrySpecialStockValnType_2())) ) {
                    setInvtrySpecialStockValnType_2(((String) value));
                }
            }
            if( values.containsKey("EliminationProfitCenter") ) {
                final Object value = values.remove("EliminationProfitCenter");
                if( (value == null) || (!value.equals(getEliminationProfitCenter())) ) {
                    setEliminationProfitCenter(((String) value));
                }
            }
            if( values.containsKey("EliminationProfitCenterName") ) {
                final Object value = values.remove("EliminationProfitCenterName");
                if( (value == null) || (!value.equals(getEliminationProfitCenterName())) ) {
                    setEliminationProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("GlobalCurrency") ) {
                final Object value = values.remove("GlobalCurrency");
                if( (value == null) || (!value.equals(getGlobalCurrency())) ) {
                    setGlobalCurrency(((String) value));
                }
            }
            if( values.containsKey("PredecessorReferenceDocType") ) {
                final Object value = values.remove("PredecessorReferenceDocType");
                if( (value == null) || (!value.equals(getPredecessorReferenceDocType())) ) {
                    setPredecessorReferenceDocType(((String) value));
                }
            }
            if( values.containsKey("LedgerFiscalYear") ) {
                final Object value = values.remove("LedgerFiscalYear");
                if( (value == null) || (!value.equals(getLedgerFiscalYear())) ) {
                    setLedgerFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocument") ) {
                final Object value = values.remove("PartnerSalesDocument");
                if( (value == null) || (!value.equals(getPartnerSalesDocument())) ) {
                    setPartnerSalesDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountAssignment") ) {
                final Object value = values.remove("PartnerAccountAssignment");
                if( (value == null) || (!value.equals(getPartnerAccountAssignment())) ) {
                    setPartnerAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccount") ) {
                final Object value = values.remove("OffsettingAccount");
                if( (value == null) || (!value.equals(getOffsettingAccount())) ) {
                    setOffsettingAccount(((String) value));
                }
            }
            if( values.containsKey("PartnerBudgetPeriod") ) {
                final Object value = values.remove("PartnerBudgetPeriod");
                if( (value == null) || (!value.equals(getPartnerBudgetPeriod())) ) {
                    setPartnerBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("AccountingDocCreatedByUser") ) {
                final Object value = values.remove("AccountingDocCreatedByUser");
                if( (value == null) || (!value.equals(getAccountingDocCreatedByUser())) ) {
                    setAccountingDocCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency4") ) {
                final Object value = values.remove("FreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency4())) ) {
                    setFreeDefinedCurrency4(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("LineItemIsCompleted") ) {
                final Object value = values.remove("LineItemIsCompleted");
                if( (value == null) || (!value.equals(getLineItemIsCompleted())) ) {
                    setLineItemIsCompleted(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectInternalID") ) {
                final Object value = values.remove("PartnerProjectInternalID");
                if( (value == null) || (!value.equals(getPartnerProjectInternalID())) ) {
                    setPartnerProjectInternalID(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectExternalID") ) {
                final Object value = values.remove("PartnerProjectExternalID");
                if( (value == null) || (!value.equals(getPartnerProjectExternalID())) ) {
                    setPartnerProjectExternalID(((String) value));
                }
            }
            if( values.containsKey("JointVentureCostRecoveryCode") ) {
                final Object value = values.remove("JointVentureCostRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureCostRecoveryCode())) ) {
                    setJointVentureCostRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockSupplier") ) {
                final Object value = values.remove("InventorySpecialStockSupplier");
                if( (value == null) || (!value.equals(getInventorySpecialStockSupplier())) ) {
                    setInventorySpecialStockSupplier(((String) value));
                }
            }
            if( values.containsKey("InvtrySpecialStockSupplierName") ) {
                final Object value = values.remove("InvtrySpecialStockSupplierName");
                if( (value == null) || (!value.equals(getInvtrySpecialStockSupplierName())) ) {
                    setInvtrySpecialStockSupplierName(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentType") ) {
                final Object value = values.remove("AccountAssignmentType");
                if( (value == null) || (!value.equals(getAccountAssignmentType())) ) {
                    setAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroup") ) {
                final Object value = values.remove("SoldProductGroup");
                if( (value == null) || (!value.equals(getSoldProductGroup())) ) {
                    setSoldProductGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroupName") ) {
                final Object value = values.remove("MaterialGroupName");
                if( (value == null) || (!value.equals(getMaterialGroupName())) ) {
                    setMaterialGroupName(((String) value));
                }
            }
            if( values.containsKey("PartnerProject") ) {
                final Object value = values.remove("PartnerProject");
                if( (value == null) || (!value.equals(getPartnerProject())) ) {
                    setPartnerProject(((String) value));
                }
            }
            if( values.containsKey("ClearingJournalEntryFiscalYear") ) {
                final Object value = values.remove("ClearingJournalEntryFiscalYear");
                if( (value == null) || (!value.equals(getClearingJournalEntryFiscalYear())) ) {
                    setClearingJournalEntryFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("GroupMasterFixedAsset") ) {
                final Object value = values.remove("GroupMasterFixedAsset");
                if( (value == null) || (!value.equals(getGroupMasterFixedAsset())) ) {
                    setGroupMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PartnerOrderCategory") ) {
                final Object value = values.remove("PartnerOrderCategory");
                if( (value == null) || (!value.equals(getPartnerOrderCategory())) ) {
                    setPartnerOrderCategory(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessAreaName") ) {
                final Object value = values.remove("PartnerBusinessAreaName");
                if( (value == null) || (!value.equals(getPartnerBusinessAreaName())) ) {
                    setPartnerBusinessAreaName(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea") ) {
                final Object value = values.remove("PartnerFunctionalArea");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea())) ) {
                    setPartnerFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalAreaName") ) {
                final Object value = values.remove("PartnerFunctionalAreaName");
                if( (value == null) || (!value.equals(getPartnerFunctionalAreaName())) ) {
                    setPartnerFunctionalAreaName(((String) value));
                }
            }
            if( values.containsKey("ProjectExternalID") ) {
                final Object value = values.remove("ProjectExternalID");
                if( (value == null) || (!value.equals(getProjectExternalID())) ) {
                    setProjectExternalID(((String) value));
                }
            }
            if( values.containsKey("OriginCostCenter") ) {
                final Object value = values.remove("OriginCostCenter");
                if( (value == null) || (!value.equals(getOriginCostCenter())) ) {
                    setOriginCostCenter(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency5") ) {
                final Object value = values.remove("FreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency5())) ) {
                    setFreeDefinedCurrency5(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("OriginObjectType") ) {
                final Object value = values.remove("OriginObjectType");
                if( (value == null) || (!value.equals(getOriginObjectType())) ) {
                    setOriginObjectType(((String) value));
                }
            }
            if( values.containsKey("ControllingObjectDebitType") ) {
                final Object value = values.remove("ControllingObjectDebitType");
                if( (value == null) || (!value.equals(getControllingObjectDebitType())) ) {
                    setControllingObjectDebitType(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementInternalID") ) {
                final Object value = values.remove("PartnerWBSElementInternalID");
                if( (value == null) || (!value.equals(getPartnerWBSElementInternalID())) ) {
                    setPartnerWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementExternalID") ) {
                final Object value = values.remove("PartnerWBSElementExternalID");
                if( (value == null) || (!value.equals(getPartnerWBSElementExternalID())) ) {
                    setPartnerWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("GLAccountHierarchy") ) {
                final Object value = values.remove("GLAccountHierarchy");
                if( (value == null) || (!value.equals(getGLAccountHierarchy())) ) {
                    setGLAccountHierarchy(((String) value));
                }
            }
            if( values.containsKey("CustomerServiceNotification") ) {
                final Object value = values.remove("CustomerServiceNotification");
                if( (value == null) || (!value.equals(getCustomerServiceNotification())) ) {
                    setCustomerServiceNotification(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency7") ) {
                final Object value = values.remove("FreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency7())) ) {
                    setFreeDefinedCurrency7(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentNumber") ) {
                final Object value = values.remove("AccountAssignmentNumber");
                if( (value == null) || (!value.equals(getAccountAssignmentNumber())) ) {
                    setAccountAssignmentNumber(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("TransactionTypeDetermination") ) {
                final Object value = values.remove("TransactionTypeDetermination");
                if( (value == null) || (!value.equals(getTransactionTypeDetermination())) ) {
                    setTransactionTypeDetermination(((String) value));
                }
            }
            if( values.containsKey("PartnerProjectNetwork") ) {
                final Object value = values.remove("PartnerProjectNetwork");
                if( (value == null) || (!value.equals(getPartnerProjectNetwork())) ) {
                    setPartnerProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("PartnerCompanyCode") ) {
                final Object value = values.remove("PartnerCompanyCode");
                if( (value == null) || (!value.equals(getPartnerCompanyCode())) ) {
                    setPartnerCompanyCode(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("OffsettingAccountType") ) {
                final Object value = values.remove("OffsettingAccountType");
                if( (value == null) || (!value.equals(getOffsettingAccountType())) ) {
                    setOffsettingAccountType(((String) value));
                }
            }
            if( values.containsKey("CalendarYearWeek") ) {
                final Object value = values.remove("CalendarYearWeek");
                if( (value == null) || (!value.equals(getCalendarYearWeek())) ) {
                    setCalendarYearWeek(((String) value));
                }
            }
            if( values.containsKey("SenderAccountAssignmentType") ) {
                final Object value = values.remove("SenderAccountAssignmentType");
                if( (value == null) || (!value.equals(getSenderAccountAssignmentType())) ) {
                    setSenderAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SenderGLAccount") ) {
                final Object value = values.remove("SenderGLAccount");
                if( (value == null) || (!value.equals(getSenderGLAccount())) ) {
                    setSenderGLAccount(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocumentItem") ) {
                final Object value = values.remove("PartnerSalesDocumentItem");
                if( (value == null) || (!value.equals(getPartnerSalesDocumentItem())) ) {
                    setPartnerSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("InventoryValuationType") ) {
                final Object value = values.remove("InventoryValuationType");
                if( (value == null) || (!value.equals(getInventoryValuationType())) ) {
                    setInventoryValuationType(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate") ) {
                final Object value = values.remove("SettlementReferenceDate");
                if( (value == null) || (!value.equals(getSettlementReferenceDate())) ) {
                    setSettlementReferenceDate(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate_T") ) {
                final Object value = values.remove("SettlementReferenceDate_T");
                if( (value == null) || (!value.equals(getSettlementReferenceDate_T())) ) {
                    setSettlementReferenceDate_T(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInCoCodeCrcy") ) {
                final Object value = values.remove("StartingBalanceAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInCoCodeCrcy())) ) {
                    setStartingBalanceAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInCoCodeCrcy_F") ) {
                final Object value = values.remove("StartingBalanceAmtInCoCodeCrcy_F");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInCoCodeCrcy_F())) ) {
                    setStartingBalanceAmtInCoCodeCrcy_F(((String) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInCoCodeCrcy_E") ) {
                final Object value = values.remove("StartingBalanceAmtInCoCodeCrcy_E");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInCoCodeCrcy_E())) ) {
                    setStartingBalanceAmtInCoCodeCrcy_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInCoCodeCrcy") ) {
                final Object value = values.remove("DebitAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getDebitAmountInCoCodeCrcy())) ) {
                    setDebitAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInCoCodeCrcy_F") ) {
                final Object value = values.remove("DebitAmountInCoCodeCrcy_F");
                if( (value == null) || (!value.equals(getDebitAmountInCoCodeCrcy_F())) ) {
                    setDebitAmountInCoCodeCrcy_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInCoCodeCrcy_E") ) {
                final Object value = values.remove("DebitAmountInCoCodeCrcy_E");
                if( (value == null) || (!value.equals(getDebitAmountInCoCodeCrcy_E())) ) {
                    setDebitAmountInCoCodeCrcy_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInCoCodeCrcy") ) {
                final Object value = values.remove("CreditAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getCreditAmountInCoCodeCrcy())) ) {
                    setCreditAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInCoCodeCrcy_F") ) {
                final Object value = values.remove("CreditAmountInCoCodeCrcy_F");
                if( (value == null) || (!value.equals(getCreditAmountInCoCodeCrcy_F())) ) {
                    setCreditAmountInCoCodeCrcy_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInCoCodeCrcy_E") ) {
                final Object value = values.remove("CreditAmountInCoCodeCrcy_E");
                if( (value == null) || (!value.equals(getCreditAmountInCoCodeCrcy_E())) ) {
                    setCreditAmountInCoCodeCrcy_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInCoCodeCrcy") ) {
                final Object value = values.remove("EndingBalanceAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInCoCodeCrcy())) ) {
                    setEndingBalanceAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInCoCodeCrcy_F") ) {
                final Object value = values.remove("EndingBalanceAmtInCoCodeCrcy_F");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInCoCodeCrcy_F())) ) {
                    setEndingBalanceAmtInCoCodeCrcy_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInCoCodeCrcy_E") ) {
                final Object value = values.remove("EndingBalanceAmtInCoCodeCrcy_E");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInCoCodeCrcy_E())) ) {
                    setEndingBalanceAmtInCoCodeCrcy_E(((String) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInGlobalCrcy") ) {
                final Object value = values.remove("StartingBalanceAmtInGlobalCrcy");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInGlobalCrcy())) ) {
                    setStartingBalanceAmtInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInGlobalCrcy_F") ) {
                final Object value = values.remove("StartingBalanceAmtInGlobalCrcy_F");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInGlobalCrcy_F())) ) {
                    setStartingBalanceAmtInGlobalCrcy_F(((String) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInGlobalCrcy_E") ) {
                final Object value = values.remove("StartingBalanceAmtInGlobalCrcy_E");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInGlobalCrcy_E())) ) {
                    setStartingBalanceAmtInGlobalCrcy_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInGlobalCrcy") ) {
                final Object value = values.remove("DebitAmountInGlobalCrcy");
                if( (value == null) || (!value.equals(getDebitAmountInGlobalCrcy())) ) {
                    setDebitAmountInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInGlobalCrcy_F") ) {
                final Object value = values.remove("DebitAmountInGlobalCrcy_F");
                if( (value == null) || (!value.equals(getDebitAmountInGlobalCrcy_F())) ) {
                    setDebitAmountInGlobalCrcy_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInGlobalCrcy_E") ) {
                final Object value = values.remove("DebitAmountInGlobalCrcy_E");
                if( (value == null) || (!value.equals(getDebitAmountInGlobalCrcy_E())) ) {
                    setDebitAmountInGlobalCrcy_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInGlobalCrcy") ) {
                final Object value = values.remove("CreditAmountInGlobalCrcy");
                if( (value == null) || (!value.equals(getCreditAmountInGlobalCrcy())) ) {
                    setCreditAmountInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInGlobalCrcy_F") ) {
                final Object value = values.remove("CreditAmountInGlobalCrcy_F");
                if( (value == null) || (!value.equals(getCreditAmountInGlobalCrcy_F())) ) {
                    setCreditAmountInGlobalCrcy_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInGlobalCrcy_E") ) {
                final Object value = values.remove("CreditAmountInGlobalCrcy_E");
                if( (value == null) || (!value.equals(getCreditAmountInGlobalCrcy_E())) ) {
                    setCreditAmountInGlobalCrcy_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInGlobalCrcy") ) {
                final Object value = values.remove("EndingBalanceAmtInGlobalCrcy");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInGlobalCrcy())) ) {
                    setEndingBalanceAmtInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInGlobalCrcy_F") ) {
                final Object value = values.remove("EndingBalanceAmtInGlobalCrcy_F");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInGlobalCrcy_F())) ) {
                    setEndingBalanceAmtInGlobalCrcy_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInGlobalCrcy_E") ) {
                final Object value = values.remove("EndingBalanceAmtInGlobalCrcy_E");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInGlobalCrcy_E())) ) {
                    setEndingBalanceAmtInGlobalCrcy_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy1") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy1");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy1())) ) {
                    setStrtgBalAmtInFreeDfndCrcy1(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy1_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy1_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy1_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy1_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy1_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy1_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy1_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy1_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy1") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy1");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy1())) ) {
                    setDebitAmountInFreeDfndCrcy1(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy1_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy1_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy1_F())) ) {
                    setDebitAmountInFreeDfndCrcy1_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy1_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy1_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy1_E())) ) {
                    setDebitAmountInFreeDfndCrcy1_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy1") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy1");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy1())) ) {
                    setCreditAmountInFreeDfndCrcy1(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy1_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy1_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy1_F())) ) {
                    setCreditAmountInFreeDfndCrcy1_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy1_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy1_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy1_E())) ) {
                    setCreditAmountInFreeDfndCrcy1_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy1") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy1");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy1())) ) {
                    setEndingBalAmtInFreeDfndCrcy1(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy1_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy1_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy1_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy1_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy1_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy1_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy1_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy1_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy2") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy2");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy2())) ) {
                    setStrtgBalAmtInFreeDfndCrcy2(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy2_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy2_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy2_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy2_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy2_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy2_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy2_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy2_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy2") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy2");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy2())) ) {
                    setDebitAmountInFreeDfndCrcy2(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy2_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy2_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy2_F())) ) {
                    setDebitAmountInFreeDfndCrcy2_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy2_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy2_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy2_E())) ) {
                    setDebitAmountInFreeDfndCrcy2_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy2") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy2");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy2())) ) {
                    setCreditAmountInFreeDfndCrcy2(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy2_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy2_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy2_F())) ) {
                    setCreditAmountInFreeDfndCrcy2_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy2_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy2_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy2_E())) ) {
                    setCreditAmountInFreeDfndCrcy2_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy2") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy2");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy2())) ) {
                    setEndingBalAmtInFreeDfndCrcy2(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy2_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy2_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy2_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy2_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy2_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy2_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy2_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy2_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy3") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy3");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy3())) ) {
                    setStrtgBalAmtInFreeDfndCrcy3(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy3_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy3_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy3_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy3_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy3_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy3_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy3_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy3_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy3") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy3");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy3())) ) {
                    setDebitAmountInFreeDfndCrcy3(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy3_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy3_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy3_F())) ) {
                    setDebitAmountInFreeDfndCrcy3_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy3_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy3_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy3_E())) ) {
                    setDebitAmountInFreeDfndCrcy3_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy3") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy3");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy3())) ) {
                    setCreditAmountInFreeDfndCrcy3(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy3_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy3_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy3_F())) ) {
                    setCreditAmountInFreeDfndCrcy3_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy3_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy3_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy3_E())) ) {
                    setCreditAmountInFreeDfndCrcy3_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy3") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy3");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy3())) ) {
                    setEndingBalAmtInFreeDfndCrcy3(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy3_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy3_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy3_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy3_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy3_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy3_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy3_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy3_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy4") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy4");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy4())) ) {
                    setStrtgBalAmtInFreeDfndCrcy4(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy4_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy4_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy4_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy4_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy4_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy4_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy4_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy4_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy4") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy4");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy4())) ) {
                    setDebitAmountInFreeDfndCrcy4(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy4_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy4_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy4_F())) ) {
                    setDebitAmountInFreeDfndCrcy4_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy4_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy4_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy4_E())) ) {
                    setDebitAmountInFreeDfndCrcy4_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy4") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy4");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy4())) ) {
                    setCreditAmountInFreeDfndCrcy4(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy4_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy4_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy4_F())) ) {
                    setCreditAmountInFreeDfndCrcy4_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy4_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy4_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy4_E())) ) {
                    setCreditAmountInFreeDfndCrcy4_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy4") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy4");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy4())) ) {
                    setEndingBalAmtInFreeDfndCrcy4(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy4_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy4_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy4_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy4_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy4_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy4_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy4_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy4_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy5") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy5");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy5())) ) {
                    setStrtgBalAmtInFreeDfndCrcy5(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy5_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy5_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy5_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy5_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy5_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy5_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy5_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy5_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy5") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy5");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy5())) ) {
                    setDebitAmountInFreeDfndCrcy5(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy5_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy5_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy5_F())) ) {
                    setDebitAmountInFreeDfndCrcy5_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy5_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy5_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy5_E())) ) {
                    setDebitAmountInFreeDfndCrcy5_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy5") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy5");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy5())) ) {
                    setCreditAmountInFreeDfndCrcy5(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy5_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy5_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy5_F())) ) {
                    setCreditAmountInFreeDfndCrcy5_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy5_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy5_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy5_E())) ) {
                    setCreditAmountInFreeDfndCrcy5_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy5") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy5");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy5())) ) {
                    setEndingBalAmtInFreeDfndCrcy5(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy5_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy5_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy5_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy5_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy5_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy5_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy5_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy5_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy6") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy6");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy6())) ) {
                    setStrtgBalAmtInFreeDfndCrcy6(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy6_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy6_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy6_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy6_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy6_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy6_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy6_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy6_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy6") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy6");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy6())) ) {
                    setDebitAmountInFreeDfndCrcy6(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy6_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy6_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy6_F())) ) {
                    setDebitAmountInFreeDfndCrcy6_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy6_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy6_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy6_E())) ) {
                    setDebitAmountInFreeDfndCrcy6_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy6") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy6");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy6())) ) {
                    setCreditAmountInFreeDfndCrcy6(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy6_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy6_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy6_F())) ) {
                    setCreditAmountInFreeDfndCrcy6_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy6_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy6_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy6_E())) ) {
                    setCreditAmountInFreeDfndCrcy6_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy6") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy6");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy6())) ) {
                    setEndingBalAmtInFreeDfndCrcy6(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy6_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy6_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy6_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy6_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy6_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy6_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy6_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy6_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy7") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy7");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy7())) ) {
                    setStrtgBalAmtInFreeDfndCrcy7(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy7_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy7_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy7_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy7_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy7_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy7_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy7_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy7_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy7") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy7");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy7())) ) {
                    setDebitAmountInFreeDfndCrcy7(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy7_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy7_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy7_F())) ) {
                    setDebitAmountInFreeDfndCrcy7_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy7_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy7_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy7_E())) ) {
                    setDebitAmountInFreeDfndCrcy7_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy7") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy7");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy7())) ) {
                    setCreditAmountInFreeDfndCrcy7(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy7_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy7_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy7_F())) ) {
                    setCreditAmountInFreeDfndCrcy7_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy7_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy7_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy7_E())) ) {
                    setCreditAmountInFreeDfndCrcy7_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy7") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy7");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy7())) ) {
                    setEndingBalAmtInFreeDfndCrcy7(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy7_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy7_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy7_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy7_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy7_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy7_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy7_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy7_E(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy8") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy8");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy8())) ) {
                    setStrtgBalAmtInFreeDfndCrcy8(((BigDecimal) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy8_F") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy8_F");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy8_F())) ) {
                    setStrtgBalAmtInFreeDfndCrcy8_F(((String) value));
                }
            }
            if( values.containsKey("StrtgBalAmtInFreeDfndCrcy8_E") ) {
                final Object value = values.remove("StrtgBalAmtInFreeDfndCrcy8_E");
                if( (value == null) || (!value.equals(getStrtgBalAmtInFreeDfndCrcy8_E())) ) {
                    setStrtgBalAmtInFreeDfndCrcy8_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy8") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy8");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy8())) ) {
                    setDebitAmountInFreeDfndCrcy8(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy8_F") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy8_F");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy8_F())) ) {
                    setDebitAmountInFreeDfndCrcy8_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInFreeDfndCrcy8_E") ) {
                final Object value = values.remove("DebitAmountInFreeDfndCrcy8_E");
                if( (value == null) || (!value.equals(getDebitAmountInFreeDfndCrcy8_E())) ) {
                    setDebitAmountInFreeDfndCrcy8_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy8") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy8");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy8())) ) {
                    setCreditAmountInFreeDfndCrcy8(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy8_F") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy8_F");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy8_F())) ) {
                    setCreditAmountInFreeDfndCrcy8_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInFreeDfndCrcy8_E") ) {
                final Object value = values.remove("CreditAmountInFreeDfndCrcy8_E");
                if( (value == null) || (!value.equals(getCreditAmountInFreeDfndCrcy8_E())) ) {
                    setCreditAmountInFreeDfndCrcy8_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy8") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy8");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy8())) ) {
                    setEndingBalAmtInFreeDfndCrcy8(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy8_F") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy8_F");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy8_F())) ) {
                    setEndingBalAmtInFreeDfndCrcy8_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalAmtInFreeDfndCrcy8_E") ) {
                final Object value = values.remove("EndingBalAmtInFreeDfndCrcy8_E");
                if( (value == null) || (!value.equals(getEndingBalAmtInFreeDfndCrcy8_E())) ) {
                    setEndingBalAmtInFreeDfndCrcy8_E(((String) value));
                }
            }
            if( values.containsKey("StartingBalAmtInBalTransCrcy") ) {
                final Object value = values.remove("StartingBalAmtInBalTransCrcy");
                if( (value == null) || (!value.equals(getStartingBalAmtInBalTransCrcy())) ) {
                    setStartingBalAmtInBalTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("StartingBalAmtInBalTransCrcy_F") ) {
                final Object value = values.remove("StartingBalAmtInBalTransCrcy_F");
                if( (value == null) || (!value.equals(getStartingBalAmtInBalTransCrcy_F())) ) {
                    setStartingBalAmtInBalTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("StartingBalAmtInBalTransCrcy_E") ) {
                final Object value = values.remove("StartingBalAmtInBalTransCrcy_E");
                if( (value == null) || (!value.equals(getStartingBalAmtInBalTransCrcy_E())) ) {
                    setStartingBalAmtInBalTransCrcy_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInBalanceTransCrcy") ) {
                final Object value = values.remove("DebitAmountInBalanceTransCrcy");
                if( (value == null) || (!value.equals(getDebitAmountInBalanceTransCrcy())) ) {
                    setDebitAmountInBalanceTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInBalanceTransCrcy_F") ) {
                final Object value = values.remove("DebitAmountInBalanceTransCrcy_F");
                if( (value == null) || (!value.equals(getDebitAmountInBalanceTransCrcy_F())) ) {
                    setDebitAmountInBalanceTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInBalanceTransCrcy_E") ) {
                final Object value = values.remove("DebitAmountInBalanceTransCrcy_E");
                if( (value == null) || (!value.equals(getDebitAmountInBalanceTransCrcy_E())) ) {
                    setDebitAmountInBalanceTransCrcy_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInBalanceTransCrcy") ) {
                final Object value = values.remove("CreditAmountInBalanceTransCrcy");
                if( (value == null) || (!value.equals(getCreditAmountInBalanceTransCrcy())) ) {
                    setCreditAmountInBalanceTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInBalanceTransCrcy_F") ) {
                final Object value = values.remove("CreditAmountInBalanceTransCrcy_F");
                if( (value == null) || (!value.equals(getCreditAmountInBalanceTransCrcy_F())) ) {
                    setCreditAmountInBalanceTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInBalanceTransCrcy_E") ) {
                final Object value = values.remove("CreditAmountInBalanceTransCrcy_E");
                if( (value == null) || (!value.equals(getCreditAmountInBalanceTransCrcy_E())) ) {
                    setCreditAmountInBalanceTransCrcy_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInBalTransCrcy") ) {
                final Object value = values.remove("EndingBalanceAmtInBalTransCrcy");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInBalTransCrcy())) ) {
                    setEndingBalanceAmtInBalTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInBalTransCrcy_F") ) {
                final Object value = values.remove("EndingBalanceAmtInBalTransCrcy_F");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInBalTransCrcy_F())) ) {
                    setEndingBalanceAmtInBalTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInBalTransCrcy_E") ) {
                final Object value = values.remove("EndingBalanceAmtInBalTransCrcy_E");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInBalTransCrcy_E())) ) {
                    setEndingBalanceAmtInBalTransCrcy_E(((String) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInTransCrcy") ) {
                final Object value = values.remove("StartingBalanceAmtInTransCrcy");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInTransCrcy())) ) {
                    setStartingBalanceAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInTransCrcy_F") ) {
                final Object value = values.remove("StartingBalanceAmtInTransCrcy_F");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInTransCrcy_F())) ) {
                    setStartingBalanceAmtInTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("StartingBalanceAmtInTransCrcy_E") ) {
                final Object value = values.remove("StartingBalanceAmtInTransCrcy_E");
                if( (value == null) || (!value.equals(getStartingBalanceAmtInTransCrcy_E())) ) {
                    setStartingBalanceAmtInTransCrcy_E(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInTransCrcy") ) {
                final Object value = values.remove("DebitAmountInTransCrcy");
                if( (value == null) || (!value.equals(getDebitAmountInTransCrcy())) ) {
                    setDebitAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitAmountInTransCrcy_F") ) {
                final Object value = values.remove("DebitAmountInTransCrcy_F");
                if( (value == null) || (!value.equals(getDebitAmountInTransCrcy_F())) ) {
                    setDebitAmountInTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("DebitAmountInTransCrcy_E") ) {
                final Object value = values.remove("DebitAmountInTransCrcy_E");
                if( (value == null) || (!value.equals(getDebitAmountInTransCrcy_E())) ) {
                    setDebitAmountInTransCrcy_E(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInTransCrcy") ) {
                final Object value = values.remove("CreditAmountInTransCrcy");
                if( (value == null) || (!value.equals(getCreditAmountInTransCrcy())) ) {
                    setCreditAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditAmountInTransCrcy_F") ) {
                final Object value = values.remove("CreditAmountInTransCrcy_F");
                if( (value == null) || (!value.equals(getCreditAmountInTransCrcy_F())) ) {
                    setCreditAmountInTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("CreditAmountInTransCrcy_E") ) {
                final Object value = values.remove("CreditAmountInTransCrcy_E");
                if( (value == null) || (!value.equals(getCreditAmountInTransCrcy_E())) ) {
                    setCreditAmountInTransCrcy_E(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInTransCrcy") ) {
                final Object value = values.remove("EndingBalanceAmtInTransCrcy");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInTransCrcy())) ) {
                    setEndingBalanceAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInTransCrcy_F") ) {
                final Object value = values.remove("EndingBalanceAmtInTransCrcy_F");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInTransCrcy_F())) ) {
                    setEndingBalanceAmtInTransCrcy_F(((String) value));
                }
            }
            if( values.containsKey("EndingBalanceAmtInTransCrcy_E") ) {
                final Object value = values.remove("EndingBalanceAmtInTransCrcy_E");
                if( (value == null) || (!value.equals(getEndingBalanceAmtInTransCrcy_E())) ) {
                    setEndingBalanceAmtInTransCrcy_E(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new TRIALBALANCEParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
            if( (values).containsKey("LedgerDetails") ) {
                final Object value = (values).remove("LedgerDetails");
                if( value instanceof Map ) {
                    if( toLedgerDetails == null ) {
                        toLedgerDetails = new Ledger();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toLedgerDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("CompanyCodeDetails") ) {
                final Object value = (values).remove("CompanyCodeDetails");
                if( value instanceof Map ) {
                    if( toCompanyCodeDetails == null ) {
                        toCompanyCodeDetails = new CompanyCode();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCompanyCodeDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("GLAccountDetails") ) {
                final Object value = (values).remove("GLAccountDetails");
                if( value instanceof Map ) {
                    if( toGLAccountDetails == null ) {
                        toGLAccountDetails = new GLAccount();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toGLAccountDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("OrderIDDetails") ) {
                final Object value = (values).remove("OrderIDDetails");
                if( value instanceof Map ) {
                    if( toOrderIDDetails == null ) {
                        toOrderIDDetails = new OrderID();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toOrderIDDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("ProjectNetworkDetails") ) {
                final Object value = (values).remove("ProjectNetworkDetails");
                if( value instanceof Map ) {
                    if( toProjectNetworkDetails == null ) {
                        toProjectNetworkDetails = new ProjectNetwork();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProjectNetworkDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("ProjectDetails") ) {
                final Object value = (values).remove("ProjectDetails");
                if( value instanceof Map ) {
                    if( toProjectDetails == null ) {
                        toProjectDetails = new Project();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProjectDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("BusinessProcessDetails") ) {
                final Object value = (values).remove("BusinessProcessDetails");
                if( value instanceof Map ) {
                    if( toBusinessProcessDetails == null ) {
                        toBusinessProcessDetails = new BusinessProcess();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessProcessDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("BillingDocumentTypeDetails") ) {
                final Object value = (values).remove("BillingDocumentTypeDetails");
                if( value instanceof Map ) {
                    if( toBillingDocumentTypeDetails == null ) {
                        toBillingDocumentTypeDetails = new BillingDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingDocumentTypeDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("SalesOrganizationDetails") ) {
                final Object value = (values).remove("SalesOrganizationDetails");
                if( value instanceof Map ) {
                    if( toSalesOrganizationDetails == null ) {
                        toSalesOrganizationDetails = new SalesOrganization();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrganizationDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("DistributionChannelDetails") ) {
                final Object value = (values).remove("DistributionChannelDetails");
                if( value instanceof Map ) {
                    if( toDistributionChannelDetails == null ) {
                        toDistributionChannelDetails = new DistributionChannel();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDistributionChannelDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("SoldProductDetails") ) {
                final Object value = (values).remove("SoldProductDetails");
                if( value instanceof Map ) {
                    if( toSoldProductDetails == null ) {
                        toSoldProductDetails = new SoldProduct();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSoldProductDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerCompanyDetails") ) {
                final Object value = (values).remove("PartnerCompanyDetails");
                if( value instanceof Map ) {
                    if( toPartnerCompanyDetails == null ) {
                        toPartnerCompanyDetails = new PartnerCompany();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerCompanyDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerOrderDetails") ) {
                final Object value = (values).remove("PartnerOrderDetails");
                if( value instanceof Map ) {
                    if( toPartnerOrderDetails == null ) {
                        toPartnerOrderDetails = new PartnerOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerOrderDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerWBSElementDetails") ) {
                final Object value = (values).remove("PartnerWBSElementDetails");
                if( value instanceof Map ) {
                    if( toPartnerWBSElementDetails == null ) {
                        toPartnerWBSElementDetails = new PartnerWBSElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerWBSElementDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerProjectDetails") ) {
                final Object value = (values).remove("PartnerProjectDetails");
                if( value instanceof Map ) {
                    if( toPartnerProjectDetails == null ) {
                        toPartnerProjectDetails = new PartnerProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerProjectDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerSalesDocumentDetails") ) {
                final Object value = (values).remove("PartnerSalesDocumentDetails");
                if( value instanceof Map ) {
                    if( toPartnerSalesDocumentDetails == null ) {
                        toPartnerSalesDocumentDetails = new PartnerSalesDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerSalesDocumentDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerBusinessProcessDetails") ) {
                final Object value = (values).remove("PartnerBusinessProcessDetails");
                if( value instanceof Map ) {
                    if( toPartnerBusinessProcessDetails == null ) {
                        toPartnerBusinessProcessDetails = new PartnerBusinessProcess();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerBusinessProcessDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("FinancialManagementAreaDetails") ) {
                final Object value = (values).remove("FinancialManagementAreaDetails");
                if( value instanceof Map ) {
                    if( toFinancialManagementAreaDetails == null ) {
                        toFinancialManagementAreaDetails = new FinancialManagementArea();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFinancialManagementAreaDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("FundDetails") ) {
                final Object value = (values).remove("FundDetails");
                if( value instanceof Map ) {
                    if( toFundDetails == null ) {
                        toFundDetails = new Fund();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFundDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("GrantIDDetails") ) {
                final Object value = (values).remove("GrantIDDetails");
                if( value instanceof Map ) {
                    if( toGrantIDDetails == null ) {
                        toGrantIDDetails = new GrantID();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toGrantIDDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("BudgetPeriodDetails") ) {
                final Object value = (values).remove("BudgetPeriodDetails");
                if( value instanceof Map ) {
                    if( toBudgetPeriodDetails == null ) {
                        toBudgetPeriodDetails = new BudgetPeriod();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBudgetPeriodDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerFundDetails") ) {
                final Object value = (values).remove("PartnerFundDetails");
                if( value instanceof Map ) {
                    if( toPartnerFundDetails == null ) {
                        toPartnerFundDetails = new PartnerFund();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerFundDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerGrantDetails") ) {
                final Object value = (values).remove("PartnerGrantDetails");
                if( value instanceof Map ) {
                    if( toPartnerGrantDetails == null ) {
                        toPartnerGrantDetails = new PartnerGrant();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerGrantDetails.fromMap(inputMap);
                }
            }
            if( (values).containsKey("PartnerBudgetPeriodDetails") ) {
                final Object value = (values).remove("PartnerBudgetPeriodDetails");
                if( value instanceof Map ) {
                    if( toPartnerBudgetPeriodDetails == null ) {
                        toPartnerBudgetPeriodDetails = new PartnerBudgetPeriod();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartnerBudgetPeriodDetails.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> TRIALBALANCEResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TRIALBALANCEResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TRIALBALANCEResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TRIALBALANCEResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        if( toLedgerDetails != null ) {
            (values).put("LedgerDetails", toLedgerDetails);
        }
        if( toCompanyCodeDetails != null ) {
            (values).put("CompanyCodeDetails", toCompanyCodeDetails);
        }
        if( toGLAccountDetails != null ) {
            (values).put("GLAccountDetails", toGLAccountDetails);
        }
        if( toOrderIDDetails != null ) {
            (values).put("OrderIDDetails", toOrderIDDetails);
        }
        if( toProjectNetworkDetails != null ) {
            (values).put("ProjectNetworkDetails", toProjectNetworkDetails);
        }
        if( toProjectDetails != null ) {
            (values).put("ProjectDetails", toProjectDetails);
        }
        if( toBusinessProcessDetails != null ) {
            (values).put("BusinessProcessDetails", toBusinessProcessDetails);
        }
        if( toBillingDocumentTypeDetails != null ) {
            (values).put("BillingDocumentTypeDetails", toBillingDocumentTypeDetails);
        }
        if( toSalesOrganizationDetails != null ) {
            (values).put("SalesOrganizationDetails", toSalesOrganizationDetails);
        }
        if( toDistributionChannelDetails != null ) {
            (values).put("DistributionChannelDetails", toDistributionChannelDetails);
        }
        if( toSoldProductDetails != null ) {
            (values).put("SoldProductDetails", toSoldProductDetails);
        }
        if( toPartnerCompanyDetails != null ) {
            (values).put("PartnerCompanyDetails", toPartnerCompanyDetails);
        }
        if( toPartnerOrderDetails != null ) {
            (values).put("PartnerOrderDetails", toPartnerOrderDetails);
        }
        if( toPartnerWBSElementDetails != null ) {
            (values).put("PartnerWBSElementDetails", toPartnerWBSElementDetails);
        }
        if( toPartnerProjectDetails != null ) {
            (values).put("PartnerProjectDetails", toPartnerProjectDetails);
        }
        if( toPartnerSalesDocumentDetails != null ) {
            (values).put("PartnerSalesDocumentDetails", toPartnerSalesDocumentDetails);
        }
        if( toPartnerBusinessProcessDetails != null ) {
            (values).put("PartnerBusinessProcessDetails", toPartnerBusinessProcessDetails);
        }
        if( toFinancialManagementAreaDetails != null ) {
            (values).put("FinancialManagementAreaDetails", toFinancialManagementAreaDetails);
        }
        if( toFundDetails != null ) {
            (values).put("FundDetails", toFundDetails);
        }
        if( toGrantIDDetails != null ) {
            (values).put("GrantIDDetails", toGrantIDDetails);
        }
        if( toBudgetPeriodDetails != null ) {
            (values).put("BudgetPeriodDetails", toBudgetPeriodDetails);
        }
        if( toPartnerFundDetails != null ) {
            (values).put("PartnerFundDetails", toPartnerFundDetails);
        }
        if( toPartnerGrantDetails != null ) {
            (values).put("PartnerGrantDetails", toPartnerGrantDetails);
        }
        if( toPartnerBudgetPeriodDetails != null ) {
            (values).put("PartnerBudgetPeriodDetails", toPartnerBudgetPeriodDetails);
        }
        return values;
    }

    /**
     * Fetches the <b>TRIALBALANCEParameters</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>Parameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>TRIALBALANCEParameters</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public TRIALBALANCEParameters fetchParameters()
    {
        return fetchFieldAsSingle("Parameters", TRIALBALANCEParameters.class);
    }

    /**
     * Retrieval of associated <b>TRIALBALANCEParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property <b>Parameters</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>TRIALBALANCEParameters</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public TRIALBALANCEParameters getParametersOrFetch()
    {
        if( toParameters == null ) {
            toParameters = fetchParameters();
        }
        return toParameters;
    }

    /**
     * Retrieval of associated <b>TRIALBALANCEParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>TRIALBALANCEParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<TRIALBALANCEParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>TRIALBALANCEParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     *
     * @param value
     *            New <b>TRIALBALANCEParameters</b> entity.
     */
    public void setParameters( final TRIALBALANCEParameters value )
    {
        toParameters = value;
    }

    /**
     * Fetches the <b>Ledger</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>LedgerDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Ledger</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Ledger fetchLedgerDetails()
    {
        return fetchFieldAsSingle("LedgerDetails", Ledger.class);
    }

    /**
     * Retrieval of associated <b>Ledger</b> entity (one to one). This corresponds to the OData navigation property
     * <b>LedgerDetails</b>.
     * <p>
     * If the navigation property <b>LedgerDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Ledger</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Ledger getLedgerDetailsOrFetch()
    {
        if( toLedgerDetails == null ) {
            toLedgerDetails = fetchLedgerDetails();
        }
        return toLedgerDetails;
    }

    /**
     * Retrieval of associated <b>Ledger</b> entity (one to one). This corresponds to the OData navigation property
     * <b>LedgerDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>LedgerDetails</b> is already loaded, the result will
     *         contain the <b>Ledger</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Ledger> getLedgerDetailsIfPresent()
    {
        return Option.of(toLedgerDetails);
    }

    /**
     * Overwrites the associated <b>Ledger</b> entity for the loaded navigation property <b>LedgerDetails</b>.
     *
     * @param value
     *            New <b>Ledger</b> entity.
     */
    public void setLedgerDetails( final Ledger value )
    {
        toLedgerDetails = value;
    }

    /**
     * Fetches the <b>CompanyCode</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>CompanyCodeDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CompanyCode</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CompanyCode fetchCompanyCodeDetails()
    {
        return fetchFieldAsSingle("CompanyCodeDetails", CompanyCode.class);
    }

    /**
     * Retrieval of associated <b>CompanyCode</b> entity (one to one). This corresponds to the OData navigation property
     * <b>CompanyCodeDetails</b>.
     * <p>
     * If the navigation property <b>CompanyCodeDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CompanyCode</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CompanyCode getCompanyCodeDetailsOrFetch()
    {
        if( toCompanyCodeDetails == null ) {
            toCompanyCodeDetails = fetchCompanyCodeDetails();
        }
        return toCompanyCodeDetails;
    }

    /**
     * Retrieval of associated <b>CompanyCode</b> entity (one to one). This corresponds to the OData navigation property
     * <b>CompanyCodeDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>CompanyCodeDetails</b> is already loaded, the result will
     *         contain the <b>CompanyCode</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CompanyCode> getCompanyCodeDetailsIfPresent()
    {
        return Option.of(toCompanyCodeDetails);
    }

    /**
     * Overwrites the associated <b>CompanyCode</b> entity for the loaded navigation property <b>CompanyCodeDetails</b>.
     *
     * @param value
     *            New <b>CompanyCode</b> entity.
     */
    public void setCompanyCodeDetails( final CompanyCode value )
    {
        toCompanyCodeDetails = value;
    }

    /**
     * Fetches the <b>GLAccount</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>GLAccountDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GLAccount</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GLAccount fetchGLAccountDetails()
    {
        return fetchFieldAsSingle("GLAccountDetails", GLAccount.class);
    }

    /**
     * Retrieval of associated <b>GLAccount</b> entity (one to one). This corresponds to the OData navigation property
     * <b>GLAccountDetails</b>.
     * <p>
     * If the navigation property <b>GLAccountDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GLAccount</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GLAccount getGLAccountDetailsOrFetch()
    {
        if( toGLAccountDetails == null ) {
            toGLAccountDetails = fetchGLAccountDetails();
        }
        return toGLAccountDetails;
    }

    /**
     * Retrieval of associated <b>GLAccount</b> entity (one to one). This corresponds to the OData navigation property
     * <b>GLAccountDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>GLAccountDetails</b> is already loaded, the result will
     *         contain the <b>GLAccount</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<GLAccount> getGLAccountDetailsIfPresent()
    {
        return Option.of(toGLAccountDetails);
    }

    /**
     * Overwrites the associated <b>GLAccount</b> entity for the loaded navigation property <b>GLAccountDetails</b>.
     *
     * @param value
     *            New <b>GLAccount</b> entity.
     */
    public void setGLAccountDetails( final GLAccount value )
    {
        toGLAccountDetails = value;
    }

    /**
     * Fetches the <b>OrderID</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>OrderIDDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>OrderID</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public OrderID fetchOrderIDDetails()
    {
        return fetchFieldAsSingle("OrderIDDetails", OrderID.class);
    }

    /**
     * Retrieval of associated <b>OrderID</b> entity (one to one). This corresponds to the OData navigation property
     * <b>OrderIDDetails</b>.
     * <p>
     * If the navigation property <b>OrderIDDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>OrderID</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public OrderID getOrderIDDetailsOrFetch()
    {
        if( toOrderIDDetails == null ) {
            toOrderIDDetails = fetchOrderIDDetails();
        }
        return toOrderIDDetails;
    }

    /**
     * Retrieval of associated <b>OrderID</b> entity (one to one). This corresponds to the OData navigation property
     * <b>OrderIDDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>OrderIDDetails</b> is already loaded, the result will
     *         contain the <b>OrderID</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<OrderID> getOrderIDDetailsIfPresent()
    {
        return Option.of(toOrderIDDetails);
    }

    /**
     * Overwrites the associated <b>OrderID</b> entity for the loaded navigation property <b>OrderIDDetails</b>.
     *
     * @param value
     *            New <b>OrderID</b> entity.
     */
    public void setOrderIDDetails( final OrderID value )
    {
        toOrderIDDetails = value;
    }

    /**
     * Fetches the <b>ProjectNetwork</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>ProjectNetworkDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProjectNetwork</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectNetwork fetchProjectNetworkDetails()
    {
        return fetchFieldAsSingle("ProjectNetworkDetails", ProjectNetwork.class);
    }

    /**
     * Retrieval of associated <b>ProjectNetwork</b> entity (one to one). This corresponds to the OData navigation
     * property <b>ProjectNetworkDetails</b>.
     * <p>
     * If the navigation property <b>ProjectNetworkDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectNetwork</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProjectNetwork getProjectNetworkDetailsOrFetch()
    {
        if( toProjectNetworkDetails == null ) {
            toProjectNetworkDetails = fetchProjectNetworkDetails();
        }
        return toProjectNetworkDetails;
    }

    /**
     * Retrieval of associated <b>ProjectNetwork</b> entity (one to one). This corresponds to the OData navigation
     * property <b>ProjectNetworkDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>ProjectNetworkDetails</b> is already loaded, the result
     *         will contain the <b>ProjectNetwork</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectNetwork> getProjectNetworkDetailsIfPresent()
    {
        return Option.of(toProjectNetworkDetails);
    }

    /**
     * Overwrites the associated <b>ProjectNetwork</b> entity for the loaded navigation property
     * <b>ProjectNetworkDetails</b>.
     *
     * @param value
     *            New <b>ProjectNetwork</b> entity.
     */
    public void setProjectNetworkDetails( final ProjectNetwork value )
    {
        toProjectNetworkDetails = value;
    }

    /**
     * Fetches the <b>Project</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>ProjectDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Project</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Project fetchProjectDetails()
    {
        return fetchFieldAsSingle("ProjectDetails", Project.class);
    }

    /**
     * Retrieval of associated <b>Project</b> entity (one to one). This corresponds to the OData navigation property
     * <b>ProjectDetails</b>.
     * <p>
     * If the navigation property <b>ProjectDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Project</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Project getProjectDetailsOrFetch()
    {
        if( toProjectDetails == null ) {
            toProjectDetails = fetchProjectDetails();
        }
        return toProjectDetails;
    }

    /**
     * Retrieval of associated <b>Project</b> entity (one to one). This corresponds to the OData navigation property
     * <b>ProjectDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>ProjectDetails</b> is already loaded, the result will
     *         contain the <b>Project</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Project> getProjectDetailsIfPresent()
    {
        return Option.of(toProjectDetails);
    }

    /**
     * Overwrites the associated <b>Project</b> entity for the loaded navigation property <b>ProjectDetails</b>.
     *
     * @param value
     *            New <b>Project</b> entity.
     */
    public void setProjectDetails( final Project value )
    {
        toProjectDetails = value;
    }

    /**
     * Fetches the <b>BusinessProcess</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>BusinessProcessDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessProcess</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessProcess fetchBusinessProcessDetails()
    {
        return fetchFieldAsSingle("BusinessProcessDetails", BusinessProcess.class);
    }

    /**
     * Retrieval of associated <b>BusinessProcess</b> entity (one to one). This corresponds to the OData navigation
     * property <b>BusinessProcessDetails</b>.
     * <p>
     * If the navigation property <b>BusinessProcessDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessProcess</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessProcess getBusinessProcessDetailsOrFetch()
    {
        if( toBusinessProcessDetails == null ) {
            toBusinessProcessDetails = fetchBusinessProcessDetails();
        }
        return toBusinessProcessDetails;
    }

    /**
     * Retrieval of associated <b>BusinessProcess</b> entity (one to one). This corresponds to the OData navigation
     * property <b>BusinessProcessDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>BusinessProcessDetails</b> is already loaded, the result
     *         will contain the <b>BusinessProcess</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessProcess> getBusinessProcessDetailsIfPresent()
    {
        return Option.of(toBusinessProcessDetails);
    }

    /**
     * Overwrites the associated <b>BusinessProcess</b> entity for the loaded navigation property
     * <b>BusinessProcessDetails</b>.
     *
     * @param value
     *            New <b>BusinessProcess</b> entity.
     */
    public void setBusinessProcessDetails( final BusinessProcess value )
    {
        toBusinessProcessDetails = value;
    }

    /**
     * Fetches the <b>BillingDocument</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>BillingDocumentTypeDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillingDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocument fetchBillingDocumentTypeDetails()
    {
        return fetchFieldAsSingle("BillingDocumentTypeDetails", BillingDocument.class);
    }

    /**
     * Retrieval of associated <b>BillingDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>BillingDocumentTypeDetails</b>.
     * <p>
     * If the navigation property <b>BillingDocumentTypeDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocument getBillingDocumentTypeDetailsOrFetch()
    {
        if( toBillingDocumentTypeDetails == null ) {
            toBillingDocumentTypeDetails = fetchBillingDocumentTypeDetails();
        }
        return toBillingDocumentTypeDetails;
    }

    /**
     * Retrieval of associated <b>BillingDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>BillingDocumentTypeDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>BillingDocumentTypeDetails</b> is already loaded, the
     *         result will contain the <b>BillingDocument</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillingDocument> getBillingDocumentTypeDetailsIfPresent()
    {
        return Option.of(toBillingDocumentTypeDetails);
    }

    /**
     * Overwrites the associated <b>BillingDocument</b> entity for the loaded navigation property
     * <b>BillingDocumentTypeDetails</b>.
     *
     * @param value
     *            New <b>BillingDocument</b> entity.
     */
    public void setBillingDocumentTypeDetails( final BillingDocument value )
    {
        toBillingDocumentTypeDetails = value;
    }

    /**
     * Fetches the <b>SalesOrganization</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>SalesOrganizationDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrganization</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization fetchSalesOrganizationDetails()
    {
        return fetchFieldAsSingle("SalesOrganizationDetails", SalesOrganization.class);
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>SalesOrganizationDetails</b>.
     * <p>
     * If the navigation property <b>SalesOrganizationDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrganization</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization getSalesOrganizationDetailsOrFetch()
    {
        if( toSalesOrganizationDetails == null ) {
            toSalesOrganizationDetails = fetchSalesOrganizationDetails();
        }
        return toSalesOrganizationDetails;
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>SalesOrganizationDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>SalesOrganizationDetails</b> is already loaded, the result
     *         will contain the <b>SalesOrganization</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrganization> getSalesOrganizationDetailsIfPresent()
    {
        return Option.of(toSalesOrganizationDetails);
    }

    /**
     * Overwrites the associated <b>SalesOrganization</b> entity for the loaded navigation property
     * <b>SalesOrganizationDetails</b>.
     *
     * @param value
     *            New <b>SalesOrganization</b> entity.
     */
    public void setSalesOrganizationDetails( final SalesOrganization value )
    {
        toSalesOrganizationDetails = value;
    }

    /**
     * Fetches the <b>DistributionChannel</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>DistributionChannelDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DistributionChannel</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DistributionChannel fetchDistributionChannelDetails()
    {
        return fetchFieldAsSingle("DistributionChannelDetails", DistributionChannel.class);
    }

    /**
     * Retrieval of associated <b>DistributionChannel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>DistributionChannelDetails</b>.
     * <p>
     * If the navigation property <b>DistributionChannelDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DistributionChannel</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DistributionChannel getDistributionChannelDetailsOrFetch()
    {
        if( toDistributionChannelDetails == null ) {
            toDistributionChannelDetails = fetchDistributionChannelDetails();
        }
        return toDistributionChannelDetails;
    }

    /**
     * Retrieval of associated <b>DistributionChannel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>DistributionChannelDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>DistributionChannelDetails</b> is already loaded, the
     *         result will contain the <b>DistributionChannel</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DistributionChannel> getDistributionChannelDetailsIfPresent()
    {
        return Option.of(toDistributionChannelDetails);
    }

    /**
     * Overwrites the associated <b>DistributionChannel</b> entity for the loaded navigation property
     * <b>DistributionChannelDetails</b>.
     *
     * @param value
     *            New <b>DistributionChannel</b> entity.
     */
    public void setDistributionChannelDetails( final DistributionChannel value )
    {
        toDistributionChannelDetails = value;
    }

    /**
     * Fetches the <b>SoldProduct</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>SoldProductDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SoldProduct</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SoldProduct fetchSoldProductDetails()
    {
        return fetchFieldAsSingle("SoldProductDetails", SoldProduct.class);
    }

    /**
     * Retrieval of associated <b>SoldProduct</b> entity (one to one). This corresponds to the OData navigation property
     * <b>SoldProductDetails</b>.
     * <p>
     * If the navigation property <b>SoldProductDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SoldProduct</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SoldProduct getSoldProductDetailsOrFetch()
    {
        if( toSoldProductDetails == null ) {
            toSoldProductDetails = fetchSoldProductDetails();
        }
        return toSoldProductDetails;
    }

    /**
     * Retrieval of associated <b>SoldProduct</b> entity (one to one). This corresponds to the OData navigation property
     * <b>SoldProductDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>SoldProductDetails</b> is already loaded, the result will
     *         contain the <b>SoldProduct</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SoldProduct> getSoldProductDetailsIfPresent()
    {
        return Option.of(toSoldProductDetails);
    }

    /**
     * Overwrites the associated <b>SoldProduct</b> entity for the loaded navigation property <b>SoldProductDetails</b>.
     *
     * @param value
     *            New <b>SoldProduct</b> entity.
     */
    public void setSoldProductDetails( final SoldProduct value )
    {
        toSoldProductDetails = value;
    }

    /**
     * Fetches the <b>PartnerCompany</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>PartnerCompanyDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerCompany</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCompany fetchPartnerCompanyDetails()
    {
        return fetchFieldAsSingle("PartnerCompanyDetails", PartnerCompany.class);
    }

    /**
     * Retrieval of associated <b>PartnerCompany</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerCompanyDetails</b>.
     * <p>
     * If the navigation property <b>PartnerCompanyDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerCompany</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerCompany getPartnerCompanyDetailsOrFetch()
    {
        if( toPartnerCompanyDetails == null ) {
            toPartnerCompanyDetails = fetchPartnerCompanyDetails();
        }
        return toPartnerCompanyDetails;
    }

    /**
     * Retrieval of associated <b>PartnerCompany</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerCompanyDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerCompanyDetails</b> is already loaded, the result
     *         will contain the <b>PartnerCompany</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerCompany> getPartnerCompanyDetailsIfPresent()
    {
        return Option.of(toPartnerCompanyDetails);
    }

    /**
     * Overwrites the associated <b>PartnerCompany</b> entity for the loaded navigation property
     * <b>PartnerCompanyDetails</b>.
     *
     * @param value
     *            New <b>PartnerCompany</b> entity.
     */
    public void setPartnerCompanyDetails( final PartnerCompany value )
    {
        toPartnerCompanyDetails = value;
    }

    /**
     * Fetches the <b>PartnerOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>PartnerOrderDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerOrder fetchPartnerOrderDetails()
    {
        return fetchFieldAsSingle("PartnerOrderDetails", PartnerOrder.class);
    }

    /**
     * Retrieval of associated <b>PartnerOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerOrderDetails</b>.
     * <p>
     * If the navigation property <b>PartnerOrderDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerOrder getPartnerOrderDetailsOrFetch()
    {
        if( toPartnerOrderDetails == null ) {
            toPartnerOrderDetails = fetchPartnerOrderDetails();
        }
        return toPartnerOrderDetails;
    }

    /**
     * Retrieval of associated <b>PartnerOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerOrderDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerOrderDetails</b> is already loaded, the result will
     *         contain the <b>PartnerOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerOrder> getPartnerOrderDetailsIfPresent()
    {
        return Option.of(toPartnerOrderDetails);
    }

    /**
     * Overwrites the associated <b>PartnerOrder</b> entity for the loaded navigation property
     * <b>PartnerOrderDetails</b>.
     *
     * @param value
     *            New <b>PartnerOrder</b> entity.
     */
    public void setPartnerOrderDetails( final PartnerOrder value )
    {
        toPartnerOrderDetails = value;
    }

    /**
     * Fetches the <b>PartnerWBSElement</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>PartnerWBSElementDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerWBSElement</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerWBSElement fetchPartnerWBSElementDetails()
    {
        return fetchFieldAsSingle("PartnerWBSElementDetails", PartnerWBSElement.class);
    }

    /**
     * Retrieval of associated <b>PartnerWBSElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerWBSElementDetails</b>.
     * <p>
     * If the navigation property <b>PartnerWBSElementDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerWBSElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerWBSElement getPartnerWBSElementDetailsOrFetch()
    {
        if( toPartnerWBSElementDetails == null ) {
            toPartnerWBSElementDetails = fetchPartnerWBSElementDetails();
        }
        return toPartnerWBSElementDetails;
    }

    /**
     * Retrieval of associated <b>PartnerWBSElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerWBSElementDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerWBSElementDetails</b> is already loaded, the result
     *         will contain the <b>PartnerWBSElement</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerWBSElement> getPartnerWBSElementDetailsIfPresent()
    {
        return Option.of(toPartnerWBSElementDetails);
    }

    /**
     * Overwrites the associated <b>PartnerWBSElement</b> entity for the loaded navigation property
     * <b>PartnerWBSElementDetails</b>.
     *
     * @param value
     *            New <b>PartnerWBSElement</b> entity.
     */
    public void setPartnerWBSElementDetails( final PartnerWBSElement value )
    {
        toPartnerWBSElementDetails = value;
    }

    /**
     * Fetches the <b>PartnerProject</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>PartnerProjectDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerProject fetchPartnerProjectDetails()
    {
        return fetchFieldAsSingle("PartnerProjectDetails", PartnerProject.class);
    }

    /**
     * Retrieval of associated <b>PartnerProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerProjectDetails</b>.
     * <p>
     * If the navigation property <b>PartnerProjectDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerProject getPartnerProjectDetailsOrFetch()
    {
        if( toPartnerProjectDetails == null ) {
            toPartnerProjectDetails = fetchPartnerProjectDetails();
        }
        return toPartnerProjectDetails;
    }

    /**
     * Retrieval of associated <b>PartnerProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerProjectDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerProjectDetails</b> is already loaded, the result
     *         will contain the <b>PartnerProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerProject> getPartnerProjectDetailsIfPresent()
    {
        return Option.of(toPartnerProjectDetails);
    }

    /**
     * Overwrites the associated <b>PartnerProject</b> entity for the loaded navigation property
     * <b>PartnerProjectDetails</b>.
     *
     * @param value
     *            New <b>PartnerProject</b> entity.
     */
    public void setPartnerProjectDetails( final PartnerProject value )
    {
        toPartnerProjectDetails = value;
    }

    /**
     * Fetches the <b>PartnerSalesDocument</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>PartnerSalesDocumentDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerSalesDocument</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerSalesDocument fetchPartnerSalesDocumentDetails()
    {
        return fetchFieldAsSingle("PartnerSalesDocumentDetails", PartnerSalesDocument.class);
    }

    /**
     * Retrieval of associated <b>PartnerSalesDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerSalesDocumentDetails</b>.
     * <p>
     * If the navigation property <b>PartnerSalesDocumentDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerSalesDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerSalesDocument getPartnerSalesDocumentDetailsOrFetch()
    {
        if( toPartnerSalesDocumentDetails == null ) {
            toPartnerSalesDocumentDetails = fetchPartnerSalesDocumentDetails();
        }
        return toPartnerSalesDocumentDetails;
    }

    /**
     * Retrieval of associated <b>PartnerSalesDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerSalesDocumentDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerSalesDocumentDetails</b> is already loaded, the
     *         result will contain the <b>PartnerSalesDocument</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerSalesDocument> getPartnerSalesDocumentDetailsIfPresent()
    {
        return Option.of(toPartnerSalesDocumentDetails);
    }

    /**
     * Overwrites the associated <b>PartnerSalesDocument</b> entity for the loaded navigation property
     * <b>PartnerSalesDocumentDetails</b>.
     *
     * @param value
     *            New <b>PartnerSalesDocument</b> entity.
     */
    public void setPartnerSalesDocumentDetails( final PartnerSalesDocument value )
    {
        toPartnerSalesDocumentDetails = value;
    }

    /**
     * Fetches the <b>PartnerBusinessProcess</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>PartnerBusinessProcessDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerBusinessProcess</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerBusinessProcess fetchPartnerBusinessProcessDetails()
    {
        return fetchFieldAsSingle("PartnerBusinessProcessDetails", PartnerBusinessProcess.class);
    }

    /**
     * Retrieval of associated <b>PartnerBusinessProcess</b> entity (one to one). This corresponds to the OData
     * navigation property <b>PartnerBusinessProcessDetails</b>.
     * <p>
     * If the navigation property <b>PartnerBusinessProcessDetails</b> of a queried <b>TRIALBALANCEResult</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerBusinessProcess</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerBusinessProcess getPartnerBusinessProcessDetailsOrFetch()
    {
        if( toPartnerBusinessProcessDetails == null ) {
            toPartnerBusinessProcessDetails = fetchPartnerBusinessProcessDetails();
        }
        return toPartnerBusinessProcessDetails;
    }

    /**
     * Retrieval of associated <b>PartnerBusinessProcess</b> entity (one to one). This corresponds to the OData
     * navigation property <b>PartnerBusinessProcessDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerBusinessProcessDetails</b> is already loaded, the
     *         result will contain the <b>PartnerBusinessProcess</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerBusinessProcess> getPartnerBusinessProcessDetailsIfPresent()
    {
        return Option.of(toPartnerBusinessProcessDetails);
    }

    /**
     * Overwrites the associated <b>PartnerBusinessProcess</b> entity for the loaded navigation property
     * <b>PartnerBusinessProcessDetails</b>.
     *
     * @param value
     *            New <b>PartnerBusinessProcess</b> entity.
     */
    public void setPartnerBusinessProcessDetails( final PartnerBusinessProcess value )
    {
        toPartnerBusinessProcessDetails = value;
    }

    /**
     * Fetches the <b>FinancialManagementArea</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>FinancialManagementAreaDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FinancialManagementArea</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialManagementArea fetchFinancialManagementAreaDetails()
    {
        return fetchFieldAsSingle("FinancialManagementAreaDetails", FinancialManagementArea.class);
    }

    /**
     * Retrieval of associated <b>FinancialManagementArea</b> entity (one to one). This corresponds to the OData
     * navigation property <b>FinancialManagementAreaDetails</b>.
     * <p>
     * If the navigation property <b>FinancialManagementAreaDetails</b> of a queried <b>TRIALBALANCEResult</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinancialManagementArea</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FinancialManagementArea getFinancialManagementAreaDetailsOrFetch()
    {
        if( toFinancialManagementAreaDetails == null ) {
            toFinancialManagementAreaDetails = fetchFinancialManagementAreaDetails();
        }
        return toFinancialManagementAreaDetails;
    }

    /**
     * Retrieval of associated <b>FinancialManagementArea</b> entity (one to one). This corresponds to the OData
     * navigation property <b>FinancialManagementAreaDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>FinancialManagementAreaDetails</b> is already loaded, the
     *         result will contain the <b>FinancialManagementArea</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FinancialManagementArea> getFinancialManagementAreaDetailsIfPresent()
    {
        return Option.of(toFinancialManagementAreaDetails);
    }

    /**
     * Overwrites the associated <b>FinancialManagementArea</b> entity for the loaded navigation property
     * <b>FinancialManagementAreaDetails</b>.
     *
     * @param value
     *            New <b>FinancialManagementArea</b> entity.
     */
    public void setFinancialManagementAreaDetails( final FinancialManagementArea value )
    {
        toFinancialManagementAreaDetails = value;
    }

    /**
     * Fetches the <b>Fund</b> entity (one to one) associated with this entity. This corresponds to the OData navigation
     * property <b>FundDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Fund</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Fund fetchFundDetails()
    {
        return fetchFieldAsSingle("FundDetails", Fund.class);
    }

    /**
     * Retrieval of associated <b>Fund</b> entity (one to one). This corresponds to the OData navigation property
     * <b>FundDetails</b>.
     * <p>
     * If the navigation property <b>FundDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Fund</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Fund getFundDetailsOrFetch()
    {
        if( toFundDetails == null ) {
            toFundDetails = fetchFundDetails();
        }
        return toFundDetails;
    }

    /**
     * Retrieval of associated <b>Fund</b> entity (one to one). This corresponds to the OData navigation property
     * <b>FundDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>FundDetails</b> is already loaded, the result will contain
     *         the <b>Fund</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<Fund> getFundDetailsIfPresent()
    {
        return Option.of(toFundDetails);
    }

    /**
     * Overwrites the associated <b>Fund</b> entity for the loaded navigation property <b>FundDetails</b>.
     *
     * @param value
     *            New <b>Fund</b> entity.
     */
    public void setFundDetails( final Fund value )
    {
        toFundDetails = value;
    }

    /**
     * Fetches the <b>GrantID</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>GrantIDDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>GrantID</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantID fetchGrantIDDetails()
    {
        return fetchFieldAsSingle("GrantIDDetails", GrantID.class);
    }

    /**
     * Retrieval of associated <b>GrantID</b> entity (one to one). This corresponds to the OData navigation property
     * <b>GrantIDDetails</b>.
     * <p>
     * If the navigation property <b>GrantIDDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>GrantID</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public GrantID getGrantIDDetailsOrFetch()
    {
        if( toGrantIDDetails == null ) {
            toGrantIDDetails = fetchGrantIDDetails();
        }
        return toGrantIDDetails;
    }

    /**
     * Retrieval of associated <b>GrantID</b> entity (one to one). This corresponds to the OData navigation property
     * <b>GrantIDDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>GrantIDDetails</b> is already loaded, the result will
     *         contain the <b>GrantID</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<GrantID> getGrantIDDetailsIfPresent()
    {
        return Option.of(toGrantIDDetails);
    }

    /**
     * Overwrites the associated <b>GrantID</b> entity for the loaded navigation property <b>GrantIDDetails</b>.
     *
     * @param value
     *            New <b>GrantID</b> entity.
     */
    public void setGrantIDDetails( final GrantID value )
    {
        toGrantIDDetails = value;
    }

    /**
     * Fetches the <b>BudgetPeriod</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>BudgetPeriodDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BudgetPeriod</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BudgetPeriod fetchBudgetPeriodDetails()
    {
        return fetchFieldAsSingle("BudgetPeriodDetails", BudgetPeriod.class);
    }

    /**
     * Retrieval of associated <b>BudgetPeriod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>BudgetPeriodDetails</b>.
     * <p>
     * If the navigation property <b>BudgetPeriodDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BudgetPeriod</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BudgetPeriod getBudgetPeriodDetailsOrFetch()
    {
        if( toBudgetPeriodDetails == null ) {
            toBudgetPeriodDetails = fetchBudgetPeriodDetails();
        }
        return toBudgetPeriodDetails;
    }

    /**
     * Retrieval of associated <b>BudgetPeriod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>BudgetPeriodDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>BudgetPeriodDetails</b> is already loaded, the result will
     *         contain the <b>BudgetPeriod</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BudgetPeriod> getBudgetPeriodDetailsIfPresent()
    {
        return Option.of(toBudgetPeriodDetails);
    }

    /**
     * Overwrites the associated <b>BudgetPeriod</b> entity for the loaded navigation property
     * <b>BudgetPeriodDetails</b>.
     *
     * @param value
     *            New <b>BudgetPeriod</b> entity.
     */
    public void setBudgetPeriodDetails( final BudgetPeriod value )
    {
        toBudgetPeriodDetails = value;
    }

    /**
     * Fetches the <b>PartnerFund</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>PartnerFundDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerFund</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerFund fetchPartnerFundDetails()
    {
        return fetchFieldAsSingle("PartnerFundDetails", PartnerFund.class);
    }

    /**
     * Retrieval of associated <b>PartnerFund</b> entity (one to one). This corresponds to the OData navigation property
     * <b>PartnerFundDetails</b>.
     * <p>
     * If the navigation property <b>PartnerFundDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerFund</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerFund getPartnerFundDetailsOrFetch()
    {
        if( toPartnerFundDetails == null ) {
            toPartnerFundDetails = fetchPartnerFundDetails();
        }
        return toPartnerFundDetails;
    }

    /**
     * Retrieval of associated <b>PartnerFund</b> entity (one to one). This corresponds to the OData navigation property
     * <b>PartnerFundDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerFundDetails</b> is already loaded, the result will
     *         contain the <b>PartnerFund</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerFund> getPartnerFundDetailsIfPresent()
    {
        return Option.of(toPartnerFundDetails);
    }

    /**
     * Overwrites the associated <b>PartnerFund</b> entity for the loaded navigation property <b>PartnerFundDetails</b>.
     *
     * @param value
     *            New <b>PartnerFund</b> entity.
     */
    public void setPartnerFundDetails( final PartnerFund value )
    {
        toPartnerFundDetails = value;
    }

    /**
     * Fetches the <b>PartnerGrant</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>PartnerGrantDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerGrant</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerGrant fetchPartnerGrantDetails()
    {
        return fetchFieldAsSingle("PartnerGrantDetails", PartnerGrant.class);
    }

    /**
     * Retrieval of associated <b>PartnerGrant</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerGrantDetails</b>.
     * <p>
     * If the navigation property <b>PartnerGrantDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerGrant</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerGrant getPartnerGrantDetailsOrFetch()
    {
        if( toPartnerGrantDetails == null ) {
            toPartnerGrantDetails = fetchPartnerGrantDetails();
        }
        return toPartnerGrantDetails;
    }

    /**
     * Retrieval of associated <b>PartnerGrant</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerGrantDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerGrantDetails</b> is already loaded, the result will
     *         contain the <b>PartnerGrant</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerGrant> getPartnerGrantDetailsIfPresent()
    {
        return Option.of(toPartnerGrantDetails);
    }

    /**
     * Overwrites the associated <b>PartnerGrant</b> entity for the loaded navigation property
     * <b>PartnerGrantDetails</b>.
     *
     * @param value
     *            New <b>PartnerGrant</b> entity.
     */
    public void setPartnerGrantDetails( final PartnerGrant value )
    {
        toPartnerGrantDetails = value;
    }

    /**
     * Fetches the <b>PartnerBudgetPeriod</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>PartnerBudgetPeriodDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerBudgetPeriod</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerBudgetPeriod fetchPartnerBudgetPeriodDetails()
    {
        return fetchFieldAsSingle("PartnerBudgetPeriodDetails", PartnerBudgetPeriod.class);
    }

    /**
     * Retrieval of associated <b>PartnerBudgetPeriod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerBudgetPeriodDetails</b>.
     * <p>
     * If the navigation property <b>PartnerBudgetPeriodDetails</b> of a queried <b>TRIALBALANCEResult</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerBudgetPeriod</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerBudgetPeriod getPartnerBudgetPeriodDetailsOrFetch()
    {
        if( toPartnerBudgetPeriodDetails == null ) {
            toPartnerBudgetPeriodDetails = fetchPartnerBudgetPeriodDetails();
        }
        return toPartnerBudgetPeriodDetails;
    }

    /**
     * Retrieval of associated <b>PartnerBudgetPeriod</b> entity (one to one). This corresponds to the OData navigation
     * property <b>PartnerBudgetPeriodDetails</b>.
     * <p>
     * If the navigation property for an entity <b>TRIALBALANCEResult</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PartnerBudgetPeriodDetails</b> is already loaded, the
     *         result will contain the <b>PartnerBudgetPeriod</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerBudgetPeriod> getPartnerBudgetPeriodDetailsIfPresent()
    {
        return Option.of(toPartnerBudgetPeriodDetails);
    }

    /**
     * Overwrites the associated <b>PartnerBudgetPeriod</b> entity for the loaded navigation property
     * <b>PartnerBudgetPeriodDetails</b>.
     *
     * @param value
     *            New <b>PartnerBudgetPeriod</b> entity.
     */
    public void setPartnerBudgetPeriodDetails( final PartnerBudgetPeriod value )
    {
        toPartnerBudgetPeriodDetails = value;
    }

    /**
     * Helper class to allow for fluent creation of TRIALBALANCEResult instances.
     *
     */
    public final static class TRIALBALANCEResultBuilder
    {

        private TRIALBALANCEParameters toParameters;
        private Ledger toLedgerDetails;
        private CompanyCode toCompanyCodeDetails;
        private GLAccount toGLAccountDetails;
        private OrderID toOrderIDDetails;
        private ProjectNetwork toProjectNetworkDetails;
        private Project toProjectDetails;
        private BusinessProcess toBusinessProcessDetails;
        private BillingDocument toBillingDocumentTypeDetails;
        private SalesOrganization toSalesOrganizationDetails;
        private DistributionChannel toDistributionChannelDetails;
        private SoldProduct toSoldProductDetails;
        private PartnerCompany toPartnerCompanyDetails;
        private PartnerOrder toPartnerOrderDetails;
        private PartnerWBSElement toPartnerWBSElementDetails;
        private PartnerProject toPartnerProjectDetails;
        private PartnerSalesDocument toPartnerSalesDocumentDetails;
        private PartnerBusinessProcess toPartnerBusinessProcessDetails;
        private FinancialManagementArea toFinancialManagementAreaDetails;
        private Fund toFundDetails;
        private GrantID toGrantIDDetails;
        private BudgetPeriod toBudgetPeriodDetails;
        private PartnerFund toPartnerFundDetails;
        private PartnerGrant toPartnerGrantDetails;
        private PartnerBudgetPeriod toPartnerBudgetPeriodDetails;

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toParameters( final TRIALBALANCEParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>TRIALBALANCEResult</b> to single <b>TRIALBALANCEParameters</b>.
         *
         * @param value
         *            The TRIALBALANCEParameters to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder parameters( final TRIALBALANCEParameters value )
        {
            return toParameters(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toLedgerDetails( final Ledger value )
        {
            toLedgerDetails = value;
            return this;
        }

        /**
         * Navigation property <b>LedgerDetails</b> for <b>TRIALBALANCEResult</b> to single <b>Ledger</b>.
         *
         * @param value
         *            The Ledger to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder ledgerDetails( final Ledger value )
        {
            return toLedgerDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toCompanyCodeDetails( final CompanyCode value )
        {
            toCompanyCodeDetails = value;
            return this;
        }

        /**
         * Navigation property <b>CompanyCodeDetails</b> for <b>TRIALBALANCEResult</b> to single <b>CompanyCode</b>.
         *
         * @param value
         *            The CompanyCode to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder companyCodeDetails( final CompanyCode value )
        {
            return toCompanyCodeDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toGLAccountDetails( final GLAccount value )
        {
            toGLAccountDetails = value;
            return this;
        }

        /**
         * Navigation property <b>GLAccountDetails</b> for <b>TRIALBALANCEResult</b> to single <b>GLAccount</b>.
         *
         * @param value
         *            The GLAccount to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder glAccountDetails( final GLAccount value )
        {
            return toGLAccountDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toOrderIDDetails( final OrderID value )
        {
            toOrderIDDetails = value;
            return this;
        }

        /**
         * Navigation property <b>OrderIDDetails</b> for <b>TRIALBALANCEResult</b> to single <b>OrderID</b>.
         *
         * @param value
         *            The OrderID to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder orderIDDetails( final OrderID value )
        {
            return toOrderIDDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toProjectNetworkDetails( final ProjectNetwork value )
        {
            toProjectNetworkDetails = value;
            return this;
        }

        /**
         * Navigation property <b>ProjectNetworkDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>ProjectNetwork</b>.
         *
         * @param value
         *            The ProjectNetwork to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder projectNetworkDetails( final ProjectNetwork value )
        {
            return toProjectNetworkDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toProjectDetails( final Project value )
        {
            toProjectDetails = value;
            return this;
        }

        /**
         * Navigation property <b>ProjectDetails</b> for <b>TRIALBALANCEResult</b> to single <b>Project</b>.
         *
         * @param value
         *            The Project to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder projectDetails( final Project value )
        {
            return toProjectDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toBusinessProcessDetails( final BusinessProcess value )
        {
            toBusinessProcessDetails = value;
            return this;
        }

        /**
         * Navigation property <b>BusinessProcessDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>BusinessProcess</b>.
         *
         * @param value
         *            The BusinessProcess to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder businessProcessDetails( final BusinessProcess value )
        {
            return toBusinessProcessDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toBillingDocumentTypeDetails( final BillingDocument value )
        {
            toBillingDocumentTypeDetails = value;
            return this;
        }

        /**
         * Navigation property <b>BillingDocumentTypeDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>BillingDocument</b>.
         *
         * @param value
         *            The BillingDocument to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder billingDocumentTypeDetails( final BillingDocument value )
        {
            return toBillingDocumentTypeDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toSalesOrganizationDetails( final SalesOrganization value )
        {
            toSalesOrganizationDetails = value;
            return this;
        }

        /**
         * Navigation property <b>SalesOrganizationDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>SalesOrganization</b>.
         *
         * @param value
         *            The SalesOrganization to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder salesOrganizationDetails( final SalesOrganization value )
        {
            return toSalesOrganizationDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toDistributionChannelDetails(
            final DistributionChannel value )
        {
            toDistributionChannelDetails = value;
            return this;
        }

        /**
         * Navigation property <b>DistributionChannelDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>DistributionChannel</b>.
         *
         * @param value
         *            The DistributionChannel to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder distributionChannelDetails(
            final DistributionChannel value )
        {
            return toDistributionChannelDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toSoldProductDetails( final SoldProduct value )
        {
            toSoldProductDetails = value;
            return this;
        }

        /**
         * Navigation property <b>SoldProductDetails</b> for <b>TRIALBALANCEResult</b> to single <b>SoldProduct</b>.
         *
         * @param value
         *            The SoldProduct to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder soldProductDetails( final SoldProduct value )
        {
            return toSoldProductDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerCompanyDetails( final PartnerCompany value )
        {
            toPartnerCompanyDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerCompanyDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>PartnerCompany</b>.
         *
         * @param value
         *            The PartnerCompany to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerCompanyDetails( final PartnerCompany value )
        {
            return toPartnerCompanyDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerOrderDetails( final PartnerOrder value )
        {
            toPartnerOrderDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerOrderDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerOrder</b>.
         *
         * @param value
         *            The PartnerOrder to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerOrderDetails( final PartnerOrder value )
        {
            return toPartnerOrderDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerWBSElementDetails( final PartnerWBSElement value )
        {
            toPartnerWBSElementDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerWBSElementDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>PartnerWBSElement</b>.
         *
         * @param value
         *            The PartnerWBSElement to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerWBSElementDetails( final PartnerWBSElement value )
        {
            return toPartnerWBSElementDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerProjectDetails( final PartnerProject value )
        {
            toPartnerProjectDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerProjectDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>PartnerProject</b>.
         *
         * @param value
         *            The PartnerProject to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerProjectDetails( final PartnerProject value )
        {
            return toPartnerProjectDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerSalesDocumentDetails(
            final PartnerSalesDocument value )
        {
            toPartnerSalesDocumentDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerSalesDocumentDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>PartnerSalesDocument</b>.
         *
         * @param value
         *            The PartnerSalesDocument to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerSalesDocumentDetails(
            final PartnerSalesDocument value )
        {
            return toPartnerSalesDocumentDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerBusinessProcessDetails(
            final PartnerBusinessProcess value )
        {
            toPartnerBusinessProcessDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerBusinessProcessDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>PartnerBusinessProcess</b>.
         *
         * @param value
         *            The PartnerBusinessProcess to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerBusinessProcessDetails(
            final PartnerBusinessProcess value )
        {
            return toPartnerBusinessProcessDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toFinancialManagementAreaDetails(
            final FinancialManagementArea value )
        {
            toFinancialManagementAreaDetails = value;
            return this;
        }

        /**
         * Navigation property <b>FinancialManagementAreaDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>FinancialManagementArea</b>.
         *
         * @param value
         *            The FinancialManagementArea to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder financialManagementAreaDetails(
            final FinancialManagementArea value )
        {
            return toFinancialManagementAreaDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toFundDetails( final Fund value )
        {
            toFundDetails = value;
            return this;
        }

        /**
         * Navigation property <b>FundDetails</b> for <b>TRIALBALANCEResult</b> to single <b>Fund</b>.
         *
         * @param value
         *            The Fund to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder fundDetails( final Fund value )
        {
            return toFundDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toGrantIDDetails( final GrantID value )
        {
            toGrantIDDetails = value;
            return this;
        }

        /**
         * Navigation property <b>GrantIDDetails</b> for <b>TRIALBALANCEResult</b> to single <b>GrantID</b>.
         *
         * @param value
         *            The GrantID to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder grantIDDetails( final GrantID value )
        {
            return toGrantIDDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toBudgetPeriodDetails( final BudgetPeriod value )
        {
            toBudgetPeriodDetails = value;
            return this;
        }

        /**
         * Navigation property <b>BudgetPeriodDetails</b> for <b>TRIALBALANCEResult</b> to single <b>BudgetPeriod</b>.
         *
         * @param value
         *            The BudgetPeriod to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder budgetPeriodDetails( final BudgetPeriod value )
        {
            return toBudgetPeriodDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerFundDetails( final PartnerFund value )
        {
            toPartnerFundDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerFundDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerFund</b>.
         *
         * @param value
         *            The PartnerFund to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerFundDetails( final PartnerFund value )
        {
            return toPartnerFundDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerGrantDetails( final PartnerGrant value )
        {
            toPartnerGrantDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerGrantDetails</b> for <b>TRIALBALANCEResult</b> to single <b>PartnerGrant</b>.
         *
         * @param value
         *            The PartnerGrant to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerGrantDetails( final PartnerGrant value )
        {
            return toPartnerGrantDetails(value);
        }

        private TRIALBALANCEResult.TRIALBALANCEResultBuilder toPartnerBudgetPeriodDetails(
            final PartnerBudgetPeriod value )
        {
            toPartnerBudgetPeriodDetails = value;
            return this;
        }

        /**
         * Navigation property <b>PartnerBudgetPeriodDetails</b> for <b>TRIALBALANCEResult</b> to single
         * <b>PartnerBudgetPeriod</b>.
         *
         * @param value
         *            The PartnerBudgetPeriod to build this TRIALBALANCEResult with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TRIALBALANCEResult.TRIALBALANCEResultBuilder partnerBudgetPeriodDetails(
            final PartnerBudgetPeriod value )
        {
            return toPartnerBudgetPeriodDetails(value);
        }

    }

}
