/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.TransactionCurrencyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.TransactionCurrencySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Transaction Currency (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TransactionCurrency</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TransactionCurrency extends VdmEntity<TransactionCurrency>
{

    /**
     * Selector for all available fields of TransactionCurrency.
     *
     */
    public final static TransactionCurrencySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency_ID</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @Key
    @SerializedName( "TransactionCurrency_ID" )
    @JsonProperty( "TransactionCurrency_ID" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency_ID" )
    private String transactionCurrency_ID;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency_ID</b> field to query operations.
     *
     */
    public final static TransactionCurrencyField<String> TRANSACTION_CURRENCY_ID =
        new TransactionCurrencyField<String>("TransactionCurrency_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrencyText</b>
     * </p>
     *
     * @return Transaction Currency (Description)
     */
    @SerializedName( "TransactionCurrencyText" )
    @JsonProperty( "TransactionCurrencyText" )
    @Nullable
    @ODataField( odataName = "TransactionCurrencyText" )
    private String transactionCurrencyText;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrencyText</b> field to query operations.
     *
     */
    public final static TransactionCurrencyField<String> TRANSACTION_CURRENCY_TEXT =
        new TransactionCurrencyField<String>("TransactionCurrencyText");

    @Nonnull
    @Override
    public Class<TransactionCurrency> getType()
    {
        return TransactionCurrency.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency_ID</b>
     * </p>
     *
     * @param transactionCurrency_ID
     *            Transaction Currency
     */
    public void setTransactionCurrency_ID( @Nullable final String transactionCurrency_ID )
    {
        rememberChangedField("TransactionCurrency_ID", this.transactionCurrency_ID);
        this.transactionCurrency_ID = transactionCurrency_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrencyText</b>
     * </p>
     *
     * @param transactionCurrencyText
     *            Transaction Currency (Description)
     */
    public void setTransactionCurrencyText( @Nullable final String transactionCurrencyText )
    {
        rememberChangedField("TransactionCurrencyText", this.transactionCurrencyText);
        this.transactionCurrencyText = transactionCurrencyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "TransactionCurrency";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("TransactionCurrency_ID", getTransactionCurrency_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("TransactionCurrency_ID", getTransactionCurrency_ID());
        values.put("TransactionCurrencyText", getTransactionCurrencyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TransactionCurrency_ID") ) {
                final Object value = values.remove("TransactionCurrency_ID");
                if( (value == null) || (!value.equals(getTransactionCurrency_ID())) ) {
                    setTransactionCurrency_ID(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrencyText") ) {
                final Object value = values.remove("TransactionCurrencyText");
                if( (value == null) || (!value.equals(getTransactionCurrencyText())) ) {
                    setTransactionCurrencyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> TransactionCurrencyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TransactionCurrencyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TransactionCurrencyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TransactionCurrencyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
