/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.WBSElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.WBSElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * WBS Element (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WBSElement</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WBSElement extends VdmEntity<WBSElement>
{

    /**
     * Selector for all available fields of WBSElement.
     *
     */
    public final static WBSElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement_ID</b>
     * </p>
     *
     * @return WBS Element
     */
    @Key
    @SerializedName( "WBSElement_ID" )
    @JsonProperty( "WBSElement_ID" )
    @Nullable
    @ODataField( odataName = "WBSElement_ID" )
    private String wBSElement_ID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement_ID</b> field to query operations.
     *
     */
    public final static WBSElementField<String> WBS_ELEMENT_ID = new WBSElementField<String>("WBSElement_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementText</b>
     * </p>
     *
     * @return WBS Element (Description)
     */
    @SerializedName( "WBSElementText" )
    @JsonProperty( "WBSElementText" )
    @Nullable
    @ODataField( odataName = "WBSElementText" )
    private String wBSElementText;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementText</b> field to query operations.
     *
     */
    public final static WBSElementField<String> WBS_ELEMENT_TEXT = new WBSElementField<String>("WBSElementText");

    @Nonnull
    @Override
    public Class<WBSElement> getType()
    {
        return WBSElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement_ID</b>
     * </p>
     *
     * @param wBSElement_ID
     *            WBS Element
     */
    public void setWBSElement_ID( @Nullable final String wBSElement_ID )
    {
        rememberChangedField("WBSElement_ID", this.wBSElement_ID);
        this.wBSElement_ID = wBSElement_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementText</b>
     * </p>
     *
     * @param wBSElementText
     *            WBS Element (Description)
     */
    public void setWBSElementText( @Nullable final String wBSElementText )
    {
        rememberChangedField("WBSElementText", this.wBSElementText);
        this.wBSElementText = wBSElementText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WBSElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WBSElement_ID", getWBSElement_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WBSElement_ID", getWBSElement_ID());
        values.put("WBSElementText", getWBSElementText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WBSElement_ID") ) {
                final Object value = values.remove("WBSElement_ID");
                if( (value == null) || (!value.equals(getWBSElement_ID())) ) {
                    setWBSElement_ID(((String) value));
                }
            }
            if( values.containsKey("WBSElementText") ) {
                final Object value = values.remove("WBSElementText");
                if( (value == null) || (!value.equals(getWBSElementText())) ) {
                    setWBSElementText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WBSElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WBSElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WBSElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WBSElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
