/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.WBSElementExternalIDField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.WBSElementExternalIDSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * WBS Element External ID (Master Data)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WBSElementExternalID</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WBSElementExternalID extends VdmEntity<WBSElementExternalID>
{

    /**
     * Selector for all available fields of WBSElementExternalID.
     *
     */
    public final static WBSElementExternalIDSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID_ID</b>
     * </p>
     *
     * @return WBS Element External ID
     */
    @Key
    @SerializedName( "WBSElementExternalID_ID" )
    @JsonProperty( "WBSElementExternalID_ID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID_ID" )
    private String wBSElementExternalID_ID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID_ID</b> field to query operations.
     *
     */
    public final static WBSElementExternalIDField<String> WBS_ELEMENT_EXTERNAL_IDID =
        new WBSElementExternalIDField<String>("WBSElementExternalID_ID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalIDText</b>
     * </p>
     *
     * @return WBS Element External ID (Description)
     */
    @SerializedName( "WBSElementExternalIDText" )
    @JsonProperty( "WBSElementExternalIDText" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalIDText" )
    private String wBSElementExternalIDText;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalIDText</b> field to query operations.
     *
     */
    public final static WBSElementExternalIDField<String> WBS_ELEMENT_EXTERNAL_ID_TEXT =
        new WBSElementExternalIDField<String>("WBSElementExternalIDText");

    @Nonnull
    @Override
    public Class<WBSElementExternalID> getType()
    {
        return WBSElementExternalID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID_ID</b>
     * </p>
     *
     * @param wBSElementExternalID_ID
     *            WBS Element External ID
     */
    public void setWBSElementExternalID_ID( @Nullable final String wBSElementExternalID_ID )
    {
        rememberChangedField("WBSElementExternalID_ID", this.wBSElementExternalID_ID);
        this.wBSElementExternalID_ID = wBSElementExternalID_ID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalIDText</b>
     * </p>
     *
     * @param wBSElementExternalIDText
     *            WBS Element External ID (Description)
     */
    public void setWBSElementExternalIDText( @Nullable final String wBSElementExternalIDText )
    {
        rememberChangedField("WBSElementExternalIDText", this.wBSElementExternalIDText);
        this.wBSElementExternalIDText = wBSElementExternalIDText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WBSElementExternalID";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WBSElementExternalID_ID", getWBSElementExternalID_ID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WBSElementExternalID_ID", getWBSElementExternalID_ID());
        values.put("WBSElementExternalIDText", getWBSElementExternalIDText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WBSElementExternalID_ID") ) {
                final Object value = values.remove("WBSElementExternalID_ID");
                if( (value == null) || (!value.equals(getWBSElementExternalID_ID())) ) {
                    setWBSElementExternalID_ID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalIDText") ) {
                final Object value = values.remove("WBSElementExternalIDText");
                if( (value == null) || (!value.equals(getWBSElementExternalIDText())) ) {
                    setWBSElementExternalIDText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WBSElementExternalIDField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WBSElementExternalIDField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WBSElementExternalIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WBSElementExternalIDField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

}
