/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link TrialBalanceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService TrialBalanceService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultTrialBalanceServiceBatch
    extends
    BatchFluentHelperBasic<TrialBalanceServiceBatch, TrialBalanceServiceBatchChangeSet>
    implements
    TrialBalanceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultTrialBalanceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultTrialBalanceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultTrialBalanceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultTrialBalanceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.TrialBalanceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultTrialBalanceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public TrialBalanceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultTrialBalanceServiceBatchChangeSet(this, service);
    }

}
