/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FinancialManagementAreaSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea
 * FinancialManagementArea} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class FinancialManagementAreaLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<FinancialManagementAreaLink<ObjectT>, FinancialManagementArea, ObjectT>
    implements
    FinancialManagementAreaSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public FinancialManagementAreaLink( final String fieldName )
    {
        super(fieldName);
    }

    private FinancialManagementAreaLink(
        final EntityLink<FinancialManagementAreaLink<ObjectT>, FinancialManagementArea, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected FinancialManagementAreaLink<ObjectT> translateLinkType(
        final EntityLink<FinancialManagementAreaLink<ObjectT>, FinancialManagementArea, ObjectT> link )
    {
        return new FinancialManagementAreaLink<ObjectT>(link);
    }

}
