/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency1Selectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1 FreeDefinedCurrency1} to
 * other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class FreeDefinedCurrency1Link<ObjectT extends VdmObject<?>>
    extends
    EntityLink<FreeDefinedCurrency1Link<ObjectT>, FreeDefinedCurrency1, ObjectT>
    implements
    FreeDefinedCurrency1Selectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public FreeDefinedCurrency1Link( final String fieldName )
    {
        super(fieldName);
    }

    private FreeDefinedCurrency1Link(
        final EntityLink<FreeDefinedCurrency1Link<ObjectT>, FreeDefinedCurrency1, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected FreeDefinedCurrency1Link<ObjectT> translateLinkType(
        final EntityLink<FreeDefinedCurrency1Link<ObjectT>, FreeDefinedCurrency1, ObjectT> link )
    {
        return new FreeDefinedCurrency1Link<ObjectT>(link);
    }

}
