/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4Result;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency4ResultSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4Result
 * FreeDefinedCurrency4Result} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class FreeDefinedCurrency4ResultLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<FreeDefinedCurrency4ResultLink<ObjectT>, FreeDefinedCurrency4Result, ObjectT>
    implements
    FreeDefinedCurrency4ResultSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public FreeDefinedCurrency4ResultLink( final String fieldName )
    {
        super(fieldName);
    }

    private FreeDefinedCurrency4ResultLink(
        final EntityLink<FreeDefinedCurrency4ResultLink<ObjectT>, FreeDefinedCurrency4Result, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected FreeDefinedCurrency4ResultLink<ObjectT> translateLinkType(
        final EntityLink<FreeDefinedCurrency4ResultLink<ObjectT>, FreeDefinedCurrency4Result, ObjectT> link )
    {
        return new FreeDefinedCurrency4ResultLink<ObjectT>(link);
    }

}
