/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.FreeDefinedCurrency5Selectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5 FreeDefinedCurrency5} to
 * other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class FreeDefinedCurrency5Link<ObjectT extends VdmObject<?>>
    extends
    EntityLink<FreeDefinedCurrency5Link<ObjectT>, FreeDefinedCurrency5, ObjectT>
    implements
    FreeDefinedCurrency5Selectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public FreeDefinedCurrency5Link( final String fieldName )
    {
        super(fieldName);
    }

    private FreeDefinedCurrency5Link(
        final EntityLink<FreeDefinedCurrency5Link<ObjectT>, FreeDefinedCurrency5, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected FreeDefinedCurrency5Link<ObjectT> translateLinkType(
        final EntityLink<FreeDefinedCurrency5Link<ObjectT>, FreeDefinedCurrency5, ObjectT> link )
    {
        return new FreeDefinedCurrency5Link<ObjectT>(link);
    }

}
