/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.PartnerBudgetPeriodSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod PartnerBudgetPeriod} to
 * other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class PartnerBudgetPeriodLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<PartnerBudgetPeriodLink<ObjectT>, PartnerBudgetPeriod, ObjectT>
    implements
    PartnerBudgetPeriodSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public PartnerBudgetPeriodLink( final String fieldName )
    {
        super(fieldName);
    }

    private PartnerBudgetPeriodLink(
        final EntityLink<PartnerBudgetPeriodLink<ObjectT>, PartnerBudgetPeriod, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected PartnerBudgetPeriodLink<ObjectT> translateLinkType(
        final EntityLink<PartnerBudgetPeriodLink<ObjectT>, PartnerBudgetPeriod, ObjectT> link )
    {
        return new PartnerBudgetPeriodLink<ObjectT>(link);
    }

}
