/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable.SAP__UnitOfMeasureSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure SAP__UnitOfMeasure} to
 * other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SAP__UnitOfMeasureLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SAP__UnitOfMeasureLink<ObjectT>, SAP__UnitOfMeasure, ObjectT>
    implements
    SAP__UnitOfMeasureSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SAP__UnitOfMeasureLink( final String fieldName )
    {
        super(fieldName);
    }

    private SAP__UnitOfMeasureLink(
        final EntityLink<SAP__UnitOfMeasureLink<ObjectT>, SAP__UnitOfMeasure, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SAP__UnitOfMeasureLink<ObjectT> translateLinkType(
        final EntityLink<SAP__UnitOfMeasureLink<ObjectT>, SAP__UnitOfMeasure, ObjectT> link )
    {
        return new SAP__UnitOfMeasureLink<ObjectT>(link);
    }

}
