/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory
 * AccountingDocumentCategory}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.AccountingDocumentCategoryField
 * AccountingDocumentCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.AccountingDocumentCategoryLink
 * AccountingDocumentCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory#ACCOUNTING_DOCUMENT_CATEGORY_ID
 * ACCOUNTING_DOCUMENT_CATEGORY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory#ACCOUNTING_DOCUMENT_CATEGORY_TEXT
 * ACCOUNTING_DOCUMENT_CATEGORY_TEXT}</li>
 * </ul>
 *
 */
public interface AccountingDocumentCategorySelectable extends EntitySelectable<AccountingDocumentCategory>
{

}
