/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument AccountingDocument}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.AccountingDocumentField
 * AccountingDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.AccountingDocumentLink
 * AccountingDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument#ACCOUNTING_DOCUMENT_TYPE_ID
 * ACCOUNTING_DOCUMENT_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument#ACCOUNTING_DOCUMENT_TYPE_TEXT
 * ACCOUNTING_DOCUMENT_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface AccountingDocumentSelectable extends EntitySelectable<AccountingDocument>
{

}
