/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction AssetTransaction}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.AssetTransactionField
 * AssetTransactionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.AssetTransactionLink
 * AssetTransactionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction#ASSET_TRANSACTION_TYPE_ID
 * ASSET_TRANSACTION_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction#ASSET_TRANSACTION_TYPE_TEXT
 * ASSET_TRANSACTION_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface AssetTransactionSelectable extends EntitySelectable<AssetTransaction>
{

}
