/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency
 * BalanceTransactionCurrency}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.BalanceTransactionCurrencyField
 * BalanceTransactionCurrencyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.BalanceTransactionCurrencyLink
 * BalanceTransactionCurrencyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency#BALANCE_TRANSACTION_CURRENCY_ID
 * BALANCE_TRANSACTION_CURRENCY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency#BALANCE_TRANSACTION_CURRENCY_TEXT
 * BALANCE_TRANSACTION_CURRENCY_TEXT}</li>
 * </ul>
 *
 */
public interface BalanceTransactionCurrencySelectable extends EntitySelectable<BalanceTransactionCurrency>
{

}
