/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea BusinessArea}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.BusinessAreaField
 * BusinessAreaField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.BusinessAreaLink
 * BusinessAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea#BUSINESS_AREA_ID
 * BUSINESS_AREA_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea#BUSINESS_AREA_TEXT
 * BUSINESS_AREA_TEXT}</li>
 * </ul>
 *
 */
public interface BusinessAreaSelectable extends EntitySelectable<BusinessArea>
{

}
