/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction BusinessTransaction}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.BusinessTransactionField
 * BusinessTransactionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.BusinessTransactionLink
 * BusinessTransactionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction#BUSINESS_TRANSACTION_TYPE_ID
 * BUSINESS_TRANSACTION_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction#BUSINESS_TRANSACTION_TYPE_TEXT
 * BUSINESS_TRANSACTION_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface BusinessTransactionSelectable extends EntitySelectable<BusinessTransaction>
{

}
