/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth CalendarMonth}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CalendarMonthField
 * CalendarMonthField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CalendarMonthLink CalendarMonthLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth#CALENDAR_MONTH_ID
 * CALENDAR_MONTH_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth#CALENDAR_MONTH_TEXT
 * CALENDAR_MONTH_TEXT}</li>
 * </ul>
 *
 */
public interface CalendarMonthSelectable extends EntitySelectable<CalendarMonth>
{

}
