/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter CalendarQuarter}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CalendarQuarterField
 * CalendarQuarterField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CalendarQuarterLink
 * CalendarQuarterLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter#CALENDAR_QUARTER_ID
 * CALENDAR_QUARTER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter#CALENDAR_QUARTER_TEXT
 * CALENDAR_QUARTER_TEXT}</li>
 * </ul>
 *
 */
public interface CalendarQuarterSelectable extends EntitySelectable<CalendarQuarter>
{

}
