/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonth;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonth CalendarYearMonth}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CalendarYearMonthField
 * CalendarYearMonthField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CalendarYearMonthLink
 * CalendarYearMonthLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonth#CALENDAR_YEAR_MONTH_ID
 * CALENDAR_YEAR_MONTH_ID}</li>
 * </ul>
 *
 */
public interface CalendarYearMonthSelectable extends EntitySelectable<CalendarYearMonth>
{

}
