/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts ChartOfAccounts}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ChartOfAccountsField
 * ChartOfAccountsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ChartOfAccountsLink
 * ChartOfAccountsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts#CHART_OF_ACCOUNTS_ID
 * CHART_OF_ACCOUNTS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts#CHART_OF_ACCOUNTS_TEXT
 * CHART_OF_ACCOUNTS_TEXT}</li>
 * </ul>
 *
 */
public interface ChartOfAccountsSelectable extends EntitySelectable<ChartOfAccounts>
{

}
