/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument
 * ClearingAccountingDocument}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ClearingAccountingDocumentField
 * ClearingAccountingDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ClearingAccountingDocumentLink
 * ClearingAccountingDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument#CLEARING_ACCOUNTING_DOCUMENT_ID
 * CLEARING_ACCOUNTING_DOCUMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * </ul>
 *
 */
public interface ClearingAccountingDocumentSelectable extends EntitySelectable<ClearingAccountingDocument>
{

}
