/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear
 * ClearingJournalEntryFiscalYear}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ClearingJournalEntryFiscalYearField
 * ClearingJournalEntryFiscalYearField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ClearingJournalEntryFiscalYearLink
 * ClearingJournalEntryFiscalYearLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear#CLEARING_JOURNAL_ENTRY_FISCAL_YEAR_ID
 * CLEARING_JOURNAL_ENTRY_FISCAL_YEAR_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * </ul>
 *
 */
public interface ClearingJournalEntryFiscalYearSelectable extends EntitySelectable<ClearingJournalEntryFiscalYear>
{

}
