/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry ClearingJournalEntry}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ClearingJournalEntryField
 * ClearingJournalEntryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ClearingJournalEntryLink
 * ClearingJournalEntryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry#CLEARING_JOURNAL_ENTRY_ID
 * CLEARING_JOURNAL_ENTRY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry#CLEARING_JOURNAL_ENTRY_FISCAL_YEAR
 * CLEARING_JOURNAL_ENTRY_FISCAL_YEAR}</li>
 * </ul>
 *
 */
public interface ClearingJournalEntrySelectable extends EntitySelectable<ClearingJournalEntry>
{

}
