/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency CompanyCodeCurrency}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CompanyCodeCurrencyField
 * CompanyCodeCurrencyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CompanyCodeCurrencyLink
 * CompanyCodeCurrencyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency#COMPANY_CODE_CURRENCY_ID
 * COMPANY_CODE_CURRENCY_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency#COMPANY_CODE_CURRENCY_TEXT
 * COMPANY_CODE_CURRENCY_TEXT}</li>
 * </ul>
 *
 */
public interface CompanyCodeCurrencySelectable extends EntitySelectable<CompanyCodeCurrency>
{

}
