/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass
 * ControllingObjectClass}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ControllingObjectClassField
 * ControllingObjectClassField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ControllingObjectClassLink
 * ControllingObjectClassLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass#CONTROLLING_OBJECT_CLASS_ID
 * CONTROLLING_OBJECT_CLASS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass#CONTROLLING_OBJECT_CLASS_TEXT
 * CONTROLLING_OBJECT_CLASS_TEXT}</li>
 * </ul>
 *
 */
public interface ControllingObjectClassSelectable extends EntitySelectable<ControllingObjectClass>
{

}
