/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit
 * ControllingObjectDebit}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.ControllingObjectDebitField
 * ControllingObjectDebitField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.ControllingObjectDebitLink
 * ControllingObjectDebitLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit#CONTROLLING_OBJECT_DEBIT_TYPE_ID
 * CONTROLLING_OBJECT_DEBIT_TYPE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit#CONTROLLING_OBJECT_DEBIT_TYPE_TEXT
 * CONTROLLING_OBJECT_DEBIT_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface ControllingObjectDebitSelectable extends EntitySelectable<ControllingObjectDebit>
{

}
