/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount CorporateGroupAccount}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.field.CorporateGroupAccountField
 * CorporateGroupAccountField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.link.CorporateGroupAccountLink
 * CorporateGroupAccountLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount#CORPORATE_GROUP_ACCOUNT_ID
 * CORPORATE_GROUP_ACCOUNT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount#CORPORATE_GROUP_ACCOUNT_TEXT
 * CORPORATE_GROUP_ACCOUNT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount#CORPORATE_GROUP_CHART_OF_ACCOUNTS
 * CORPORATE_GROUP_CHART_OF_ACCOUNTS}</li>
 * </ul>
 *
 */
public interface CorporateGroupAccountSelectable extends EntitySelectable<CorporateGroupAccount>
{

}
